//************
//  Description:	Generic midas driver for an ICECORE library
//
//  Author:	Jeff Schoen	2/2013
//
//  $Revision:	$
//  $Modtime:	$
//
//************
#include <stdio.h>
#include <primitive.h>
#include <fintrinsics.h>
#include <stdlib.h>
#include <string.h>
#include "icedefs.h"
#include "niolib.h"

void set_trslt (char *name, char *str) {
  char c; int i,ie,i1=0,lin,liv,ln=strlen(name),ls=strlen(str);
  char rname[40], rvalue[128];
  for (i=0; i<ls; i++) {
    c = str[i];
    if (c=='=') ie=i;
    if (c==',' || c=='}') {
      strcpy(rname,name);
      strcat(rname,"_");
      strncat(rname,str+i1+1,ie-i1-1);
      lin = ln+ie-i1; rname[lin]=0;
      strncpy(rvalue,str+ie+1,i-ie-1);
      liv = i-ie-1; rvalue[liv]=0;
      m_arslt(string(rname,lin),string(rvalue,liv));
    }
    if (c=='{' || c==',') i1=i;
  }
}

char *s2c (string s) { return (char*)s.c_str(); }

void mainroutine ()
{
  CPHEADER hwf,hi,ho;
  int_4 stat,sock,iflag,cmd,chans,llen,len,tlen,xfer,i,j,ls;
  string addr,abuf,label,table,func,flag,alias;
  char buf[4096];

  // parameters
  func = m_apick(1);
  addr = m_apick(2);
  abuf = m_apick(3);
  flag = m_apick(4);
  xfer = m_get_switch_def("TL",4096);
  llen = m_get_uswitch("LABEL",label);
  tlen = m_get_uswitch("TABLE",table);

  i = addr.find(':',0);
  j = addr.find('/',0);

  if (i<=0 && j<=0) {
    alias = addr;
    i  = m_hwf_open (hwf);
    ls = m_hwf_alias (hwf, alias, addr);
    i  = m_hwf_close (hwf);
    if (ls<=0) m_error("Alias "+alias+" not found in HW config file");
  }

  if (func == "SET" || func == "GET" || func == "MSG") {
    cmd   = (func=="MSG")? NIO_MSG : (func=="SET")? NIO_SET : NIO_GET;
    iflag = (flag=="RTAB")? NIO_RTAB|NIO_HTTP : (flag=="RMIF")? NIO_RMIF : NIO_HTTP;
    len   = m_length(abuf);
    bcopy(s2c(abuf),buf,len);
    chans = 0;
    sock = nioOpen(s2c(addr),chans,iflag);
    stat = nioMsg(sock,chans,cmd,buf,len,iflag);
    if (stat<=0) m_error("Bad NIO_MSG return status");
    if (llen>0) m_arslt(label,string(buf,stat));
    if (tlen>0) set_trslt(s2c(table),s2c(string(buf,stat)));
    if (llen<=0 && tlen<=0) printf("%s\n",buf);
    stat = nioClose(sock);
  }
  else if (func == "ACQ") {
    m_propagate (hi, ho);
    ho.file_name = m_apick(2);
    m_open (ho, HCBF_OUTPUT+HCBF_OPTIONAL);
  }
  else if (func == "PLY") {
    m_init (hi, m_apick(1), "1000,2000","S#,C#", 0);
    m_open (hi, HCBF_INPUT+HCBF_OPTIONAL);
  }
  else {
    m_error("Unsupported func="+func);
  }

  m_sync();

  // close all resources
  m_close(hi);
  m_close(ho);

}
