startmacro/quiet/theme=gear1 &
  s:device[PIC1] l:side[3] l:nfft[1k] l:dec[256] l:ntun[-1] &
  l:samplerate[4*10e6] d:freq[-1] s:sclk[I] 

! /MUX=1 Multiplex multiple sourcepics into packet stream
! /MUX=2 Use single sourcepic/multi=N to packet stream
! /MUX=3 Use single sourcepic/port=TBANKx to packet stream
! /MCP   Use multichannel plotter

global/readall
set aflags ^/aflags
sedit "^{device}_testout" testout "LOCASE"

! start test waveform playback
if /LIVE gt 0 then
  res flags "muxclk=^sclk"
  picd/flags=^flags|^aflags reset device 
  res plotmax "75"
  res plotmin "-60"
elseif /RCVR then
  res flags "MUXCLK=P|INP=1|LBDATTEN=0|LBDRFG=0|LBDBBG=3|LBDBW=20E6|LBDFREQ=1900|LBDDCC"
  res samplerate 100e6
  if freq lt 0 res freq 30e6
  res samplerate 100e6
  picd/flags=^flags|^aflags reset device 
  res plotmax "55"
  res plotmin "-30"
elseif /TCT gt 0
  res aflags "^aflags|ioc=t1"
  picd/flags=^aflags reset device 
  res flags "iom=test"
  res plotmax "75"
  res plotmin "-60"
elseif /TCX gt 0
  picd/flags=^aflags reset device 
  res flags ""
  res plotmax "75"
  res plotmin "-60"
else
  res aflags "^aflags|ioc=iir"
  if /hs gt 0
   res flags "muxclk=c"
   picd get device "CCLK" samplerate
  elseif /hs2 gt 0
   res flags "muxclk=p"
   res samplerate 90e6
  else
   res flags "muxclk=^sclk"
  endif
  picd/flags=^flags|^aflags reset device
  res plotmax "75"
  res plotmin "-60"
endif

picd/flags=^aflags get device "CPC" cp 
picd/flags=^aflags get device "TYPE" ctype 
picd/flags=^aflags get device "GCHIP" gtype 

res l:n2i (1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16)
if cp eq 1 res l:n2i (1,2,9,10,17,18,25,26)
if /mux le 0
if cp eq 2 res l:n2i (1,3,2,4,9,11,10,12,17,19,18,20,25,27,26,28)
if cp eq 4 res l:n2i (1,3,5,7,2,4,6,8,9,11,13,15,10,12,14,16,17,19,21,23,18,20,22,24,25,27,29,31,26,28,30,32)
else
if cp eq 2 res l:n2i (1,2,3,4,9,10,11,12,17,18,19,20,25,26,27,28)
if cp eq 4 res l:n2i (1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32)
endif

picd/flags=^aflags get device "MCHNS" ii 
if ii eq 4 res n2i (1,2,3,4)
if ii eq 0 then
  warn "No tuners in this configuration"
  stop
endif

if ntun lt 0
  picd/flags=^aflags get device "CHNS" l:ntun
  if side ne 3 calc l:ntun ntun/2
endif

calc l:nplot ntun power2 2 max
if ntun eq 24 res l:nplot ntun
switch "NPLOT" l:nplot get ^nplot
switch "GAIN" gain get 0

res ratio 0

calc pdec ntun 256/dec * samplerate * 40e6 / round 1 max

if /polar gt 0
 res flags "^flags|polar"
endif

if /rr gt 0 then
 switch RR ratio
 res flags "^flags|resamp"
! res flags "^flags|resamp|rfir=res_15x32_80"
!  picd/flags=^flags loadfc device nxm.ice.dat.res_15x32_80 ,, -1
endif

if freq le 0 then
  if ctype eq 5 or ctype eq 6 or ctype eq 7 
    calc freq samplerate/128
  else
    calc freq samplerate/32
  endif
  if freq lt samplerate/dec/2 calc freq samplerate/dec/2
endif
if /ovsr gt 0 picd ovsr device ,, /ovsr -1
if /mcp then res pdec 1
if /meas then res pdec 1

if /cal then
picd test device 81 /verbose
endif

switch "FORM" format get "SI"
if /C then set format "CI"
if "L" subs format
  res plotmax "170"
  res plotmin "30"
endif
if "C" subs format
  calc osamplerate samplerate/dec/2
  calc nfft nfft/2
else
  calc osamplerate samplerate/dec
endif
res nyquist samplerate/2
calc ioff /chnoff 0 max
res l:nn 1
call nn2ii

if dec ge 2k
  res ipkt 2k
else
  res ipkt 8k
endif

if ntun gt 32 
  calc filelen 1
else
  calc filelen 2
endif

calc filesize filelen*osamplerate 64k max nfft / round 2 max nfft *  

pipe on

! acquire tuner data
if /mux gt 1 then					! multi source
  calc ix osamplerate/4/ntun
  if /meas then calc ix 0
  picd create testout format filesize osamplerate /multi=ntun
  if /mux eq 3 then
    sourcepic/id=SP1/port=tbank^side/flags=^flags|^aflags/skip=pdec/tl=ipkt/nchn=ntun/packet/tcpp=1/ratio=ratio &
	testout _cbx{ps=4m} device dec freq-(ix*ntun/2) gain /dfreq=ix
  else
    sourcepic/id=SP1/port=tuner^ii/flags=^flags|^aflags/skip=pdec/tl=ipkt/multi=ntun/packet/tcpp=1/ratio=ratio &
	testout _cbx{ps=4m} device dec freq-(ix*ntun/2) gain /dfreq=ix
  endif
else
  do nn 1 ntun
    call nn2ii
    calc ix nn-1 4 mod 1.5 - 0.103*osamplerate * 
    if /meas then calc ix 0
    picd create ^{testout}^nn format filesize osamplerate
    if /mux gt 0 then
      sourcepic/id=SP^nn/port=tuner^ii/flags=^flags|^aflags/skip=pdec/tl=ipkt/packet/tcpp=1/ratio=ratio &
	^{testout}^nn _cbp^nn device dec freq+ix gain
    else
      set rgo test(ii,gt,2,and,/rgo,gt,0)
      sourcepic/id=SP^nn/port=tuner^ii/flags=^flags|^aflags|rgo=^rgo/skip=pdec/tl=1/ratio=ratio &
	^{testout}^nn{fs=nfft} _cb^nn device dec freq+ix gain
    endif
  enddo
endif

! process mux and measure 
if /mux eq 1 then picfanin/renum _cbx{ps=2m} _cbp ntun 
if /meas then picmeasure _cbx test_measure 32 

! plot output data
if /nox then
  panel/setup=NC
elseif /mcp then					! MultiChannel plot
  panel/setup=MC
  plot/id=PP/msgid=main/wtitle="Plot Active Tuners" &
	_cbx type=line view=iyx axis=frame &
        layer={LT="nxm.ice.libg.LayerMC",NFFT=256,NCHAN=^nplot}
else							! Independent plots
  panel/setup=^nplot
  if /mux gt 0 picfanout _cbx _cb ntun /strip
  do nn 1 ntun
    call nn2ii
    fft/mag/log _cb^nn _cbf^nn nfft HANN 0
    plot/id=PP^nn/msgid=main/wtitle="Plot-^nn  Tuner-^ii" &
	_cbf^nn type=line y1=plotmin y2=plotmax axis=frame options=+contrast 
  enddo
endif

gcontrol label  "MACRO" "Macro" 
gcontrol button "STATE" "State" "Run,ReStart,DMAC,Test,Stop,Check,Status,Exit" /tleft /nc=2
gcontrol button "SIDE"  "Side " "1,2,3" ^side /tleft /nc=3
gcontrol lvalue "PLOT"  "Plot#" 1 1 ntun 1 /slider
gcontrol dvalue "FREQ"  "TFreq" 0 0 nyquist nyquist*1e-5 /slider
gcontrol lvalue "GAIN"  "TGain" gain -100 100 1 /gauge
gcontrol lvalue "DEC"   "TDec " dec 2 8192 2 
gcontrol button "MODE"  "TGo  " "Restart,Cont,One,Stop,ReConn,NewDev" /tleft /nc=2
gcontrol button "TC"    "TC   " "Cont,Once,Stop" /tleft
gcontrol lvalue "DELAY" "Delay" 0 0 64M 1 /slider
gcontrol pipemon "PMON" "PMON " 
res sp reg.sp1
res gc reg.panel.controls

do nn 1 /WBP 1
  res nfftw 4K
  res wbfmt "SI"
  calc filesize 1*samplerate nfftw*2 max 64k max round
  calc pdec filesize nfftw / 32 / round 1 max
  pic create ^{testout}wb^nn wbfmt 32*nfftw samplerate
  sourcepic/id=SPWB^nn/port=module^nn/tl=1/flags=^flags|^aflags &
	^{testout}wb^nn{fs=nfftw} _cbw^nn device /skip=pdec /skiponcard
  fft/mag/log _cbw^nn{fs=0} _cbwf^nn nfftw HANN 0 8
  gcontrol label  "PANEL^nn" "WideBand ^nn" 1
  gcontrol panel "PPW^nn" 
  plot/id=PPW^nn/msgid=main/wtitle="PlotWB-^nn  Module-^nn" &
	_cbwf^nn type=line axis=unlab options=+contrast 
enddo

if /testx then
  set this.timers 1
  set this.timer(0) 2.0
  set dfreq 10e3
else
  set this.timers 1
  set this.timer(0) 1.0
endif

timer set

pipe off

! remove test output files
if /mux gt 1 then
  erase testout 
else
 do nn 1 ntun
  erase ^{testout}^nn 
 enddo
endif

endmacro

procedure processMessage 

if msg.name eqs "TIMER" then
  timer elapse f:ttt
  if /testx then
    call mixup
  endif
  if /timeout gt 0 and ttt gt /timeout then
    info "Macro exceeded timeout at ^ttt sec"
    pipe stop
  endif

elseif msg.name eqs "MARK" then
  if /mux eq 3 then
    set reg.pp.layers._cbx.select msg.data
    set l:nn reg.pp.layers._cbx.select+1
  else
    sedit msg.fid l:nn trim "PP"
  endif
  call newnn
elseif msg.name eqs "PLOT" then
  res l:nn msg.data
  call newnn
elseif msg.name eqs "FREQ" then
  set SP.freq gc.FREQ.value
elseif msg.name eqs "DEC" then
  set SP.dec gc.DEC.value
elseif msg.name eqs "GAIN" then
  set SP.gain gc.GAIN.value
elseif msg.name eqs "DELAY" then
  picd set ^device "DELAY" l:gc.DELAY.value
elseif msg.name eqs "MODE" then
  set SP.replay msg.data
elseif msg.name eqs "STATE" then
  if msg.data eqs "EXIT" then
    stop
  elseif msg.data eqs "RUN" then
    message send "MAIN" ,, "STATESTART" ^gc.SIDE.value
  elseif msg.data eqs "STOP" then
    message send "MAIN" ,, "STATESTOP" ^gc.SIDE.value
  elseif msg.data eqs "TEST" then
    call mixup
  elseif msg.data eqs "CHECK" then
    call checkup
  elseif msg.data eqs "DMAC" then
    picd dmac device
  elseif msg.data eqs "STATUS" then
    pic status device
  elseif msg.data eqs "RESTART" then
    message send "MAIN" ,, "STATESTOP" ^gc.SIDE.value
    message send "MAIN" ,, "STATESTART" ^gc.SIDE.value
  endif
elseif msg.name eqs "STATESTART" then
 if /mux ge 2
  set SP.replay "CONT"
 else
  do nn 1 ntun
    call nn2ii
    calc iis ii-1 2 mod 1 +
    if msg.info eq 3 or msg.info eq iis then set reg.SP^{nn}.replay "CONT"
  enddo
 endif
elseif msg.name eqs "STATESTOP" then
 if /mux ge 2
  set SP.replay "STOP"
 else
  do nn 1 ntun
    call nn2ii
    calc iis ii-1 2 mod 1 +
    if msg.info eq 3 or msg.info eq iis then set reg.SP^{nn}.replay "STOPNOW"
  enddo
 endif
  pause 1
endif
return

procedure nn2ii 
if /mux eq 3 or /linear gt 0 
  res l:ii nn
  return
endif
if side eq 3
  res n3 nn-1
elseif /mux gt 0
  calc n3 nn-1 2 * (side-1) +
else
  calc n1 nn-1 cp mod
  calc n2 nn-1 cp / fix
  calc n3 n2*2 (side-1) + cp * n1 +
endif
if gtype gt 2 
 if side eq 3
  res l:ii nn+ioff
 else
  res l:ii nn*2+side-2+ioff
 endif
elseif n3 ge cp*8
  res l:ii n2i(n3-(cp*8))+ioff+32
else
  res l:ii n2i(n3)+ioff
endif
return

procedure newnn
  call nn2ii
  if /mux gt 1 then
    set sp reg.sp1
    set sp.channel nn-1
  else
    set sp reg.sp^nn
  endif
  set gc.plot.value nn
  set gc.freq.value SP.freq
  set gc.dec.value SP.dec
  set gc.gain.value SP.gain
return

procedure frequp
say "Setting the new freq ^dfreq mode ^reg.spwb2.replay"
do nn 1 ntun
  set reg.SP^{nn}.freq freq+dfreq
enddo
calc dfreq -dfreq
if reg.spwb2.replay eqs "CONTINUOUS" then
  set reg.spwb2.replay "STOPNOW"
elseif reg.spwb2.replay neqs "ONESHOT" then
  say "Starting WB2"
  set reg.spwb2.replay "ONESHOT"
endif
return

procedure mixup
do nn 1 ntun
  calc rand random
  calc ndec rand*250 round 650 + 2 *
!  set reg.SP^{nn}.dec ndec
  if rand gt 0.4
    set reg.SP^{nn}.replay "CONT"
  else
    set reg.SP^{nn}.replay "STOPNOW"
  endif
  pause 0.01
enddo
picd get device "HUNG" hung
say "Got hung = ^hung"
if hung gt 0 set this.timer(0) 0
return

procedure checkup
picd get device "HUNG" hung
say "Got hung = ^hung"
!if hung ne 0 stop
return
