startmacro t:tbl f:cableloss[0]
! TODO overhaul, lots of [test] eqs ... then %[test]
  set vmods "a2dm14,a2dr8,a2dr11,a2dr13,d2awg,diode,femto,gigexd,lb2d,ngigexd"
  set mod ^tbl.module
  set test ^tbl.test
  set siggen ^tbl.gen

  switch "PLOTSON" po get "plotsoff" "plotson"

  ! check for valid modules
  if (mod subs vmods) isfalse then
    say "invalid module: ^mod! valid modules are: ^vmods"
    stop
  endif

  ! set valid tests and defaults!
  if mod subs a2dr8 then
    set vtests "nosig,timecode,tone"
  elseif mod subs a2dr11 then
    set vtests "nosig,timecode,tone,tuner"
  elseif mod subs a2dr13 then 
    set vtests "nosig,ramp,timecode,tone"
  elseif mod subs a2dm14 then
    set vtests "nosig,ramp,timecode,tone,trans"
  elseif mod subs d2awg then
    set vtests "nosig,cnpr,genfiles,tone"
  elseif mod subs diode then
    set vtests "diode,flash"
  elseif mod subs femto then
    set vtests "atten,nosig,out,ramp,sweep,timecode,tone,trig"
  elseif mod eqs gigexd then
    set vtests "nosig,tone"
  elseif mod subs lb2d then
    set vtests "atten,band,nosig,notch,out,ramp,stuck,sweep,timecode,tone,trig"
  elseif mod eqs ngigexd then
    set vtests "nosig,tone"
  endif
  
  if (test subs vtests) isfalse then
    say "Error! Invalid test! Valid tests are all,^vtests"
    stop
  endif

  ! display the text
  say "^{tbl.text}"

  if nosig subs test then 
    if mod eqs ngigexd then
      %gigexdnosig/^po tbl
    else 
      call sourceOff
      if ( mod subs lb2d ) or ( mod subs femto ) then 
        %lbnosig/^po tbl
      else 
        %adcnosig/^po tbl
      endif
    endif
  endif

  ! tone
  if tone subs test then 
    if mod subs d2awg then 
      %adctone/^po tbl
    elseif mod eqs ngigexd then
      %gigexdtone/^po tbl
    else
      call sourceOn ^tbl.sigfreq ^tbl.sigamp
      if ( mod subs lb2d ) or ( mod subs femto ) then 
        %lbtone/^po tbl
      else
        %adctone/^po tbl
      endif 
      call sourceOff
    endif
  endif

  if trans subs test then 
    call sourceOff
    ! DCM test needs an extra reset
    picd/flags=force|^{tbl.flags}|muxclk=p reset ^{tbl.card}
    %adcnosig/^po tbl
  endif

  ! stuck bits
  ! TODO confirm (we need to find a module with stuck bits)
  if stuck subs test then 
    if mod subs lb2d then 
      call sourceOn ^tbl.sigfreq ^tbl.sigamp
      %lbstuck/^po tbl
      call sourceOff
    endif
  endif

  if ramp subs test then 
    call sourceOn ^tbl.sigfreq ^tbl.sigamp
    if mod subs lb2d then 
      ! gain ramp (c-code goes from 0 to 75)
      %lbramp/^po tbl cableloss
    elseif mod subs femto then 
      %lbramp/^po tbl cableloss
    else
      ! acquire the data
      %adcramp/^po tbl
    endif
    call sourceOff
  endif
  
  if atten subs test then 
    call sourceOn ^tbl.sigfreq ^tbl.sigamp
    if mod subs lb2d then 
      ! atten sweeps (c-code goes from 0 to 31)
      %lbatten/^po tbl cableloss
    endif
    call sourceOff
  endif 

  if notch subs test then 
    if mod subs lb2d then 
      call sourceOff
      %lbnotch/^po tbl
    endif
  endif

  if band subs test then 
    if mod subs lb2d then 
      call sourceOff
      %lbnosig/^po tbl
    endif
  endif 

  if out subs test then 
    ! NOTE Rohde schwarz sig gen only goes to 1100 MHz
    call sourceOn ^tbl.sigfreq ^tbl.sigamp
    if mod subs lb2d then 
      %lbout/^po tbl
    elseif mod subs femto then 
      %lbout/^po tbl
    endif
    call sourceOff
  endif 

  if tuner subs test then
    if mod subs a2dr11 
      call sourceOn ^tbl.sigfreq ^tbl.sigamp
      %adctuner/^po tbl
      call sourceOff
    
    endif
  endif

  if cnpr subs test then 
    if mod subs d2awg
      %adcnpr/^po tbl ^tbl.f1 ^tbl.f2 ^tbl.gap
    endif
  endif

  if genfiles subs test then 
    %genfiles tbl
  endif
 
  if sweep subs test then 
    %lbsweep/^po tbl
  endif

  ! time code test
  if timecode subs test then
    %tcfile/^po tbl
  endif

  if flash subs test then
    %flash/^po tbl
  endif

  if diode subs test then
    %diode/^po tbl
  endif

  ! trigger test
  if trig subs test then 
    if mod subs lb2d then 
      call sourceOn ^tbl.sigfreq ^tbl.sigamp
      %lbtone/^po tbl
      call sourceOff
    endif
  endif

endmacro

procedure sourceOn f:sigfreq f:sigamp 
  hw set ^siggen ^{tbl.genpre}=1
  hw set ^siggen ^{tbl.genfreq}=^sigfreq
  hw set ^siggen ^{tbl.genamp}=^sigamp
  hw set ^siggen ^{tbl.genon}=1
return

procedure sourceOff
  hw set ^siggen ^{tbl.genoff}=1
return
