startmacro u:type[ii] u:device[pic1ii] n:npass[10] u:devout[pic0oo]

if /fab gt 0
ask answer "Make sure extender slot power is OFF [Y]/N :"
if answer neqss "Y" goto abort
if type eqs "IO" then
ask answer "Insure D2E test output module is on Module-2 connector [Y]/N :"
else
ask answer "Insure E2D test input module is on Module-2 connector [Y]/N :"
endif
if answer neqss "Y" goto abort
if type eqs "IO" then
ask answer "Press E2D in test onto extender card Module-1 connector [Y]/N :"
else
ask answer "Press D2E in test onto extender card Module-1 connector [Y]/N :"
endif
if answer neqss "Y" goto abort
ask answer "Attach ribbon cable from D2E module to the E2D module [Y]/N :"
if answer neqss "Y" goto abort
ask answer "Switch extender slot power to ON [Y]/N :"
if answer neqss "Y" goto abort
picd/flags=test test ^device 91
endif

say "Looking for card signature ..."
picd/stat=pstat sniff ^device 
if pstat lt 0 goto problem_cardsig

say "Testing PCI/SHARC interface ..."
picd/stat=pstat test ^device 0
if pstat gt 0 goto problem_card
picd reset ^device 
if type neqs "IO" and type neqs "OI" and type neqs "IOX" &
picd reset ^devout 

say "Creating test files ..."
res sr 8e6
pic create testin si 16k sr ramp
pic create testout si 1m sr 

if /hs gt 0
say "Setting speed to 20MHz ..."
header testin f=sb xd=1/20e6
header testout f=sb xd=1/20e6
else
say "Setting speed to 10MHz ..."
endif

if type eqs "II" or type eqs "IX"
if type eqs "IX" picd reset ^device io
say "Testing A side external transfer through E2D ..."
call testxfer module1 module1 testin testout testin npass
if pstat eq -1 goto problem_noclock
if pstat lt 0 goto problem_xferx
endif

if type eqs "II" or type eqs "XI"
if type eqs "XI" picd reset ^device oi
say "Testing B side external transfer through E2D ..."
call testxfer module2 module2 testin testout testin npass
if pstat eq -1 goto problem_noclock
if pstat lt 0 goto problem_xferx
endif

if type eqs "IO" 
res devout device
say "Testing A side E2D and B side D2E external transfer ..."
call testxferx module2 module1 testin testout testin npass
if pstat eq -1 goto problem_noclock
if pstat lt 0 goto problem_xferx
endif

if type eqs "OI" 
res devout device
say "Testing B side E2D and A side D2E external transfer ..."
call testxfer module1 module2 testin testout testin npass
if pstat eq -1 goto problem_noclock
if pstat lt 0 goto problem_xferx
endif

if type eqs "IOX" 
res devout device
picd reset ^device lt1
say "Testing A side E2D and B side D2E external transfer ..."
call testxferx module2 module1 testin testout testin npass
if pstat eq -1 goto problem_noclock
if pstat lt 0 goto problem_xferx
endif

if type eqs "XX"
pic create testin si 32k sr ramp
header testin f=cb 
header testout f=cb
picd/flags=muxclk reset ^device 
say "Testing AB side external transfer through E2D ..."
call testxfer module3 module3 testin testout testin npass
if pstat eq -1 goto problem_noclock
if pstat lt 0 goto problem_xferx
endif

if type eqs "ZZ" 
say "Testing B side external transfer through E2D ..."
call testxfer module1 module2 testin testout testin npass
if pstat eq -1 goto problem_noclock
if pstat lt 0 goto problem_xferx
endif

say "********************************"
say "* All tests completed normally *"
say "********************************"

if /fab gt 0
picd halt ^device
ask answer "Switch extender slot power to OFF [Y]/N :"
if answer neqss "Y" goto abort
say "Remove E2D from module-A connector "
say "Then remove ribbon cable from the E2D module "
else
picd reset ^device
endif

stop

label abort
say "Test aborted ..."
stop

label problem_cardsig
say "Problem getting the card signature."
say "Try  > Cycle power on card extender."
say "     > Power OFF card extender and reseat card in extender slot."
say "     > Check that EPROM U10 is seated correctly."
say "     > Check solder connections on U1."
stop

label problem_card
say "Problem getting the card to pass internal tests."
say "Try  > Reseat card in slot."
stop

label problem_noclock
say "     > Check ribbon cable connection/polarity from D2E to E2D."
say "     > No clock, check U3 solder connections."
stop

label problem_xferx
say "Problem with external transfer."
say "     > Check ribbon cable connection/polarity from D2E to E2D."
say "     > If bit errs fit mask 0x003F, check U1 solder connections."
say "     > If bit errs fit mask 0x0FC0, check U2 solder connections."
say "     > If bit errs fit mask 0xF000, check U3 solder connections."
stop

endmacro

procedure testxfer u:porto u:porti s:filei s:fileo s:fileg n:count

calc/quiet l:iper file(fileo).size file(filei).size /
calc/quiet l:nper 5
calc/quiet l:inper -iper*nper-1

do pass 1 count 
say " -> running transfer pass ^pass"

pipe on
if /extclk gt 0 then
 picd/replay=^inper/stat=chan/port=^porto/quiet/pause=0.5 &
	play ^devout filei
else
 picd/replay=^inper/stat=chan/port=^porto/flags=intclk/quiet/pause=0.5 &
	play ^devout filei
endif
picd/replay=-^nper/stat=pstat/port=^porti/flags=to=5|muxclk/quiet/goldtest=^fileg &
	acquire ^device fileo
pipe off
if pstat lt 0 return

enddo

return

procedure testxferx u:porto u:porti s:filei s:fileo s:fileg n:count

calc/quiet l:iper file(fileo).size file(filei).size /
calc/quiet l:nper 5

do pass 1 count
say " -> running transferx pass ^pass"
res flags "to=5"

picd/replay=4/stat=chan/port=^porto/flags=^flags|muxclk=i/quiet &
	play ^devout filei
picd/replay=-^nper/stat=pstat/kick=chan/port=^porti/flags=^flags/quiet/goldtest=^fileg &
	acquire ^device fileo
picd/port=^porto stop ^devout
if pstat lt 0 return

enddo

return

