startmacro s:fsaux["21"]
  set l:ndisks -1
  ! read aux!
  res maux aux.^fsaux
  ! parse out the config & directory
  sedit maux s:icedir trim "ice:" ","
  sedit maux s:icecon trim "," ","
  ! open the config file and determine how many disks there are
  file open/t cnf icecon
  ! read the first element
  file read cnf asdf
  ! loop through file
  while (asdf eqs null) isfalse
    file next cnf asdf
    if "DMSETUP=" subs asdf then    
      sedit asdf parts split "="
      call getNDisks "^{parts(1)}"
      break
    endif
  endwhile

  file close cnf

  ! error check
  if ("^icedir" dexists) isfalse then
    error "IceFS directory (^icedir) doesn't exist"
    stop
  endif
  if ndisks lt 1 then
    error "Problem reading Device Mapper file"
    stop
  endif

  ! clean up the files
  call cleanFiles
  calc tl ndisks 2m *

  call compareFiles 1 tst1 fsaux tl tl 4k "Small file"
  call compareFiles 1 tst2 fsaux tl tl 128m "Large file"
  call compareFiles 1 tst3 fsaux tl tl 33565905 "Non-stripe boundary 1"
  call compareFiles 1 tst4 fsaux tl tl 1153433 "Non-stripe boundary 2"
  call compareFiles 1 tst5 fsaux tl tl 7m "Regular file"
  ! erase tst3, next file < tst3 size will get stuffed there
  erase/warn=n tst3
  call compareFiles 1 tst6 fsaux tl tl 117 "Stuffed file"
  call compareFiles 1 tst7 fsaux 32k 64k 4k "Small file with sub-optimal xfer"
  call compareFiles 0 tst8 fsaux 32k 64k 48m "Large file with sub-optimal xfer"
  call compareFiles 0 tst9 fsaux 32k 64k 2923827 "Non-stripe boundary with sub-optimal xfer"
  call compareFiles 0 tst10 fsaux 32k 64k 9m "Regular file with sub-optimal xfer"
  call compareFiles 2 tst11 fsaux 32k tl 48m "Large file with 1 sub-optimal xfer"
  call compareFiles 2 tst12 fsaux 32k tl 16m "Regular file with 1 sub-optimal xfer"

  ! clean up files
  call cleanFiles

endmacro

procedure compareFiles i:native s:out s:fsaux l:tl1 l:tl2 l:nels s:str
  ! delete files
  erase/warn=n out mwave nwave1 nwave2 nwave3

  ! create a noise file
  wave mwave elem=nels shape=white

  ! noop it to and from the IceFS
  noop/tl=^tl1 mwave out{aux=^fsaux,det=det}
  noop/tl=^tl2 out nwave1
  ! compare the files
  assert/text="^str normal" mwave feq/d nwave1 AND mwave feq/s nwave1
  
  ! check if a native comparison is desired
  if native gt 0 then 
    ! copy file already on IceFS off using native 
    icecopy/tl=^tl2 out nwave2
    assert/text="^str normal on, native off" mwave feq nwave2 AND mwave feq/s nwave2
  endif
  if native eq 1 then 
    erase/warn=n out 
    ! now re-copy using only native copies
    icecopy/tl=^tl1 mwave out{aux=^fsaux}
    icecopy/tl=^tl2 out nwave3
    ! compare the files
    assert/text="^str native on, native off" mwave feq nwave3 AND mwave feq/s nwave3
  else
    ! native should fail
    !icecopy/tl=^tl1 out nwave3
    !assert/test=fail/text="^str native on, native off" mwave feq/s nwave3
  endif

return

procedure cleanFiles 
  ! erase all the files that were created
  erase/warn=n tst1 tst2 tst3 tst4 tst5 tst6 tst7 tst8 tst9 tst10 tst11 tst12 mwave nwave1 nwave2 nwave3
return

procedure getNDisks s:fstr 
  ! make sure config file exists
  if ("^fstr" fexists) isfalse then        
    error "Device Mapper file doesn't exist"
    stop
  endif
  ! it exists so read in ndisks
  file open/t dvmp "^fstr"
  file read dvmp asdf
  file close dvmp
  sedit asdf words split " "
  set l:ndisks ^words(3)
return
