startmacro/ps=4m u:device[pic1iia] s:mode[USD] d:freq[1e6] 

set nfft 2k
set wbport "MODULE1"

if mode eqs "DEF" then
 set rate 100e6
 set dec  1K
 set nchn 256
 set flg "PPC=^mode,MUXCLK=C,FTTM=2"
 set psz  2k*nchn*4

elseif mode eqs "MWC" 
 set rate 100e6
 if /m3 then
  set dec  4K
  set nchn 1024
  set flg "IOC=IIRW,MUXCLK=C,FTTM=3"
 else
  set dec  1K
  set nchn 256
  set flg "IOC=IIR,MUXCLK=C,FTTM=2"
 endif
 set psz  2k*nchn*4

elseif mode eqs "USD" or mode eqs "USD2" then  ! uses generic routing
 set rate 104e6
 set dec  100
 set nchn 1
 set flg "IOC=IIR|MUXCLK=P,TCLK=105000000|CPC=2|INP=1"  ! test
 set psz  32k

elseif mode eqs "ISD" then 
 set rate 97.2e6
 set dec  1000
 set nchn 256
 set flg "PPC=^mode,MUXCLK=P,FTTM=2"
 set xfer (1944*3+36+36) 
 set cons (1944*2) 		! CI samples
 set psz  cons*4*nchn
 set psz  xfer*4*nchn

elseif mode eqs "TSD" then 
 set rate 56e6
 set dec  1120
 set nchn 256	! up to 400
 set flg "PPC=^mode,MUXCLK=P,FTTM=2"
 set psz  32k
 set xfer 9664 
 set cons 6368 ! CI samples
 set psz  cons*4*nchn
 set psz  xfer*4*nchn

elseif mode eqs "DLT" then 
 set rate 100e6
 set nchn 1
 set dec  100
 set flg "PPC=DLT,MUXCLK=D,DELAYPORT=3"
 set psz  32k

elseif mode eqss "CSD" then
 set rate 104e6
 set dec  12
 set nchn 1
 set flg "PPC=^mode,TCLK=105000000|CPC=2"
 set psz  32k
 if mode eqs "CSD1" then set flg "IOC=IO|^flg"
 if mode eqs "CSD2" then set flg "MUXCLK=A|^flg"

elseif mode eqs "DAN" then 
 set rate 100e6
 set nchn 1
 set dec  20
 set flg "MUXCLK=P|INP=2"
 set psz  32k
 set wbport "MODULE2"

else
 error "Unsupported flow=^mode"
endif

set crate rate/dec/2
set orate rate/dec
set frep  freq+10e3
set skp   50
set cskp  32

picd get ^device type ctype

if ctype eq 10 then
  res wbfmt "SB"
else
  res wbfmt "SI"
endif

pic/round=nfft create wbfile ^wbfmt 1M rate
pic/round=psz create nafile ci nchn*crate crate
pic/round=psz create nbfile ci nchn*crate crate
pic/round=psz create ncfile ci nchn*crate crate
pic/round=psz create ndfile ci nchn*crate crate
pic/round=psz create nefile ci nchn*crate crate
pic/round=psz create cafile ci nchn*crate crate
pic/round=psz create cbfile ci nchn*crate crate
pic/round=psz create ctfile ci nchn*crate crate 

picd reset ^device /flags=flg

if /dump then
  erase testca testcb
endif

pipe/panel on

  ! wideband data source
  sourcepic/id=swb/port=^wbport wbfile{fs=nfft} _wb ^device skp*16 /flags=flg /host=n

  fft/log _wb _wbf nfft=nfft 
  plot/id=wbp _wbf

if mode eqs "CSD1" then

  sourcepic/id=sna/port=tuner1 nafile{fs=nfft} _na ^device dec freq /flags=(NODMA|^flg) /replay=0 /master=snb
  sourcepic/id=snb/port=tuner5 nbfile{fs=nfft} _nb ^device dec frep /flags=(NODMA|^flg) /slave=ss /master=snc
  sourcepic/id=snc/port=tuner9 ncfile{fs=nfft} _nc ^device dec frep /flags=(NODMA|^flg) /slave=ss /master=snd
  sourcepic/id=snd/port=tuner13 ndfile{fs=nfft} _nd ^device dec frep /flags=(NODMA|^flg) /slave=ss /master=sca
  ! need up to 6 tuners to get through - no data from the 5 and 13 tuners with CPC=2 and NODMA
  sourcepic/id=sca/port=core11 cafile{fs=nfft} _ca ^device 1 0 /flags=(IPORT=TUNER1|^flg) /slave=ss /master=scb 
  sinkpic/id=sct/port=module2  _ca ctfile   /srate=crate*6     /flags=(MUXCLK=P) /replay=0 /bits=16 /throttle=ondemand 
  sourcepic/id=scb/port=core12 cbfile{fs=nfft} _cb ^device 1 0 /flags=(^flg) /slave /skip=cskp

  fft/log _ca _caf nfft=nfft over=-cskp
  plot/id=cap _caf type=line cm=re y1=-50 y2=90
  fft/log _cb _cbf nfft=nfft 
  plot/id=cbp _cbf type=line cm=re y1=-50 y2=90

elseif mode eqs "CSD2" then

  sourcepic/id=sna/port=tuner1  nafile{fs=nfft} _na ^device dec freq /flags=(NODMA|^flg) /replay=0 /master=snb
  sourcepic/id=snb/port=tuner5  nbfile{fs=nfft} _nb ^device dec frep /flags=(NODMA|^flg) /slave /master=snc

  sourcepic/id=snc/port=tuner2  ncfile{fs=nfft} _nc ^device dec freq /flags=(NODMA|^flg) /slave /master=snd
  sourcepic/id=snd/port=tuner6  ndfile{fs=nfft} _nd ^device dec frep /flags=(NODMA|^flg) /slave /master=sne

  sourcepic/id=sne/port=tuner9 nefile{fs=nfft} _ne ^device dec freq /flags=(NODMA|^flg) /slave /master=sca

  sourcepic/id=sca/port=core11  cafile{fs=nfft} _ca ^device 1 0 /flags=(IPORT=TUNER1|^flg) /slave /master=scb /skip=cskp
  sourcepic/id=scb/port=core12  cbfile{fs=nfft} _cb ^device 1 0 /flags=(IPORT=TUNER2|^flg) /slave /xmaster=sne /skip=cskp

  fft/log _ca _caf nfft=nfft 
  plot/id=cap _caf type=line cm=re y1=-50 y2=90
  fft/log _cb _cbf nfft=nfft 
  plot/id=cbp _cbf type=line cm=re y1=-50 y2=90

elseif mode eqs "USD" then

  sourcepic/id=sna/port=tuner1 nafile{fs=nfft} _na ^device dec freq /flags=(OPORT=NONE|^flg) /replay=0  /master=scb 
  sourcepic/id=scb/port=core11 cbfile{fs=nfft} _cb ^device   1    0 /flags=(IPORT=TUNER1|^flg) /replay=0 /slave

  fft/log _na _naf nfft=nfft 
  plot/id=nap _naf type=line cm=re y1=-50 y2=90
  fft/log _cb _cbf nfft=nfft over=-50
  plot/id=cbp _cbf type=line cm=re

elseif mode eqs "USD2" then

  sourcepic/id=sna/port=tuner1  nafile{fs=nfft} _na ^device dec freq /flags=(OPORT=NONE|^flg) /replay=0  /master=snb 
  sourcepic/id=snb/port=tuner2  nbfile{fs=nfft} _nb ^device dec freq /flags=(OPORT=NONE|^flg) /slave     /master=snc 
  sourcepic/id=snc/port=tuner9  ncfile{fs=nfft} _nc ^device dec freq /flags=(OPORT=NONE|^flg) /slave=ss  /master=snd 
  sourcepic/id=snd/port=tuner11 ndfile{fs=nfft} _nd ^device dec freq /flags=(OPORT=NONE|^flg) /slave=ss  /master=sca 
  sourcepic/id=sca/port=core11  cafile{fs=nfft} _ca ^device   1    0 /flags=(IPORT=TUNER1|^flg) /slave=ss /master=scb
  sourcepic/id=scb/port=core12  cbfile{fs=nfft} _cb ^device   1    0 /flags=(IPORT=TUNER2|^flg) /slave=ss 

  fft/log _na _naf nfft=nfft 
  plot/id=nap _naf type=line cm=re y1=-50 y2=90
  fft/log _nb _nbf nfft=nfft 
  plot/id=nbp _nbf type=line cm=re y1=-50 y2=90
  fft/log _ca _caf nfft=nfft over=-50
  plot/id=cap _caf type=line cm=re
  fft/log _cb _cbf nfft=nfft over=-50
  plot/id=cbp _cbf type=line cm=re

elseif mode eqs "MWC" then

  sourcepic/id=sna/port=tbank3 nafile{fs=nfft} _na{ps=4m} ^device dec freq /flags=(OPORT=THRUCORE1|^flg) /replay=0 /master=scb /nchn=nchn /dfreq=1e3
  picd set ^device CORE 0x1 /port=core11
  sourcepic/id=scb/port=core12 cbfile{fs=nfft} _cb{ps=4m} ^device   1    0 /flags=(IPORT=TBANK1|^flg) /slave

  plot/id=nap _na view=iyx axis=frame layer={LT="nxm.ice.libg.LayerMC",&
        TYPE=LINE,PROCESS=RAW,NFFT=256,NCHAN=nchn,MIN=-32k,MAX=32K,MINRANGE=100}
  plot/id=cbp _cb view=iyx axis=frame layer={LT="nxm.ice.libg.LayerMC",&
        TYPE=LINE,PROCESS=RAW,NFFT=256,NCHAN=nchn,MIN=-32k,MAX=32K,MINRANGE=100}

elseif mode eqs "ISD" or mode eqs "TSD" then

  ! this enables the core, actual cores will turn XFER into CONS or less
  picd set ^device CORE 0x8805 /port=core11
  ! THRUCORE routes the tuner bank output through core then to host
  sourcepic/id=sna/port=tbank3 nafile{fs=xfer} _na{ps=4m} ^device dec freq /flags=(OPORT=THRUCORE1|^flg) /replay=0 /nchn=nchn /dfreq=1e3 /verbose

  plot/id=cap _na view=iyx axis=frame layer={LT="nxm.ice.libg.LayerMC",&
        TYPE=LINE,PROCESS=RAW,NFFT=256,NCHAN=nchn,MIN=-32k,MAX=32K,MINRANGE=100}

elseif mode eqs "DLT" then

  sourcepic/id=sna/port=tuner1 nafile{fs=nfft} _na ^device dec freq /flags=flg /replay=0 /master=snb 
  sourcepic/id=snb/port=tuner2 nbfile{fs=nfft} _nb ^device dec frep /flags=flg /slave 

  fft/log _na _naf nfft=nfft 
  plot/id=nap _naf type=line cm=re y1=-50 y2=90
  fft/log _nb _nbf nfft=nfft 
  plot/id=nbp _nbf type=line cm=re y1=-50 y2=90

elseif mode eqs "DAN" then

  sourcepic/id=sna/port=tuner1  nafile{fs=nfft} _na ^device dec freq /flags=(OPORT=NONE|^flg) /replay=0 /master=snb
if /extrat then
  sourcepic/id=snb/port=tuner2  nbfile{fs=nfft} _nb ^device dec frep /flags=(OPORT=NONE|^flg) /slave    /master=snc
  sourcepic/id=snc/port=tuner5  ncfile{fs=nfft} _nc ^device dec freq /flags=(OPORT=NONE|^flg) /slave=ss  /master=snd
  sourcepic/id=snd/port=tuner6  ndfile{fs=nfft} _nd ^device dec frep /flags=(OPORT=NONE|^flg) /slave=ss  /master=sca
else
  sourcepic/id=snb/port=tuner2  nbfile{fs=nfft} _nb ^device dec frep /flags=(OPORT=NONE|^flg) /slave    /master=sca
endif
  sourcepic/id=sca/port=core11  cafile{fs=nfft} _ca ^device 1 0 /flags=(IPORT=TUNER1|^flg) /slave  /master=scb /skip=cskp
  sourcepic/id=scb/port=core12  cbfile{fs=nfft} _cb ^device 1 0 /flags=(IPORT=TUNER2|^flg) /slave  /master=sva /skip=cskp

if /extrac then
  sourcepic/id=sva/port=core23  nafile{fs=nfft} _va ^device 1 0 /flags=(IPORT=CORE11|^flg) /slave  /master=svb /skip=cskp
  sourcepic/id=svb/port=core24  nbfile{fs=nfft} _vb ^device 1 0 /flags=(IPORT=CORE12|^flg) /slave              /skip=cskp
else
  sourcepic/id=sva/port=core21  nafile{fs=nfft} _va ^device 1 0 /flags=(IPORT=CORE11|^flg) /slave  /master=svb /skip=cskp
  sourcepic/id=svb/port=core22  nbfile{fs=nfft} _vb ^device 1 0 /flags=(IPORT=CORE12|^flg) /slave              /skip=cskp
endif

  fft/log _va _naf nfft=nfft 
  plot/id=nap _naf type=line cm=re y1=-50 y2=90
  fft/log _vb _nbf nfft=nfft
  plot/id=nbp _nbf type=line cm=re y1=-50 y2=90

  fft/log _ca _caf nfft=nfft 
  plot/id=cap _caf type=line cm=re y1=-50 y2=90
  fft/log _cb _cbf nfft=nfft 
  plot/id=cbp _cbf type=line cm=re y1=-50 y2=90

elseif mode eqs "DEF" then

  sourcepic/id=sna/port=tbank3 nafile{fs=nfft} _na{ps=4m} ^device dec freq &
    /flags=(^flg) /replay=0 /nchn=nchn /dfreq=1e3

  plot/id=nap _na view=iyx axis=frame layer={LT="nxm.ice.libg.LayerMC",&
        TYPE=LINE,PROCESS=RAW,NFFT=256,NCHAN=nchn,MIN=-32k,MAX=32K,MINRANGE=100}

endif


if /dump then
  noop _ca testca
  noop _cb testcb
endif

  gcontrol prompt "MODE" "Mode" mode
  gcontrol menu "ACTION" "Do" "Cont,OneShot,Stop,StopWB,Status,Test,DMACx0,DMACx1,DMACx2,SYSREG,FTT,Exit" /nc=2 /tleft
  gcontrol pipemon 

pipe off

if /dump then
  icediff testca testcb
endif

erase wbfile nafile nbfile ncfile ndfile nefile cafile cbfile ctfile

endmacro

procedure processMessage msg

if msg.name eqs "ACTION" then
  if msg.data eqs "CONT" or msg.data eqs "ONESHOT" or msg.data eqs "STOP" then
    set reg.sna.replay msg.data
    if reg.sct rexists then set reg.sct.replay msg.data
!    pause 0.5
!    set reg.swb.replay msg.data
  elseif msg.data eqs "RUNM" then
    set reg.sna.replay "CONT"
  elseif msg.data eqs "RUNS" then
    set reg.scb.replay "CONT"
  elseif msg.data eqs "DMACX0" then
    pic dmacx device /node=0
  elseif msg.data eqs "DMACX1" then
    pic dmacx device /node=7
  elseif msg.data eqs "DMACX2" then
    pic dmacx device /node=8
  elseif msg.data eqs "SYSREG" then
    picd/hex get device "CORE" /port=core11
    picd/hex get device "CORE" /port=core12
  elseif msg.data eqs "FTT" then
    icetest PPC/FTT device
  elseif msg.data eqs "STATUS" then
    pic status device
  elseif msg.data eqs "STOPWB" then
    set reg.swb.replay "STOP"
  elseif msg.data eqs "TEST" then
    if mode eqs "DLT" then
      picd/port=tuner1 set ^device DELAY 30e6
      icetest ppc/peek ^device 0xfd000600 4
    endif
  elseif msg.data eqs "EXIT" then
    pipe stop
  endif
endif
return

