startmacro/replay=0/tcps=2/tc=cpu s:card[pic3v6s] l:side[1]

calc rate  50e6
calc dec1  32
calc ratio1 (32/25)
calc rate1 rate/dec1/2 ratio1 *
calc dec2  16
calc ratio2 (1.2)
calc rate2 rate1/dec2/2 ratio2 *
calc l:ptl 1M

set l:nfdm 16
set rfn "test^{side}"

if /live then
set  flags "MUXCLK=N"
else
set  flags "IOC=IIRR|MUXCLK=P"
endif
set nflags "^flags|RESAMP|RGO"
set dflags "^flags|RGO|LUT=FM|IPORT=PM0TUNER^side"
set tflags "^flags|RESAMP|RGO|IPORT=PM^{side}COREX"

pipe on 

panel /setup /logger /controls=gc

! wideband capture
picd/round=ptl create ^{rfn}_wb si rate  rate
sourcepic/id=wb/port=module^side   ^{rfn}_wb{fs=8k} _wb card 1     /flags=flags  

! narrowband capture
picd/round=ptl create ^{rfn}_nb ci rate1 rate1
sourcepic/id=nb/port=pm0tuner^side ^{rfn}_nb{fs=8k} _nb card dec1 /ratio=ratio1  /flags=nflags 

! split demod captures
picd/round=ptl create ^{rfn}_fda si rate1 rate1
sourcepic/id=fda/port=pm^{side}core1 ^{rfn}_fda{fs=8k} _fda card 1  /flags=dflags /skip=16
picd/round=ptl create ^{rfn}_fdb si rate1 rate1
sourcepic/id=fdb/port=pm^{side}core2 ^{rfn}_fdb{fs=8k} _fdb card 1  /flags=dflags /skip=16

! post demod tuners
if /multi then
 picd/round=ptl create ^{rfn}_fdma ci rate2 rate2
 sourcepic/id=fdma/port=pm^{side}tuner1 ^{rfn}_fdma{fs=8k} _fdma card dec2 /ratio=ratio2 /flags=tflags /multi=nfdm /autoss
 picd/round=ptl create ^{rfn}_fdmb ci rate2 rate2
 sourcepic/id=fdmb/port=pm^{side}tuner2 ^{rfn}_fdmb{fs=8k} _fdmb card dec2 /ratio=ratio2 /flags=tflags /multi=nfdm /autoss
else
 do l:nn 1 nfdm*2
  picd/round=ptl create ^{rfn}_fdm^nn ci rate2 rate2
  sourcepic/id=fdm^nn/port=pm^{side}tuner^nn ^{rfn}_fdm^nn{fs=8k} _fdm^nn card dec2 /ratio=ratio2 /flags=tflags 
 enddo
endif

plot/id=tdp _fda

gcontrol menu "ACTION" "Action" "Cont,Stop,Check,Status,Exit" 
gcontrol lval "DEC1"   "PreDec  " dec1 16 256 2
gcontrol lval "DEC2"   "PostDec " dec2 16 256 2
gcontrol pipemon 

pipe off

endmacro

procedure processMessage msg

if msg.name eqs "ACTION"
  if msg.data eqs "EXIT" then
    pipe stop
  elseif msg.data eqs "STATUS" then
    pic status card
  elseif msg.data eqs "CHECK" then
    foreach item intable reg
      if reg.^item ninstanceof "nxm.ice.prim.sourcepic" continue
      set tc reg.^{item}.tc
      set delta reg.^{item}.delta
      if item eqs "WB" then
        say "SP=^item D=^delta TC=^tcd TC=^tc"
        set tc0 tc
        set delta0 delta
      else
        calc tcd tc.wsec-tc0.wsec tc.fsec-tc0.fsec + tc.offset*delta - tc0.offset*delta0 +
        say "SP=^item D=^delta TCdif=^tcd TC=^tc"
      endif
    endfor
  else
    info "Begin kick"
    if /multi then
      sendto/sync fdmb "SET.REPLAY" msg.data
      sendto/sync fdma "SET.REPLAY" msg.data
    else
     do l:nn 1 nfdm*2
      sendto/sync fdm^nn "SET.REPLAY" msg.data
     enddo
    endif
    sendto/sync fda "SET.REPLAY" msg.data
    sendto/sync fdb "SET.REPLAY" msg.data
    sendto/sync nb  "SET.REPLAY" msg.data
    sendto/sync wb  "SET.REPLAY" msg.data
    info "End kick"
  endif
elseif msg.name eqss "DEC" 
  set l:dec1 gc.DEC1.val
  set l:dec2 gc.DEC2.val
  calc rate1 rate/dec1/2 ratio1 *
  calc rate2 rate1/dec2/2 ratio2 *
  info "Reset dec1=^dec1 dec2=^dec2"
  set reg.nb.dec dec1
  set reg.fda.rate rate1 reg.fda.replay reconnect
  set reg.fdb.rate rate1 reg.fdb.replay reconnect
  do l:nn 1 nfdm*2
    set reg.fdm^{nn}.dec dec2 reg.fdm^{nn}.rate rate1 reg.fdm^{nn}.replay reconnect
  enddo
endif
return
