startmacro t:tbl
  set flags "^tbl.flags|^tbl.aflags|rffreq=^tbl.cardfreq|rfbw=^tbl.cardbw|rfgain=^tbl.gain"
  set wstr "aux=^tbl.aux"
  calc rate ^tbl.rate 1e6 *
  set failure 0

  call cleanFiles
  picd/flags=force|^flags reset ^tbl.card
  ! create the output file
  pic create fileo ^tbl.format ^tbl.fsize rate

  ! acquire
  picd/replay=^tbl.replay/port=^tbl.port/flags=^flags acquire ^tbl.card fileo
  fft/mag fileo ftmp{^wstr} ^tbl.nfft navg=^tbl.aves win=bh92
  calc fbw ^tbl.cardbw 1e6 * rate /
  icemeasure noise flist{^wstr} ftmp rate fbw ^tbl.threshdb
  call procResults flist ^tbl.nf ^tbl.spur ^tbl.thresh

  if /plotson or ( failure eq 1 ) then 
    fcalc fplot{^wstr} ftmp log 10 *
    pipe on
      panel/setup
      plot/id=plot1 fplot
      plot/id=plot2 fplot type=line
      list/id=plot3 flist
    pipe off
  endif
  call cleanFiles
endmacro

procedure cleanFiles
  erase/warn=n ftmp flist fplot fileo
return

procedure procResults hi f:vnf f:vspur f:vthresh
 status hi size=sze
  file open/d tag hi
  calc/nform=".00" nf tag.getDataTable(0).nf
  calc/nform=".00" spur tag.getDataTable(0).maxspur
  calc/nform=".00" thresh tag.getDataTable(0).thresh

  do ind 1 sze-1 1
    res tmp tag.getDataTable(ind)
    if nf gt tmp.nf
      calc/nform=".00" nf tmp.nf
    endif
    if spur gt tmp.maxspur
      calc/nform=".00" spur tmp.maxspur
    endif
    if thresh lt tmp.thresh
      calc/nform=".00" thresh tmp.thresh
    endif
  enddo

  file close tag
  ! test thresholds here
  assert/text="Noise Floor (Meas: ^nf, Thresh: ^vnf)" nf lt vnf
  assert/text="Maximum spur (Meas: ^spur, Thresh: ^vspur)" spur lt vspur
  assert/text="Median Noise (Meas: ^thresh, Thresh: ^vthresh)" thresh lt vthresh
  if ( nf ge vnf ) or ( spur ge vspur ) or ( thresh ge vthresh ) then 
    set failure 1
  endif
return 
