startmacro t:tbl
  set flags "^tbl.flags|^tbl.aflags"
  set wstr "aux=^tbl.aux"
  calc rate ^tbl.rate 1e6 *
  set failure 0

  if ( tbl.port eqs module1 ) OR ( tbl.port eqs tuner1 ) then
    set port "tuner1"
  else 
    set port "tuner2"
  endif

  call cleanFiles
  picd/flags=force|^flags reset ^tbl.card

  ! create the output file
  pic create fileo ^tbl.format ^tbl.fsize rate

  picd/flags=^flags/port=^port set ^tbl.card rffreq ^tbl.cardfreq
  picd/flags=^flags/port=^port set ^tbl.card rfbw ^tbl.cardbw

  ! acquire
  picd/replay=^tbl.replay/port=^port/flags=^flags acquire ^tbl.card fileo
  fft/mag fileo ftmp{^wstr} ^tbl.nfft navg=^tbl.aves win=bh92
  ! only consider a small portion (2%) of the signal
  ! this will determine if the notch is too wide
  icemeasure notch flist{^wstr} ftmp rate ^tbl.nbw ^tbl.fbw
  call procResults flist ^tbl.notch ^tbl.tone

  if /plotson or ( failure eq 1 ) then
    fcalc fplot{^wstr} ftmp log 10 *
    pipe on
      panel/setup
      plot/id=plot1 fplot
      plot/id=plot2 fplot type=line
      list/id=plot3 flist
    pipe off
  endif
  call cleanFiles
endmacro

procedure cleanFiles
  erase/warn=n ftmp flist fplot fileo
return

procedure procResults hi f:vnotch f:vtone
  status hi size=sze
  file open/d tag hi
  calc/nform=".00" ndel tag.getDataTable(0).median tag.getDataTable(0).notch - 
  calc/nform=".00" tone tag.getDataTable(0).tone

  do ind 1 sze-1 1
    res tmp tag.getDataTable(ind)
    calc/nform=".00" cdel tmp.median tmp.notch -
    if cdel lt ndel then 
      set ndel cdel
    endif
    if tone lt tmp.tone then 
      calc/nform=".00" tone tmp.tone
    endif 
  enddo

  file close tag
  ! test thresholds here
  assert/text="Notch depth (Meas: ^ndel, Thresh: ^vnotch)" ndel gt vnotch
  assert/text="Leak through (Meas: ^tone, Thresh: ^vtone)" tone lt vtone
  if ( ndel le vnotch ) or ( tone ge vtone ) then 
    set failure 1
  endif
return 
