startmacro t:tbl
  set wstr "aux=^tbl.aux"
  calc rate ^tbl.rate 1e6 *
  calc freq ^tbl.sigfreq 1e6 *
  set failure 0 

  ! determine byte order
  if ^tbl.endian eqs eeei then
    set bswap false
  else 
    set bswap true
  endif

  calc maxout ^tbl.fsize ^tbl.skip /

  call cleanFiles
  wave fileo{^wstr} ^tbl.format ^tbl.fsize zero delta=^rate

  sourceice/tl=1k/sdds "udp:^{tbl.nic}/^{tbl.multi}" fileo ^tbl.format rate /skip=^tbl.skip /frame=^tbl.frame /maxout=^maxout /swap=^bswap
  fft/tl=^tbl.nfft/mag fileo ftmp{^wstr} ^tbl.nfft win=bh92 navg=^tbl.aves
  ! process the data!
  icemeasure char flist{^wstr} ftmp rate ^tbl.fbw ^tbl.threshdb freq
  call procResults flist ^tbl.snr ^tbl.sfdr ^tbl.thresh 

  if /plotson or ( failure eq 1 ) then 
    fcalc fplot{^wstr} ftmp log 10 *
    pipe on
      panel/setup
      plot/id=plot1 fileo type=line
      plot/id=plot2 fplot
      plot/id=plot3 fplot type=line
      list/id=plot4 flist
    pipe off
  endif
  call cleanFiles
endmacro

procedure cleanFiles
  erase/warn=n temp fileo ftmp flist fplot
return

procedure procResults hi f:vsnr f:vsfdr f:vthresh
  status hi size=sze
  file open/d tag hi
  calc/nform=".00" snr tag.getDataTable(0).snr
  calc/nform=".00" sfdr tag.getDataTable(0).sfdr
  calc/nform=".00" thresh tag.getDataTable(0).thresh

  do ind 1 sze-1 1
    res tmp tag.getDataTable(ind)
    if snr gt tmp.snr
      calc/nform=".00" snr tmp.snr
    endif
    if sfdr gt tmp.sfdr
      calc/nform=".00" sfdr tmp.sfdr
    endif
    if thresh lt tmp.thresh
      calc/nform=".00" thresh tmp.thresh
    endif
  enddo

  file close tag
  ! test thresholds here
  assert/text="Signal-to-Noise (Meas: ^snr, Thresh: ^vsnr)" ^snr gt vsnr
  if snr le vsnr then 
    set failure 1
  endif
  if /tone isnull then 
    assert/text="Spur Free Dynamic Range (Meas: ^sfdr, Thresh: ^vsfdr)" ^sfdr gt vsfdr
    assert/text="Median Noise Floor (Meas: ^thresh, Thresh: ^vthresh)" ^thresh lt vthresh
    if ( sfdr le vsfdr ) or ( thresh ge vthresh ) then 
      set failure 1 
    endif 
  endif
return
