startmacro t:tbl
  set wstr "aux=^tbl.aux"
  calc rate ^tbl.rate 1e6 *
  set failure 0

  call cleanFiles

  calc maxout ^tbl.fsize ^tbl.skip /
  wave fileo{^wstr} ^tbl.format ^tbl.fsize zero delta=^rate
  ! acquire
  sourceice/sdds/xfer=1m "udp:^{tbl.nic}/^{tbl.multi}" fileo ^tbl.format rate /skip=^tbl.skip /frame=^tbl.frame /maxout=^maxout

  ! process
  fft/tl=^tbl.nfft/mag fileo ftmp{^wstr} ^tbl.nfft win=bh92 navg=^tbl.aves
  icemeasure noise flist{^wstr} ftmp rate ^tbl.fbw ^tbl.threshdb
  call procResults flist ^tbl.nf ^tbl.spur ^tbl.thresh

  if /plotson or ( failure eq 1 ) then 
    fcalc fplot{^wstr} ftmp log 10 *
    pipe on
      panel/setup
      plot/id=plot1 fileo type=line
      plot/id=plot2 fplot
      plot/id=plot3 fplot type=line
      list/id=plot4 flist
    pipe off
  endif
  call cleanFiles
endmacro

procedure cleanFiles
  erase/warn=n fileo ftmp flist fplot
return

procedure procResults hi f:vnf f:vspur f:vthresh
  status hi size=sze
  file open/d tag hi
  calc/nform=".00" nf tag.getDataTable(0).nf
  calc/nform=".00" spur tag.getDataTable(0).maxspur
  calc/nform=".00" thresh tag.getDataTable(0).thresh

  do ind 1 sze-1 1
    res tmp tag.getDataTable(ind)
    if nf lt tmp.nf
      calc/nform=".00" nf tmp.nf 
    endif
    if spur lt tmp.maxspur
      calc/nform=".00" spur tmp.maxspur
    endif
    if thresh lt tmp.thresh
      calc/nform=".00" thresh tmp.thresh
    endif
  enddo

  file close tag
  assert/text="Noise Floor (Meas: ^nf, Thresh: ^vnf)" nf lt vnf
  assert/text="Spur (Meas: ^spur, Thresh: ^vspur)" spur lt vspur
  assert/text="Median Noise (Meas: ^thresh, Thresh: ^vthresh)" thresh lt vthresh
  if ( nf ge vnf ) or ( spur ge vspur ) or ( thresh ge vthresh ) then 
    set failure 1
  endif
return

