startmacro t:tbl l:f1 l:f2
  set flags "^tbl.flags|^tbl.aflags"
  set wstr "aux=^tbl.aux"
  calc rate ^tbl.rate 1e6 *
  set failure 0

  ! check if a reset is required
  if /noreset isnull then
    call cleanFiles
    picd/flags=force|^flags reset ^tbl.card
  endif
  pic create fileo ^tbl.format ^tbl.fsize rate
  picd/replay=^tbl.replay/port=^tbl.port/flags=^flags acquire ^tbl.card fileo
  fft/mag fileo ftmp{^wstr} ^tbl.nfft win=bh92 navg=^tbl.aves
  icemeasure harm flist{^wstr} ftmp rate ^tbl.threshdb f1 f2 ^tbl.order

  call procResults flist ^tbl.snr ^tbl.s1s2 ^tbl.sfdr ^tbl.thresh

  if /plotson or ( failure eq 1 ) then 
    fcalc fplot{^wstr} ftmp log 10 *
    pipe on
      panel/setup
      plot/id=plot1 fileo
      plot/id=plot2 fplot
      plot/id=plot3 fplot type=line
      list/id=plot4 flist
    pipe off
  endif 
  call cleanFiles
endmacro

procedure cleanFiles
  erase/warn=n fileo ftmp fplot flist
return

procedure procResults hi f:vsnr f:vs1s2 f:vsfdr f:vthresh
 status hi size=sze
  file open/d tag hi

  calc/nform=".00" snr tag.getDataTable(0).snr
  calc/nform=".00" sfdr tag.getDataTable(0).sfdr
  calc/nform=".00" thresh tag.getDataTable(0).thresh
  calc/nform=".00" s1s2 tag.getDataTable(0).s1s2 abs

  do ind 1 sze-1 1
    res row tag.getDataTable(ind)
    if snr gt row.snr
      calc/nform=".00" snr row.snr
    endif
    ! absolute value for signal delta
    calc/nform=".00" cur row.s1s2 abs
    if s1s2 lt cur
      res s1s2 cur
    endif
    if sfdr gt row.sfdr
      calc/nform=".00" sfdr row.sfdr
    endif
    if thresh lt row.thresh
      calc/nform=".00" thresh row.thresh
    endif
  enddo

  file close tag
  assert/text="Signal-to-Noise (Meas: ^snr, Thresh: ^vsnr)" snr gt vsnr
  assert/text="Signal-to-Signal (Meas: ^s1s2, Thresh: ^vs1s2)" s1s2 lt vs1s2
  assert/text="Spur Free Dynamic Range (Meas: ^sfdr, Thresh: ^vsfdr)" sfdr gt vsfdr
  assert/text="Median Noise (Meas: ^thresh, Thresh: ^vthresh)" thresh lt vthresh
  if ( snr le vsnr ) or ( s1s2 ge vs1s2 ) or ( sfdr le vsfdr ) or ( thresh ge vthresh ) then
    set failure 1
  endif
return

