startmacro t:tbl
  set flags "^tbl.flags|^tbl.aflags"
  set wstr "aux=^tbl.aux"
  calc rate ^tbl.rate 1e6 *

  ! check if a reset is required
  if /noreset isnull then
    call cleanFiles
    picd/flags=force|^flags reset ^tbl.card
  endif

  ! create the file
  file open/d/n tag2 temp{sr=(GAIN/SD,PEAK/SD,SNR/SD,SFDR/SD,THRESH/SD)}

  calc freq ^tbl.sigfreq 1e6 *
  pic create fileo ^tbl.format ^tbl.fsize rate
  set mingain 99999
  set maxgain -99999
   
  ! loop
  do gain ^tbl.gbeg ^tbl.gend ^tbl.gstep
    set failure 0 
    ! acquire the file
    picd/replay=^tbl.replay/port=^tbl.port/flags=^flags acquire ^tbl.card fileo gain=^gain

    fft/mag fileo ftmp{^wstr} ^tbl.nfft navg=^tbl.aves win=bh92
    icemeasure char flist{^wstr} ftmp rate ^tbl.fbw ^tbl.threshdb freq

    call procResults flist mtab ^gain again ^tbl.snr ^tbl.sfdr ^tbl.thresh
    ! two seperate conditionals in case the max or min is 1st
    if ^again lt mingain
      set mingain ^again
    endif
    if ^again gt maxgain
      set maxgain ^again
    endif
    invoke ,, tag2.insertData(-1,mtab)
    if /plotson or ( failure eq 1 ) then 
      fcalc fplot{^wstr} ftmp log 10 *
      pipe on
        panel/setup
        plot/id=plot1 fileo
        plot/id=plot2 fplot
        plot/id=plot3 fplot type=line
      pipe off
    endif
  enddo

  ! close the file
  invoke ,, tag2.flush() 
  file close tag2
  ! make sure the gain was acceptable
  calc/nform=".00" gdelta maxgain mingain 2 ^tbl.gthresh * + - 
  assert/text="Testing Gain Ramp (Meas: ^gdelta, Thresh: 0)" ^gdelta le 0
  if /plotson or ( gdelta gt 0 ) then 
    list temp
  endif
  call cleanFiles
endmacro

procedure cleanFiles
  erase/warn=n temp fileo ftmp flist fmax fplot fplot2
return

procedure procResults hi tab f:gain again f:vsnr f:vsfdr f:vthresh
  status hi size=sze
  file open/d tag hi
  calc/nform=".00" snr tag.getDataTable(0).snr
  calc/nform=".00" sfdr tag.getDataTable(0).sfdr
  calc/nform=".00" thresh tag.getDataTable(0).thresh
  calc/nform=".00" accum 10 tag.getDataTable(0).sig 20 / ** sze /

  do ind 1 sze-1 1
    res tmp tag.getDataTable(ind)
    if snr gt tmp.snr
      calc/nform=".00" snr tmp.snr
    endif
    if sfdr gt tmp.sfdr
      calc/nform=".00" sfdr tmp.sfdr
    endif
    if thresh lt tmp.thresh
      calc/nform=".00" thresh tmp.thresh
    endif
    calc/nform=".00" accum 10 tag.getDataTable(0).sig 20 / ** sze / accum +
  enddo

  calc peak accum log 20 *
  file close tag
  ! build table
  res ^tab {GAIN=^gain,PEAK=^peak,SNR=^snr,SFDR=^sfdr,THRESH=^thresh}
  calc again peak gain -
  ! test thresholds here
  assert/text="Signal/Noise Gain=^gain dB (Meas: ^snr, Thresh: ^vsnr)" snr gt vsnr
  assert/text="Spur Free Dynamic Range Gain=^gain dB (Meas: ^sfdr, Thresh: ^vsfdr)" sfdr gt vsfdr
  assert/text="Median Noise Gain=^gain dB (Meas: ^thresh, Thresh: ^vthresh)" thresh lt vthresh
  if ( snr le vsnr ) or ( sfdr le vsfdr ) or ( thresh ge vthresh ) then 
    set failure 1
  endif
return
