startmacro t:tbl s:in
  set flags "^tbl.flags|^tbl.aflags"
  set wstr "aux=^tbl.aux"
  calc rate ^tbl.rate 1e6 *
  set failure 0 

  ! check if a reset is required
  if /noreset isnull then
    call cleanFiles
    picd/flags=force|^flags reset ^tbl.card
  endif
  pic create fileo ^tbl.format ^tbl.fsize rate
  picd/replay=^tbl.replay/port=^tbl.port/flags=^flags acquire ^tbl.card fileo
  ! process the data!
  thin in ftmpin{^wstr} end=^tbl.fsize
  fft/mag ftmpin ftmp1{^wstr} ^tbl.nfft navg=^tbl.aves win=bh92
  fft/mag fileo ftmp2{^wstr} ^tbl.nfft navg=^tbl.aves win=bh92
  icemeasure mse flist{^wstr} ftmp1 ftmp2 ^tbl.segs

  call procResults flist ^tbl.vave ^tbl.vworst

  if /plotson or ( failure eq 1 ) then 
    fcalc fplot{^wstr} ftmp2 log 10 *
    pipe on
      panel/setup
      plot/id=plot1 fileo
      plot/id=plot2 fplot
      plot/id=plot3 fplot type=line
      list/id=plot4 flist
    pipe off
  endif 
  call cleanFiles
endmacro

procedure cleanFiles
  erase/warn=n fileo fplot flist ftmpin ftmp1 ftmp2
return

procedure procResults hi f:vave f:vworst
  status hi size=sze
  file open/d tag hi
  calc/nform=".00" ave tag.getDataTable(0).average
  calc/nform=".00" worst tag.getDataTable(0).worst

  do ind 1 sze-1 1
    if ave lt tag.getDataTable(ind).average
      calc/nform=".00" ave tag.getDataTable(ind).average
    endif
    if worst lt tag.getDataTable(ind).worst
      calc/nform=".00" worst tag.getDataTable(ind).worst
    endif
  enddo

  file close tag
  assert/text="Average Error (Meas: ^ave, Thresh: ^vave)" ave lt vave
  assert/text="Worst Error (Meas: ^worst, Thresh: ^vworst)" worst lt vworst
  if ( ave ge vave ) or ( worst ge vworst ) then 
    set failure 1 
  endif
return
