////////////////////////////////////////////////////////////
//  Icepic.h - prototypes and structures
//  Portions Copyright (c) 1997-2000, BlueWater Systems, Inc.
////////////////////////////////////////////////////////////

#define VENDOR_ID        0x1172
#define DEVICE_ID        0x7777

#define MAX_BUSES_TO_SEARCH        129

// this definition determines the maximum number of devices of this type that can handled by this driver
#define ICEPIC_DEVICES_SUPPORTED        16

// the increment applied to completed requests
#define ICEPIC_IO_INCREMENT             IO_NO_INCREMENT

// this define controls the size of the common buffer
#define ICEPIC_DMA_LENGTH               131072

// this is the IOCTL control code
#define ICEPIC_IOCTL (ULONG)CTL_CODE(ICEPIC_DEVICE_TYPE,0x800,METHOD_BUFFERED,FILE_ANY_ACCESS)

// the main PCI device structure
typedef struct _ICEPIC_PCI_INFORMATION {
    LONG	SlotNumber; // non-PNP needs
    ULONG	BusNumber; // non-PNP needs
} ICEPIC_PCI_INFORMATION, *PICEPIC_PCI_INFORMATION;

// the main device structure
typedef struct _DEVICE_EXTENSION {
    WKDEV_INFORMATION           Information;        // WinDK device information
    WINDK_MAPPED_ADDRESS        Registers;          // memory range information
    ULONG			BusNumber,SlotNumber; // non-PNP needs
} DEVICE_EXTENSION, *PDEVICE_EXTENSION;

// prototypes

// main driver entry point
NTSTATUS DriverEntry(IN  PDRIVER_OBJECT  pDriverObject,
                     IN  PUNICODE_STRING pRegistryPath);

// initializes the device
#ifdef WINDK_ENV_PNP
NTSTATUS IcepicCreateDevice(IN  PDEVICE_OBJECT  pPhysicalDeviceObject,
                            IN  PDRIVER_OBJECT  pDriverObject,
                            IN  PWSTR           pDeviceName,
                            IN  PUNICODE_STRING pRegistryPath,
                            IN  ULONG           DeviceNumber,
                            OUT PDEVICE_OBJECT  *ppDeviceObject);
#else
NTSTATUS IcepicCreateDevice(IN  PDRIVER_OBJECT  pDriverObject,
                            IN  PWSTR           pDeviceName,
                            IN  PUNICODE_STRING pRegistryPath,
                            IN  ULONG           DeviceNumber,
                            OUT PDEVICE_OBJECT  *ppDeviceObject,
                            IN  PVOID           pContext);
#endif

// deletes the device
VOID IcepicDeleteDevice(IN  PDEVICE_OBJECT  pDeviceObject);

// unmap the device's resources
VOID IcepicUnMapDeviceResources(IN  PDEVICE_EXTENSION  pExtension);

// a handler for unload is needed to cleanup the driver
VOID IcepicUnload(IN  PDRIVER_OBJECT pDriverObject);

// a handler is needed for Cleanup
NTSTATUS IcepicCleanup(
    IN  PDEVICE_OBJECT pDeviceObject,
    IN  PIRP           pIrp);

// add device for plug and play
NTSTATUS CALLBACK IcepicAddDevice(
    IN  PDRIVER_OBJECT  pDriverObject,
    IN  PDEVICE_OBJECT  pPhysicalDeviceObject);

// driver wide dispatch routine
NTSTATUS IcepicDriverDispatch(
    IN  PDEVICE_OBJECT pDeviceObject,
    IN  PIRP           pIrp);

// Perform the Read request from the dispatch routine
NTSTATUS IcepicIoctl(
    IN  PDEVICE_EXTENSION   pExtension,
    IN  PIRP                pIrp,
    IN  PIO_STACK_LOCATION  pIrpStack);

// Hardware initialization
NTSTATUS IcepicInitializeBoard(IN  PDEVICE_EXTENSION pExtension);

// Hardware uninitialization
VOID IcepicUnInitializeBoard(IN  PDEVICE_EXTENSION pExtension);

