#define MAXDEV 24
#define MAXBIO 32
#define MSKBIO (MAXBIO-1)
#define MAXNOD 256
#define SBR 512

#define ICEFS_ENA_WR 1
#define ICEFS_ENA_DIO 2
#define ICEFS_ENA_KRN 4

// Midas Super Block Header
struct icesbfile {
  char version[4];
  char filla[20];
  int32_t ext_start, ext_size;
  double data_start, data_size;
  char fillb[20];
  char fillc[92];
  int32_t keylength;
  char keywords[92];
  char adjunct[256];
};

struct submit_bio_ret {
  struct completion event;
  int error;
};

// icefs super 
struct icefs_sb_info {
  // 512by on disk - read only for blkid recognition and MSB file allocation
  int32_t magic;	// 0x01cef500
  int32_t soff;		// byte offset to MSB file
  int32_t skeys;	// byte allocation for inodes
  int32_t smaps;	// byte allocation for maps
  int32_t devtype;	// dev type 1=char 2=block 3=icebd
  int32_t devices;	// number of devices in stripe set
  int32_t blocksize;	// block size in bytes
  int32_t stripesize;	// stripe size in bytes
  uint8_t label[16];	// volume label
  int32_t uuid[4];	// unique ID
  uint8_t devlist[256];	// list of devices in stripe set
  int32_t magx;		// 0x01cef501

  uint8_t pad[192];	// pad to 512 by for on disk superblock read

  // in memory only 
  int32_t pagesize;
  int32_t bouncesize;
  int32_t blocks;
  int32_t pages;
  int32_t bused;
  int32_t files;
  int32_t fused;
  rwlock_t kwlock,balock,bmlock;
  struct  file cdfh;
  struct  file *fdev[MAXDEV];
  struct  block_device *bdev[MAXDEV];
  struct  icesbfile *msbf;
  char    *kws;		// Keyword blocks
  int32_t *map;		// Block map
  int32_t *nextinode;
  int32_t *nextblock;
  int32_t *nextpage;
  int32_t *pageblock;
  int32_t *blockused;
  size_t  max_xfer;
  int32_t bindex;
  int32_t rdev;
  int32_t sbmc;		// SuperBlock modify count
  int32_t ibdi;		// IceBlkDevice index
};

struct icefs_file {
  int32_t ino;	// inode number
  int32_t pblk;	// page block
  int16_t pind;	// page index
  int16_t pbyt;	// page bytes
  int32_t sblk;	// start block
  int32_t nblk;	// number allocated blocks
  int32_t fbyt;	// number free bytes in last block
  int32_t iblk;	// current data block logical index
  int32_t dblk;	// current data block physical index
  loff_t  dpos;	// physical position on device
  int32_t doff;	// offset in block
  int32_t ddev;	// device number
  int32_t devno;
  int32_t atime;
  int32_t mtime;
  int32_t bindex;
  char    *bounce;
  struct  bio bio[MAXBIO];
  struct  bio_vec bvec[MAXBIO];
  struct  submit_bio_ret bret[MAXBIO];
};
