/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See UDAT.jv for documentation.
*/

import CORE_types::*;
package UDAT_types;
import CORE_types::*;
endpackage
import UDAT_types::*;

module UDAT_core #(PORT=1, IBW=32,OBW=32, IFLG=0,OFLG=0, IOCLKS=1, IKR=8,OKR=4, PBW=32,PKR=1) (
  input[2:0] s_clks, input s_rst, input s_cs, input[31:0] s_addr,
                     input s_wr, input[31:0] s_wrbus, input s_rd, output[31:0] s_rdbus, output s_ack,
  input[3:0] io_clk, output[1:0] i_rdy, input i_ena, input[7:0] i_sel, input[IBW-1:0] i_bus,
                     output[1:0] o_rdy, input o_ena, output[7:0] o_sel, output[OBW-1:0] o_bus,
  output [7:0] s_test);
  wire T=1,F=0; wire[7:0] T8=~0,F8=0;
  localparam SBW=32, ARRAY=0, STREAM=1, BUFFER=2, BUFSTR=3, PACKET=4;
  localparam BCIO=0, BCI=1, BCO=2, BCIIO=3, BCIOO=4, BCIIIOO=5;
  localparam FRAW=0, FCXI=1, FBIT=2, FAXI=3, FALL=4, FSWP=5;
  localparam TIGHT=8, BPAR=1024, BDMA=2048, BENA=16384, DBLBUF=32768, NEMPTY=131072, RAHEAD=262144;
  localparam FLOW=BUFSTR, BUFCFG=BCIO, SELFPACE=1, PIPE=-1, MC=0, CW=6, AW=16, MBW=256, NP=1, BW=32, SIBW=BW, SOBW=BW, BIBW=BW, BOBW=BW, PIBW=PBW, POBW=PBW, IFMT=FRAW, OFMT=FSWP, DBGBW=32, DBGBD=10, P2=FLOW, P3=NP, P4=BW, P5=0, P6=0, P7=0;
  localparam XIBW=BIBW, XOBW=SOBW;
  localparam BWP=BW/8, IBWP=IBW/8, OBWP=OBW/8, XIBWP=XIBW/8, XOBWP=XOBW/8;
  localparam XIBWO=(XIBW>64)? 4 : (XIBW>32)? 3 : (XIBW>16)? 2 : (XIBW>8)? 1 : 0;
  localparam XOBWO=(XOBW>64)? 4 : (XOBW>32)? 3 : (XOBW>16)? 2 : (XOBW>8)? 1 : 0;
  localparam NSUB=PORT/100, SUB=PORT%100;

  wire s_clk=s_clks[0],clk=s_clks[0],clk2=s_clks[1]; wire[1:0] clks=s_clks;
  logic rst,s_wrsys,s_wrscid; logic[31:0] s_sys; logic s_csm,s_csd,s_ena; logic[3:0] s_scid; 
  logic c_rd,c_wr,c_wok; logic[15:0] c_adr; logic[31:0] c_wbus,c_rbus; wire c_ok;
  always @(posedge s_clk) begin
    s_csd <= s_cs && s_addr[11:0]==12'hFFC;
    s_csm <= s_cs && !s_csd;
    s_wrsys <= s_cs && s_wr && s_addr[11:0]==0;
    if (s_rst) s_sys <= 0; else if (s_wrsys) s_sys <= s_wrbus;
    rst <= s_rst || s_sys[23];
    if (s_rst) c_wok <= 1; else if (!c_wr) c_wok <= !s_sys[22];
    s_ena <= (NSUB>0)? s_clks[2] : s_sys[0];
  end
  wire frst=!s_ena; wire s_opt=s_sys[4]; wire[3:0] s_ifmt=s_sys[11:8], s_ofmt=s_sys[15:12]; wire [1:0] s_vbpr=s_sys[21:20];
  wire i_frst = frst; wire o_frst = frst; wire p_frst = frst;

  wire [31:0] s_sub, s_rdbusm, s_rdbust; wire [63:0] s_val; wire [15:0] s_ind; wire[26:0] s_set;
  wire s_csr=s_csm && !s_sub[24] && !s_addr[0];
  setter #(27,1) s_bank (clk,rst,s_csm&s_wr,s_addr,s_wrbus,s_sub,s_ind,s_set,s_val);
  portstatusblk #(PORT,"UDAT",P2,P3,P4,P5,P6,P7) s_sblk (s_clk,s_csr,s_addr,s_wr,s_wrbus,s_rd,s_rdbusm, clk,1'b1,c_adr,c_wok&c_wr,c_wbus,c_rd,c_rbus);
  assign s_rdbus = s_rdbusm;

  wire i_clk=io_clk[0], o_clk=(IOCLKS>1)?io_clk[1]:io_clk[0];
  logic bi_rd,so_wen,bi_nxt,bi_rok,so_wok; logic[7:0] so_swaps;
  logic[AW-1:0] bi_adr,bi_len; logic[31:0] bi_dma;
  logic[XIBW-1:0] bi_bus; logic[XIBWP-1:0] bi_sel; logic[XOBW-1:0] so_wbus; logic[XOBWP-1:0] so_wsel;
  logic[XIBWO-1:0] bi_adrb;  always @(posedge s_clk) bi_adrb <= bi_adr;
  logic[7:0] bi_busb; assign bi_busb = bi_bus >> {bi_adrb,3'h0};
  logic i_val; always @(posedge i_clk) i_val <= i_ena;
  wire c_rdy = (SELFPACE!=0) || (bi_rok && so_wok);

  fiaoNxM #(IBW+IBWP,XIBW+XIBWP,IKR,5,IFLG^BPAR,BPAR|BDMA|BENA) f_i (i_clk,i_frst, i_rdy,i_val,{i_sel,i_bus}, s_clk,i_frst, bi_rok,bi_rd,bi_dma,bi_nxt,bi_adr,bi_len,{bi_sel,bi_bus});
  if (NSUB>0 && SUB==1) assign s_ack = bi_rok;
  logic so_wen_; logic[XOBWP-1:0] so_wsel_; logic[XOBW-1:0] so_wbus_;   convertEndian f_oswp (s_clk,o_frst,so_swaps, so_wen,so_wsel,so_wbus, so_wen_,so_wsel_,so_wbus_);
  generate if (NSUB>0 && SUB!=NSUB) begin
    assign o_bus=so_wbus_, o_sel=so_wsel_, o_rdy=so_wen_, so_wok=o_ena;
  end else begin
    fifoNxM #(XOBW+XOBWP,OBW+OBWP,OKR,5,BPAR,OFLG^BPAR) f_o (s_clk,o_frst, so_wok,so_wen_,{so_wsel_,so_wbus_}, o_clk,o_frst, o_rdy,o_ena,{o_sel,o_bus});
    if (NSUB>0 && SUB==NSUB) assign s_ack = so_wok;
  end endgenerate

  logic c_start,c_prep,c_done,c_active; logic[15:0] c_cnt,c_stat;
  always @(posedge clk) begin
    if (frst) c_prep <= 1; else if (c_done) c_prep <= 0;
    if (frst) c_start <= 0; else c_start <= s_ena && (c_rdy||c_prep) && !c_start && !c_active;
    if (frst) c_active <= 0; else c_active <= c_start || (c_active && !c_done);
    if (c_start) c_cnt <= 0; else c_cnt <= c_cnt+1;
  end
  flowcontrol f_c (clk, frst, s_opt, c_cnt, c_ok);

  import CORE_funcs::*;

  localparam NL=250, PT_AUTO=-1, PT_NONE=0, PT_NOOP=1, PT_ICE=2, PT_SDDS=3, PT_VRT=4, PT_VRTL=5, PT_VRTW=6, PT_VRTX=7,
     PT_VRTD=8, PF_FILL=0, PF_TIME=1, PF_OUID=2, PF_DBG=3, PF_FB3=4, PF_ANYSID=5, PF_BYPASS=6, PF_CTXF=7, PF_XSR=8,
     PF_XIF=9, PF_XRF=10, PF_XGAIN=11, OUID=1068407, DIFI=6971934;
  localparam CV_halo_sys=0, CV_halo_flag=28, CV_halo_func=64, CV_halo_fmts=68, CV_halo_flow=72, CV_halo_impl=76;
  localparam CV_pkty=256,CV_flags=260,CV_sid=264,CV_pinc=268,CV_cwsec=272,CV_nwsec=276,CV_cpsec=280,CV_npsec=288,
    CV_mpsec=296,CV_counts=304,CV_nseq=308,CV_swaps=312,CV_length=316,CV_ifix=320,CV_mfix=324,CV_nfix=328,CV_pad=332,
    CV_pstate=336,CV_npinc=340,CV_ouid=344,CV_pass=348,CV_vctx=352,CV_dbps=356,CV_maxfer=360;

  int8 pkty;
  uint12 flags;
  uint16 sid;
  uint20 pinc;
  uint32 cwsec;
  uint32 nwsec;
  uint40 cpsec;
  uint40 npsec;
  uint40 mpsec;
  uint32 counts;
  uint8 nseq;
  int8 swaps;
  uint12 length;
  uint4 ifix;
  uint4 mfix;
  uint4 nfix;
  uint32 pad;
  uint4 pstate;
  uint20 npinc;
  int24 ouid;
  uint4 pass;
  uint28 vctx;
  uint6 dbps;
  uint12 maxfer;

  /* verilator lint_off UNOPTFLAT */
  Line c_ln[250];  wire c_en[250];  wire c_xn[250];
  /* verilator lint_on UNOPTFLAT */

  setLine #(1,0,0) f_1 (c_ln[1],"startMethod",c_start,F);    // public int process ( BufferI bi , StreamO so ) {
  uint14 ulen;                                               // uint14 ulen ;
  uint12 xfer, bfer, i;                                      // uint12 xfer , bfer , i ;
  uint8 ioff, seq;                                           // uint8 ioff , seq ;
  uint4 ooff, bpa, j;                                        // uint4 ooff , bpa , j ;
  uint6 bps, coff;                                           // uint6 bps , coff ;
  uint32 bx, by, bz;                                         // uint32 bx , by , bz ;
  uint40 lpsec;                                              // uint40 lpsec ;
  int32 difws;                                               // int32 difws ;
  int44 difps;                                               // int44 difps ;
  uint16 id;                                                 // uint16 id ;
  uint2 ifb;                                                 // uint2 ifb ;
  uint10 pfix;                                               // uint10 pfix ;
  int28 dpsec, fpsec;                                        // int28 dpsec , fpsec ;
  int20 phinc;                                               // int20 phinc ;
  int32 bc;                                                  // int32 bc ;
  boolean isNone, isNoop, isICE, isSDDS, isVRT, isVRTi, isVRTj, isVRTd, isVRTc, isVCTX, isSID, isBE, isNB, isOK; // boolean isNone , isNoop , isICE , isSDDS , isVRT , isVRTi , isVRTj , isVRTd , isVRTc , isVCTX , isSID , isBE , isNB , isOK ;
  boolean anyID, hasOUID, hasSID, useFill, useTC, useOUID, anyOUID, fb3, dbg, ctxf, xSR, xIF, xRF, xGain, byp; // boolean anyID , hasOUID , hasSID , useFill , useTC , useOUID , anyOUID , fb3 , dbg , ctxf , xSR , xIF , xRF , xGain , byp ;
  boolean okICE, okSDDS, okVRT, okIn, okLen, oknSec, doFill, doWrap, doStop, doClip, doTrim; // boolean okICE , okSDDS , okVRT , okIn , okLen , oknSec , doFill , doWrap , doStop , doClip , doTrim ;
  boolean cweqnw, cwgtnw, cwltnw, cpeqnp, cpgtnp, cpltnp, ceqn, cgtn, cltn, lpgtnp, needPad, needFill, needDrop, isDrop; // boolean cweqnw , cwgtnw , cwltnw , cpeqnp , cpgtnp , cpltnp , ceqn , cgtn , cltn , lpgtnp , needPad , needFill , needDrop , isDrop ;
  setLine #(1,0,0) f_21 (c_ln[21],"If",c_prep,F);            // if ( this.halo.prep ) {
  setLine #(21,0,0) f_22 (c_ln[22],"BufferI_rokLen",T,F);    // bi.rokLen ( maxfer << 2 ) ;
  setLine #(21,4,0) f_23 (c_ln[23],"return",c_stat,F);       // return 0 ;
  setLine #(23,0,0) f_24 (c_ln[24],"endIf",c_xn[21],F);      // }
  setLine #(24,0,1) f_25 (c_ln[25],"setVar",T,F);            // useFill = flags [ PF_FILL ] ;
  setLine #(24,0,1) f_26 (c_ln[26],"setVar",T,F);            // useTC = flags [ PF_TIME ] ;
  setLine #(24,0,1) f_27 (c_ln[27],"setVar",T,F);            // anyID = flags [ PF_ANYSID ] ;
  setLine #(24,0,1) f_28 (c_ln[28],"setVar",T,F);            // fb3 = flags [ PF_FB3 ] ;
  setLine #(24,0,1) f_29 (c_ln[29],"setVar",T,F);            // dbg = flags [ PF_DBG ] ;
  setLine #(24,0,1) f_30 (c_ln[30],"setVar",T,F);            // ctxf = flags [ PF_CTXF ] ;
  setLine #(24,0,1) f_31 (c_ln[31],"setVar",T,F);            // byp = flags [ PF_BYPASS ] ;
  setLine #(24,0,1) f_32 (c_ln[32],"setVar",T,F);            // useOUID = flags [ PF_OUID ] ;
  setLine #(24,0,1) f_33 (c_ln[33],"setVar",T,F);            // xSR = flags [ PF_XSR ] ;
  setLine #(24,0,1) f_34 (c_ln[34],"setVar",T,F);            // xIF = flags [ PF_XIF ] ;
  setLine #(24,0,1) f_35 (c_ln[35],"setVar",T,F);            // xRF = flags [ PF_XRF ] ;
  setLine #(24,0,1) f_36 (c_ln[36],"setVar",T,F);            // xGain = flags [ PF_XGAIN ] ;
  setLine #(24,0,1) f_37 (c_ln[37],"setVar",T,F);            // isNone = ( pkty == PT_NONE ) ;
  setLine #(24,0,1) f_38 (c_ln[38],"setVar",T,F);            // isNoop = ( pkty == PT_NOOP ) ;
  setLine #(24,0,1) f_39 (c_ln[39],"setVar",T,F);            // okICE = ( pkty == PT_AUTO ) || ( pkty == PT_ICE ) ;
  setLine #(24,0,1) f_40 (c_ln[40],"setVar",T,F);            // okSDDS = ( pkty == PT_SDDS ) ;
  setLine #(24,0,1) f_41 (c_ln[41],"setVar",T,F);            // okVRT = ( pkty == PT_AUTO ) || ( pkty >= PT_VRT ) ;
  setLine #(24,0,1) f_42 (c_ln[42],"setVar",T,F);            // okIn = bi.rok ;
  setLine #(24,0,1) f_43 (c_ln[43],"setVar",T,F);            // phinc = pinc ;
  setLine #(24,0,1) f_44 (c_ln[44],"setVar",T,F);            // okLen = ( length > 0 ) ;
  setLine #(24,0,1) f_45 (c_ln[45],"setVar",T,F);            // doTrim = length < maxfer ;
  setLine #(24,1,1) f_46 (c_ln[46],"setVar",T,F);            // xfer = ! okIn ? 0 : doTrim ? length : maxfer ;
  setLine #(24,0,1) f_47 (c_ln[47],"setVar",T,F);            // oknSec = ( nwsec > 0 ) ;
  setLine #(24,0,1) f_48 (c_ln[48],"setVar",T,F);            // difws = cwsec - nwsec ;
  setLine #(24,0,1) f_49 (c_ln[49],"setVar",T,F);            // difps = cpsec - npsec ;
  setLine #(24,1,1) f_50 (c_ln[50],"setVar",T,F);            // cwgtnw = ( difws > 0 ) ;
  setLine #(24,1,1) f_51 (c_ln[51],"setVar",T,F);            // cwltnw = ( difws < 0 ) ;
  setLine #(24,2,0) f_52 (c_ln[52],"setVar",T,F);            // cweqnw = ! cwgtnw && ! cwltnw ;
  setLine #(24,1,1) f_53 (c_ln[53],"setVar",T,F);            // cpgtnp = ( difps > ( phinc << 2 ) ) ;
  setLine #(24,1,1) f_54 (c_ln[54],"setVar",T,F);            // cpltnp = ( difps < - phinc ) ;
  setLine #(24,2,0) f_55 (c_ln[55],"setVar",T,F);            // cpeqnp = ! cpgtnp && ! cpltnp ;
  setLine #(24,2,0) f_56 (c_ln[56],"setVar",T,F);            // ceqn = cweqnw && cpeqnp ;
  setLine #(24,2,0) f_57 (c_ln[57],"setVar",T,F);            // cgtn = cwgtnw || ( cweqnw && cpgtnp ) ;
  setLine #(24,2,0) f_58 (c_ln[58],"setVar",T,F);            // cltn = cwltnw || ( cweqnw && cpltnp ) ;
  setLine #(24,1,1) f_59 (c_ln[59],"setVar",T,F);            // needFill = ( useFill && ! okIn ) ;
  setLine #(24,2,1) f_60 (c_ln[60],"setVar",T,F);            // needPad = ( useTC && oknSec && cltn ) ;
  setLine #(24,2,1) f_61 (c_ln[61],"setVar",T,F);            // needDrop = ( pstate == 4 ) && useTC && cgtn ;
  setLine #(24,0,1) f_62 (c_ln[62],"setVar",T,F);            // isDrop = ( pstate == 9 ) ;
  setLine #(24,0,1) f_63 (c_ln[63],"setVar",T,F);            // lpsec = cpsec + ( pinc << 8 ) ;
  setLine #(24,1,1) f_64 (c_ln[64],"setVar",T,F);            // lpgtnp = ( lpsec > npsec ) ;
  setLine #(24,1,1) f_65 (c_ln[65],"setVar",T,F);            // doClip = ( lpsec > mpsec ) ;
  setLine #(24,3,1) f_66 (c_ln[66],"setVar",T,F);            // doFill = ( needPad || needFill || needDrop || isDrop ) && ! isNoop && ! isNone ;
  setLine #(24,2,1) f_67 (c_ln[67],"setVar",T,F);            // doStop = oknSec && cweqnw && lpgtnp && ! needFill ;
  setLine #(24,3,1) f_68 (c_ln[68],"setVar",T,F);            // fpsec = doClip ? l2i ( mpsec - cpsec ) : doStop ? l2i ( npsec - cpsec ) : ( pinc << 8 ) ;
  setLine #(24,1,1) f_69 (c_ln[69],"setVar",T,F);            // lpsec = ( pinc << 3 ) ;
  setLine #(24,0,1) f_70 (c_ln[70],"setVar",T,F);            // sid = 0 ;
  setLine #(24,0,1) f_71 (c_ln[71],"setVar",T,F);            // ooff = 0 ;
  setLine #(24,0,1) f_72 (c_ln[72],"setVar",T,F);            // seq = 0 ;
  setLine #(24,0,1) f_73 (c_ln[73],"setVar",T,F);            // ifb = 0 ;
  setLine #(24,0,1) f_74 (c_ln[74],"setVar",T,F);            // pfix = 0 ;
  setLine #(24,3,0) f_75 (c_ln[75],"print",s_vbpr[1],F);     // dprint ( "Top  Cur w=%08x p=%012lx  Nxt w=%08x p=%012lx  Counts=%x Pad=%x Fill=%x Drop=%x rOk=%x wOk=%x cnt=%d\n" , cwsec , cpsec , nwsec , npsec , counts , needPad ? 1 : 0 , needFill ? 1 : 0 , needDrop ? 1 : 0 , bi.rok ? 1 : 0 , so.wok ? 1 : 0 , c_cnt ) ;
  setLine #(24,4,0) f_76 (c_ln[76],"If",doFill,F);           // if ( doFill ) {
  setLine #(76,0,1) f_77 (c_ln[77],"setVar",T,F);            // pstate = 1 ;
  setLine #(76,0,1) f_78 (c_ln[78],"setVar",T,F);            // dpsec = fpsec ;
  setLine #(76,0,1) f_79 (c_ln[79],"setVar",T,F);            // bz = pad ;
  setLine #(76,1,0) f_80 (c_ln[80],"While",(so_wok && dpsec > 0) || (ifb != 0),c_xn[87]); // while ( ( so.wok && dpsec > 0 ) || ( ifb != 0 ) ) {
  setLine #(80,0,1) f_81 (c_ln[81],"setVar",T,F);            // cpsec = cpsec + pinc ;
  setLine #(80,0,1) f_82 (c_ln[82],"setVar",T,F);            // ifb = ! fb3 ? 0 : ( ifb == 2 ) ? 0 : ifb + 1 ;
  setLine #(80,0,1) f_83 (c_ln[83],"setVar",T,F);            // pfix = ( ifix == mfix ) ? pfix + nfix : pfix ;
  setLine #(80,0,1) f_84 (c_ln[84],"setVar",T,F);            // ifix = ( ifix == mfix ) ? 0 : ifix + 1 ;
  setLine #(80,0,1) f_85 (c_ln[85],"StreamO_wrLCS",T,F);     // so.wrLCS ( bz , ( dpsec < lpsec ) ? 1 : 0 , 0 ) ;
  setLine #(80,0,1) f_86 (c_ln[86],"setVar",T,F);            // dpsec -= pinc ;
  setLine #(80,1,0) f_87 (c_ln[87],"endWhile",c_xn[80],F);   // }
  setLine #(87,0,1) f_88 (c_ln[88],"setVar",T,F);            // counts [ 15 : 12 ] = counts [ 15 : 12 ] + 1 ;
  setLine #(87,0,1) f_89 (c_ln[89],"setVar",T,F);            // bz = 0 ;
  setLine #(87,1,0) f_90 (c_ln[90],"endIfE",c_xn[76],F);     // }
  setLine #(90,4,0) f_91 (c_ln[91],"ElseIf",okLen,c_xn[76]); // else if ( okLen ) {
  setLine #(91,0,1) f_92 (c_ln[92],"setVar",T,F);            // pstate = 2 ;
  setLine #(91,0,1) f_93 (c_ln[93],"setVar",T,F);            // i = 0 ;
  setLine #(91,1,0) f_94 (c_ln[94],"While",so_wok && i < xfer,c_xn[102]); // while ( so.wok && i < xfer ) {
  setLine #(94,0,1) f_95 (c_ln[95],"setVar",T,F);            // cpsec = cpsec + pinc ;
  setLine #(94,0,1) f_96 (c_ln[96],"setVar",T,F);            // pfix = ( ifix == mfix ) ? pfix + nfix : pfix ;
  setLine #(94,0,1) f_97 (c_ln[97],"setVar",T,F);            // ifix = ( ifix == mfix ) ? 0 : ifix + 1 ;
  setLine #(94,0,3) f_98 (c_ln[98],"BufferI_getL",T,F);      // bz = bi.getL ( i << 2 ) ;
  setLine #(94,3,1) f_99 (c_ln[99],"StreamO_wrLCS",T,F);     // so.wrLCS ( bz , ( length < 8 ) ? 1 : 0 , swaps ) ;
  setLine #(94,0,1) f_100 (c_ln[100],"setVar",T,F);          // i ++ ;
  setLine #(94,3,1) f_101 (c_ln[101],"setVar",T,F);          // length -- ;
  setLine #(94,4,0) f_102 (c_ln[102],"endWhile",c_xn[94],F); // }
  setLine #(102,0,0) f_103 (c_ln[103],"BufferI_rnxt",T,F);   // bi.rnxt ( i << 2 ) ;
  setLine #(102,0,0) f_104 (c_ln[104],"endIfE",c_xn[91],F);  // }
  setLine #(104,4,0) f_105 (c_ln[105],"ElseIf",okIn && isNoop,c_xn[91]); // else if ( okIn && isNoop ) {
  setLine #(105,0,1) f_106 (c_ln[106],"setVar",T,F);         // pstate = 3 ;
  setLine #(105,0,1) f_107 (c_ln[107],"setVar",T,F);         // length = maxfer ;
  setLine #(105,1,0) f_108 (c_ln[108],"endIfE",c_xn[105],F); // }
  setLine #(108,4,0) f_109 (c_ln[109],"ElseIf",okIn && ! isNone,c_xn[105]); // else if ( okIn && ! isNone ) {
  setLine #(109,0,1) f_110 (c_ln[110],"setVar",T,F);         // pstate = 4 ;
  setLine #(109,0,1) f_111 (c_ln[111],"setVar",T,F);         // ulen = 0 ;
  setLine #(109,0,3) f_112 (c_ln[112],"BufferI_getL",T,F);   // bx = bi.getL ( 0 ) ;
  setLine #(109,1,3) f_113 (c_ln[113],"BufferI_getL",T,F);   // by = bi.getL ( 4 ) ;
  setLine #(109,2,3) f_114 (c_ln[114],"BufferI_getL",T,F);   // bz = bi.getL ( 8 ) ;
  setLine #(109,3,1) f_115 (c_ln[115],"setVar",T,F);         // anyOUID = ! useOUID || ! bx [ 3 ] ;
  setLine #(109,3,1) f_116 (c_ln[116],"setVar",T,F);         // hasOUID = bx [ 3 ] ;
  setLine #(109,3,1) f_117 (c_ln[117],"setVar",T,F);         // hasSID = ( bx [ 6 : 5 ] > 1 ) ? T : bx [ 4 ] ;
  setLine #(109,5,1) f_118 (c_ln[118],"setVar",T,F);         // isSID = bswap2 ( hasSID ? by [ 31 : 16 ] : bz [ 15 : 0 ] ) == sid ;
  setLine #(109,5,1) f_119 (c_ln[119],"setVar",T,F);         // isVRTi = ( bx [ 7 : 0 ] == 0x1C ) && ( ( bswap4 ( bz ) == ouid ) || anyOUID ) ;
  setLine #(109,4,1) f_120 (c_ln[120],"setVar",T,F);         // isVRTj = ( bx [ 7 : 0 ] == 0x08 ) && ( ( bswap4 ( by ) == ouid ) || anyOUID ) ;
  setLine #(109,5,1) f_121 (c_ln[121],"setVar",T,F);         // isVRTd = ( bx [ 7 : 0 ] == 0x18 ) && ( ( bswap4 ( bz ) == DIFI ) || anyOUID ) ;
  setLine #(109,5,1) f_122 (c_ln[122],"setVar",T,F);         // isVRTc = ( bx [ 7 : 0 ] == 0x49 ) && ( ( bswap4 ( bz ) == ouid ) || anyOUID ) ;
  setLine #(109,3,1) f_123 (c_ln[123],"setVar",T,F);         // isICE = okICE && ( bx == 0x00676665 ) ;
  setLine #(109,6,1) f_124 (c_ln[124],"setVar",T,F);         // isVRT = okVRT && ( isVRTi || isVRTj || isVRTd ) && ( isSID || anyID ) ;
  setLine #(109,6,1) f_125 (c_ln[125],"setVar",T,F);         // isVCTX = okVRT && isVRTc && ( isSID || anyID ) ;
  setLine #(109,7,0) f_126 (c_ln[126],"If",isICE,F);         // if ( isICE ) {
  setLine #(126,0,1) f_127 (c_ln[127],"setVar",T,F);         // ioff = 64 ;
  setLine #(126,0,1) f_128 (c_ln[128],"setVar",T,F);         // seq = by [ 7 : 0 ] ;
  setLine #(126,0,1) f_129 (c_ln[129],"setVar",T,F);         // bfer = bz [ 13 : 0 ] ;
  setLine #(126,0,1) f_130 (c_ln[130],"setVar",T,F);         // ulen = bz [ 13 : 0 ] ;
  setLine #(126,0,3) f_131 (c_ln[131],"BufferI_getL",T,F);   // bx = bi.getL ( 12 ) ;
  setLine #(126,3,1) f_132 (c_ln[132],"setVar",T,F);         // sid = bx [ 31 : 16 ] ;
  setLine #(126,1,3) f_133 (c_ln[133],"BufferI_getL",T,F);   // bx = bi.getL ( 16 ) ;
  setLine #(126,4,1) f_134 (c_ln[134],"setVar",T,F);         // bpa = bx [ 27 : 24 ] ;
  setLine #(126,5,0) f_135 (c_ln[135],"For",j+1 < bpa,F);    // for ( j = 1 ; j < bpa ; j ++ ) {
  setLine #(135,0,1) f_136 (c_ln[136],"setVar",T,F);         // ulen = ulen + bfer ;
  setLine #(135,0,0) f_137 (c_ln[137],"endFor",c_xn[135],F); // }
  setLine #(137,0,0) f_138 (c_ln[138],"endIfE",c_xn[126],F); // }
  setLine #(138,7,0) f_139 (c_ln[139],"ElseIf",isVRT,c_xn[126]); // else if ( isVRT ) {
  setLine #(139,0,1) f_140 (c_ln[140],"setVar",T,F);         // ooff = ( bx [ 2 ] ) ? 4 : 0 ;
  setLine #(139,0,1) f_141 (c_ln[141],"setVar",T,F);         // ioff = ! hasOUID ? 20 : ! hasSID ? 24 : 28 ;
  setLine #(139,0,1) f_142 (c_ln[142],"setVar",T,F);         // seq = bx [ 11 : 8 ] ;
  setLine #(139,0,1) f_143 (c_ln[143],"setVar",T,F);         // nseq = nseq & 0xF ;
  setLine #(139,1,1) f_144 (c_ln[144],"setVar",T,F);         // ulen = ( bswap2 ( bx [ 31 : 16 ] ) << 2 ) - ioff - ooff ;
  setLine #(139,0,3) f_145 (c_ln[145],"BufferI_getL",T,F);   // bx = bi.getL ( 12 ) ;
  setLine #(139,3,1) f_146 (c_ln[146],"setVar",T,F);         // isBE = isVRTi ? bx [ 22 ] : isVRTj ? bz [ 22 ] : T ;
  setLine #(139,3,1) f_147 (c_ln[147],"setVar",T,F);         // bps = isVRTi ? bx [ 27 : 24 ] : isVRTj ? bz [ 27 : 24 ] : dbps ;
  setLine #(139,4,0) f_148 (c_ln[148],"If",useTC || dbg,F);  // if ( useTC || dbg ) {
  setLine #(148,0,3) f_149 (c_ln[149],"BufferI_getL",T,F);   // by = bi.getL ( ioff - 12 ) ;
  setLine #(148,3,1) f_150 (c_ln[150],"setVar",T,F);         // nwsec = bswap4 ( by ) ;
  setLine #(148,1,3) f_151 (c_ln[151],"BufferI_getL",T,F);   // by = bi.getL ( ioff - 8 ) ;
  setLine #(148,4,1) f_152 (c_ln[152],"setVar",T,F);         // npsec [ 39 : 32 ] = bswap4 ( by ) ;
  setLine #(148,2,3) f_153 (c_ln[153],"BufferI_getL",T,F);   // by = bi.getL ( ioff - 4 ) ;
  setLine #(148,5,1) f_154 (c_ln[154],"setVar",T,F);         // npsec [ 31 : 0 ] = bswap4 ( by ) ;
  setLine #(148,6,0) f_155 (c_ln[155],"endIf",c_xn[148],F);  // }
  setLine #(155,0,1) f_156 (c_ln[156],"setVar",T,F);         // swaps [ 0 ] = ( bps == 15 ) && isBE ;
  setLine #(155,0,1) f_157 (c_ln[157],"setVar",T,F);         // swaps [ 1 ] = ( bps > 15 ) && isBE ;
  setLine #(155,0,1) f_158 (c_ln[158],"setVar",T,F);         // swaps [ 2 ] = ( bps == 11 ) && isBE ;
  setLine #(155,0,0) f_159 (c_ln[159],"print",s_vbpr[1],F);  // dprint ( "New Cur w=%08x p=%012lx  Nxt w=%08x p=%012lx\n" , cwsec , cpsec , nwsec , npsec ) ;
  setLine #(155,1,0) f_160 (c_ln[160],"endIfE",c_xn[139],F); // }
  setLine #(160,7,0) f_161 (c_ln[161],"ElseIf",isVCTX,c_xn[139]); // else if ( isVCTX ) {
  setLine #(161,0,1) f_162 (c_ln[162],"setVar",T,F);         // pstate = 5 ;
  setLine #(161,0,1) f_163 (c_ln[163],"setVar",T,F);         // ioff = bx [ 31 : 24 ] << 2 ;
  setLine #(161,0,1) f_164 (c_ln[164],"setVar",T,F);         // coff = hasOUID ? 28 : 20 ;
  setLine #(161,1,0) f_165 (c_ln[165],"If",ctxf,F);          // if ( ctxf ) {
  setLine #(165,0,3) f_166 (c_ln[166],"BufferI_getL",T,F);   // bx = bi.getL ( coff ) ;
  setLine #(165,3,1) f_167 (c_ln[167],"setVar",T,F);         // bx = brev4 ( bswap4 ( bx ) ) ;
  setLine #(165,4,0) f_168 (c_ln[168],"print",s_vbpr[0],F);  // vprint ( "UDAT Ctx bx=%08x coff=%d len=%d\n" , bx , coff , ioff ) ;
  setLine #(165,4,1) f_169 (c_ln[169],"StreamO_wrLCS",T,F);  // so.wrLCS ( bx , 2 , 0 ) ;
  setLine #(165,4,1) f_170 (c_ln[170],"setVar",T,F);         // coff += 4 + ( ( bx [ 2 : 2 ] ) << 3 ) + ( ( bx [ 1 : 1 ] ) << 2 ) ;
  setLine #(165,5,0) f_171 (c_ln[171],"If",bx[3] && xIF,F);  // if ( bx [ 3 ] && xIF ) {
  setLine #(171,0,3) f_172 (c_ln[172],"BufferI_getL",T,F);   // by = bi.getL ( coff ) ;
  setLine #(171,1,3) f_173 (c_ln[173],"BufferI_getL",T,F);   // bz = bi.getL ( coff + 4 ) ;
  setLine #(171,4,1) f_174 (c_ln[174],"setVar",T,F);         // bc = l2i ( ii2l ( bswap4 ( by ) , bswap4 ( bz ) ) >> 20 ) ;
  setLine #(171,5,0) f_175 (c_ln[175],"print",s_vbpr[0],F);  // vprint ( "UDAT Ctx IF bc=%d\n" , bc ) ;
  setLine #(171,5,1) f_176 (c_ln[176],"StreamO_wrLCS",T,F);  // so.wrLCS ( bc , 4 , 0 ) ;
  setLine #(171,6,0) f_177 (c_ln[177],"endIf",c_xn[171],F);  // }
  setLine #(177,0,1) f_178 (c_ln[178],"setVar",T,F);         // coff += ( ( bx [ 3 : 3 ] ) << 3 ) ;
  setLine #(177,1,0) f_179 (c_ln[179],"If",bx[4] && xRF,F);  // if ( bx [ 4 ] && xRF ) {
  setLine #(179,0,3) f_180 (c_ln[180],"BufferI_getL",T,F);   // by = bi.getL ( coff ) ;
  setLine #(179,1,3) f_181 (c_ln[181],"BufferI_getL",T,F);   // bz = bi.getL ( coff + 4 ) ;
  setLine #(179,4,1) f_182 (c_ln[182],"setVar",T,F);         // bc = l2i ( ii2l ( bswap4 ( by ) , bswap4 ( bz ) ) >> 20 ) ;
  setLine #(179,5,0) f_183 (c_ln[183],"print",s_vbpr[0],F);  // vprint ( "UDAT Ctx RF bc=%d\n" , bc ) ;
  setLine #(179,5,1) f_184 (c_ln[184],"StreamO_wrLCS",T,F);  // so.wrLCS ( bc , 4 , 0 ) ;
  setLine #(179,6,0) f_185 (c_ln[185],"endIf",c_xn[179],F);  // }
  setLine #(185,0,1) f_186 (c_ln[186],"setVar",T,F);         // coff += ( ( bx [ 4 : 4 ] + bx [ 5 : 5 ] + bx [ 6 : 6 ] ) << 3 ) + ( ( bx [ 7 : 7 ] ) << 2 ) ;
  setLine #(185,1,0) f_187 (c_ln[187],"If",bx[8] && xGain,F); // if ( bx [ 8 ] && xGain ) {
  setLine #(187,0,3) f_188 (c_ln[188],"BufferI_getL",T,F);   // by = bi.getL ( coff ) ;
  setLine #(187,3,1) f_189 (c_ln[189],"setVar",T,F);         // bc = bswap4 ( by ) >> 7 ;
  setLine #(187,4,0) f_190 (c_ln[190],"print",s_vbpr[0],F);  // vprint ( "UDAT Ctx GAIN bc=%d\n" , bc ) ;
  setLine #(187,4,1) f_191 (c_ln[191],"StreamO_wrLCS",T,F);  // so.wrLCS ( bc , 8 , 0 ) ;
  setLine #(187,5,0) f_192 (c_ln[192],"endIf",c_xn[187],F);  // }
  setLine #(192,0,1) f_193 (c_ln[193],"setVar",T,F);         // coff += ( ( bx [ 8 : 8 ] + bx [ 9 : 9 ] ) << 2 ) ;
  setLine #(192,1,0) f_194 (c_ln[194],"If",bx[10] && xSR,F); // if ( bx [ 10 ] && xSR ) {
  setLine #(194,0,3) f_195 (c_ln[195],"BufferI_getL",T,F);   // by = bi.getL ( coff ) ;
  setLine #(194,1,3) f_196 (c_ln[196],"BufferI_getL",T,F);   // bz = bi.getL ( coff + 4 ) ;
  setLine #(194,4,1) f_197 (c_ln[197],"setVar",T,F);         // bc = l2i ( ii2l ( bswap4 ( by ) , bswap4 ( bz ) ) >> 20 ) ;
  setLine #(194,5,0) f_198 (c_ln[198],"print",s_vbpr[0],F);  // vprint ( "UDAT Ctx SR bc=%d\n" , bc ) ;
  setLine #(194,5,1) f_199 (c_ln[199],"StreamO_wrLCS",T,F);  // so.wrLCS ( bc , 10 , 0 ) ;
  setLine #(194,6,0) f_200 (c_ln[200],"endIf",c_xn[194],F);  // }
  setLine #(200,0,1) f_201 (c_ln[201],"StreamO_wrLCS",T,F);  // so.wrLCS ( bx , 2 , 0 ) ;
  setLine #(200,1,1) f_202 (c_ln[202],"StreamO_setC",T,F);   // so.setC ( 0 ) ;
  setLine #(200,2,0) f_203 (c_ln[203],"endIf",c_xn[165],F);  // }
  setLine #(203,0,1) f_204 (c_ln[204],"setVar",T,F);         // counts [ 23 : 20 ] = counts [ 23 : 20 ] + 1 ;
  setLine #(203,1,0) f_205 (c_ln[205],"endIfE",c_xn[161],F); // }
  setLine #(205,7,0) f_206 (c_ln[206],"ElseIf",T,c_xn[161]); // else {
  setLine #(206,0,1) f_207 (c_ln[207],"setVar",T,F);         // ioff = 4 ;
  setLine #(206,0,1) f_208 (c_ln[208],"setVar",T,F);         // counts [ 30 : 24 ] = counts [ 30 : 24 ] + 1 ;
  setLine #(206,1,0) f_209 (c_ln[209],"endIf",c_xn[206],F|c_en[205]|c_en[160]|c_en[138]); // }
  setLine #(209,0,0) f_210 (c_ln[210],"BufferI_rnxt",T,F);   // bi.rnxt ( ioff ) ;
  setLine #(209,0,0) f_211 (c_ln[211],"If",ulen > 0,F);      // if ( ulen > 0 ) {
  setLine #(211,0,1) f_212 (c_ln[212],"setVar",T,F);         // length = ulen >> 2 ;
  setLine #(211,0,1) f_213 (c_ln[213],"setVar",T,F);         // counts [ 3 : 0 ] = counts [ 3 : 0 ] + 1 ;
  setLine #(211,1,0) f_214 (c_ln[214],"If",seq != nseq,F);   // if ( seq != nseq ) {
  setLine #(214,0,1) f_215 (c_ln[215],"setVar",T,F);         // counts [ 7 : 4 ] = counts [ 7 : 4 ] + 1 ;
  setLine #(214,1,0) f_216 (c_ln[216],"endIf",c_xn[214],F);  // }
  setLine #(216,0,1) f_217 (c_ln[217],"setVar",T,F);         // nseq = seq + 1 ;
  setLine #(216,0,1) f_218 (c_ln[218],"StreamO_setC",T,F);   // so.setC ( 0 ) ;
  setLine #(216,1,0) f_219 (c_ln[219],"endIf",c_xn[211],F);  // }
  setLine #(219,0,0) f_220 (c_ln[220],"endIf",c_xn[109],F|c_en[108]|c_en[104]|c_en[90]); // }
  setLine #(220,0,0) f_221 (c_ln[221],"If",needDrop || isDrop,F); // if ( needDrop || isDrop ) {
  setLine #(221,0,0) f_222 (c_ln[222],"If",xfer > 0,F);      // if ( xfer > 0 ) {
  setLine #(222,0,0) f_223 (c_ln[223],"BufferI_rnxt",T,F);   // bi.rnxt ( xfer << 2 ) ;
  setLine #(222,0,1) f_224 (c_ln[224],"setVar",T,F);         // length = length - xfer ;
  setLine #(222,1,0) f_225 (c_ln[225],"endIf",c_xn[222],F);  // }
  setLine #(225,0,1) f_226 (c_ln[226],"setVar",T,F);         // pstate = ( length == 0 ) ? 1 : 9 ;
  setLine #(225,1,0) f_227 (c_ln[227],"If",needDrop,F);      // if ( needDrop ) {
  setLine #(227,0,1) f_228 (c_ln[228],"setVar",T,F);         // counts [ 11 : 8 ] = counts [ 11 : 8 ] + 1 ;
  setLine #(227,1,0) f_229 (c_ln[229],"endIf",c_xn[227],F);  // }
  setLine #(229,0,0) f_230 (c_ln[230],"endIf",c_xn[221],F);  // }
  setLine #(230,0,1) f_231 (c_ln[231],"setVar",T,F);         // counts [ 19 : 16 ] = ( length > 15 ) ? 15 : length [ 3 : 0 ] ;
  setLine #(230,1,1) f_232 (c_ln[232],"setVar",T,F);         // counts [ 31 ] = okIn ;
  setLine #(230,0,1) f_233 (c_ln[233],"setVar",T,F);         // cpsec = cpsec + pfix ;
  setLine #(230,1,1) f_234 (c_ln[234],"setVar",T,F);         // doWrap = ( cpsec >= mpsec ) ;
  setLine #(230,2,0) f_235 (c_ln[235],"If",doWrap,F);        // if ( doWrap ) {
  setLine #(235,0,1) f_236 (c_ln[236],"setVar",T,F);         // cpsec = cpsec - mpsec ;
  setLine #(235,0,1) f_237 (c_ln[237],"setVar",T,F);         // cwsec = cwsec + 1 ;
  setLine #(235,1,0) f_238 (c_ln[238],"endIf",c_xn[235],F);  // }
  setLine #(238,0,0) f_239 (c_ln[239],"If",pass == 0,F);     // if ( pass == 0 ) {
  setLine #(239,0,0) f_240 (c_ln[240],"Ram_wr",CV_counts,F); // this.counts = counts ;
  setLine #(239,1,0) f_241 (c_ln[241],"Ram_wr",CV_cwsec,F);  // this.cwsec = cwsec ;
  setLine #(239,2,2) f_242 (c_ln[242],"Ram_wrx",CV_cpsec,F); // this.cpsec = cpsec ;
  setLine #(239,4,0) f_243 (c_ln[243],"Ram_wr",CV_nwsec,F);  // this.nwsec = nwsec ;
  setLine #(239,5,2) f_244 (c_ln[244],"Ram_wrx",CV_npsec,F); // this.npsec = npsec ;
  setLine #(239,1,0) f_245 (c_ln[245],"print",s_vbpr[1],F);  // dprint ( "Upd  Counts=%x   Nxt w=%08x p=%012lx   Cur w=%08x p=%012lx   pstate=%d cnt=%d pass=%d\n" , counts , nwsec , npsec , cwsec , cpsec , pstate , c_cnt , pass ) ;
  setLine #(239,7,0) f_246 (c_ln[246],"endIf",c_xn[239],F);  // }
  setLine #(246,0,1) f_247 (c_ln[247],"setVar",T,F);         // pass = ( pass >= 14 ) ? 0 : pass + 1 ;
  setLine #(246,0,0) f_248 (c_ln[248],"return",c_stat,F);    // return 0 ;
  setLine #(248,0,0) f_249 (c_ln[249],"endMethod",T,F);      // }

  assign cweqnw = ! cwgtnw && ! cwltnw;
  assign cpeqnp = ! cpgtnp && ! cpltnp;
  assign ceqn = cweqnw && cpeqnp;
  assign cgtn = cwgtnw || (cweqnw && cpgtnp);
  assign cltn = cwltnw || (cweqnw && cpltnp);
  always @(posedge clk) begin
    c_wr <= F; c_rd <= F; c_done <= F;
    bi_rd <= F; bi_nxt <= F;
    so_wen <= F; 
    if (s_set[0]) pkty <= s_val;
    if (s_set[1]) flags <= s_val;
    if (s_set[2]) sid <= s_val;
    if (s_set[3]) pinc <= s_val;
    if (s_set[4]) cwsec <= s_val;
    if (s_set[5]) nwsec <= s_val;
    if (s_set[7]) cpsec <= lswap(s_val);
    if (s_set[9]) npsec <= lswap(s_val);
    if (s_set[11]) mpsec <= lswap(s_val);
    if (s_set[12]) counts <= s_val;
    if (s_set[13]) nseq <= s_val;
    if (s_set[14]) swaps <= s_val;
    if (s_set[15]) length <= s_val;
    if (s_set[16]) ifix <= s_val;
    if (s_set[17]) mfix <= s_val;
    if (s_set[18]) nfix <= s_val;
    if (s_set[19]) pad <= s_val;
    if (s_set[20]) pstate <= s_val;
    if (s_set[21]) npinc <= s_val;
    if (s_set[22]) ouid <= s_val;
    if (s_set[23]) pass <= s_val;
    if (s_set[24]) vctx <= s_val;
    if (s_set[25]) dbps <= s_val;
    if (s_set[26]) maxfer <= s_val;
    if (c_en[22]) begin bi_len <= maxfer << 2; end
    if (c_xn[23]) begin c_stat <= 0; c_done <= T; end
    if (c_xn[25]) begin useFill <= flags[PF_FILL]; end
    if (c_xn[26]) begin useTC <= flags[PF_TIME]; end
    if (c_xn[27]) begin anyID <= flags[PF_ANYSID]; end
    if (c_xn[28]) begin fb3 <= flags[PF_FB3]; end
    if (c_xn[29]) begin dbg <= flags[PF_DBG]; end
    if (c_xn[30]) begin ctxf <= flags[PF_CTXF]; end
    if (c_xn[31]) begin byp <= flags[PF_BYPASS]; end
    if (c_xn[32]) begin useOUID <= flags[PF_OUID]; end
    if (c_xn[33]) begin xSR <= flags[PF_XSR]; end
    if (c_xn[34]) begin xIF <= flags[PF_XIF]; end
    if (c_xn[35]) begin xRF <= flags[PF_XRF]; end
    if (c_xn[36]) begin xGain <= flags[PF_XGAIN]; end
    if (c_xn[37]) begin isNone <= (pkty == PT_NONE); end
    if (c_xn[38]) begin isNoop <= (pkty == PT_NOOP); end
    if (c_xn[39]) begin okICE <= (pkty == PT_AUTO) || (pkty == PT_ICE); end
    if (c_xn[40]) begin okSDDS <= (pkty == PT_SDDS); end
    if (c_xn[41]) begin okVRT <= (pkty == PT_AUTO) || (pkty >= PT_VRT); end
    if (c_xn[42]) begin okIn <= bi_rok; end
    if (c_xn[43]) begin phinc <= pinc; end
    if (c_xn[44]) begin okLen <= (length > 0); end
    if (c_xn[45]) begin doTrim <= length < maxfer; end
    if (c_xn[46]) begin xfer <= ! okIn ? 0 : doTrim ? length : maxfer; end
    if (c_xn[47]) begin oknSec <= (nwsec > 0); end
    if (c_xn[48]) begin difws <= cwsec - nwsec; end
    if (c_xn[49]) begin difps <= cpsec - npsec; end
    if (c_xn[50]) begin cwgtnw <= (difws > 0); end
    if (c_xn[51]) begin cwltnw <= (difws < 0); end
    if (c_xn[53]) begin cpgtnp <= (difps > (phinc << 2)); end
    if (c_xn[54]) begin cpltnp <= (difps < - phinc); end
    if (c_xn[59]) begin needFill <= (useFill && ! okIn); end
    if (c_xn[60]) begin needPad <= (useTC && oknSec && cltn); end
    if (c_xn[61]) begin needDrop <= (pstate == 4) && useTC && cgtn; end
    if (c_xn[62]) begin isDrop <= (pstate == 9); end
    if (c_xn[63]) begin lpsec <= cpsec + (pinc << 8); end
    if (c_xn[64]) begin lpgtnp <= (lpsec > npsec); end
    if (c_xn[65]) begin doClip <= (lpsec > mpsec); end
    if (c_xn[66]) begin doFill <= (needPad || needFill || needDrop || isDrop) && ! isNoop && ! isNone; end
    if (c_xn[67]) begin doStop <= oknSec && cweqnw && lpgtnp && ! needFill; end
    if (c_xn[68]) begin fpsec <= doClip ? l2i (mpsec - cpsec) : doStop ? l2i (npsec - cpsec) : (pinc << 8); end
    if (c_xn[69]) begin lpsec <= (pinc << 3); end
    if (c_xn[70]) begin sid <= 0; end
    if (c_xn[71]) begin ooff <= 0; end
    if (c_xn[72]) begin seq <= 0; end
    if (c_xn[73]) begin ifb <= 0; end
    if (c_xn[74]) begin pfix <= 0; end
    if (c_xn[75]) begin $write ("Top  Cur w=%08x p=%012x  Nxt w=%08x p=%012x  Counts=%x Pad=%x Fill=%x Drop=%x rOk=%x wOk=%x cnt=%d\n", cwsec, cpsec, nwsec, npsec, counts, needPad ? 1 : 0, needFill ? 1 : 0, needDrop ? 1 : 0, bi_rok ? 1 : 0, so_wok ? 1 : 0, c_cnt); end
    if (c_xn[77]) begin pstate <= 1; end
    if (c_xn[78]) begin dpsec <= fpsec; end
    if (c_xn[79]) begin bz <= pad; end
    if (c_xn[81]) begin cpsec <= cpsec + pinc; end
    if (c_xn[82]) begin ifb <= ! fb3 ? 0 : (ifb == 2) ? 0 : ifb + 1; end
    if (c_xn[83]) begin pfix <= (ifix == mfix) ? pfix + nfix : pfix; end
    if (c_xn[84]) begin ifix <= (ifix == mfix) ? 0 : ifix + 1; end
    if (c_xn[85]) begin so_wen <= T; so_wbus <= bz; so_wsel <= (dpsec < lpsec) ? 1 : 0; so_swaps <= 0; end
    if (c_xn[86]) begin dpsec <= dpsec - pinc; end
    if (c_xn[88]) begin counts[15:12] <= counts[15:12] + 1; end
    if (c_xn[89]) begin bz <= 0; end
    if (c_xn[92]) begin pstate <= 2; end
    if (c_xn[93]) begin i <= 0; end
    if (c_xn[95]) begin cpsec <= cpsec + pinc; end
    if (c_xn[96]) begin pfix <= (ifix == mfix) ? pfix + nfix : pfix; end
    if (c_xn[97]) begin ifix <= (ifix == mfix) ? 0 : ifix + 1; end
    if (c_en[98]) begin bi_rd <= T; bi_adr <= i << 2; end 
    if (c_xn[98]) begin bz <= bi_bus; end
    if (c_xn[99]) begin so_wen <= T; so_wbus <= bz; so_wsel <= (length < 8) ? 1 : 0; so_swaps <= swaps; end
    if (c_xn[100]) begin i <= i + 1; end
    if (c_xn[101]) begin length <= length - 1; end
    if (c_en[103]) begin bi_nxt <= T; bi_adr <= i << 2; end
    if (c_xn[106]) begin pstate <= 3; end
    if (c_xn[107]) begin length <= maxfer; end
    if (c_xn[110]) begin pstate <= 4; end
    if (c_xn[111]) begin ulen <= 0; end
    if (c_en[112]) begin bi_rd <= T; bi_adr <= 0; end 
    if (c_xn[112]) begin bx <= bi_bus; end
    if (c_en[113]) begin bi_rd <= T; bi_adr <= 4; end 
    if (c_xn[113]) begin by <= bi_bus; end
    if (c_en[114]) begin bi_rd <= T; bi_adr <= 8; end 
    if (c_xn[114]) begin bz <= bi_bus; end
    if (c_xn[115]) begin anyOUID <= ! useOUID || ! bx[3]; end
    if (c_xn[116]) begin hasOUID <= bx[3]; end
    if (c_xn[117]) begin hasSID <= (bx[6:5] > 1) ? T : bx[4]; end
    if (c_xn[118]) begin isSID <= bswap2 (hasSID ? by[31:16] : bz[15:0]) == sid; end
    if (c_xn[119]) begin isVRTi <= (bx[7:0] == 8'h1C) && ((bswap4 (bz) == ouid) || anyOUID); end
    if (c_xn[120]) begin isVRTj <= (bx[7:0] == 8'h08) && ((bswap4 (by) == ouid) || anyOUID); end
    if (c_xn[121]) begin isVRTd <= (bx[7:0] == 8'h18) && ((bswap4 (bz) == DIFI) || anyOUID); end
    if (c_xn[122]) begin isVRTc <= (bx[7:0] == 8'h49) && ((bswap4 (bz) == ouid) || anyOUID); end
    if (c_xn[123]) begin isICE <= okICE && (bx == 32'h00676665); end
    if (c_xn[124]) begin isVRT <= okVRT && (isVRTi || isVRTj || isVRTd) && (isSID || anyID); end
    if (c_xn[125]) begin isVCTX <= okVRT && isVRTc && (isSID || anyID); end
    if (c_xn[127]) begin ioff <= 64; end
    if (c_xn[128]) begin seq <= by[7:0]; end
    if (c_xn[129]) begin bfer <= bz[13:0]; end
    if (c_xn[130]) begin ulen <= bz[13:0]; end
    if (c_en[131]) begin bi_rd <= T; bi_adr <= 12; end 
    if (c_xn[131]) begin bx <= bi_bus; end
    if (c_xn[132]) begin sid <= bx[31:16]; end
    if (c_en[133]) begin bi_rd <= T; bi_adr <= 16; end 
    if (c_xn[133]) begin bx <= bi_bus; end
    if (c_xn[134]) begin bpa <= bx[27:24]; end
    if (c_xn[135] || rst) begin j <= 1; end else if (c_en[135]) begin j <= j + 1; end
    if (c_xn[136]) begin ulen <= ulen + bfer; end
    if (c_xn[140]) begin ooff <= (bx[2]) ? 4 : 0; end
    if (c_xn[141]) begin ioff <= ! hasOUID ? 20 : ! hasSID ? 24 : 28; end
    if (c_xn[142]) begin seq <= bx[11:8]; end
    if (c_xn[143]) begin nseq <= nseq & 4'hF; end
    if (c_xn[144]) begin ulen <= (bswap2 (bx[31:16]) << 2) - ioff - ooff; end
    if (c_en[145]) begin bi_rd <= T; bi_adr <= 12; end 
    if (c_xn[145]) begin bx <= bi_bus; end
    if (c_xn[146]) begin isBE <= isVRTi ? bx[22] : isVRTj ? bz[22] : T; end
    if (c_xn[147]) begin bps <= isVRTi ? bx[27:24] : isVRTj ? bz[27:24] : dbps; end
    if (c_en[149]) begin bi_rd <= T; bi_adr <= ioff - 12; end 
    if (c_xn[149]) begin by <= bi_bus; end
    if (c_xn[150]) begin nwsec <= bswap4 (by); end
    if (c_en[151]) begin bi_rd <= T; bi_adr <= ioff - 8; end 
    if (c_xn[151]) begin by <= bi_bus; end
    if (c_xn[152]) begin npsec[39:32] <= bswap4 (by); end
    if (c_en[153]) begin bi_rd <= T; bi_adr <= ioff - 4; end 
    if (c_xn[153]) begin by <= bi_bus; end
    if (c_xn[154]) begin npsec[31:0] <= bswap4 (by); end
    if (c_xn[156]) begin swaps[0] <= (bps == 15) && isBE; end
    if (c_xn[157]) begin swaps[1] <= (bps > 15) && isBE; end
    if (c_xn[158]) begin swaps[2] <= (bps == 11) && isBE; end
    if (c_xn[159]) begin $write ("New Cur w=%08x p=%012x  Nxt w=%08x p=%012x\n", cwsec, cpsec, nwsec, npsec); end
    if (c_xn[162]) begin pstate <= 5; end
    if (c_xn[163]) begin ioff <= bx[31:24] << 2; end
    if (c_xn[164]) begin coff <= hasOUID ? 28 : 20; end
    if (c_en[166]) begin bi_rd <= T; bi_adr <= coff; end 
    if (c_xn[166]) begin bx <= bi_bus; end
    if (c_xn[167]) begin bx <= brev4 (bswap4 (bx)); end
    if (c_xn[168]) begin $write ("UDAT Ctx bx=%08x coff=%d len=%d\n", bx, coff, ioff); end
    if (c_xn[169]) begin so_wen <= T; so_wbus <= bx; so_wsel <= 2; so_swaps <= 0; end
    if (c_xn[170]) begin coff <= coff + 4 + ((bx[2:2]) << 3) + ((bx[1:1]) << 2); end
    if (c_en[172]) begin bi_rd <= T; bi_adr <= coff; end 
    if (c_xn[172]) begin by <= bi_bus; end
    if (c_en[173]) begin bi_rd <= T; bi_adr <= coff + 4; end 
    if (c_xn[173]) begin bz <= bi_bus; end
    if (c_xn[174]) begin bc <= l2i (ii2l (bswap4 (by), bswap4 (bz)) >>> 20); end
    if (c_xn[175]) begin $write ("UDAT Ctx IF bc=%d\n", bc); end
    if (c_xn[176]) begin so_wen <= T; so_wbus <= bc; so_wsel <= 4; so_swaps <= 0; end
    if (c_xn[178]) begin coff <= coff + ((bx[3:3]) << 3); end
    if (c_en[180]) begin bi_rd <= T; bi_adr <= coff; end 
    if (c_xn[180]) begin by <= bi_bus; end
    if (c_en[181]) begin bi_rd <= T; bi_adr <= coff + 4; end 
    if (c_xn[181]) begin bz <= bi_bus; end
    if (c_xn[182]) begin bc <= l2i (ii2l (bswap4 (by), bswap4 (bz)) >>> 20); end
    if (c_xn[183]) begin $write ("UDAT Ctx RF bc=%d\n", bc); end
    if (c_xn[184]) begin so_wen <= T; so_wbus <= bc; so_wsel <= 4; so_swaps <= 0; end
    if (c_xn[186]) begin coff <= coff + ((bx[4:4] + bx[5:5] + bx[6:6]) << 3) + ((bx[7:7]) << 2); end
    if (c_en[188]) begin bi_rd <= T; bi_adr <= coff; end 
    if (c_xn[188]) begin by <= bi_bus; end
    if (c_xn[189]) begin bc <= bswap4 (by) >>> 7; end
    if (c_xn[190]) begin $write ("UDAT Ctx GAIN bc=%d\n", bc); end
    if (c_xn[191]) begin so_wen <= T; so_wbus <= bc; so_wsel <= 8; so_swaps <= 0; end
    if (c_xn[193]) begin coff <= coff + ((bx[8:8] + bx[9:9]) << 2); end
    if (c_en[195]) begin bi_rd <= T; bi_adr <= coff; end 
    if (c_xn[195]) begin by <= bi_bus; end
    if (c_en[196]) begin bi_rd <= T; bi_adr <= coff + 4; end 
    if (c_xn[196]) begin bz <= bi_bus; end
    if (c_xn[197]) begin bc <= l2i (ii2l (bswap4 (by), bswap4 (bz)) >>> 20); end
    if (c_xn[198]) begin $write ("UDAT Ctx SR bc=%d\n", bc); end
    if (c_xn[199]) begin so_wen <= T; so_wbus <= bc; so_wsel <= 10; so_swaps <= 0; end
    if (c_xn[201]) begin so_wen <= T; so_wbus <= bx; so_wsel <= 2; so_swaps <= 0; end
    if (c_xn[202]) begin so_wsel <= 0; end
    if (c_xn[204]) begin counts[23:20] <= counts[23:20] + 1; end
    if (c_xn[207]) begin ioff <= 4; end
    if (c_xn[208]) begin counts[30:24] <= counts[30:24] + 1; end
    if (c_en[210]) begin bi_nxt <= T; bi_adr <= ioff; end
    if (c_xn[212]) begin length <= ulen >>> 2; end
    if (c_xn[213]) begin counts[3:0] <= counts[3:0] + 1; end
    if (c_xn[215]) begin counts[7:4] <= counts[7:4] + 1; end
    if (c_xn[217]) begin nseq <= seq + 1; end
    if (c_xn[218]) begin so_wsel <= 0; end
    if (c_en[223]) begin bi_nxt <= T; bi_adr <= xfer << 2; end
    if (c_xn[224]) begin length <= length - xfer; end
    if (c_xn[226]) begin pstate <= (length == 0) ? 1 : 9; end
    if (c_xn[228]) begin counts[11:8] <= counts[11:8] + 1; end
    if (c_xn[231]) begin counts[19:16] <= (length > 15) ? 15 : length[3:0]; end
    if (c_xn[232]) begin counts[31] <= okIn; end
    if (c_xn[233]) begin cpsec <= cpsec + pfix; end
    if (c_xn[234]) begin doWrap <= (cpsec >= mpsec); end
    if (c_xn[236]) begin cpsec <= cpsec - mpsec; end
    if (c_xn[237]) begin cwsec <= cwsec + 1; end
    if (c_xn[240]) begin c_wr <= T; c_adr <= CV_counts; c_wbus <= counts; end
    if (c_xn[241]) begin c_wr <= T; c_adr <= CV_cwsec; c_wbus <= cwsec; end
    if (c_en[242]) begin c_wr <= T; c_adr <= CV_cpsec; c_wbus <= cpsec; end 
    if (c_xn[242]) begin c_wr <= T; c_adr <= CV_cpsec + 4; c_wbus <= (cpsec) >> 32; end
    if (c_xn[243]) begin c_wr <= T; c_adr <= CV_nwsec; c_wbus <= nwsec; end
    if (c_en[244]) begin c_wr <= T; c_adr <= CV_npsec; c_wbus <= npsec; end 
    if (c_xn[244]) begin c_wr <= T; c_adr <= CV_npsec + 4; c_wbus <= (npsec) >> 32; end
    if (c_xn[245]) begin $write ("Upd  Counts=%x   Nxt w=%08x p=%012x   Cur w=%08x p=%012x   pstate=%d cnt=%d pass=%d\n", counts, nwsec, npsec, cwsec, cpsec, pstate, c_cnt, pass); end
    if (c_xn[247]) begin pass <= (pass >= 14) ? 0 : pass + 1; end
    if (c_xn[248]) begin c_stat <= 0; c_done <= T; end
  end

  /* verilator lint_off WIDTHCONCAT */
  localparam int SEQ_PARAMS[250*4] = '{ 0,0,0,0, 11,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 31,1,0,0, 10,21,0,0, 14,21,4,0, 32,23,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,1,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,1,0, 21,24,1,0, 21,24,2,0, 21,24,1,0, 21,24,1,0, 21,24,2,0, 21,24,2,0, 21,24,2,0, 21,24,2,0, 21,24,1,0, 21,24,2,0, 21,24,2,0, 21,24,0,0, 21,24,0,0, 21,24,1,0, 21,24,1,0, 21,24,3,0, 21,24,2,0, 21,24,3,0, 21,24,1,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 21,24,0,0, 24,24,3,0, 33,24,4,0, 21,76,0,0, 21,76,0,0, 21,76,0,0, 41,76,1,1, 21,80,0,0, 21,80,0,0, 21,80,0,0, 21,80,0,0, 10,80,0,0, 21,80,0,0, 42,80,1,0, 21,87,0,0, 21,87,0,0, 35,87,1,0, 34,90,4,0, 21,91,0,0, 21,91,0,0, 41,91,1,1, 21,94,0,0, 21,94,0,0, 21,94,0,0, 10,94,0,2, 10,94,3,0, 21,94,0,0, 21,94,3,0, 42,94,4,0, 10,102,0,0, 35,102,0,0, 34,104,4,0, 21,105,0,0, 21,105,0,0, 35,105,1,0, 34,108,4,0, 21,109,0,0, 21,109,0,0, 10,109,0,2, 10,109,1,2, 10,109,2,2, 21,109,3,0, 21,109,3,0, 21,109,3,0, 21,109,5,0, 21,109,5,0, 21,109,4,0, 21,109,5,0, 21,109,5,0, 21,109,3,0, 21,109,6,0, 21,109,6,0, 33,109,7,0, 21,126,0,0, 21,126,0,0, 21,126,0,0, 21,126,0,0, 10,126,0,2, 21,126,3,0, 10,126,1,2, 21,126,4,0, 45,126,5,0, 21,135,0,0, 46,135,0,0, 35,137,0,0, 34,138,7,0, 21,139,0,0, 21,139,0,0, 21,139,0,0, 21,139,0,0, 21,139,1,0, 10,139,0,2, 21,139,3,0, 21,139,3,0, 31,139,4,0, 10,148,0,2, 21,148,3,0, 10,148,1,2, 21,148,4,0, 10,148,2,2, 21,148,5,0, 32,148,6,0, 21,155,0,0, 21,155,0,0, 21,155,0,0, 24,155,0,0, 35,155,1,0, 34,160,7,0, 21,161,0,0, 21,161,0,0, 21,161,0,0, 31,161,1,0, 10,165,0,2, 21,165,3,0, 24,165,4,0, 10,165,4,0, 21,165,4,0, 31,165,5,0, 10,171,0,2, 10,171,1,2, 21,171,4,0, 24,171,5,0, 10,171,5,0, 32,171,6,0, 21,177,0,0, 31,177,1,0, 10,179,0,2, 10,179,1,2, 21,179,4,0, 24,179,5,0, 10,179,5,0, 32,179,6,0, 21,185,0,0, 31,185,1,0, 10,187,0,2, 21,187,3,0, 24,187,4,0, 10,187,4,0, 32,187,5,0, 21,192,0,0, 31,192,1,0, 10,194,0,2, 10,194,1,2, 21,194,4,0, 24,194,5,0, 10,194,5,0, 32,194,6,0, 10,200,0,0, 10,200,1,0, 32,200,2,0, 21,203,0,0, 35,203,1,0, 34,205,7,0, 21,206,0,0, 21,206,0,0, 32,206,1,0, 10,209,0,0, 31,209,0,0, 21,211,0,0, 21,211,0,0, 31,211,1,0, 21,214,0,0, 32,214,1,0, 21,216,0,0, 10,216,0,0, 32,216,1,0, 32,219,0,0, 31,220,0,0, 31,221,0,0, 10,222,0,0, 21,222,0,0, 32,222,1,0, 21,225,0,0, 31,225,1,0, 21,227,0,0, 32,227,1,0, 32,229,0,0, 21,230,0,0, 21,230,1,0, 21,230,0,0, 21,230,1,0, 31,230,2,0, 21,235,0,0, 21,235,0,0, 32,235,1,0, 31,238,0,0, 10,239,0,0, 10,239,1,0, 10,239,2,1, 10,239,4,0, 10,239,5,1, 24,239,1,0, 32,239,7,0, 21,246,0,0, 14,246,0,0, 15,248,0,0};
  sequencer #(250,SEQ_PARAMS) c_seq (clks,rst, c_ln, c_en,c_xn);
  /* verilator lint_on WIDTHCONCAT */
  assign s_test = {c_cnt[0],c_done,c_active,c_start,o_ena,i_ena,o_frst,i_frst};
endmodule

