/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See RFP.jv for documentation.
*/
#include "Modefs.c"
#include "Modems.c"

/** Define Signatures */
#define CORE_NAME RFP
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 1
#include "cores/CoreDefs.h"
#define NP 1
#define AW 16
#define BW 32
#define CW 6

enum { RFP_MO = 9 };
enum { RFP_OLUT = 12 };
enum { RFP_NLUT = 1 << RFP_OLUT };
enum { RFP_COMMA = 0x1CE1CEBB };
enum { RFP_LRSPB = 0x0400081 };
enum { RFP_LRSPM = 0x2000023 };
enum { RFP_MSEQ = 0xFFFFFF };
enum { RFP_MTU = 1536 };


/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  int_4 rfp;
  int_4 fec;
  int_4 scr;
  int_4 bpw;
  int_4 upp;
  int_4 lrsl;
  int_u2 shft;
  int_u2 mask;
  int_u1 punc;
  int_u1 ipunc;
  int_u1 mpunc;
  int_u4 iseq;
  int_u4 mseq;
  int_u4 cseq;
  int_u4 errs;
  int_u2* elut;
  int_u1 ilen;
  int_u1 olen;
  int_u1 flgs;
  int_u1 scrc;
  int_u4 scrv;
  int_u1 gmask;
  int_u4 lrsi;
  int_u4 lrsc;
  int_u4 lrsp;
  int_u1 uv;
  int_u4 bi;
  int_u4 crc;
} RFP;

#include "cores/CoreProtos.h"

/** CORE Code */

void* RFP_alloc (char *config) {
  RFP* plan = RFP_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 RFP_upload (RFP* plan, void *planp) {
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,22);
  HW_loadInt  (planp,plan->shft);
  HW_loadInt  (planp,plan->mask);
  HW_loadInt  (planp,plan->punc);
  HW_loadInt  (planp,plan->ipunc);
  HW_loadInt  (planp,plan->mpunc);
  HW_loadInt  (planp,plan->iseq);
  HW_loadInt  (planp,plan->mseq);
  HW_loadInt  (planp,plan->cseq);
  HW_loadInt  (planp,plan->errs);
  HW_loadBuf  (planp,plan->elut,'s',1);
  HW_loadInt  (planp,plan->ilen);
  HW_loadInt  (planp,plan->olen);
  HW_loadInt  (planp,plan->flgs);
  HW_loadInt  (planp,plan->scrc);
  HW_loadInt  (planp,plan->scrv);
  HW_loadInt  (planp,plan->gmask);
  HW_loadInt  (planp,plan->lrsi);
  HW_loadInt  (planp,plan->lrsc);
  HW_loadInt  (planp,plan->lrsp);
  HW_loadInt  (planp,plan->uv);
  HW_loadInt  (planp,plan->bi);
  HW_loadInt  (planp,plan->crc);
  HW_push (planp,HW_OPEN);
  return 22;
}

void RFP_optimize (RFP* plan) {
  if (getBit(plan->flgs, 0)) plan->elut = zallocBuf(sizeof(int_u2)*(8));
}

int_4 RFP_init (RFP* plan) {
  plan->rfp = Modefs_RFP_NONE;
  plan->fec = Modefs_FEC_NONE;
  plan->scr = -1;
  plan->bpw = -1;
  return 0;
}

int_1 RFP_isGen (RFP* plan) {
  return (plan->bpw == 0);
}

int_4 RFP_set (RFP* plan, String* key, Value* value) {
  if (isMatch (key, "S:RFP")) plan->rfp = Value_toItem (value, Modefs_rfpList);
  else if (isMatch (key, "S:FEC")) plan->fec = Value_toItem (value, Modefs_fecList);
  else if (isMatch (key, "S:SCR")) plan->scr = Value_toItem (value, Modefs_scrList);
  else if (isMatch (key, "L:BPW")) plan->bpw = Value_toL (value);
  else if (isMatch (key, "L:LRSP")) plan->lrsp = Value_toL (value);
  else if (isMatch (key, "L:LRSI")) plan->lrsi = Value_toL (value);
  else if (isMatch (key, "L:LRSL")) plan->lrsl = Value_toL (value);
  else if (isMatch (key, "L:VFLG"));
  else if (isMatch (key, "L:ERRS")) plan->errs = Value_toL (value);
  else if (isMatch (key, "L:UPP")) plan->upp = Value_toL (value);
  else return Core_set (plan, key, value);
  return 0;
}

int_4 RFP_get (RFP* plan, String* key, Value* value) {
  if (isMatch (key, "L:RFP")) Value_fromL (value, plan->rfp);
  else if (isMatch (key, "L:FEC")) Value_fromL (value, plan->fec);
  else if (isMatch (key, "L:SCR")) Value_fromL (value, plan->scr);
  else if (isMatch (key, "L:ERRS")) Value_fromL (value, plan->errs);
  else return Core_get (plan, key, value);
  return 0;
}

int_4 RFP_open (RFP* plan) {
  int_4 iom;
  plan->elut = zallocBuf(sizeof(int_u2)*(RFP_NLUT));
  iom = Modems_getFECLUT (plan->fec, plan->upp, plan->elut, null);
  plan->ilen = (iom >> 0) & 0xFF;
  plan->olen = (iom >> 8) & 0xFF;
  plan->mask = (iom >> 16) & 0xFFF;
  plan->mpunc = (iom >> 28) & 0xF;
  plan->gmask = (1 << plan->ilen) - 1;
  plan->shft = 0;
  plan->ipunc = plan->mpunc;
  plan->lrsc = plan->lrsi;
  if (plan->lrsp == 0 || plan->lrsp == - 1) plan->lrsp = RFP_LRSPM;
  if (plan->lrsl >= (1 << 24)) printf ("Err: LSR repeat length=%d too long max=%d\n", plan->lrsl, (1 << 24));
  plan->flgs = 0;
  if (plan->scr < 0) plan->scr = (plan->fec == Modefs_FEC_NONE) ? Modefs_SCR_LRS : Modefs_SCR_NONE;
  if (plan->scr > Modefs_SCR_LRS) {
    plan->flgs |= 0x4;
    if (plan->fec == Modefs_FEC_NONE) plan->ilen = plan->olen = 1;
  }
  if (plan->rfp == Modefs_RFP_NONE && plan->fec == Modefs_FEC_NONE && plan->scr <= Modefs_SCR_LRS && plan->bpw != 0) plan->flgs |= 0x1;
  if (plan->bpw == 0 && plan->rfp == 0) plan->flgs |= 0x08;
  if (plan->bpw == 0 && plan->rfp != 0) plan->flgs |= 0x20;
  if (plan->fec >= Modefs_FEC_TCM) plan->flgs |= 0x10;
  if (getBit(plan->flgs, 0)) plan->ilen = plan->olen = 32;
  plan->iseq = 0;
  plan->mseq = (plan->lrsl > 0) ? plan->lrsl - plan->ilen : getBit(plan->flgs, 3) ? RFP_MSEQ : RFP_MTU * 8 - plan->ilen;
  plan->cseq = plan->mseq & 0xFFFFE0;
  RFP_optimize (plan);
  if(plan->halo.vbpr&1)printf ("RFP rfp=%d fec=%d scr=%x bpw=%d ilen=%d olen=%d flgs=%x punc=%d\n", plan->rfp, plan->fec, plan->scr, plan->bpw, plan->ilen, plan->olen, plan->flgs, plan->mpunc + 1);
  RFP_upload (plan,plan);
  return 0;
}

int_4 RFP_process (RFP* plan, Stream* si, Stream* so) {
  int_u2 olut;
  int_u2 ilut;
  int_u1 bix;
  int_u1 otcm3;
  int_u1 biy, otcm2;
  int_u1 qtcm, scrv0;
  int_1 bypass, scramb, genl, tcm, rt, srst, genc;
  bypass = getBit(plan->flgs, 0);
  rt = getBit(plan->flgs, 1);
  scramb = getBit(plan->flgs, 2);
  genl = getBit(plan->flgs, 3);
  tcm = getBit(plan->flgs, 4);
  genc = getBit(plan->flgs, 5);
  while (so->wok && (genl || genc || si->rok || rt)) {
    if (bypass) {
      plan->bi = Stream_rdL (si);
    }
    else if (genl) {
      plan->lrsc = (plan->iseq == 0) ? plan->lrsi : iLRSP (plan->lrsc, plan->lrsp);
      plan->bi = plan->lrsc;
      plan->crc = (plan->iseq == 0) ? RFP_COMMA : plan->crc ^ plan->bi;
    }
    else if ((plan->iseq & 0x1F) != 0) {
      plan->bi = plan->bi >> plan->ilen;
    }
    else if (plan->iseq == plan->cseq) {
      plan->bi = plan->crc;
    }
    else if (plan->iseq == 0 || (! genc && ! si->rok)) {
      plan->bi = RFP_COMMA;
      plan->crc = plan->bi;
    }
    else if (genc) {
      plan->bi = 0x01CE01CE;
      plan->crc = plan->crc ^ plan->bi;
    }
    else {
      plan->bi = Stream_rdL (si);
      plan->crc = plan->crc ^ plan->bi;
    }
    srst = (plan->iseq <= 32);
    plan->iseq = (plan->iseq >= plan->mseq) ? 0 : plan->iseq + plan->ilen;
    if (bypass) {
      Stream_wrBits (so, 32, plan->bi);
    }
    else {
      scrv0 = getBits(plan->bi, 0, 0) ^ (srst ? 0 : (getBits(plan->scrv, 3, 3) ^ getBits(plan->scrv, 20, 20) ^ ((plan->scrc == 31) ? 1 : 0)));
      plan->scrc = srst ? 0 : (getBit(plan->scrv, 1) != getBit(plan->scrv, 9)) ? 0 : plan->scrc + 1;
      plan->scrv = srst ? 1 : (scrv0 << 1) | (plan->scrv << 1);
      bix = tcm ? getBits(plan->bi, 1, 1) : scramb ? scrv0 : (plan->bi & plan->gmask);
      biy = getBits(plan->bi, 0, 0);
      plan->shft = ((plan->shft << 1) & plan->mask) | bix;
      ilut = (plan->ipunc << RFP_MO) | plan->shft;
      plan->ipunc = (plan->ipunc >= plan->mpunc) ? 0 : plan->ipunc + 1;
      olut = plan->elut[ilut];
      if (tcm) {
        plan->uv = plan->uv ^ (biy << getBits(olut, 1, 1));
        otcm2 = getBits(olut, 1, 0);
        qtcm = getBits(olut, 1, 1);
        otcm3 = otcm2 | (getBit(plan->uv, qtcm) ? 4 : 0);
        Stream_wrBits (so, 3, otcm3);
      }
      else {
        Stream_wrBits (so, plan->olen - getBits(olut, 8, 8), getBits(olut, 7, 0));
      }
    }
  }
  return 0;
}

int_4 RFP_close (RFP* plan) {
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 RFP_poll (RFP* plan) { return 0; }

int_4 RFP_free (RFP* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

RFP* RFP_subCore (HALO* halo, int_4 scid) {
  RFP* plan = RFP_plan();
  if (plan==NULL) return NULL;
  Core_copyHaloToSub(halo,&plan->halo,scid);
  RFP_init(plan);
  return plan;
}
#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
