/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See PKT2DAT.jv for documentation.
*/
package nxm.ice.core;
import nxm.ice.lib.*;
public class PKT2DAT extends CoreFactory {

public static class JVM extends CORE       {                             public JVM() { setFlow(PACKET); } }
public static class CPU extends CoreNative { public native long alloc(); public CPU() { setFlow(PACKET); } }
public static class ICE extends CoreNative { public native long alloc(); public ICE() { setFlow(PACKET); } }

public static class CORE extends Core {
  public final static int FLOW = PACKET, SELFPACE = 1, PIPE = 0;
  public final static String pktList = "Auto,None,Eth,UDP,ICE,SDDS,VRT,VRTL,VRTW,VRTX,VRTD";
  public final static int PT_AUTO = -1, PT_NONE = 0, PT_ETH = 1, PT_UDP = 2, PT_ICE = 3, PT_SDDS = 4, PT_VRT = 5, PT_VRTL = 6, PT_VRTW = 7, PT_VRTX = 8, PT_VRTD = 9;
  public final static String flgList = "Asis,Gate,Clip,AllEth,AnyMC,AnySID,AnyIP,Other,Pack,Test";
  public final static int BW = 32, PIBW = 32, POBW = 32, RW = 15, CW = 2, NC = 4;
  public final static int IP = 0x0008, ARP = 0x0608, ICMP = 1, IGMP = 2, TCP = 6, UDP = 17, SOP = 0xD555, OUID = 0x104D77, DIFI = 0x6A621E, GATE = 0x7FDE1CED, IGMP_BA = 0xe0000001;
  public final static int RES_IPKT = 1, RES_OPKT = 2, RES_ARP = 3, RES_ICMP = 4, RES_IGMP = 5, RES_OTHER = 6;
  int pkty;
  int myip;
  int mcip;
  int mcid;
  int flags;
  int osel;
  int ipkt;
  int opkt;
  int ic;
  int nc;
  int[] mcips;
  int[] mcids;
  int[] osels;
  int counts;
  int nseq;
  int ouid;
  int debug;
  int gcnt;
  Dma dma;
  public int init () {
    ic = 0;
    nc = 0;
    pkty = PT_AUTO;
    ouid = 0;
    return 0;
  }
  public int set (String key, Value value) {
    if (isMatch (key, "S:PT")) pkty = value.toItem (pktList);
    else if (isMatch (key, "L:PKTY")) pkty = value.toL ();
    else if (isMatch (key, "L:MYIP")) myip = value.toL ();
    else if (isMatch (key, "L:CHAN")) ic = value.toL ();
    else if (isMatch (key, "L:MCIP")) mcip = value.toL ();
    else if (isMatch (key, "L:MCID")) mcid = value.toL () & 0xFFFF;
    else if (isMatch (key, "L:OSEL")) osel = value.toL ();
    else if (isMatch (key, "L:OUID")) ouid = value.toL ();
    else if (isMatch (key, "S:FLAGS")) flags = value.toMask (flgList);
    else if (isMatch (key, "L:FLAGS")) flags = value.toL ();
    else return super.set (key, value);
    return 0;
  }
  public int get (String key, Value value) {
    if (isMatch (key, "L:PKTY")) value.fromL (pkty);
    else if (isMatch (key, "L:MYIP")) value.fromL (myip);
    else if (isMatch (key, "L:MCIP")) value.fromL (mcip);
    else if (isMatch (key, "L:MCID")) value.fromL (mcid);
    else if (isMatch (key, "L:FLAGS")) value.fromL (flags);
    else return super.get (key, value);
    return 0;
  }
  public int open () {
    int i;
    dma = new Dma (RW, BW);
    mcips = new int[NC];
    mcids = new int[NC];
    osels = new int[NC];
    for (i = 0; i < NC; i ++) {
      mcips[i] = 0xFFFFFFFF;
      mcids[i] = 0xFFFF;
      osels[i] = 0;
    }
    mcips[ic] = mcip;
    mcids[ic] = mcid;
    osels[ic] = osel;
    if (pkty == PT_UDP) flags |= 0x01;
    if (pkty == PT_ETH) flags |= 0x08;
    if (mcip == 0xFFFFFFFF) flags |= 0x10;
    if (mcid == 0xFFFF) flags |= 0x20;
    if (ouid < 0) flags |= 0x400;
    if (ouid <= 0) ouid = (pkty == PT_VRTD) ? DIFI : OUID;
    ipkt = 0;
    opkt = 0;
    nseq = 0;
    counts = 0;
    if((this.halo.vbpr&1)!=0)System.out.printf ("PKT2DAT pkt=%d flg=%04x\n", pkty, flags);
    this.halo.state=1;
    return 0;
  }
  public int process (Buffer bi, Stream sip, Stream so, Stream sop) {
    int length, reslen, pktlen, udplen, ulen, dlen;
    int src, dest, bx, by, bz, bq, bs;
    int ihdr, ioff, seq, dmaflg;
    int restyp, ooff, bps, tlen;
    int sid;
    boolean asis, gate, doclip, anyMC, anySID, anyOUID, anyIP, othpkt, pack, isMe, isBA, isMC, isSID, isOUID, hasOUID, hasSID;
    boolean isARP, isIP, isICMP, isIGMP, isUDP, isICE, isSDDS, isVRT, isVRTi, isVRTj, isVRTx, isVRTd, isVRTc, isVCTX, isKeep, isBE, isNB;
    boolean alludp, alleth, okICE, okSDDS, okVRT, noOut, doUDP, tena, xrst, doGate;
    boolean isMC0, isMC1, isMC2, isMC3;
    asis = getBit(flags, 0);
    gate = getBit(flags, 1);
    doclip = getBit(flags, 2);
    alleth = getBit(flags, 3) || (pkty == PT_ETH);
    anyMC = getBit(flags, 4);
    anySID = getBit(flags, 5);
    anyIP = getBit(flags, 6);
    othpkt = getBit(flags, 7);
    pack = getBit(flags, 8);
    tena = getBit(flags, 9);
    tlen = getBits(flags, 15, 12);
    xrst = false;
    noOut = (pkty == PT_NONE) && ! getBit(flags, 1);
    alludp = (pkty == PT_UDP);
    okICE = (pkty == PT_AUTO) || (pkty == PT_ICE);
    okSDDS = (pkty == PT_AUTO) || (pkty == PT_SDDS);
    okVRT = (pkty == PT_AUTO) || (pkty >= PT_VRT);
    while (sip.rok) {
      dmaflg = 0;
      pktlen = 0;
      reslen = 0;
      restyp = 0;
      ihdr = 0;
      ioff = 0;
      length = 0;
      seq = nseq;
      ipkt ++;
      counts=setBits(counts, 11, 0, ipkt);
      bs = sip.rdL ();
      by = bi.getL (0);
      bx = bi.getL (12);
      isARP = (getBits(bx, 31, 16) == ARP);
      isIP = (getBits(bx, 31, 16) == IP);
      bx = bi.getL (24);
      isUDP = isIP && (getBits(bx, 15, 8) == UDP);
      isICMP = isIP && (getBits(bx, 15, 8) == ICMP);
      isIGMP = isIP && (getBits(bx, 15, 8) == IGMP);
      isVCTX = false;
      bx = bi.getL (32);
      dest = bswap4 (bx);
      isMe = (dest == myip);
      isBA = (dest == IGMP_BA);
      isMC = (dest == mcip);
      if (nc > 0) {
        isMC0 = (dest == mcips[0]);
        isMC1 = (dest == mcips[1]);
        isMC2 = (dest == mcips[2]);
        isMC3 = (dest == mcips[3]);
        isMC = isMC0 || isMC1 || isMC2 || isMC3;
        ic = isMC0 ? 0 : isMC1 ? 1 : isMC2 ? 2 : isMC3 ? 3 : 0;
        mcid = mcids[ic];
        osel = osels[ic];
      }
      if (getBits(bs, 17, 16) != 0x1 || getBits(by, 15, 0) != SOP) {
        xrst = true;
        counts=setBit(counts, 31, true);
        counts=setBits(counts, 30, 28, getBits(counts, 30, 28) + 1);
        return 1;
      }
      doUDP = isUDP && (anyMC || isMC) && ! alleth;
      if (doUDP) {
        bx = bi.getL (40);
        udplen = bswap2 (getBits(bx, 15, 0));
        ooff = 8;
        ihdr = 44;
        isKeep = true;
        bx = bi.getL (ihdr);
        by = bi.getL (ihdr + 4);
        bz = bi.getL (ihdr + 8);
        bq = bi.getL (ihdr + 12);
        anyOUID = getBit(flags, 10) || ! getBit(bx, 3);
        hasOUID = getBit(bx, 3);
        hasSID = (getBits(bx, 6, 5) > 1) ? true : getBit(bx, 4);
        sid = bswap2 (hasSID ? getBits(by, 31, 16) : getBits(bz, 15, 0));
        isSID = (sid == mcid);
        isOUID = (ouid == bswap4 (hasSID ? bz : by));
        isVRTi = (getBits(bx, 7, 0) == 0x1C);
        isVRTj = (getBits(bx, 7, 0) == 0x08);
        isVRTx = (getBits(bx, 7, 0) == 0x14) && (pkty == PT_VRTX);
        isVRTd = (getBits(bx, 7, 0) == 0x18);
        isVRTc = (getBits(bx, 7, 0) == 0x49) || (getBits(bx, 7, 0) == 0x41);
        isICE = okICE && (bx == 0x00676665);
        isSDDS = okSDDS && (udplen == 1088);
        isVRT = okVRT && (isVRTi || isVRTj || isVRTx || isVRTd) && (isSID || anySID) && (isOUID || anyOUID);
        isVCTX = okVRT && isVRTc && (isSID || anySID) && (isOUID || anyOUID);
        if (alludp) {
          ioff = 0;
        }
        else if (isICE) {
          ioff = 64;
          seq = getBits(by, 7, 0);
          sid = getBits(bq, 31, 16);
        }
        else if (isSDDS) {
          ioff = 56;
          seq = getBits(bx, 31, 24);
          isNB = getBits(bx, 13, 8) > 8;
          bq = bi.getL (ihdr + 52);
          sid = getBits(bq, 31, 16);
          dmaflg=setBit(dmaflg, 0, isNB);
        }
        else if (isVRT) {
          if ((getBit(bx, 2)) && ! asis) {
            ooff = 12;
          }
          seq = getBits(bx, 11, 8);
          nseq = nseq & 0xF;
          ioff = ! hasOUID ? 20 : ! hasSID ? 24 : 28;
          isBE = isVRTi ? getBit(bq, 22) : isVRTj ? getBit(bz, 22) : true;
          bps = isVRTi ? getBits(bq, 27, 24) : isVRTj ? getBits(bz, 27, 24) : 15;
          dmaflg=setBit(dmaflg, 0, (bps == 15) && isBE);
          dmaflg=setBit(dmaflg, 1, (bps > 7) && isBE);
          dmaflg=setBit(dmaflg, 2, (bps == 11) && isBE);
          if (tena) {
            bx = bi.getL (ihdr + 16);
            isKeep = (getBits(bx, 31, 28) < tlen);
          }
        }
        else {
          isKeep = isVCTX ? asis : false;
        }
        if (asis) {
          ioff = 0;
          dmaflg = 0;
        }
        ulen = udplen - ioff - ooff;
        isSID = (sid == mcid);
        if (isKeep && (isSID || anySID)) {
          length = ulen;
        }
      }
      else if (isICMP && (isMe | anyIP)) {
        restyp = RES_ICMP;
        counts=setBits(counts, 19, 16, getBits(counts, 19, 16) + 1);
        alleth &= ! gate;
      }
      else if (isIGMP && (isMe | anyIP | isMC | isBA)) {
        restyp = RES_IGMP;
        counts=setBits(counts, 23, 20, getBits(counts, 23, 20) + 1);
      }
      else if (isARP) {
        bx = bi.getL (40);
        isMe = (bswap4 (bx) == myip);
        if (isMe) {
          restyp = RES_ARP;
          counts=setBits(counts, 27, 24, getBits(counts, 27, 24) + 1);
          alleth &= ! gate;
        }
      }
      else if (othpkt && ! isUDP) {
        restyp = RES_OTHER;
        counts=setBits(counts, 30, 28, getBits(counts, 30, 28) + 1);
      }
      if (alleth) {
        while (! sip.rok) {
        }
        bs = sip.rdL ();
        pktlen = bs & 0xFFFF;
        length = pktlen;
        if (gate) {
          so.wrL (GATE);
        }
      }
      if (length > 0 && ! noOut) {
        so.setC (osel);
        dma.setFlags (dmaflg);
        dma.b2s (bi, ihdr + ioff, so, 0, length);
        opkt ++;
        if (isUDP && ! isVCTX) {
          if (seq != nseq) {
            counts=setBits(counts, 15, 12, getBits(counts, 15, 12) + 1);
          }
          nseq = seq + 1;
        }
        gcnt = 0;
        dma.sync ();
        if (gate) {
          so.wrL (GATE);
        }
      }
      if (! alleth) {
        while (! sip.rok) {
        }
        bs = sip.rdL ();
        pktlen = bs & 0xFFFF;
      }
      if (restyp > 0 && sop.wok) {
        dma.setFlags (0);
        reslen = pktlen;
        bs=setBits(bs, 31, 20, 0x1CE);
        bs=setBits(bs, 19, 16, restyp);
        bs=setBits(bs, 15, 0, reslen);
        sop.wrL (bs);
        bs = bswap4 (myip);
        sop.wrL (bs);
        dma.b2s (bi, 0, sop, 0, reslen);
        System.out.printf ("Got restyp=%d reslen=%d\n", restyp, reslen);
        dma.sync ();
      }
      bi.rnxt (pktlen);
    }
    this.opkt = opkt;
    this.counts = counts;
    doGate = gate && ! sip.rok && so.wok && ! noOut && (gcnt == 0xFF);
    if (doGate) {
      so.wrL (GATE);
    }
    gcnt ++;
    return 0;
  }
  public int close () {
    this.halo.state=0;
    return 0;
  }
}
}
