package nxm.ice.core;

import nxm.ice.lib.*;
import nxm.sys.lib.Data;
import nxm.sys.lib.Convert;

/**
  Implements a Hardware (verilog/vhdl) Only Core interface

  @author Jeff Schoen
  @version $Id: HOC.java,v 1.8 2011/05/24 13:21:13 jgs Exp $
*/
public class HOC extends CoreFactory {

 // native implementation wrappers
 public static class CPU extends CoreNative { public native long alloc(); }
 public static class VHS extends CoreNative { public native long alloc(); }
 public static class ICE extends CoreNative { public native long alloc(); }

 // java implementation
 public static class JVM extends Core { 

  /** set parameters */
  public int set (String key, Data value) {
    return super.set(key,value);
  }

  /** get parameters */
  public Data get (String key, byte type) {
    return super.get(key,type);
  }

  /** Ready this engine with current parameters */
  public int open() {
    return 0;
  }

 }
}
