/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See Filters.jv for documentation.
*/

import CORE_types::*;
package Filters_types;
import CORE_types::*;
endpackage
import Filters_types::*;

module Filters_Smooth #(ORDER=0) (input[1:0] clks, input rst,input s_wr, input[31:0] s_addr, input[31:0] s_wrbus,
  input process_ena, input fptx fin, input valid, output fptx process_ret);

  wire clk=clks[0],clk2=clks[1];
  logic T=1,F=0; logic[7:0] T8=~0,F8=0;
  logic[15:0] c_cnt; always @(posedge clk) c_cnt <= c_cnt+1;
  wire [31:0] s_sub; wire [63:0] s_val; wire [15:0] s_ind; wire[9:0] s_set;
  setter #(10) s_bank (clk,rst,s_wr,s_addr,s_wrbus,s_sub,s_ind,s_set,s_val);

  import CORE_funcs::*;

  localparam mlen = 1 << ORDER ;
  localparam mask = ( mlen - 1 ) ;
  intx offa;
  intx offb;
  fptx scale;
  dptx fx;
  boolean full;
  fptx ival;
  fptx ax[mlen];

  /* verilator lint_off UNOPTFLAT */
  Line c_ln[14];  wire c_en[14];  wire c_xn[14];
  /* verilator lint_on UNOPTFLAT */

  setLine #(1,0,0) f_1 (c_ln[1],"startMethod",process_ena,F); // public fptx process ( fptx fin , boolean valid ) {
  fptx fa, fb;                                               // fptx fa , fb ;
  setLine #(1,0,1) f_3 (c_ln[3],"setVar",T,F);               // fa = fin ;
  setLine #(1,0,1) f_4 (c_ln[4],"setVar",T,F);               // ax [ offa ] = fin ;
  setLine #(1,0,1) f_5 (c_ln[5],"setVar",T,F);               // fb = full ? ax [ offb ] : ival ;
  setLine #(1,0,1) f_6 (c_ln[6],"setVar",T,F);               // full = full || ( offb == mask ) ;
  setLine #(1,0,0) f_7 (c_ln[7],"If",valid,F);               // if ( valid ) {
  setLine #(7,0,1) f_8 (c_ln[8],"setVar",T,F);               // offa = ( offa + 1 ) & mask ;
  setLine #(7,0,1) f_9 (c_ln[9],"setVar",T,F);               // offb = ( offb + 1 ) & mask ;
  setLine #(7,1,1) f_10 (c_ln[10],"setVar",T,F);             // fx += f2d ( fa - fb ) ;
  setLine #(7,0,0) f_11 (c_ln[11],"endIf",c_xn[7],F);        // }
  setLine #(1,2,0) f_12 (c_ln[12],"return",T,F);             // return d2f ( fx * scale ) ;
  setLine #(12,0,0) f_13 (c_ln[13],"endMethod",T,F);         // }

  always @(posedge clk) begin
    if (s_set[2]) offa <= s_val;
    if (s_set[3]) offb <= s_val;
    if (s_set[4]) scale <= s_val;
    if (s_set[6]) fx <= lswap(s_val);
    if (s_set[8]) full <= s_val;
    if (s_set[9]) ival <= s_val;
    if (c_xn[3]) begin fa <= fin; end
    if (c_xn[4]) begin ax[offa] <= fin; end
    if (c_xn[5]) begin fb <= full ? ax[offb] : ival; end
    if (c_xn[6]) begin full <= full || (offb == mask); end
    if (c_xn[8]) begin offa <= (offa + 1) & mask; end
    if (c_xn[9]) begin offb <= (offb + 1) & mask; end
    if (c_xn[10]) begin fx <= fx + f2d (fa - fb); end
    if (c_xn[12]) begin process_ret <= d2f (muldf (fx, scale)); end
  end

  /* verilator lint_off WIDTHCONCAT */
  localparam int SEQ_PARAMS[14*4] = '{ 0,0,0,0, 11,0,0,0, 0,0,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 31,1,0,0, 21,7,0,0, 21,7,0,0, 21,7,1,0, 32,7,0,0, 14,1,2,0, 15,12,0,0};
  sequencer #(14,SEQ_PARAMS) c_seq (clks,rst, c_ln, c_en,c_xn);
  /* verilator lint_on WIDTHCONCAT */
endmodule

module Filters_SmoothP2 #(ORDER=0) (input[1:0] clks, input rst,input s_wr, input[31:0] s_addr, input[31:0] s_wrbus,
  input process_ena, input fptx fin, input valid, output fptx process_ret);

  wire clk=clks[0],clk2=clks[1];
  logic T=1,F=0; logic[7:0] T8=~0,F8=0;
  logic[15:0] c_cnt; always @(posedge clk) c_cnt <= c_cnt+1;
  wire [31:0] s_sub; wire [63:0] s_val; wire [15:0] s_ind; wire[7:0] s_set;
  setter #(8) s_bank (clk,rst,s_wr,s_addr,s_wrbus,s_sub,s_ind,s_set,s_val);

  import CORE_funcs::*;

  localparam mlen = 1 << ORDER ;
  localparam mask = ( mlen - 1 ) ;
  uint12 offa;
  uint12 offb;
  uint4 olen;
  int32 lx;
  boolean full;
  int32 ax[mlen];

  /* verilator lint_off UNOPTFLAT */
  Line c_ln[15];  wire c_en[15];  wire c_xn[15];
  /* verilator lint_on UNOPTFLAT */

  setLine #(1,0,0) f_1 (c_ln[1],"startMethod",process_ena,F); // public fptx process ( fptx fin , boolean valid ) {
  int32 lin, fa, fb;                                         // int32 lin , fa , fb ;
  setLine #(1,0,0) f_3 (c_ln[3],"setVar",T,F);               // lin = F2K ( fin ) ;
  setLine #(1,0,1) f_4 (c_ln[4],"setVar",T,F);               // fa = lin ;
  setLine #(1,0,1) f_5 (c_ln[5],"setVar",T,F);               // ax [ offa ] = lin ;
  setLine #(1,0,1) f_6 (c_ln[6],"setVar",T,F);               // fb = full ? ax [ offb ] : 0 ;
  setLine #(1,0,1) f_7 (c_ln[7],"setVar",T,F);               // full = full || ( offb == mask ) ;
  setLine #(1,0,0) f_8 (c_ln[8],"If",valid,F);               // if ( valid ) {
  setLine #(8,0,1) f_9 (c_ln[9],"setVar",T,F);               // offa = ( offa + 1 ) & mask ;
  setLine #(8,0,1) f_10 (c_ln[10],"setVar",T,F);             // offb = ( offb + 1 ) & mask ;
  setLine #(8,1,1) f_11 (c_ln[11],"setVar",T,F);             // lx += ( fa - fb ) ;
  setLine #(8,0,0) f_12 (c_ln[12],"endIf",c_xn[8],F);        // }
  setLine #(1,2,0) f_13 (c_ln[13],"return",T,F);             // return K2F ( lx >> olen ) ;
  setLine #(13,0,0) f_14 (c_ln[14],"endMethod",T,F);         // }

  assign lin = F2K (fin);
  always @(posedge clk) begin
    if (s_set[2]) offa <= s_val;
    if (s_set[3]) offb <= s_val;
    if (s_set[4]) olen <= s_val;
    if (s_set[5]) lx <= s_val;
    if (s_set[7]) full <= s_val;
    if (c_xn[4]) begin fa <= lin; end
    if (c_xn[5]) begin ax[offa] <= lin; end
    if (c_xn[6]) begin fb <= full ? ax[offb] : 0; end
    if (c_xn[7]) begin full <= full || (offb == mask); end
    if (c_xn[9]) begin offa <= (offa + 1) & mask; end
    if (c_xn[10]) begin offb <= (offb + 1) & mask; end
    if (c_xn[11]) begin lx <= lx + (fa - fb); end
    if (c_xn[13]) begin process_ret <= K2F (lx >>> olen); end
  end

  /* verilator lint_off WIDTHCONCAT */
  localparam int SEQ_PARAMS[15*4] = '{ 0,0,0,0, 11,0,0,0, 0,0,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 31,1,0,0, 21,8,0,0, 21,8,0,0, 21,8,1,0, 32,8,0,0, 14,1,2,0, 15,13,0,0};
  sequencer #(15,SEQ_PARAMS) c_seq (clks,rst, c_ln, c_en,c_xn);
  /* verilator lint_on WIDTHCONCAT */
endmodule

module Filters_SmoothP2X #(ORDER=0) (input[1:0] clks, input rst,input s_wr, input[31:0] s_addr, input[31:0] s_wrbus,
  input process_ena, input fptx fin, input valid, output fptx process_ret);

  wire clk=clks[0],clk2=clks[1];
  logic T=1,F=0; logic[7:0] T8=~0,F8=0;
  logic[15:0] c_cnt; always @(posedge clk) c_cnt <= c_cnt+1;
  wire [31:0] s_sub; wire [63:0] s_val; wire [15:0] s_ind; wire[3:0] s_set;
  setter #(4) s_bank (clk,rst,s_wr,s_addr,s_wrbus,s_sub,s_ind,s_set,s_val);

  import CORE_funcs::*;

  localparam shift = ORDER ;
  localparam mshft=0;
  fptx val;
  fptx scale;

  /* verilator lint_off UNOPTFLAT */
  Line c_ln[7];  wire c_en[7];  wire c_xn[7];
  /* verilator lint_on UNOPTFLAT */

  setLine #(1,0,0) f_1 (c_ln[1],"startMethod",process_ena,F); // public fptx process ( fptx fin , boolean valid ) {
  setLine #(1,0,0) f_2 (c_ln[2],"If",valid,F);               // if ( valid ) {
  setLine #(2,0,1) f_3 (c_ln[3],"setVar",T,F);               // val = val * scale + divfp2 ( mulfp2 ( fin , 8 ) , shift ) ;
  setLine #(2,0,0) f_4 (c_ln[4],"endIf",c_xn[2],F);          // }
  setLine #(1,1,0) f_5 (c_ln[5],"return",T,F);               // return divfp2 ( val , 8 ) ;
  setLine #(5,0,0) f_6 (c_ln[6],"endMethod",T,F);            // }

  always @(posedge clk) begin
    if (s_set[2]) val <= s_val;
    if (s_set[3]) scale <= s_val;
    if (c_xn[3]) begin val <= mulff (val, scale) + divfp2 (mulfp2 (fin, 8), shift); end
    if (c_xn[5]) begin process_ret <= divfp2 (val, 8); end
  end

  /* verilator lint_off WIDTHCONCAT */
  localparam int SEQ_PARAMS[7*4] = '{ 0,0,0,0, 11,0,0,0, 31,1,0,0, 21,2,0,0, 32,2,0,0, 14,1,1,0, 15,5,0,0};
  sequencer #(7,SEQ_PARAMS) c_seq (clks,rst, c_ln, c_en,c_xn);
  /* verilator lint_on WIDTHCONCAT */
endmodule

module Filters_CxCIC #(ocic=0,odec=0) (input[1:0] clks, input rst,input s_wr, input[31:0] s_addr, input[31:0] s_wrbus,
  input process_ena, input CxFptx fi, output CxFptx fo, output logic process_ret);

  wire clk=clks[0],clk2=clks[1];
  logic T=1,F=0; logic[7:0] T8=~0,F8=0;
  logic[15:0] c_cnt; always @(posedge clk) c_cnt <= c_cnt+1;
  wire [31:0] s_sub; wire [63:0] s_val; wire [15:0] s_ind; wire[11:0] s_set;
  setter #(12) s_bank (clk,rst,s_wr,s_addr,s_wrbus,s_sub,s_ind,s_set,s_val);

  import CORE_funcs::*;

  localparam O_CIC = ocic ;
  localparam O_DEC = odec ;
  uint12 count;
  uint12 decm;
  uint5 coarse;
  uint5 fine;
  int64 pix[O_CIC + 1];
  int64 piy[O_CIC + 1];
  int32 pox[O_CIC + 1];
  int32 poy[O_CIC + 1];
  int32 pdx[O_CIC + 1];
  int32 pdy[O_CIC + 1];

  /* verilator lint_off UNOPTFLAT */
  Line c_ln[25];  wire c_en[25];  wire c_xn[25];
  /* verilator lint_on UNOPTFLAT */

  setLine #(1,0,0) f_1 (c_ln[1],"startMethod",process_ena,F); // public boolean process ( CxFptx fi , CxFptx fo ) {
  int ia, ib;                                                // int ia , ib ;
  boolean out;                                               // boolean out ;
  boolean out_2; delayp #(2,1) dp_out_2(clk,out,out_2);
  int64 pox0, poy0;                                          // int64 pox0 , poy0 ;
  setLine #(1,0,0) f_5 (c_ln[5],"GenFor",T,F);               // for ( ia = O_CIC ; ia >= 0 ; ia -- ) {
  setLine #(5,0,1) f_6 (c_ln[6],"setVar",T,F);               // pix [ ia ] = ( ia == 0 ) ? s2l ( F2I ( fi.x ) ) : pix [ ia ] + pix [ ia - 1 ] ;
  setLine #(5,0,1) f_7 (c_ln[7],"setVar",T,F);               // piy [ ia ] = ( ia == 0 ) ? s2l ( F2I ( fi.y ) ) : piy [ ia ] + piy [ ia - 1 ] ;
  setLine #(5,0,0) f_8 (c_ln[8],"endGenFor",c_xn[5],F);      // }
  setLine #(1,0,1) f_9 (c_ln[9],"setVar",T,F);               // out = ( count == 0 ) ;
  setLine #(1,0,1) f_10 (c_ln[10],"setVar",T,F);             // count = ( count == 0 ) ? decm : count - 1 ;
  setLine #(1,1,0) f_11 (c_ln[11],"If",out,F);               // if ( out ) {
  setLine #(11,0,1) f_12 (c_ln[12],"setVar",T,F);            // pox0 = pix [ O_CIC ] >> coarse ;
  setLine #(11,0,1) f_13 (c_ln[13],"setVar",T,F);            // poy0 = piy [ O_CIC ] >> coarse ;
  setLine #(11,0,0) f_14 (c_ln[14],"GenFor",T,F);            // for ( ib = O_CIC ; ib >= 0 ; ib -- ) {
  setLine #(14,0,1) f_15 (c_ln[15],"setVar",T,F);            // pdx [ ib ] = pox [ ib ] ;
  setLine #(14,0,1) f_16 (c_ln[16],"setVar",T,F);            // pox [ ib ] = ( ib == 0 ) ? l2i ( pox0 ) : pox [ ib - 1 ] - pdx [ ib - 1 ] ;
  setLine #(14,0,1) f_17 (c_ln[17],"setVar",T,F);            // pdy [ ib ] = poy [ ib ] ;
  setLine #(14,0,1) f_18 (c_ln[18],"setVar",T,F);            // poy [ ib ] = ( ib == 0 ) ? l2i ( poy0 ) : poy [ ib - 1 ] - pdy [ ib - 1 ] ;
  setLine #(14,0,0) f_19 (c_ln[19],"endGenFor",c_xn[14],F);  // }
  setLine #(11,0,1) f_20 (c_ln[20],"setVar",T,F);            // fo.x = K2F ( pox [ O_CIC ] >> fine ) ;
  setLine #(11,0,1) f_21 (c_ln[21],"setVar",T,F);            // fo.y = K2F ( poy [ O_CIC ] >> fine ) ;
  setLine #(11,0,0) f_22 (c_ln[22],"endIf",c_xn[11],F);      // }
  setLine #(1,3,0) f_23 (c_ln[23],"return",T,F);             // return out ;
  setLine #(23,0,0) f_24 (c_ln[24],"endMethod",T,F);         // }

  always @(posedge clk) begin
    if (rst) fo <= 0;
    if (s_set[2]) count <= s_val;
    if (s_set[3]) decm <= s_val;
    if (s_set[4]) coarse <= s_val;
    if (s_set[5]) fine <= s_val;
    if (c_xn[9]) begin out <= (count == 0); end
    if (c_xn[10]) begin count <= (count == 0) ? decm : count - 1; end
    if (c_xn[12]) begin pox0 <= pix[O_CIC] >>> coarse; end
    if (c_xn[13]) begin poy0 <= piy[O_CIC] >>> coarse; end
    if (c_xn[20]) begin fo.x <= K2F (pox[O_CIC] >>> fine); end
    if (c_xn[21]) begin fo.y <= K2F (poy[O_CIC] >>> fine); end
    if (c_xn[23]) begin process_ret <= out_2; end
  end

  /* verilator lint_off SELRANGE */
  generate
  genvar I1,I2,I3,I4;
  for (I1 = O_CIC; I1 >= 0; I1 = I1 - 1) begin : b5
    always @(posedge clk) if (c_xn[6]) begin pix[I1] <= (I1 == 0) ? s2l (F2I (fi.x)) : pix[I1] + pix[I1-1]; end
    always @(posedge clk) if (c_xn[7]) begin piy[I1] <= (I1 == 0) ? s2l (F2I (fi.y)) : piy[I1] + piy[I1-1]; end
  end
  for (I1 = O_CIC; I1 >= 0; I1 = I1 - 1) begin : b14
    always @(posedge clk) if (c_xn[15]) begin pdx[I1] <= pox[I1]; end
    always @(posedge clk) if (c_xn[16]) begin pox[I1] <= (I1 == 0) ? l2i (pox0) : pox[I1-1] - pdx[I1-1]; end
    always @(posedge clk) if (c_xn[17]) begin pdy[I1] <= poy[I1]; end
    always @(posedge clk) if (c_xn[18]) begin poy[I1] <= (I1 == 0) ? l2i (poy0) : poy[I1-1] - pdy[I1-1]; end
  end
  endgenerate
  /* verilator lint_on SELRANGE */

  /* verilator lint_off WIDTHCONCAT */
  localparam int SEQ_PARAMS[25*4] = '{ 0,0,0,0, 11,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0, 61,1,0,0, 21,5,0,0, 21,5,0,0, 10,5,0,0, 21,1,0,0, 21,1,0,0, 31,1,1,0, 21,11,0,0, 21,11,0,0, 61,11,0,0, 21,14,0,0, 21,14,0,0, 21,14,0,0, 21,14,0,0, 10,14,0,0, 21,11,0,0, 21,11,0,0, 32,11,0,0, 14,1,3,0, 15,23,0,0};
  sequencer #(25,SEQ_PARAMS) c_seq (clks,rst, c_ln, c_en,c_xn);
  /* verilator lint_on WIDTHCONCAT */
endmodule

module Filters_CxComb #(ORDER=0) (input[1:0] clks, input rst,input s_wr, input[31:0] s_addr, input[31:0] s_wrbus,
  input process_ena, input CxFptx fi, output CxFptx fo, output logic process_ret);

  wire clk=clks[0],clk2=clks[1];
  logic T=1,F=0; logic[7:0] T8=~0,F8=0;
  logic[15:0] c_cnt; always @(posedge clk) c_cnt <= c_cnt+1;
  wire [31:0] s_sub; wire [63:0] s_val; wire [15:0] s_ind; wire[7:0] s_set;
  setter #(8) s_bank (clk,rst,s_wr,s_addr,s_wrbus,s_sub,s_ind,s_set,s_val);

  import CORE_funcs::*;

  intx off;
  intx lenm1;
  fptx fx;
  fptx fy;
  fptx scale;
  boolean full;
  boolean full_1; delayp #(1,1) dp_full_1(clk,full,full_1);
  fptx ax[1 << ORDER];
  fptx ay[1 << ORDER];

  /* verilator lint_off UNOPTFLAT */
  Line c_ln[18];  wire c_en[18];  wire c_xn[18];
  /* verilator lint_on UNOPTFLAT */

  setLine #(1,0,0) f_1 (c_ln[1],"startMethod",process_ena,F); // public boolean process ( CxFptx fi , CxFptx fo ) {
  fptx axi, ayi;                                             // fptx axi , ayi ;
  fptx bxi, byi;                                             // fptx bxi , byi ;
  setLine #(1,0,1) f_4 (c_ln[4],"setVar",T,F);               // axi = ! full ? 0 : ax [ off ] ;
  setLine #(1,0,1) f_5 (c_ln[5],"setVar",T,F);               // ayi = ! full ? 0 : ay [ off ] ;
  setLine #(1,0,1) f_6 (c_ln[6],"setVar",T,F);               // bxi = fi.x ;
  setLine #(1,0,1) f_7 (c_ln[7],"setVar",T,F);               // byi = fi.y ;
  setLine #(1,0,1) f_8 (c_ln[8],"setVar",T,F);               // ax [ off ] = fi.x ;
  setLine #(1,0,1) f_9 (c_ln[9],"setVar",T,F);               // ay [ off ] = fi.y ;
  setLine #(1,1,1) f_10 (c_ln[10],"setVar",T,F);             // fx = fx + bxi - axi ;
  setLine #(1,1,1) f_11 (c_ln[11],"setVar",T,F);             // fy = fy + byi - ayi ;
  setLine #(1,2,1) f_12 (c_ln[12],"setVar",T,F);             // fo.x = fx * scale ;
  setLine #(1,2,1) f_13 (c_ln[13],"setVar",T,F);             // fo.y = fy * scale ;
  setLine #(1,0,1) f_14 (c_ln[14],"setVar",T,F);             // full = full || ( off == lenm1 ) ;
  setLine #(1,0,1) f_15 (c_ln[15],"setVar",T,F);             // off = ( off < lenm1 ) ? off + 1 : 0 ;
  setLine #(1,2,0) f_16 (c_ln[16],"return",T,F);             // return full ;
  setLine #(16,0,0) f_17 (c_ln[17],"endMethod",T,F);         // }

  always @(posedge clk) begin
    if (rst) fo <= 0;
    if (s_set[0]) off <= s_val;
    if (s_set[1]) lenm1 <= s_val;
    if (s_set[2]) fx <= s_val;
    if (s_set[3]) fy <= s_val;
    if (s_set[4]) scale <= s_val;
    if (s_set[7]) full <= s_val;
    if (c_xn[4]) begin axi <= ! full ? 0 : ax[off]; end
    if (c_xn[5]) begin ayi <= ! full ? 0 : ay[off]; end
    if (c_xn[6]) begin bxi <= fi.x; end
    if (c_xn[7]) begin byi <= fi.y; end
    if (c_xn[8]) begin ax[off] <= fi.x; end
    if (c_xn[9]) begin ay[off] <= fi.y; end
    if (c_xn[10]) begin fx <= fx + bxi - axi; end
    if (c_xn[11]) begin fy <= fy + byi - ayi; end
    if (c_xn[12]) begin fo.x <= mulff (fx, scale); end
    if (c_xn[13]) begin fo.y <= mulff (fy, scale); end
    if (c_xn[14]) begin full <= full || (off == lenm1); end
    if (c_xn[15]) begin off <= (off < lenm1) ? off + 1 : 0; end
    if (c_xn[16]) begin process_ret <= full_1; end
  end

  /* verilator lint_off WIDTHCONCAT */
  localparam int SEQ_PARAMS[18*4] = '{ 0,0,0,0, 11,0,0,0, 0,0,0,0, 0,0,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,1,0, 21,1,1,0, 21,1,2,0, 21,1,2,0, 21,1,0,0, 21,1,0,0, 14,1,2,0, 15,16,0,0};
  sequencer #(18,SEQ_PARAMS) c_seq (clks,rst, c_ln, c_en,c_xn);
  /* verilator lint_on WIDTHCONCAT */
endmodule

module Filters_CxIIRStageO1 #() (input[1:0] clks, input rst,input s_wr, input[31:0] s_addr, input[31:0] s_wrbus,
  input process_ena, input CxFptx fi, output CxFptx fo, input fptx axM, input fptx ayM, input fptx naxM, input fptx nayM, output logic process_ret);

  wire clk=clks[0],clk2=clks[1];
  logic T=1,F=0; logic[7:0] T8=~0,F8=0;
  logic[15:0] c_cnt; always @(posedge clk) c_cnt <= c_cnt+1;
  wire [31:0] s_sub; wire [63:0] s_val; wire [15:0] s_ind; wire[4:0] s_set;
  setter #(5) s_bank (clk,rst,s_wr,s_addr,s_wrbus,s_sub,s_ind,s_set,s_val);

  import CORE_funcs::*;

  fptx b0;
  fptx b1;
  fptx b2;
  fptx a1;
  fptx a2;

  /* verilator lint_off UNOPTFLAT */
  Line c_ln[11];  wire c_en[11];  wire c_xn[11];
  /* verilator lint_on UNOPTFLAT */

  setLine #(1,0,0) f_1 (c_ln[1],"startMethod",process_ena,F); // public int process ( CxFptx fi , CxFptx fo , fptx axM , fptx ayM , fptx naxM , fptx nayM ) {
  fptx tax, tay, tbx, tby;                                   // fptx tax , tay , tbx , tby ;
  setLine #(1,0,1) f_3 (c_ln[3],"setVar",T,F);               // tax = naxM * a1 - nayM * a2 ;
  setLine #(1,0,1) f_4 (c_ln[4],"setVar",T,F);               // tay = nayM * a1 + naxM * a2 ;
  setLine #(1,0,1) f_5 (c_ln[5],"setVar",T,F);               // tbx = axM * b1 - ayM * b2 + fi.x ;
  setLine #(1,0,1) f_6 (c_ln[6],"setVar",T,F);               // tby = ayM * b1 + axM * b2 + fi.y ;
  setLine #(1,1,1) f_7 (c_ln[7],"setVar",T,F);               // fo.x = tbx * b0 - tax ;
  setLine #(1,1,1) f_8 (c_ln[8],"setVar",T,F);               // fo.y = tby * b0 - tay ;
  setLine #(1,0,0) f_9 (c_ln[9],"return",T,F);               // return 1 ;
  setLine #(9,0,0) f_10 (c_ln[10],"endMethod",T,F);          // }

  always @(posedge clk) begin
    if (rst) fo <= 0;
    if (s_set[0]) b0 <= s_val;
    if (s_set[1]) b1 <= s_val;
    if (s_set[2]) b2 <= s_val;
    if (s_set[3]) a1 <= s_val;
    if (s_set[4]) a2 <= s_val;
    if (c_xn[3]) begin tax <= mulff (naxM, a1) - mulff (nayM, a2); end
    if (c_xn[4]) begin tay <= mulff (nayM, a1) + mulff (naxM, a2); end
    if (c_xn[5]) begin tbx <= mulff (axM, b1) - mulff (ayM, b2) + fi.x; end
    if (c_xn[6]) begin tby <= mulff (ayM, b1) + mulff (axM, b2) + fi.y; end
    if (c_xn[7]) begin fo.x <= mulff (tbx, b0) - tax; end
    if (c_xn[8]) begin fo.y <= mulff (tby, b0) - tay; end
    if (c_xn[9]) begin process_ret <= 1; end
  end

  /* verilator lint_off WIDTHCONCAT */
  localparam int SEQ_PARAMS[11*4] = '{ 0,0,0,0, 11,0,0,0, 0,0,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,1,0, 21,1,1,0, 14,1,0,0, 15,9,0,0};
  sequencer #(11,SEQ_PARAMS) c_seq (clks,rst, c_ln, c_en,c_xn);
  /* verilator lint_on WIDTHCONCAT */
endmodule

module Filters_CxIIRStageO2 #() (input[1:0] clks, input rst,input s_wr, input[31:0] s_addr, input[31:0] s_wrbus,
  input process_ena, input CxFptx fi, output CxFptx fo, input fptx axM, input fptx ayM, input fptx naxM, input fptx nayM, input fptx ax2M, input fptx ay2M, input fptx nax2M, input fptx nay2M, output logic process_ret);

  wire clk=clks[0],clk2=clks[1];
  logic T=1,F=0; logic[7:0] T8=~0,F8=0;
  logic[15:0] c_cnt; always @(posedge clk) c_cnt <= c_cnt+1;
  wire [31:0] s_sub; wire [63:0] s_val; wire [15:0] s_ind; wire[4:0] s_set;
  setter #(5) s_bank (clk,rst,s_wr,s_addr,s_wrbus,s_sub,s_ind,s_set,s_val);

  import CORE_funcs::*;

  fptx b0;
  fptx b1;
  fptx b2;
  fptx a1;
  fptx a2;

  /* verilator lint_off UNOPTFLAT */
  Line c_ln[11];  wire c_en[11];  wire c_xn[11];
  /* verilator lint_on UNOPTFLAT */

  setLine #(1,0,0) f_1 (c_ln[1],"startMethod",process_ena,F); // public int process ( CxFptx fi , CxFptx fo , fptx axM , fptx ayM , fptx naxM , fptx nayM , fptx ax2M , fptx ay2M , fptx nax2M , fptx nay2M ) {
  fptx tax, tay, tbx, tby;                                   // fptx tax , tay , tbx , tby ;
  setLine #(1,0,1) f_3 (c_ln[3],"setVar",T,F);               // tax = naxM * a1 + nax2M * a2 ;
  setLine #(1,0,1) f_4 (c_ln[4],"setVar",T,F);               // tay = nayM * a1 + nay2M * a2 ;
  setLine #(1,0,1) f_5 (c_ln[5],"setVar",T,F);               // tbx = axM * b1 + ax2M * b2 + fi.x ;
  setLine #(1,0,1) f_6 (c_ln[6],"setVar",T,F);               // tby = ayM * b1 + ay2M * b2 + fi.y ;
  setLine #(1,1,1) f_7 (c_ln[7],"setVar",T,F);               // fo.x = tbx * b0 - tax ;
  setLine #(1,1,1) f_8 (c_ln[8],"setVar",T,F);               // fo.y = tby * b0 - tay ;
  setLine #(1,0,0) f_9 (c_ln[9],"return",T,F);               // return 1 ;
  setLine #(9,0,0) f_10 (c_ln[10],"endMethod",T,F);          // }

  always @(posedge clk) begin
    if (rst) fo <= 0;
    if (s_set[0]) b0 <= s_val;
    if (s_set[1]) b1 <= s_val;
    if (s_set[2]) b2 <= s_val;
    if (s_set[3]) a1 <= s_val;
    if (s_set[4]) a2 <= s_val;
    if (c_xn[3]) begin tax <= mulff (naxM, a1) + mulff (nax2M, a2); end
    if (c_xn[4]) begin tay <= mulff (nayM, a1) + mulff (nay2M, a2); end
    if (c_xn[5]) begin tbx <= mulff (axM, b1) + mulff (ax2M, b2) + fi.x; end
    if (c_xn[6]) begin tby <= mulff (ayM, b1) + mulff (ay2M, b2) + fi.y; end
    if (c_xn[7]) begin fo.x <= mulff (tbx, b0) - tax; end
    if (c_xn[8]) begin fo.y <= mulff (tby, b0) - tay; end
    if (c_xn[9]) begin process_ret <= 1; end
  end

  /* verilator lint_off WIDTHCONCAT */
  localparam int SEQ_PARAMS[11*4] = '{ 0,0,0,0, 11,0,0,0, 0,0,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 21,1,1,0, 21,1,1,0, 14,1,0,0, 15,9,0,0};
  sequencer #(11,SEQ_PARAMS) c_seq (clks,rst, c_ln, c_en,c_xn);
  /* verilator lint_on WIDTHCONCAT */
endmodule

module Filters_CxIIR #(ORDER=0,STRIDE=0) (input[1:0] clks, input rst,input s_wr, input[31:0] s_addr, input[31:0] s_wrbus,
  input process_ena, input CxFptx ci, output CxFptx co, output logic process_ret);

  wire clk=clks[0],clk2=clks[1];
  logic T=1,F=0; logic[7:0] T8=~0,F8=0;
  logic[15:0] c_cnt; always @(posedge clk) c_cnt <= c_cnt+1;
  wire [31:0] s_sub; wire [63:0] s_val; wire [15:0] s_ind; wire[19:0] s_set;
  setter #(20) s_bank (clk,rst,s_wr,s_addr,s_wrbus,s_sub,s_ind,s_set,s_val);

  import CORE_funcs::*;

  localparam ORD = ORDER ;
  localparam STR = STRIDE ;
  localparam LEN = STR * 2 ;
  localparam LENM1 = LEN - 1 ;
  uint4 iN;
  uint4 iN_3; delayp #(3,4) dp_iN_3(clk,iN,iN_3);
  uint4 iN_6; delayp #(6,4) dp_iN_6(clk,iN,iN_6);
  uint4 iN_9; delayp #(9,4) dp_iN_9(clk,iN,iN_9);
  uint4 iM;
  uint4 iM_3; delayp #(3,4) dp_iM_3(clk,iM,iM_3);
  uint4 iM_6; delayp #(6,4) dp_iM_6(clk,iM,iM_6);
  uint4 i2M;
  logic s1_process_ena; CxFptx s1_fi; CxFptx s1_fo; fptx s1_axM; fptx s1_ayM; fptx s1_naxM; fptx s1_nayM; logic s1_process_ret; 
  Filters_CxIIRStageO1 #( ) s1 (clks,rst,s_set[4],s_sub,s_val,s1_process_ena,s1_fi,s1_fo,s1_axM,s1_ayM,s1_naxM,s1_nayM,s1_process_ret);
  logic s2_process_ena; CxFptx s2_fi; CxFptx s2_fo; fptx s2_axM; fptx s2_ayM; fptx s2_naxM; fptx s2_nayM; logic s2_process_ret; 
  Filters_CxIIRStageO1 #( ) s2 (clks,rst,s_set[5],s_sub,s_val,s2_process_ena,s2_fi,s2_fo,s2_axM,s2_ayM,s2_naxM,s2_nayM,s2_process_ret);
  logic s3_process_ena; CxFptx s3_fi; CxFptx s3_fo; fptx s3_axM; fptx s3_ayM; fptx s3_naxM; fptx s3_nayM; logic s3_process_ret; 
  Filters_CxIIRStageO1 #( ) s3 (clks,rst,s_set[6],s_sub,s_val,s3_process_ena,s3_fi,s3_fo,s3_axM,s3_ayM,s3_naxM,s3_nayM,s3_process_ret);
  CxFptx c1;
  CxFptx c2;
  fptx ax1[LEN];
  fptx ay1[LEN];
  fptx ax2[LEN];
  fptx ay2[LEN];
  fptx ax3[LEN];
  fptx ay3[LEN];
  fptx ax4[LEN];
  fptx ay4[LEN];

  /* verilator lint_off UNOPTFLAT */
  Line c_ln[18];  wire c_en[18];  wire c_xn[18];
  /* verilator lint_on UNOPTFLAT */

  setLine #(1,0,0) f_1 (c_ln[1],"startMethod",process_ena,F); // public int process ( CxFptx ci , CxFptx co ) {
  setLine #(1,0,1) f_2 (c_ln[2],"setVarI",T,F);              // ax1 [ iN ] = ci.x ;
  setLine #(1,0,1) f_3 (c_ln[3],"setVarI",T,F);              // ay1 [ iN ] = ci.y ;
  setLine #(1,0,3) f_4 (c_ln[4],"CxIIRStageO1_process",T,F); // s1.process ( ci , c1 , ax1 [ iM ] , ay1 [ iM ] , ax2 [ iM ] , ay2 [ iM ] ) ;
  setLine #(1,3,1) f_5 (c_ln[5],"setVarI",T,F);              // ax2 [ iN ] = c1.x ;
  setLine #(1,3,1) f_6 (c_ln[6],"setVarI",T,F);              // ay2 [ iN ] = c1.y ;
  setLine #(1,3,3) f_7 (c_ln[7],"CxIIRStageO1_process",T,F); // s2.process ( c1 , c2 , ax2 [ iM ] , ay2 [ iM ] , ax3 [ iM ] , ay3 [ iM ] ) ;
  setLine #(1,6,1) f_8 (c_ln[8],"setVarI",T,F);              // ax3 [ iN ] = c2.x ;
  setLine #(1,6,1) f_9 (c_ln[9],"setVarI",T,F);              // ay3 [ iN ] = c2.y ;
  setLine #(1,6,3) f_10 (c_ln[10],"CxIIRStageO1_process",T,F); // s3.process ( c2 , co , ax3 [ iM ] , ay3 [ iM ] , ax4 [ iM ] , ay4 [ iM ] ) ;
  setLine #(1,9,1) f_11 (c_ln[11],"setVar",T,F);             // ax4 [ iN ] = co.x ;
  setLine #(1,9,1) f_12 (c_ln[12],"setVar",T,F);             // ay4 [ iN ] = co.y ;
  setLine #(1,0,1) f_13 (c_ln[13],"setVar",T,F);             // iN = ( iN == LENM1 ) ? 0 : iN + 1 ;
  setLine #(1,0,1) f_14 (c_ln[14],"setVar",T,F);             // iM = ( iM == LENM1 ) ? 0 : iM + 1 ;
  setLine #(1,0,1) f_15 (c_ln[15],"setVar",T,F);             // i2M = ( i2M == LENM1 ) ? 0 : i2M + 1 ;
  setLine #(1,0,0) f_16 (c_ln[16],"return",T,F);             // return 1 ;
  setLine #(16,0,0) f_17 (c_ln[17],"endMethod",T,F);         // }

  assign c1 = s1_fo;
  assign c2 = s2_fo;
  assign co = s3_fo;
  always @(posedge clk) begin
    if (rst) iN <= iN+1;
    s1_process_ena <= F; if (rst) s1_fi <= 0; if (rst) s1_axM <= 0; if (rst) s1_ayM <= 0; if (rst) s1_naxM <= 0; if (rst) s1_nayM <= 0; 
    s2_process_ena <= F; if (rst) s2_fi <= 0; if (rst) s2_axM <= 0; if (rst) s2_ayM <= 0; if (rst) s2_naxM <= 0; if (rst) s2_nayM <= 0; 
    s3_process_ena <= F; if (rst) s3_fi <= 0; if (rst) s3_axM <= 0; if (rst) s3_ayM <= 0; if (rst) s3_naxM <= 0; if (rst) s3_nayM <= 0; 
    if (s_set[9]) iN <= s_val;
    if (s_set[10]) iM <= s_val;
    if (s_set[11]) i2M <= s_val;
    if (c_xn[2]) begin ax1[iN] <= ci.x; end
    if (c_xn[3]) begin ay1[iN] <= ci.y; end
    if (c_en[4]) begin s1_process_ena <= T; s1_fi <= ci; s1_axM <= ax1[iM]; s1_ayM <= ay1[iM]; s1_naxM <= ax2[iM]; s1_nayM <= ay2[iM]; end 
    if (c_xn[4]) begin end
    if (c_xn[5]) begin ax2[iN_3] <= c1.x; end
    if (c_xn[6]) begin ay2[iN_3] <= c1.y; end
    if (c_en[7]) begin s2_process_ena <= T; s2_fi <= c1; s2_axM <= ax2[iM_3]; s2_ayM <= ay2[iM_3]; s2_naxM <= ax3[iM_3]; s2_nayM <= ay3[iM_3]; end 
    if (c_xn[7]) begin end
    if (c_xn[8]) begin ax3[iN_6] <= c2.x; end
    if (c_xn[9]) begin ay3[iN_6] <= c2.y; end
    if (c_en[10]) begin s3_process_ena <= T; s3_fi <= c2; s3_axM <= ax3[iM_6]; s3_ayM <= ay3[iM_6]; s3_naxM <= ax4[iM_6]; s3_nayM <= ay4[iM_6]; end 
    if (c_xn[10]) begin end
    if (c_xn[11]) begin ax4[iN_9] <= co.x; end
    if (c_xn[12]) begin ay4[iN_9] <= co.y; end
    if (c_xn[13]) begin iN <= (iN == LENM1) ? 0 : iN + 1; end
    if (c_xn[14]) begin iM <= (iM == LENM1) ? 0 : iM + 1; end
    if (c_xn[15]) begin i2M <= (i2M == LENM1) ? 0 : i2M + 1; end
    if (c_xn[16]) begin process_ret <= 1; end
  end

  /* verilator lint_off WIDTHCONCAT */
  localparam int SEQ_PARAMS[18*4] = '{ 0,0,0,0, 11,0,0,0, 22,1,0,0, 22,1,0,0, 10,1,0,2, 22,1,3,0, 22,1,3,0, 10,1,3,2, 22,1,6,0, 22,1,6,0, 10,1,6,2, 21,1,9,0, 21,1,9,0, 21,1,0,0, 21,1,0,0, 21,1,0,0, 14,1,0,0, 15,16,0,0};
  sequencer #(18,SEQ_PARAMS) c_seq (clks,rst, c_ln, c_en,c_xn);
  /* verilator lint_on WIDTHCONCAT */
endmodule

module Filters_CxPhasePLL #() (input[1:0] clks, input rst,input s_wr, input[31:0] s_addr, input[31:0] s_wrbus,
  input process_ena, input CxFptx fi, output fptx process_ret);

  wire clk=clks[0],clk2=clks[1];
  logic T=1,F=0; logic[7:0] T8=~0,F8=0;
  logic[15:0] c_cnt; always @(posedge clk) c_cnt <= c_cnt+1;
  wire [31:0] s_sub; wire [63:0] s_val; wire [15:0] s_ind; wire[7:0] s_set;
  setter #(8) s_bank (clk,rst,s_wr,s_addr,s_wrbus,s_sub,s_ind,s_set,s_val);

  import CORE_funcs::*;

  localparam BNSHF = 20 ;
  fptx B0;
  fptx B1;
  fptx adl;
  dptx nco;
  dptx uF;

  /* verilator lint_off UNOPTFLAT */
  Line c_ln[10];  wire c_en[10];  wire c_xn[10];
  /* verilator lint_on UNOPTFLAT */

  setLine #(1,0,0) f_1 (c_ln[1],"startMethod",process_ena,F); // public fptx process ( CxFptx fi ) {
  fptx ap, ad;                                               // fptx ap , ad ;
  setLine #(1,0,2) f_3 (c_ln[3],"doTask",T,F);               // ap = atan2cf ( fi.y , fi.x ) ;
  setLine #(1,2,1) f_4 (c_ln[4],"setVar",T,F);               // ad = wrapf ( ap - d2f ( nco ) ) ;
  setLine #(1,2,1) f_5 (c_ln[5],"setVar",T,F);               // nco = frac ( nco + divp2 ( uF , BNSHF ) ) ;
  setLine #(1,3,1) f_6 (c_ln[6],"setVar",T,F);               // uF += f2d ( B0 * ad + B1 * adl ) ;
  setLine #(1,3,1) f_7 (c_ln[7],"setVar",T,F);               // adl = ad ;
  setLine #(1,3,0) f_8 (c_ln[8],"return",T,F);               // return d2f ( nco ) ;
  setLine #(8,0,0) f_9 (c_ln[9],"endMethod",T,F);            // }
  atan2cf_task fn3 (clks,rst,c_en[3],c_xn[3], fi.y,fi.x,ap);

  always @(posedge clk) begin
    if (s_set[1]) B0 <= s_val;
    if (s_set[2]) B1 <= s_val;
    if (s_set[3]) adl <= s_val;
    if (s_set[5]) nco <= lswap(s_val);
    if (s_set[7]) uF <= lswap(s_val);
    if (c_xn[3]) begin /* ap <= atan2cf (fi.y, fi.x); */ end
    if (c_xn[4]) begin ad <= wrapf (ap - d2f (nco)); end
    if (c_xn[5]) begin nco <= frac (nco + divp2 (uF, BNSHF)); end
    if (c_xn[6]) begin uF <= uF + f2d (mulff (B0, ad) + mulff (B1, adl)); end
    if (c_xn[7]) begin adl <= ad; end
    if (c_xn[8]) begin process_ret <= d2f (nco); end
  end

  /* verilator lint_off WIDTHCONCAT */
  localparam int SEQ_PARAMS[10*4] = '{ 0,0,0,0, 11,0,0,0, 0,0,0,0, 10,1,0,1, 21,1,2,0, 21,1,2,0, 21,1,3,0, 21,1,3,0, 14,1,3,0, 15,8,0,0};
  sequencer #(10,SEQ_PARAMS) c_seq (clks,rst, c_ln, c_en,c_xn);
  /* verilator lint_on WIDTHCONCAT */
endmodule

