/**
  Do NOT edit.
  This file is generated by ICEJVCC.
  See AWG.jv for documentation.
*/
#include "Modefs.c"
#include "Modems.c"
#include "Filters.c"

/** Define Signatures */
#define CORE_NAME AWG
#define CORE_AREA nxm_ice_core
#define CORE_FLOW 1
#include "cores/CoreDefs.h"
#define NP 1
#define AW 16
#define BW 32
#define CW 6

enum { AWG_OSEQ = 11 };
enum { AWG_NSEQ = ( 1 << AWG_OSEQ ) };
enum { AWG_OLUT = 10 };
enum { AWG_NLUT = ( 1 << AWG_OLUT ) };
enum { AWG_OFILT = 7 };
enum { AWG_NFILT = ( 1 << AWG_OFILT ) };
enum { AWG_OTAP = 5 };
enum { AWG_RTAP = 32 };
enum { AWG_PTAP = 16 };
enum { AWG_HTAP = 8 };
enum { AWG_FPS = ( AWG_NFILT / 8 - 1 ) };
enum { AWG_MAXCR = 250000000 };
enum { AWG_OMSEQ = 24 };


/** Define CORE Plan Handles */
typedef struct {
  HALO halo;
  int_4 mod;
  int_4 map;
  int_4 scr;
  int_4 ups;
  real_8 gain;
  int_1 isFPGA;
  int_4 nlut;
  real_8 midx;
  real_8 fS;
  real_8 fSym;
  real_8 tOff;
  real_8 fC;
  real_8 fbwf;
  int_4 obpw;
  int_4 lmod;
  int_4 bups;
  int_4 fbd;
  int_1 mute;
  real_8 ps;
  real_8 dps;
  real_8 p;
  real_8 dp;
  real_4 fscl;
  real_4 lfps;
  int_1 bpw;
  int_u1 iper;
  int_u1 nper;
  int_u1 mper;
  int_u1 flgs;
  int_u1 pr;
  int_u1 princ;
  int_u2 mlut;
  real_4* xlut;
  real_4* ylut;
  int_u2 din;
  int_u2 dinc;
  int_2 ntap;
  int_2 nrpt;
  int_2 ntot;
  CxTapBuf* vd;
  RomF2Di* rft;
  int_u2 scrvec;
  int_u2* seq;
  int_u4 iseq;
  int_u4 mseq;
  int_u4 di;
  int_u2 db;
  int_u4 imon;
  int_u4 mmon;
  int_u1 cups;
  int_u1 cper;
  int_u2 ifbd;
  int_u2 mfbd;
} AWG;

#include "cores/CoreProtos.h"

/** CORE Code */

void* AWG_alloc (char *config) {
  AWG* plan = AWG_plan();
  if (plan==NULL) return NULL;
  HW_alloc(plan,config);
  return (void*)plan;
}


int_4 AWG_upload (AWG* plan, void *planp) {
  if (HW_isLocal(planp)) return 0;
  HW_push (planp,HW_PREP);
  HW_loadHdr (planp,39);
  HW_loadDbl  (planp,plan->ps);
  HW_loadDbl  (planp,plan->dps);
  HW_loadDbl  (planp,plan->p);
  HW_loadDbl  (planp,plan->dp);
  HW_loadFlt  (planp,plan->fscl);
  HW_loadFlt  (planp,plan->lfps);
  HW_loadInt  (planp,plan->bpw);
  HW_loadInt  (planp,plan->iper);
  HW_loadInt  (planp,plan->nper);
  HW_loadInt  (planp,plan->mper);
  HW_loadInt  (planp,plan->flgs);
  HW_loadInt  (planp,plan->pr);
  HW_loadInt  (planp,plan->princ);
  HW_loadInt  (planp,plan->mlut);
  HW_loadBuf  (planp,plan->xlut,'f',1);
  HW_loadBuf  (planp,plan->ylut,'f',1);
  HW_loadInt  (planp,plan->din);
  HW_loadInt  (planp,plan->dinc);
  HW_loadInt  (planp,plan->ntap);
  HW_loadInt  (planp,plan->nrpt);
  HW_loadInt  (planp,plan->ntot);
  HW_loadInt  (planp,0);
  HW_loadObj  (planp,RomF2Di_upload(plan->rft,planp));
  HW_loadInt  (planp,plan->scrvec);
  HW_loadBuf  (planp,plan->seq,'s',1);
  HW_loadInt  (planp,plan->iseq);
  HW_loadInt  (planp,plan->mseq);
  HW_loadInt  (planp,plan->di);
  HW_loadInt  (planp,plan->db);
  HW_loadInt  (planp,plan->imon);
  HW_loadInt  (planp,plan->mmon);
  HW_loadInt  (planp,plan->cups);
  HW_loadInt  (planp,plan->cper);
  HW_loadInt  (planp,plan->ifbd);
  HW_loadInt  (planp,plan->mfbd);
  HW_push (planp,HW_OPEN);
  return 39;
}

void AWG_dump (AWG* plan, String* cc) {
  printf ("set=%s fsym=%f dps=%f nper=%d imon=%d mmon=%d cper=%d cups=%d mseq=%d bpw=%d flgs=%d\n", cc, plan->fSym, plan->dps, plan->nper, plan->imon, plan->mmon, plan->cper, plan->cups, plan->mseq, plan->bpw, plan->flgs);
}

int_4 AWG_findMoN (AWG* plan, real_8 dphase) {
  int_4 i;
  real_8 phase, err;
  if (dphase < 0.0001) return 0;
  for (i = 2; i < 0x100000; i ++) {
    phase = dphase * i;
    err = fabs (phase - round (phase));
    if (err < 1.0e-12) return i;
  }
  return 0;
}

void AWG_genFilt (AWG* plan) {
  int_4 i, j, k, nt = plan->nrpt * plan->ntap, nhlf = plan->nrpt / 2;
  real_4 scl = d2f (plan->nrpt * AWG_FPS / plan->fbwf);
  real_8 fw = plan->fbwf;
  if (plan->mod == Modefs_MT_FSK) fw = 2 * plan->midx / plan->nper;
  if (plan->mod == Modefs_MT_4FSK) fw = 4 * plan->midx / plan->nper;
  real_4* ctap = zallocBuf(sizeof(real_4)*(nt * 2));
  Filters_genFirKais (1, fw / plan->nrpt, 0.0, 0.05 / plan->nrpt, 90.0, ctap, nt);
  RomF2Di_clear (plan->rft);
  for (i = j = 0; j < plan->ntap; j ++) for (k = 0; k < plan->nrpt; k ++, i += 2) RomF2Di_set (plan->rft, k, j, ctap[i] * scl);
  if (plan->mod == Modefs_MT_OQPSK) for (i = j = 0; j < plan->ntap; j ++) for (k = 0; k < plan->nrpt; k ++, i += 2) RomF2Di_set (plan->rft, k + nhlf, j + AWG_HTAP, ctap[i] * scl);
}

void AWG_genRotates (AWG* plan) {
  int_4 i, n, ii = 16;
  real_4 p, ax, ay, bx, by;
  int_1 alt = 0;
  int_1 rot = (plan->mod == Modefs_MT_1P4DQPSK);
  plan->princ = (plan->mod == Modefs_MT_1P4DQPSK) ? 2 : (plan->mod == Modefs_MT_1P4QPSK) ? 2 : (plan->mod == Modefs_MT_3P4QPSK) ? 6 : 0;
  if (plan->princ == 0) return;
  for (i = 0; i < ii; i ++) {
    p = rot ? i / 8.0F : alt ? plan->princ / 16.0F : 0;
    bx = coscf (p);
    by = sincf (p);
    for (n = 0; n < plan->nlut; n ++) {
      ax = plan->xlut[n];
      ay = plan->ylut[n];
      plan->xlut[(i<<4)+n] = ax * bx - ay * by;
      plan->ylut[(i<<4)+n] = ax * by + ay * bx;
    }
    alt = ! alt;
  }
  plan->princ = 1;
}

void AWG_setDPS (AWG* plan) {
  real_8 err, odps = plan->dps, freq = plan->dps * plan->fS;
  plan->dps = dptx2d (d2dptx (plan->dps));
  plan->fSym = plan->dps * plan->fS * plan->nper;
  plan->mmon = 0;
  if (plan->fSym != freq) {
    plan->mmon = AWG_findMoN (plan, odps);
    if (plan->mmon > 1) {
      err = frac (plan->dps * plan->mmon);
      if (err > 0.5) {
        plan->dps = dptx2d (d2dptx (plan->dps) + 0x4);
        err = frac (plan->dps * plan->mmon);
        plan->fSym = plan->dps * plan->fS;
      }
      if (err > 1.0e-3 && plan->fSym != freq) printf ("AWG fS=%18.9f fSym=%18.9f fActual=%18.9f MoN=%d perr=%8.6f\n", plan->fS, freq, plan->fSym, plan->mmon, err);
      plan->fSym = odps * plan->fS;
    }
    else {
      printf ("AWG fS=%18.9f fSym=%18.9f fActual=%18.9f\n", plan->fS, freq, plan->fSym);
    }
  }
  plan->mmon = (plan->mmon == 0) ? 0 : plan->mmon - 1;
  plan->flgs=setBit(plan->flgs, 4, (plan->mmon > 0));
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,2);HW_loadDbl(plan,plan->dps); HW_loadAddr(plan,34);HW_loadInt4(plan,plan->mmon); HW_loadAddr(plan,14);HW_loadInt1(plan,plan->flgs);  HW_push(plan,HW_UPD); }
}

void AWG_setRate (AWG* plan, real_8 sr) {
  if (sr > 2 * AWG_MAXCR) {
    printf ("Desired sample rate = %f limited to max supported rate of %d\n", sr, AWG_MAXCR * 2);
    sr = AWG_MAXCR * 2;
  }
  plan->ups = (sr > AWG_MAXCR) ? 2 : 1;
  plan->fS = sr / plan->ups;
}

void AWG_setCUPS (AWG* plan, int_4 c) {
  plan->cups = (c >= 0) ? c : plan->mute ? 0 : plan->bups + 2;
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,35);HW_loadInt1(plan,plan->cups);  HW_push(plan,HW_UPD); }
}

void AWG_setMute (AWG* plan, int_4 m) {
  plan->mute = (m != 0);
  AWG_setCUPS (plan, -1);
}

void AWG_setFcny (AWG* plan, real_8 f) {
  plan->bups = 0;
  plan->dp = f;
  if (plan->ups == 2) {
    if (f <- 0.125) {
      plan->bups = -1;
      plan->dp = (f + 0.25) * plan->ups;
    }
    else if (f < 0.125) {
      plan->bups = 0;
      plan->dp = (f - 0.00) * plan->ups;
    }
    else {
      plan->bups = 1;
      plan->dp = (f - 0.25) * plan->ups;
    }
  }
  if (f <- 0.5 || f > 0.5) plan->bups = 0;
  if (plan->isFPGA) plan->dp = dptx2d (d2dptx (plan->dp));
  plan->cups = plan->mute ? 0 : plan->bups + 2;
  plan->fC = (plan->dp / plan->ups + (plan->bups * 0.25)) * plan->fS * plan->ups;
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,6);HW_loadDbl(plan,plan->dp); HW_loadAddr(plan,35);HW_loadInt1(plan,plan->cups);  HW_push(plan,HW_UPD); }
}

void AWG_setFreq (AWG* plan, real_8 f) {
  AWG_setFcny (plan, f / (plan->fS * plan->ups));
}

void AWG_setGain (AWG* plan, real_8 g) {
  plan->gain = g;
  if (plan->mod >= Modefs_MT_FSK) g -= 3;
  if (plan->mod > Modefs_MT_OQPSK) g -= 3;
  plan->fscl = d2f (pow (2.0, g / 6) * plan->fbwf / (real_8) AWG_FPS);
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,8);HW_loadFlt(plan,plan->fscl);  HW_push(plan,HW_UPD); }
}

void AWG_setSpec (AWG* plan, real_8 v) {
  int_1 sweep = 0;
  int_4 mxseq = (1 << AWG_OMSEQ);
  plan->midx = v;
  if (plan->mod == Modefs_MT_CW && plan->fS > 0) {
    plan->mseq = 0;
    if (plan->midx > 0) {
      sweep = 1;
      plan->mseq = d2i (plan->fS * plan->dps / plan->midx / 0x10000);
      if (plan->mseq < 1) {
        printf ("Unable to perform CW sweep parameters min=%d\n", plan->mseq);
        plan->mseq = 1;
      }
      if (plan->mseq > mxseq) {
        printf ("Unable to perform CW sweep parameters max=%d\n", plan->mseq);
        plan->mseq = mxseq;
      }
    }
    plan->flgs=setBit(plan->flgs, 5, sweep);
    if (plan->mseq > 0) plan->mseq --;
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,14);HW_loadInt1(plan,plan->flgs); HW_loadAddr(plan,30);HW_loadInt4(plan,plan->mseq);  HW_push(plan,HW_UPD); }
    if (! sweep) plan->dinc = 0;
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,21);HW_loadInt2(plan,plan->dinc);  HW_push(plan,HW_UPD); }
  }
}

void AWG_genSeq (AWG* plan, int_4 olut) {
  int_4 i = 0, j, bits, seed = 123456, lrs = ~ seed, mask = (1 << olut) - 1, mxseq = (1 << AWG_OMSEQ);
  plan->mseq = AWG_NSEQ - 3;
  if (plan->mod == Modefs_MT_CW) {
    plan->scr = 0;
    plan->mseq = 1;
    plan->seq[0] = 0x0000;
    AWG_setSpec (plan, plan->midx);
  }
  else {
    for (; i < plan->mseq; i ++) {
      if (plan->scr != Modefs_SCR_LRS) lrs = 0;
      else for (j = 0; j < 8; j ++) {
        lrs = (lrs << 1) | (0x1 ^ getBits(lrs, 0, 0) ^ getBits(lrs, 1, 1) ^ getBits(lrs, 5, 5) ^ getBits(lrs, 25, 25));
      }
      plan->seq[i] = lrs & 0x3FF;
    }
  }
  plan->mseq --;
}

void AWG_genMod (AWG* plan) {
  int_4 olut;
  switch (plan->mod) {
    case Modefs_MT_FSK : plan->nper = (int_4) (plan->midx * 2);
    plan->mper = 2 * plan->nper - 1;
    break;
    case Modefs_MT_4FSK : plan->nper = (int_4) (plan->midx * 4);
    plan->mper = 2 * plan->nper - 1;
    break;
    default : plan->nper = 1;
    plan->mper = 0;
    break;
  }
  olut = Modems_getBitsPerSym (plan->mod);
  plan->nlut = Modems_getSymbolMap (plan->mod, plan->map, 1.0, plan->midx, plan->nper, plan->xlut, plan->ylut);
  plan->mlut = plan->nlut - 1;
  plan->bpw = (plan->mod == Modefs_MT_NONE) ? 32 : (plan->obpw >= 0) ? plan->obpw : olut;
  plan->dinc = 0;
  AWG_genSeq (plan, olut);
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,28);HW_loadBuf(plan,plan->seq,'s',1); HW_loadAddr(plan,30);HW_loadInt4(plan,plan->mseq); HW_loadAddr(plan,12);HW_loadInt1(plan,plan->nper); HW_loadAddr(plan,13);HW_loadInt1(plan,plan->mper); HW_loadAddr(plan,21);HW_loadInt2(plan,plan->dinc);  HW_push(plan,HW_UPD); }
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,18);HW_loadBuf(plan,plan->xlut,'f',1); HW_loadAddr(plan,19);HW_loadBuf(plan,plan->ylut,'f',1); HW_loadAddr(plan,17);HW_loadInt2(plan,plan->mlut); HW_loadAddr(plan,10);HW_loadInt1(plan,plan->bpw);  HW_push(plan,HW_UPD); }
  plan->lmod = plan->mod;
}

void AWG_setFBWF (AWG* plan, real_8 f) {
  plan->fbwf = f;
  if (plan->halo.state == 1) {
    AWG_setGain (plan, plan->gain);
    AWG_genFilt (plan);
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,26);HW_loadObj(plan,RomF2Di_upload(plan->rft,plan));  HW_push(plan,HW_UPD); }
  }
}

void AWG_setFsym (AWG* plan, real_8 f) {
  plan->fSym = f;
  plan->dps = plan->nper * plan->fSym / plan->fS;
  AWG_setDPS (plan);
  if (plan->halo.state == 1) {
    AWG_genFilt (plan);
  if (HW_needsPut(plan)) { HW_push(plan,HW_PREP);  HW_loadAddr(plan,26);HW_loadObj(plan,RomF2Di_upload(plan->rft,plan));  HW_push(plan,HW_UPD); }
  }
  plan->mfbd = d2i (plan->fS / (1.5 * plan->fSym)) - 1;
}

int_4 AWG_init (AWG* plan) {
  plan->mod = Modefs_MT_NONE;
  plan->midx = 1.0;
  plan->fbwf = 1.0;
  plan->fS = -1.0;
  plan->dp = 0;
  plan->dps = 0.25;
  plan->tOff = 0;
  plan->gain = -3;
  plan->ntap = -1;
  plan->obpw = -1;
  plan->iseq = 0;
  plan->scr = -1;
  plan->map = -1;
  plan->nper = 1;
  plan->mper = 0;
  plan->ups = 1;
  plan->bups = 0;
  plan->fbd = -1;
  plan->mfbd = 0;
  plan->flgs = 0;
  plan->isFPGA = (plan->halo.impl >= CORE_TYPE_FPGA);
  return 0;
}

int_4 AWG_set (AWG* plan, String* key, Value* value) {
  int_4 lmod = plan->mod;
  real_8 lmidx = plan->midx, lfSym = plan->fSym;
  if (isMatch (key, "S:SHAPE")) plan->mod = Value_toItem (value, Modefs_modList);
  else if (isMatch (key, "D:MIDX")) AWG_setSpec (plan, Value_toD (value));
  else if (isMatch (key, "D:SPEC")) AWG_setSpec (plan, Value_toD (value));
  else if (isMatch (key, "S:MOD")) plan->mod = Value_toItem (value, Modefs_modList);
  else if (isMatch (key, "L:MOD")) plan->mod = Value_toL (value);
  else if (isMatch (key, "S:MAP")) plan->map = Value_toItem (value, Modefs_mapList);
  else if (isMatch (key, "S:SCR")) plan->scr = Value_toItem (value, Modefs_scrList);
  else if (isMatch (key, "D:FS")) AWG_setRate (plan, Value_toD (value));
  else if (isMatch (key, "D:FREQ")) AWG_setFreq (plan, Value_toD (value));
  else if (isMatch (key, "D:COFF")) AWG_setFreq (plan, Value_toD (value));
  else if (isMatch (key, "D:FCNY")) AWG_setFcny (plan, Value_toD (value));
  else if (isMatch (key, "D:FSYM")) AWG_setFsym (plan, Value_toD (value));
  else if (isMatch (key, "D:BAUD")) AWG_setFsym (plan, Value_toD (value));
  else if (isMatch (key, "D:FBWF")) AWG_setFBWF (plan, Value_toD (value));
  else if (isMatch (key, "D:TOFF")) plan->tOff = Value_toD (value);
  else if (isMatch (key, "L:NTAP")) plan->ntap = Value_toL (value);
  else if (isMatch (key, "L:BPW")) plan->obpw = Value_toL (value);
  else if (isMatch (key, "L:FBD")) plan->fbd = Value_toL (value);
  else if (isMatch (key, "D:GAIN")) AWG_setGain (plan, Value_toD (value));
  else if (isMatch (key, "L:GAIN")) AWG_setGain (plan, Value_toD (value));
  else if (isMatch (key, "L:CUPS")) AWG_setCUPS (plan, Value_toL (value));
  else if (isMatch (key, "L:MUTE")) AWG_setMute (plan, Value_toL (value));
  else return Core_set (plan, key, value);
  if (plan->halo.state == 0) return 0;
  if ((plan->mod >= Modefs_MT_FSK && plan->mod <= Modefs_MT_4FSK) && (plan->midx != lmidx || plan->fSym != lfSym)) lmod = 0;
  if (plan->mod != lmod) AWG_genMod (plan);
  return 0;
}

int_4 AWG_get (AWG* plan, String* key, Value* value) {
  if (isMatch (key, "D:FS")) Value_fromD (value, plan->fS * plan->ups);
  else if (isMatch (key, "D:XDO")) Value_fromD (value, 1.0 / (plan->fS * plan->ups));
  else if (isMatch (key, "D:FSYM")) Value_fromD (value, plan->fSym);
  else if (isMatch (key, "D:FREQ")) Value_fromD (value, plan->fC);
  else if (isMatch (key, "L:CUPS")) Value_fromL (value, plan->cups);
  else if (isMatch (key, "L:MOD")) Value_fromL (value, plan->mod);
  else if (isMatch (key, "L:FBD")) Value_fromL (value, (plan->mfbd + 1) * plan->ups);
  else if (isMatch (key, "S:MODLIST")) Value_fromS (value, Modefs_modList);
  else if (isMatch (key, "S:MAPLIST")) Value_fromS (value, Modefs_mapList);
  else if (isMatch (key, "S:SCRLIST")) Value_fromS (value, Modefs_scrList);
  else return Core_get (plan, key, value);
  return 0;
}

int_4 AWG_open (AWG* plan) {
  int_4 mtap;
  if (plan->scr < 0) plan->scr = Modefs_SCR_NONE;
  if (plan->map < 0) plan->map = Modefs_MAP_BRGC;
  plan->seq = zallocBuf(sizeof(int_u2)*(AWG_NSEQ));
  plan->xlut = zallocBuf(sizeof(real_4)*(AWG_NLUT));
  plan->ylut = zallocBuf(sizeof(real_4)*(AWG_NLUT));
  AWG_genMod (plan);
  AWG_setFsym (plan, plan->fSym);
  AWG_setGain (plan, plan->gain);
  mtap = plan->isFPGA ? AWG_PTAP : AWG_RTAP;
  if (plan->ntap <= 0) plan->ntap = (plan->mod <= 0) ? mtap : (plan->mod == Modefs_MT_FSK || plan->mod == Modefs_MT_4FSK) ? 21 : 7;
  if (plan->ntap >= AWG_HTAP && plan->mod == Modefs_MT_OQPSK) {
    printf ("Warn ntap=%d limited to ntap=%d for OQPSK\n", plan->ntap, AWG_HTAP - 1);
    plan->ntap = AWG_HTAP - 1;
  }
  if (plan->ntap > AWG_RTAP) {
    printf ("Warn ntap=%d limited to ntap=%d for this compile\n", plan->ntap, AWG_RTAP);
    plan->ntap = AWG_RTAP;
  }
  plan->cper = (plan->ntap + AWG_PTAP - 1) / AWG_PTAP;
  mtap = plan->isFPGA ? AWG_PTAP * imax (1, d2i (AWG_MAXCR / plan->fS)) : AWG_RTAP;
  if (plan->ntap > mtap) {
    printf ("Number taps=%d at fS=%f too large max=%d for FPGA load PTAP=%d RTAP=%d\n", plan->ntap, plan->fS, mtap, AWG_PTAP, AWG_RTAP);
    plan->ntap = mtap;
    plan->cper = plan->ntap / AWG_PTAP;
  }
  plan->nrpt = AWG_NFILT;
  plan->ntot = plan->ntap;
  plan->vd = CxTapBuf_new (AWG_OTAP, 1, AWG_PTAP, 0);
  CxTapBuf_setLength (plan->vd, plan->ntap);
  plan->rft = RomF2Di_new (AWG_OFILT, AWG_OTAP, AWG_PTAP);
  AWG_genFilt (plan);
  plan->pr = 0;
  plan->ps = 0;
  plan->p = 0;
  plan->di = 0;
  plan->lfps = 1;
  plan->iper = 0;
  plan->ifbd = 0;
  plan->imon = 1;
  plan->scrvec = 0;
  plan->flgs = 0;
  plan->flgs=setBit(plan->flgs, 0, (plan->bpw == 0));
  plan->flgs=setBit(plan->flgs, 1, (plan->bpw == 32));
  plan->flgs=setBit(plan->flgs, 2, (plan->mod == Modefs_MT_CW));
  plan->flgs=setBit(plan->flgs, 3, (plan->mod == Modefs_MT_OQPSK));
  plan->flgs=setBit(plan->flgs, 4, (plan->mmon > 0));
  plan->flgs=setBit(plan->flgs, 5, (plan->mod == Modefs_MT_CW && plan->midx > 0));
  if (plan->fbd > 0) plan->mfbd = (plan->fbd / plan->ups) - 1;
  AWG_genRotates (plan);
  AWG_setCUPS (plan, -1);
  if(plan->halo.vbpr&1)printf ("AWG mod=%d fSym=%f fS=%f fbwf=%f mmon=%d ntap=%d bpw=%d cper=%d\n", plan->mod, plan->fSym, plan->fS, plan->fbwf, plan->mmon, plan->ntap, plan->bpw, plan->cper);
  AWG_upload (plan,plan);
  return 0;
}

int_4 AWG_process (AWG* plan, Stream* si, Stream* so) {
  int_1 gen, byp, cw, oqp, mon, load, sos, zseq, zbinc, zfbd;
  CxReal_4 cm_,*cm=&cm_, cb_,*cb=&cb_, sc_,*sc=&sc_, fo_,*fo=&fo_, cn_,*cn=&cn_, cmr_,*cmr=&cmr_, cmrs_,*cmrs=&cmrs_;
  real_4 fps, fp;
  int_u2 dix;
  int_u1 lper;
  int_u1 diy;
  int_u1 ia;
  gen = getBit(plan->flgs, 0);
  byp = getBit(plan->flgs, 1);
  cw = getBit(plan->flgs, 2);
  oqp = getBit(plan->flgs, 3);
  mon = getBit(plan->flgs, 4);
  zbinc = getBit(plan->flgs, 5);
  Stream_setC (so, plan->cups);
  while ((gen || si->rok) && so->wok) {
    fps = fracf (d2f (plan->ps));
    plan->ps = (mon && (plan->imon == 0)) ? 0 : frac (plan->ps + plan->dps);
    plan->imon = (plan->imon >= plan->mmon) ? 0 : plan->imon + 1;
    load = (fps < plan->lfps);
    plan->lfps = fps;
    if (load) {
      sos = (plan->iper == 0) || (plan->iper == plan->nper);
      lper = plan->iper;
      plan->iper = (plan->iper == plan->mper) ? 0 : plan->iper + 1;
      if (sos) {
        plan->scrvec = plan->seq[plan->iseq&0x7FF];
        plan->iseq = (plan->iseq >= plan->mseq) ? 0 : plan->iseq + 1;
        zseq = (plan->iseq == 0);
        if (gen | cw) {
          plan->di = plan->din & 0x3FF;
        }
        else {
          plan->di = Stream_rdBits (si, plan->bpw);
        }
        plan->din = plan->din + (plan->dinc >> 6);
        if (zbinc && zseq) {
          plan->dinc = plan->dinc + 1;
        }
      }
      dix = (plan->di ^ plan->scrvec) & plan->mlut;
      plan->db = dix | (lper << 4) | (plan->pr << 4);
      plan->pr = (plan->pr + plan->princ) & 0xF;
      cm->x = plan->xlut[plan->db];
      cm->y = plan->ylut[plan->db];
      cb->x = CI2Fx (plan->di);
      cb->y = CI2Fy (plan->di);
      CxTapBuf_load (plan->vd, byp ? cb : cm);
    }
    fo->x = 0;
    fo->y = 0;
    for (ia = 0; ia < plan->ntot; ia ++) {
      CxReal_4 ft_,*ft=&ft_, ftd_,*ftd=&ftd_, fdi_,*fdi=&fdi_, fdj_,*fdj=&fdj_;
      RomF2Di_getrNc (plan->rft, plan->lfps, ia, oqp, ft);
      ftd = ft;
      CxTapBuf_get (plan->vd, ia, fdi);
      fdj = fdi;
      fo->x += ftd->x * fdj->x;
      fo->y += ftd->y * fdj->y;
    }
    cn = fo;
    fp = d2f (plan->p + plan->dp);
    plan->p = frac (plan->p + plan->dp);
    sincoscf (fp, sc);
    mulcc (cn, sc, cmr);
    zfbd = (plan->ifbd == plan->mfbd);
    plan->ifbd = (plan->ifbd == plan->mfbd) ? 0 : plan->ifbd + 1;
    mulcf (cmr, plan->fscl, cmrs);
    Stream_wrCFI (so, cmrs);
  }
  return 0;
}

int_4 AWG_close (AWG* plan) {
  HW_push(plan,HW_CLOSE);
  return 0;
}

int_4 AWG_poll (AWG* plan) { return 0; }

int_4 AWG_free (AWG* plan) {
  HW_free(plan);
  free(plan);
}

#include "cores/CoreHandles.h"

AWG* AWG_subCore (HALO* halo, int_4 scid) {
  AWG* plan = AWG_plan();
  if (plan==NULL) return NULL;
  Core_copyHaloToSub(halo,&plan->halo,scid);
  AWG_init(plan);
  return plan;
}
#undef CORE_NAME
#undef CORE_AREA
#undef CORE_FLOW
#undef AW
#undef BW
#undef CW
#undef NP
