/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  Interface to the Xilinx viterbi core
  Soft decisions are created by lookup table in IQSDF

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003
*/
module Viterbi (clk,reset, load,bi, pflg,vflg, bo);
  input clk,reset;
  input load;
  input [7:0] bi;
  input [3:0] pflg;
  input [7:0] vflg;
  output [3:0] bo;

  wire s3  = vflg[0];
  wire s4  = vflg[1];
  wire tcm = vflg[2];

  wire p0 = pflg[3]&pflg[0];	// erasure bit
  wire p1 = pflg[3]&pflg[1];

  wire [7:0] sd0 = s3? {bi[2:0],1'b0} : s4? bi[3:0] : {4{bi[0]}};
  wire [7:0] sd1 = s3? {bi[5:3],1'b0} : s4? bi[7:4] : {4{bi[1]}};
  wire [7:0] pad = 0;

`ifdef verilator
  wire gox = load;
  wire goerr = 0;
  wire gobit = sd0[3];
  reg [31:0] ccc;                                                                                                      
  always @(posedge clk) begin                                                                                          
    if (reset) ccc <= 0; else if (load) ccc <= ccc+1;                                                                    
    if (load && ccc<32) $write("Load viterbi core bi=%x pflg=%x tcm=%x s3=%d s4=%d bo=%x\n",bi,pflg,tcm,s3,s4,bo);          
  end                                                                                                                  
`elsif CORE_VIT
  // fill in AXI input bus based on puncture pattern, p0 = bit0 punctured, p1 = bit1 punctured
  wire [15:0] s_axis_data_tdata = p0? {sd0,pad} : p1? {pad,sd0} : {sd1,sd0};
  wire [7:0] s_axis_data_tuser = {p1,p0};
  wire s_axis_data_tvalid = load;
  wire s_axis_data_tready;
  wire [7:0] m_axis_data_tdata;
  wire [23:0] m_axis_data_tuser;
  wire m_axis_data_tvalid;
  viterbi_v27 v27 (clk, !reset, s_axis_data_tdata, s_axis_data_tuser, s_axis_data_tvalid, s_axis_data_tready, 
				m_axis_data_tdata, m_axis_data_tuser, m_axis_data_tvalid);
  wire gox = m_axis_data_tvalid;
  wire goerr = m_axis_data_tuser[8];
  wire gobit = m_axis_data_tdata;
`else
  wire gox = load;
  wire goerr = 0;
  wire gobit = sd0[3];
`endif

  wire qstat;
  wire [1:0] qdata;
  wire goval = load&qstat;
  queMxN #(6,2) oque (clk,reset, gox,goval, {goerr,gobit}, qdata, qstat);
  assign bo = {qdata[1],goval,1'b0,qdata[0]};

endmodule
