/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  Test port handler

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003

  The MPCIO bus consists of 1 to 4 two wire interfaces often I2C
  The MPCIO byte[5:4] are the interface index and byte[1:0] are the values and byte[3:2] the driver enables

*/
`ifdef PIC
`define TP_HAS_J4
`define TP_HAS_STATUS
`endif
`include "mdefs.h"

module testport (
  clk,rst, rd,wr,cs,addr,data,dataout,
  tp,tpi,
`ifdef TP_HAS_TPO
  tpo,
`endif
  oppms,sig,
`ifdef TP_HAS_J4
  pj4, 
`endif
`ifdef TP_TRACE
  trace,
`endif
`ifdef TP_MPIO
  mpcio,
`endif
  tp0,tp1,tp2,tp3,tp4,tp5,tp6,tp7);

  parameter TP_OE=0;
  parameter TP_SEL=0;
  parameter FILE="none";

  input clk,rst,cs,rd,wr;
  input [7:0] addr,data;
  output [7:0] dataout;
  inout [7:0] tp;
  output [8:0] tpi;
  input oppms;
  input [3:0] sig;
`ifdef TP_HAS_J4
  input pj4;
`else
  wire pj4=0;
`endif
`ifdef TP_HAS_TPO
  output [7:0] tpo;
`else
  wire [7:0] tpo;
`endif
`ifdef TP_TRACE
  input [32:0] trace;
`endif
`ifdef TP_MPIO
  inout [`TP_MPIO-1:0] mpcio;
`else
  wire [7:0] mpcio;
`endif
  input [7:0] tp0,tp1,tp2,tp3,tp4,tp5,tp6,tp7;

  wire L=0,H=1;
  genvar i;

`ifdef PIC6
  wire pod = sig[0];
`else
  wire pod = L;
`endif

  reg tpoe,tpts;
  reg [3:0] tpsel;
  reg [7:0] status,mpreg;
  wire [7:0] datao,datat;
  wire [1:0] ad = addr[1:0];
  wire wtps = cs&(ad==0)&wr;
  wire wtpd = cs&(ad==1)&wr;
  wire rtps = cs&(ad==1)&rd;
  wire wtpm = cs&(ad==3)&wr;
  wire rstn; delaypipe #(15) dl1 (clk,!rst,rstn);
  wire rstd = !rstn;
  //always @(posedge clk or posedge rstd) begin
  always @(posedge clk) begin
    if (rstd) tpoe  <= TP_OE;  else if (wtps) tpoe  <= data[4];
    if (rstd) tpsel <= TP_SEL; else if (wtps) tpsel <= data[3:0];
    if (rstd) tpts  <= !TP_OE && !pod;  else if (wtps) tpts  <= !data[4] && !pod;
  end

  // generate the test status array for PICs
`ifdef TP_HAS_STATUS 
  reg [9:0] scount;
  wire silon = !tpsel[3];
  always @(posedge clk) if (oppms) scount <= scount+1;
  generate
  for (i=0; i<8; i=i+1) begin:blk
    always @(posedge clk) if (wtpd) status[i] <= data[i]; else if (silon) status[i] <= (scount[9:6]==i || scount[9:6]==(15-i));
  end
  endgenerate
`endif

`ifdef TP_MPIO
  wire [15:0] mpdef = pj4? 16'h00C0 : 16'h0000;
`ifdef TP_OLD
  always @(posedge clk or posedge rstd) begin
    if (rstd) mpreg <= mpdef;  else if (wtpm) mpreg <= data;
  end
  assign mpcio = { mpreg[7]?mpreg[3]:1'bZ, mpreg[6]?mpreg[2]:1'bZ, mpreg[5]?mpreg[1]:1'bZ, mpreg[4]?mpreg[0]:1'bZ };
`else
  generate
  for (i=0; i<`TP_MPIO; i=i+2) begin:mpr
    reg [3:0] mpreg; 
    always @(posedge clk or posedge rstd) begin
      if (rstd) mpreg <= mpdef[i*2+3:i*2];  else if (wtpm && data[6:4]==i) mpreg <= data[3:0];
    end
    assign mpcio[i+1:i] = {mpreg[3]?mpreg[1]:1'bZ,mpreg[2]?mpreg[0]:1'bZ};
  end
  endgenerate
`endif
`else
  assign mpcio = { H,H,H,H, sig };
`endif

  // mux test sources
`ifdef TP_ONE
  assign tpo = tp0;
`elsif TP_NONE
  assign tpo = 0;
`else
  mux8xN #(8) tpm (tpo, tp0,tp1,tp2,tp3,tp4,tp5,tp6,tp7, tpsel[2:0]);
`endif

`ifdef TESTMUXC
  reg [7:0] tpc;
  generate
  for (i=0; i<8; i=i+1) begin:bit
    always @(posedge tpo[i] or posedge rtps) if (rtps) tpc[i] <= 0; else tpc[i] <= 1;
  end
  endgenerate
`else
  wire [7:0] tpc = 0;
`endif

  // assign the signature
  wire [31:0] idat = {mpcio,status,tpc,tpo};
`ifdef AGILEX
  ramNxM_agx #(32,8,256,FILE) ram (clk,H,H,8'h02,idat,H,addr[6:0],datao);
`else      	
  RAMB16_S9_S36 ram (.CLKA(clk),.ENA(H),.WEA(L),.SSRA(L),.ADDRA(addr[6:0]),.DIA(8'b0),.DIPA(1'b0),.DOA(datao),
                     .CLKB(clk),.ENB(H),.WEB(H),.SSRB(L),.ADDRB(8'h02),  .DIB(idat),.DIPB(4'b0));
 `ifdef HDSG
  defparam ram.INIT_00 = {64'h0,`HDSG,64'h0,`HSV};
 `elsif HSV
  defparam ram.INIT_00 = `HSV;
 `endif
`endif

`ifdef AGILEX
  assign tp = tpo;
`else
  iobuftN #(8) tpb (tp,tpts,tpi[7:0],tpoe?tpo:status);
`endif
  assign tpi[8] = tpoe;

`ifdef TP_TRACE
  localparam TORDER=(`TP_TRACE>10)? `TP_TRACE : 12;
  wire csdbg = cs && addr[5];
  tracedbg #(32,TORDER,8) dbg (clk,csdbg, wr,data, rd,datat, trace[32],trace[31:0]);
  assign dataout = csdbg? datat:datao;
`else
  assign dataout = datao;
`endif

endmodule

module serial_test_port (clk,tout,test);
  input clk;
  output tout;
  input [7:0] test;

  reg [7:0] cyc;
  always @(posedge clk) cyc <= cyc+1;
  muxMxN #(32,1) tmux (tout, {20'h00002,test,4'h5}, cyc[7:3]);

endmodule

