/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  JTAG port controller 
  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003

  startbit
  8 bits slave address + R/W
  8 bits register address
  8 bits register data
  stopbit

*/

module i2c (clk, cs,cwr,caddr,cdata, scl,sda);

  input clk,cs,cwr;
  input [7:0] caddr,cdata;
  output scl,sda;

  wire L=0, H=1;

  reg [31:0] sdata;
  wire cwr0 = cs&&cwr&&(caddr[2:0]==0);
  wire cwr1 = cs&&cwr&&(caddr[2:0]==1);
  wire cwr2 = cs&&cwr&&(caddr[2:0]==2);
  wire cwr3 = cs&&cwr&&(caddr[2:0]==3);
  reg [7:0] cnt;
  reg [7:0] dec;
  reg next,cycle,shift,clock;
  wire [1:0] phase = cnt[1:0];
  wire [4:0] baud  = cnt[6:2];
  wire startbit = (baud==0);
  wire stopbit = (baud==25);
  always @(posedge clk) begin
    if (cwr0) sdata[ 7: 0] <= cdata; else if (shift) sdata[ 7: 0] <= {sdata[6:0],L};
    if (cwr1) sdata[15: 8] <= cdata; else if (shift) sdata[15: 8] <=  sdata[14: 7];
    if (cwr2) sdata[23:16] <= cdata; else if (shift) sdata[23:16] <=  sdata[22:15];
    if (cwr3) sdata[31:24] <= cdata; else if (shift) sdata[31:24] <=  sdata[30:23];
    next <= (dec==125);	// 4 quadrants per baud clk=50MHz/(4*125) = 100kHz
    if (!cycle || next) dec <= 0; else dec <= dec+1;
    if (!cycle) cnt <= 0; else if (next) cnt <= cnt+1;
    cycle <= cwr3 || (cycle && !(stopbit && next && phase==3));
    shift <= cycle && next && (phase==3);
    if (!cycle) clock <= H; else if (next) clock <= !phase[1] || stopbit;
  end
  assign scl = clock;
  assign sda = cycle? sdata[24] : H;

endmodule

