module crc32_d32 (clk, init,init2, add,add2, data,crc);

  input clk,init,init2,add,add2;
  input [31:0] data;
  output reg [31:0] crc;
  // polynomial 0xEDB88320 first serial bit is data[0]
  // data width: 32
  wire [31:0] d = data;
  wire [31:0] c = crc;
  wire [31:0] e,f,g;
  wire C0=0,C1=1;
  
  // full 4 bytes
  assign e[31] = d[0]^d[1]^d[2]^d[3]^d[5]^d[6]^d[7]^d[15]^d[19]^d[21]^d[22]^d[25]^d[31] ^ c[31]^c[25]^c[22]^c[21]^c[19]^c[15]^c[7]^c[6]^c[5]^c[3]^c[2]^c[1]^c[0];
  assign e[30] = d[3]^d[4]^d[7]^d[14]^d[15]^d[18]^d[19]^d[20]^d[22]^d[24]^d[25]^d[30]^d[31] ^ c[31]^c[30]^c[25]^c[24]^c[22]^c[20]^c[19]^c[18]^c[15]^c[14]^c[7]^c[4]^c[3];
  assign e[29] = d[0]^d[1]^d[5]^d[7]^d[13]^d[14]^d[15]^d[17]^d[18]^d[22]^d[23]^d[24]^d[25]^d[29]^d[30]^d[31] ^ c[31]^c[30]^c[29]^c[25]^c[24]^c[23]^c[22]^c[18]^c[17]^c[15]^c[14]^c[13]^c[7]^c[5]^c[1]^c[0];
  assign e[28] = d[0]^d[4]^d[6]^d[12]^d[13]^d[14]^d[16]^d[17]^d[21]^d[22]^d[23]^d[24]^d[28]^d[29]^d[30] ^ c[30]^c[29]^c[28]^c[24]^c[23]^c[22]^c[21]^c[17]^c[16]^c[14]^c[13]^c[12]^c[6]^c[4]^c[0];
  assign e[27] = d[0]^d[1]^d[2]^d[6]^d[7]^d[11]^d[12]^d[13]^d[16]^d[19]^d[20]^d[23]^d[25]^d[27]^d[28]^d[29]^d[31] ^ c[31]^c[29]^c[28]^c[27]^c[25]^c[23]^c[20]^c[19]^c[16]^c[13]^c[12]^c[11]^c[7]^c[6]^c[2]^c[1]^c[0];
  assign e[26] = d[2]^d[3]^d[7]^d[10]^d[11]^d[12]^d[18]^d[21]^d[24]^d[25]^d[26]^d[27]^d[28]^d[30]^d[31] ^ c[31]^c[30]^c[28]^c[27]^c[26]^c[25]^c[24]^c[21]^c[18]^c[12]^c[11]^c[10]^c[7]^c[3]^c[2];
  assign e[25] = d[1]^d[2]^d[6]^d[9]^d[10]^d[11]^d[17]^d[20]^d[23]^d[24]^d[25]^d[26]^d[27]^d[29]^d[30] ^ c[30]^c[29]^c[27]^c[26]^c[25]^c[24]^c[23]^c[20]^c[17]^c[11]^c[10]^c[9]^c[6]^c[2]^c[1];
  assign e[24] = d[2]^d[3]^d[6]^d[7]^d[8]^d[9]^d[10]^d[15]^d[16]^d[21]^d[23]^d[24]^d[26]^d[28]^d[29]^d[31] ^ c[31]^c[29]^c[28]^c[26]^c[24]^c[23]^c[21]^c[16]^c[15]^c[10]^c[9]^c[8]^c[7]^c[6]^c[3]^c[2];
  assign e[23] = d[0]^d[3]^d[8]^d[9]^d[14]^d[19]^d[20]^d[21]^d[23]^d[27]^d[28]^d[30]^d[31]^c[31]^c[30]^c[28]^c[27] ^ c[23]^c[21]^c[20]^c[19]^c[14]^c[9]^c[8]^c[3]^c[0];
  assign e[22] = d[2]^d[7]^d[8]^d[13]^d[18]^d[19]^d[20]^d[22]^d[26]^d[27]^d[29]^d[30] ^ c[30]^c[29]^c[27]^c[26]^c[22]^c[20]^c[19]^c[18]^c[13]^c[8]^c[7]^c[2];
  assign e[21] = d[0]^d[2]^d[3]^d[5]^d[12]^d[15]^d[17]^d[18]^d[22]^d[26]^d[28]^d[29]^d[31] ^ c[31]^c[29]^c[28]^c[26]^c[22]^c[18]^c[17]^c[15]^c[12]^c[5]^c[3]^c[2]^c[0];
  assign e[20] = d[0]^d[3]^d[4]^d[5]^d[6]^d[7]^d[11]^d[14]^d[15]^d[16]^d[17]^d[19]^d[22]^d[27]^d[28]^d[30]^d[31] ^ c[31]^c[30]^c[28]^c[27]^c[22]^c[19]^c[17]^c[16]^c[15]^c[14]^c[11]^c[7]^c[6]^c[5]^c[4]^c[3]^c[0];
  assign e[19] = d[0]^d[1]^d[4]^d[7]^d[10]^d[13]^d[14]^d[16]^d[18]^d[19]^d[22]^d[25]^d[26]^d[27]^d[29]^d[30]^d[31] ^ c[31]^c[30]^c[29]^c[27]^c[26]^c[25]^c[22]^c[19]^c[18]^c[16]^c[14]^c[13]^c[10]^c[7]^c[4]^c[1]^c[0];
  assign e[18] = d[0]^d[3]^d[6]^d[9]^d[12]^d[13]^d[15]^d[17]^d[18]^d[21]^d[24]^d[25]^d[26]^d[28]^d[29]^d[30] ^ c[30]^c[29]^c[28]^c[26]^c[25]^c[24]^c[21]^c[18]^c[17]^c[15]^c[13]^c[12]^c[9]^c[6]^c[3]^c[0];
  assign e[17] = d[2]^d[5]^d[8]^d[11]^d[12]^d[14]^d[16]^d[17]^d[20]^d[23]^d[24]^d[25]^d[27]^d[28]^d[29] ^ c[29]^c[28]^c[27]^c[25]^c[24]^c[23]^c[20]^c[17]^c[16]^c[14]^c[12]^c[11]^c[8]^c[5]^c[2];
  assign e[16] = d[1]^d[4]^d[7]^d[10]^d[11]^d[13]^d[15]^d[16]^d[19]^d[22]^d[23]^d[24]^d[26]^d[27]^d[28] ^ c[28]^c[27]^c[26]^c[24]^c[23]^c[22]^c[19]^c[16]^c[15]^c[13]^c[11]^c[10]^c[7]^c[4]^c[1];
  assign e[15] = d[1]^d[2]^d[5]^d[7]^d[9]^d[10]^d[12]^d[14]^d[18]^d[19]^d[23]^d[26]^d[27]^d[31] ^ c[31]^c[27]^c[26]^c[23]^c[19]^c[18]^c[14]^c[12]^c[10]^c[9]^c[7]^c[5]^c[2]^c[1];
  assign e[14] = d[0]^d[1]^d[4]^d[6]^d[8]^d[9]^d[11]^d[13]^d[17]^d[18]^d[22]^d[25]^d[26]^d[30] ^ c[30]^c[26]^c[25]^c[22]^c[18]^c[17]^c[13]^c[11]^c[9]^c[8]^c[6]^c[4]^c[1]^c[0];
  assign e[13] = d[0]^d[3]^d[5]^d[7]^d[8]^d[10]^d[12]^d[16]^d[17]^d[21]^d[24]^d[25]^d[29] ^ c[29]^c[25]^c[24]^c[21]^c[17]^c[16]^c[12]^c[10]^c[8]^c[7]^c[5]^c[3]^c[0];
  assign e[12] = d[2]^d[4]^d[6]^d[7]^d[9]^d[11]^d[15]^d[16]^d[20]^d[23]^d[24]^d[28] ^ c[28]^c[24]^c[23]^c[20]^c[16]^c[15]^c[11]^c[9]^c[7]^c[6]^c[4]^c[2];
  assign e[11] = d[1]^d[3]^d[5]^d[6]^d[8]^d[10]^d[14]^d[15]^d[19]^d[22]^d[23]^d[27] ^ c[27]^c[23]^c[22]^c[19]^c[15]^c[14]^c[10]^c[8]^c[6]^c[5]^c[3]^c[1];
  assign e[10] = d[0]^d[2]^d[4]^d[5]^d[7]^d[9]^d[13]^d[14]^d[18]^d[21]^d[22]^d[26] ^ c[26]^c[22]^c[21]^c[18]^c[14]^c[13]^c[9]^c[7]^c[5]^c[4]^c[2]^c[0];
  assign e[9] = d[0]^d[2]^d[4]^d[5]^d[7]^d[8]^d[12]^d[13]^d[15]^d[17]^d[19]^d[20]^d[22]^d[31] ^ c[31]^c[22]^c[20]^c[19]^c[17]^c[15]^c[13]^c[12]^c[8]^c[7]^c[5]^c[4]^c[2]^c[0];
  assign e[8] = d[0]^d[2]^d[4]^d[5]^d[11]^d[12]^d[14]^d[15]^d[16]^d[18]^d[22]^d[25]^d[30]^d[31] ^ c[31]^c[30]^c[25]^c[22]^c[18]^c[16]^c[15]^c[14]^c[12]^c[11]^c[5]^c[4]^c[2]^c[0];
  assign e[7] = d[1]^d[3]^d[4]^d[10]^d[11]^d[13]^d[14]^d[15]^d[17]^d[21]^d[24]^d[29]^d[30] ^ c[30]^c[29]^c[24]^c[21]^c[17]^c[15]^c[14]^c[13]^c[11]^c[10]^c[4]^c[3]^c[1];
  assign e[6] = d[0]^d[2]^d[3]^d[9]^d[10]^d[12]^d[13]^d[14]^d[16]^d[20]^d[23]^d[28]^d[29] ^ c[29]^c[28]^c[23]^c[20]^c[16]^c[14]^c[13]^c[12]^c[10]^c[9]^c[3]^c[2]^c[0];
  assign e[5] = d[0]^d[3]^d[5]^d[6]^d[7]^d[8]^d[9]^d[11]^d[12]^d[13]^d[21]^d[25]^d[27]^d[28]^d[31] ^ c[31]^c[28]^c[27]^c[25]^c[21]^c[13]^c[12]^c[11]^c[9]^c[8]^c[7]^c[6]^c[5]^c[3]^c[0];
  assign e[4] = d[2]^d[4]^d[5]^d[6]^d[7]^d[8]^d[10]^d[11]^d[12]^d[20]^d[24]^d[26]^d[27]^d[30] ^ c[30]^c[27]^c[26]^c[24]^c[20]^c[12]^c[11]^c[10]^c[8]^c[7]^c[6]^c[5]^c[4]^c[2];
  assign e[3] = d[1]^d[3]^d[4]^d[5]^d[6]^d[7]^d[9]^d[10]^d[11]^d[19]^d[23]^d[25]^d[26]^d[29] ^ c[29]^c[26]^c[25]^c[23]^c[19]^c[11]^c[10]^c[9]^c[7]^c[6]^c[5]^c[4]^c[3]^c[1];
  assign e[2] = d[0]^d[2]^d[3]^d[4]^d[5]^d[6]^d[8]^d[9]^d[10]^d[18]^d[22]^d[24]^d[25]^d[28] ^ c[28]^c[25]^c[24]^c[22]^c[18]^c[10]^c[9]^c[8]^c[6]^c[5]^c[4]^c[3]^c[2]^c[0];
  assign e[1] = d[1]^d[2]^d[3]^d[4]^d[5]^d[7]^d[8]^d[9]^d[17]^d[21]^d[23]^d[24]^d[27] ^ c[27]^c[24]^c[23]^c[21]^c[17]^c[9]^c[8]^c[7]^c[5]^c[4]^c[3]^c[2]^c[1];
  assign e[0] = d[0]^d[1]^d[2]^d[3]^d[4]^d[6]^d[7]^d[8]^d[16]^d[20]^d[22]^d[23]^d[26] ^ c[26]^c[23]^c[22]^c[20]^c[16]^c[8]^c[7]^c[6]^c[4]^c[3]^c[2]^c[1]^c[0];

  // initial 2 bytes from CRC=0xFFFFFFFF
  assign f[31] = d[19]^d[21]^d[22]^d[25]^d[31] ^ C1;
  assign f[30] = d[18]^d[19]^d[20]^d[22]^d[24]^d[25]^d[30]^d[31] ^ C0;
  assign f[29] = d[17]^d[18]^d[22]^d[23]^d[24]^d[25]^d[29]^d[30]^d[31] ^ C1;
  assign f[28] = d[16]^d[17]^d[21]^d[22]^d[23]^d[24]^d[28]^d[29]^d[30] ^ C1;
  assign f[27] = d[16]^d[19]^d[20]^d[23]^d[25]^d[27]^d[28]^d[29]^d[31] ^ C1;
  assign f[26] = d[18]^d[21]^d[24]^d[25]^d[26]^d[27]^d[28]^d[30]^d[31] ^ C1;
  assign f[25] = d[17]^d[20]^d[23]^d[24]^d[25]^d[26]^d[27]^d[29]^d[30] ^ C1;
  assign f[24] = d[16]^d[21]^d[23]^d[24]^d[26]^d[28]^d[29]^d[31] ^ C0;
  assign f[23] = d[19]^d[20]^d[21]^d[23]^d[27]^d[28]^d[30]^d[31] ^ C0;
  assign f[22] = d[18]^d[19]^d[20]^d[22]^d[26]^d[27]^d[29]^d[30] ^ C0;
  assign f[21] = d[17]^d[18]^d[22]^d[26]^d[28]^d[29]^d[31] ^ C1;
  assign f[20] = d[16]^d[17]^d[19]^d[22]^d[27]^d[28]^d[30]^d[31] ^ C0;
  assign f[19] = d[16]^d[18]^d[19]^d[22]^d[25]^d[26]^d[27]^d[29]^d[30]^d[31] ^ C0;
  assign f[18] = d[17]^d[18]^d[21]^d[24]^d[25]^d[26]^d[28]^d[29]^d[30] ^ C1;
  assign f[17] = d[16]^d[17]^d[20]^d[23]^d[24]^d[25]^d[27]^d[28]^d[29] ^ C1;
  assign f[16] = d[16]^d[19]^d[22]^d[23]^d[24]^d[26]^d[27]^d[28] ^ C0;
  assign f[15] = d[18]^d[19]^d[23]^d[26]^d[27]^d[31] ^ C1;
  assign f[14] = d[17]^d[18]^d[22]^d[25]^d[26]^d[30] ^ C1;
  assign f[13] = d[16]^d[17]^d[21]^d[24]^d[25]^d[29] ^ C1;
  assign f[12] = d[16]^d[20]^d[23]^d[24]^d[28] ^ C0;
  assign f[11] = d[19]^d[22]^d[23]^d[27] ^ C1;
  assign f[10] = d[18]^d[21]^d[22]^d[26] ^ C1;
  assign f[9] = d[17]^d[19]^d[20]^d[22]^d[31] ^ C0;
  assign f[8] = d[16]^d[18]^d[22]^d[25]^d[30]^d[31] ^ C1;
  assign f[7] = d[17]^d[21]^d[24]^d[29]^d[30] ^ C0;
  assign f[6] = d[16]^d[20]^d[23]^d[28]^d[29] ^ C0;
  assign f[5] = d[21]^d[25]^d[27]^d[28]^d[31] ^ C0;
  assign f[4] = d[20]^d[24]^d[26]^d[27]^d[30] ^ C0;
  assign f[3] = d[19]^d[23]^d[25]^d[26]^d[29] ^ C0;
  assign f[2] = d[18]^d[22]^d[24]^d[25]^d[28] ^ C0;
  assign f[1] = d[17]^d[21]^d[23]^d[24]^d[27] ^ C0;
  assign f[0] = d[16]^d[20]^d[22]^d[23]^d[26] ^ C0;

  // final 2 bytes from CRC
  assign g[31] = d[3]^d[5]^d[6]^d[9]^d[15] ^ c[15]^c[9]^c[6]^c[5]^c[3];
  assign g[30] = d[2]^d[3]^d[4]^d[6]^d[8]^d[9]^d[14]^d[15] ^ c[15]^c[14]^c[9]^c[8]^c[6]^c[4]^c[3]^c[2];
  assign g[29] = d[1]^d[2]^d[6]^d[7]^d[8]^d[9]^d[13]^d[14]^d[15] ^ c[15]^c[14]^c[13]^c[9]^c[8]^c[7]^c[6]^c[2]^c[1];
  assign g[28] = d[0]^d[1]^d[5]^d[6]^d[7]^d[8]^d[12]^d[13]^d[14] ^ c[14]^c[13]^c[12]^c[8]^c[7]^c[6]^c[5]^c[1]^c[0];
  assign g[27] = d[0]^d[3]^d[4]^d[7]^d[9]^d[11]^d[12]^d[13]^d[15] ^ c[15]^c[13]^c[12]^c[11]^c[9]^c[7]^c[4]^c[3]^c[0];
  assign g[26] = d[2]^d[5]^d[8]^d[9]^d[10]^d[11]^d[12]^d[14]^d[15] ^ c[15]^c[14]^c[12]^c[11]^c[10]^c[9]^c[8]^c[5]^c[2];
  assign g[25] = d[1]^d[4]^d[7]^d[8]^d[9]^d[10]^d[11]^d[13]^d[14] ^ c[14]^c[13]^c[11]^c[10]^c[9]^c[8]^c[7]^c[4]^c[1];
  assign g[24] = d[0]^d[5]^d[7]^d[8]^d[10]^d[12]^d[13]^d[15] ^ c[15]^c[13]^c[12]^c[10]^c[8]^c[7]^c[5]^c[0];
  assign g[23] = d[3]^d[4]^d[5]^d[7]^d[11]^d[12]^d[14]^d[15] ^ c[15]^c[14]^c[12]^c[11]^c[7]^c[5]^c[4]^c[3];
  assign g[22] = d[2]^d[3]^d[4]^d[6]^d[10]^d[11]^d[13]^d[14] ^ c[14]^c[13]^c[11]^c[10]^c[6]^c[4]^c[3]^c[2];
  assign g[21] = d[1]^d[2]^d[6]^d[10]^d[12]^d[13]^d[15] ^ c[15]^c[13]^c[12]^c[10]^c[6]^c[2]^c[1];
  assign g[20] = d[0]^d[1]^d[3]^d[6]^d[11]^d[12]^d[14]^d[15] ^ c[15]^c[14]^c[12]^c[11]^c[6]^c[3]^c[1]^c[0];
  assign g[19] = d[0]^d[2]^d[3]^d[6]^d[9]^d[10]^d[11]^d[13]^d[14]^d[15] ^ c[15]^c[14]^c[13]^c[11]^c[10]^c[9]^c[6]^c[3]^c[2]^c[0];
  assign g[18] = d[1]^d[2]^d[5]^d[8]^d[9]^d[10]^d[12]^d[13]^d[14] ^ c[14]^c[13]^c[12]^c[10]^c[9]^c[8]^c[5]^c[2]^c[1];
  assign g[17] = d[0]^d[1]^d[4]^d[7]^d[8]^d[9]^d[11]^d[12]^d[13] ^ c[13]^c[12]^c[11]^c[9]^c[8]^c[7]^c[4]^c[1]^c[0];
  assign g[16] = d[0]^d[3]^d[6]^d[7]^d[8]^d[10]^d[11]^d[12] ^ c[12]^c[11]^c[10]^c[8]^c[7]^c[6]^c[3]^c[0];
  assign g[15] = d[2]^d[3]^d[7]^d[10]^d[11]^d[15] ^ c[31]^c[15]^c[11]^c[10]^c[7]^c[3]^c[2];
  assign g[14] = d[1]^d[2]^d[6]^d[9]^d[10]^d[14] ^ c[30]^c[14]^c[10]^c[9]^c[6]^c[2]^c[1];
  assign g[13] = d[0]^d[1]^d[5]^d[8]^d[9]^d[13] ^ c[29]^c[13]^c[9]^c[8]^c[5]^c[1]^c[0];
  assign g[12] = d[0]^d[4]^d[7]^d[8]^d[12] ^ c[28]^c[12]^c[8]^c[7]^c[4]^c[0];
  assign g[11] = d[3]^d[6]^d[7]^d[11] ^ c[27]^c[11]^c[7]^c[6]^c[3];
  assign g[10] = d[2]^d[5]^d[6]^d[10] ^ c[26]^c[10]^c[6]^c[5]^c[2];
  assign g[9] = d[1]^d[3]^d[4]^d[6]^d[15] ^ c[25]^c[15]^c[6]^c[4]^c[3]^c[1];
  assign g[8] = d[0]^d[2]^d[6]^d[9]^d[14]^d[15] ^ c[24]^c[15]^c[14]^c[9]^c[6]^c[2]^c[0];
  assign g[7] = d[1]^d[5]^d[8]^d[13]^d[14] ^ c[23]^c[14]^c[13]^c[8]^c[5]^c[1];
  assign g[6] = d[0]^d[4]^d[7]^d[12]^d[13] ^ c[22]^c[13]^c[12]^c[7]^c[4]^c[0];
  assign g[5] = d[5]^d[9]^d[11]^d[12]^d[15] ^ c[21]^c[15]^c[12]^c[11]^c[9]^c[5];
  assign g[4] = d[4]^d[8]^d[10]^d[11]^d[14] ^ c[20]^c[14]^c[11]^c[10]^c[8]^c[4];
  assign g[3] = d[3]^d[7]^d[9]^d[10]^d[13] ^ c[19]^c[13]^c[10]^c[9]^c[7]^c[3];
  assign g[2] = d[2]^d[6]^d[8]^d[9]^d[12] ^ c[18]^c[12]^c[9]^c[8]^c[6]^c[2];
  assign g[1] = d[1]^d[5]^d[7]^d[8]^d[11] ^ c[17]^c[11]^c[8]^c[7]^c[5]^c[1];
  assign g[0] = d[0]^d[4]^d[6]^d[7]^d[10] ^ c[16]^c[10]^c[7]^c[6]^c[4]^c[0];

  always @(posedge clk) begin
    if (init) crc <= 32'hFFFFFFFF; 
    else if (init2) crc <= f;
    else if (add) crc <= e;
    else if (add2) crc <= g;
  end

endmodule
