`include "../lib/ramdefs.h"

`ifndef NIO_NKRI
  `define NIO_NKRI 16
`endif
`ifndef NIO_NKRO
  `define NIO_NKRO 16
`endif

module ice_tg_phy (
	clk,rst, irdy,iena,isel,ibus, ordy,oena,osel,obus,
	sclk,srst, scs,saddr, swr,swrbus, srd,srdbus,
	cclk,crd,cwr,cpage,caddr,cdata,cdatao, cs,
	drpclk,drprst,drpen,drpaddr,drpwe,drpdi,drprdy,drpdo,dmondo,
	refclks, txp,txn, rxp,rxn, streams,testout, dbgsys,dbgout);

  parameter NC = 4;	// number channels
  parameter DW = 32;	// IO bus width

`ifdef NIO_FMLB			// Faux Modem Loop Back
  localparam CW = 32;		// external IO bus width
`else
  localparam CW = DW;		// external IO bus width
`endif
  localparam PW = 32;		// internal QSFP bus width
  localparam CWC = CW/8;
  localparam PWC = PW/8;
  localparam CWX = CW+CWC;
  localparam PWX = PW+PWC;
  localparam ONC = (NC>4)? 3 : (NC>2)? 2 : (NC>1)? 1 : 0;
  localparam NKRI = `NIO_NKRI;	// num KBy RAM in PKT2DAT buffers
  localparam NKRO = `NIO_NKRO;	// num KBy RAM in DAT2PKT buffers

  input clk;
  input rst;

  output reg irdy;
  input iena;
  input [7:0] isel;
  input [CW-1:0] ibus;

  output ordy;
  input  oena;
  output [7:0] osel;
  output [CW-1:0] obus;

  input sclk,srst,scs,swr,srd;
  input [31:0] saddr,swrbus;
  output [31:0] srdbus;

  input cclk,crd,cwr,cs;
  input [7:0] cpage,caddr,cdata;
  output [7:0] cdatao;

  input drpclk;
  input drprst;
  input drpen;
  input [8:0] drpaddr;
  input drpwe;
  input [15:0] drpdi;
  output [NC-1:0] drprdy;
  output [(NC*16)-1:0] drpdo;
  output [(NC*17)-1:0] dmondo;

  inout [3:0] refclks;
  output [NC-1:0] txp,txn;
  input  [NC-1:0] rxp,rxn;

  output [NC*38:0] streams;
  output [7:0] testout;
  input  [7:0] dbgsys;
  output [32:0] dbgout;

  // Functions
  function [3:0] selector (input [3:0] rdys);
    selector = rdys[0]? 0 : rdys[1]? 1 : rdys[2]? 2 : rdys[3]? 3 : 4;
  endfunction

  wire T=1, F=0;

  wire raw   = dbgsys[0];
  wire ardy  = dbgsys[1];
  wire arst  = dbgsys[2] || srst;
  wire tmode = dbgsys[3];

`ifdef NIO_MIM
  // Man In the Middle mode
  wire [3:0] mims = dbgsys[7:4];
`else
  wire [3:0] mims = 0;
`endif
  wire [3:0] ignores = dbgsys[7:4];

  wire [2:0] pma_pmd_type = 3'b111;
  wire signal_detect=T;
  wire tx_fault=F;
  wire tx_disable;

  wire coreclk,txoutclk,txusrclk,txusrclk2;
  wire areset_coreclk,areset_txusrclk2,gttxreset,gtrxreset,txuserrdy,reset_counter_done;
  wire [NC-1:0] qpll0reset,qpll0lock,txoutclks;
  wire tclk = txusrclk;
  wire rclk = txusrclk;

  wire irdy_;
  wire [NC-1:0] irdys,ordys;
  wire [CW-1:0] obuss[NC-1:0];
  wire [7:0]    osels[NC-1:0];

  // Main JVM Controller
  wire srwx,srdx,swrx,sackx,swrs,srds,swrf,srdf;
  wire [31:0] saddrx,srdbusx,swrbusx;
  wire [7:0] testp;
  wire bwr,brd;
  wire [31:0] bwrbus;
  wire [31:0] brdbus;
  wire [15:0] baddr;
  processorLite #(PW,2,2) prc ( 
	cclk,crd,cwr,cpage,caddr,cdata,cdatao, cs,
	sclk,baddr, brd,brdbus, bwr,bwrbus,
	sclk,srst, srwx,saddrx, srdx,srdbusx, swrx,swrbusx, sackx,
	tclk,srds,swrs, tclk,srdf,swrf, testp);

  // System bus
  reg twr_,twr,twrd,swrt,srstpc;
  reg [15:0] taddr;
  reg [31:0] twrbus,srdbus;
  wire [31:0] srdbusi[NC-1:0], srdbusj[NC-1:0], srdbusk[NC-1:0];
  wire [ONC-1:0] tchn = taddr[14:12];
  wire [ONC-1:0] schn = saddr[14:12];
  wire aios = saddr[17];
  wire sios = saddr[15];
  wire tios = taddr[15];
  always @(posedge tclk) begin
    twr_ <= scs && swr && !aios;	// tclk should be ~ 3x sclk
    twr  <= twr_; twrd <= twr; 
    taddr <= saddr;
    if (twr) twrbus <= swrbus;
    swrt <= twr && !twrd;		// swrti and j are 1 cycle later
  end
  reg [3:0] iauxf,oauxf,cmode;
  always @(posedge sclk) begin
    if (arst) iauxf <= 0; else if (scs && swr && aios && saddr[2]) iauxf <= swrbus;
    if (arst) oauxf <= 0; else if (scs && swr && aios && saddr[3]) oauxf <= swrbus;
    if (arst) cmode <= 0; else if (scs && swr && aios && saddr[5]) cmode <= swrbus;
    srstpc <= (scs && swr && aios && saddr[4]);
    srdbus <= aios? srdbusk[schn] : sios? srdbusj[schn] : srdbusi[schn];
  end

  // Input bus counters
  reg [9:0] icnts[3:0];
  reg [1:0] vchnd; 
  reg [CWX-1:0] ibusd; 
  wire [1:0] iauxm = iauxf[1:0];	// mode
  wire [1:0] iauxs = iauxf[3:2];	// size
  wire [1:0] vchn = isel[1:0];
  wire [9:0] icnt = icnts[vchn];;
  wire [1:0] ichn = (iauxs==0)? icnt[6:5] : (iauxs==1)? icnt[7:6] : (iauxs==2)? icnt[8:7] : icnt[9:8];
  always @(posedge clk) begin
    if (rst) icnts[0] <= 0; else if (iena&&(vchn==0)) icnts[0] <= icnts[0]+1;
    if (rst) icnts[1] <= 0; else if (iena&&(vchn==1)) icnts[1] <= icnts[1]+1;
    if (rst) icnts[2] <= 0; else if (iena&&(vchn==2)) icnts[2] <= icnts[2]+1;
    if (rst) icnts[3] <= 0; else if (iena&&(vchn==3)) icnts[3] <= icnts[3]+1;
    ibusd <= {isel,ibus};
    vchnd <= vchn;
  end

  // Output bus aggregation
  reg [ONC-1:0] ochn,ochnp,pchn;
  reg oval,pval,pena;
  reg [CWX-1:0] pbus;
  reg [9:0] ocnt; 
  wire prdy;
  wire [1:0] oauxm = oauxf[1:0];	// mode
  wire [1:0] oauxs = oauxf[3:2];	// size
`ifdef NIO_FMLB
  reg [NC-1:0] oenas;
`else
  reg noaux;
  wire [NC-1:0] oenas;
  always @(posedge rclk) begin
    noaux <= (oauxm==0);
    pval <= oval; pena <= pval; pchn <= ochn;
  end
  // 7	ocyc
  // 0	oval	ochnx	oenas
  // 1	pval	pchnx	
  // 2	pena	pbus
  wire ocyc = noaux? (ocnt[3:0]==0) : (oauxs==0)? (ocnt[4:0]==0) : (oauxs==1)? (ocnt[5:0]==0) : (oauxs==2)? (ocnt[6:0]==0) : (ocnt[7:0]==0);
  always @(posedge rclk) begin
    if (rst) ocnt <= 0; else if (oval) ocnt <= ocnt+1;	// special MUXGBE capability
    if (oval) ochnp <= ((oauxm==1) && (ochn>=1))? 0 : ochn+1;
    oval <= oval? (ocnt[3:0]!=15) : prdy && ( ocyc? (ordys!=0) : ordys[ochn] ); 
    if (ocyc&!oval) ochn <= (!noaux && ordys[ochnp])? ochnp : selector(ordys);
    pbus <= {osels[pchn][3:0],4'b0,obuss[pchn]};		// use lower 4 bits of osel now that OBW=32
  end
  fifoNxM #(CWX,CWX,4,4) ofifo (rclk,rst, prdy,pena,pbus, clk,rst, ordy,oena,{osel[7:0],obus[CW-1:0]});
  assign irdy_ = (!irdys==0);
  assign oenas = (oval<<ochn);
`endif
  always @(posedge clk) irdy <= ardy? T : irdy_;

  // Packet responder bus logic
  reg  [31:0] ibusx;
  wire [31:0] obusx;
  wire [31:0] rtbuss [NC-1:0];
  reg  [NC-1:0] rtrdys,rtnrdys;
  wire [NC-1:0] rtrdys_,rtenas,rtsels;
  reg  [ONC-1:0] rseli,rselo,rselx;
  reg  [7:0] rtcnt,ioaddr;
  wire [2:0] rsely = rselx;
  wire rtrdyi = rtrdys[rselx];
  wire rtnrdyi = rtnrdys[rselx];
  wire rtseli = rtsels[rselo];
  reg  rtena,rtenax,rtval,rtval2,rtrd,rdyany,rtoff,rtrw,oreq;
  assign srdbusx = saddrx[2]? {rtena,oreq, rtrdys, 1'h0,rtrdyi,1'h0,rdyany,1'h0,rsely} : ibusx;
  wire rtstr = swrs && !saddrx[2];
  wire rtrw_ = swrbusx[31];	// read=0 or write=1 cycle
  wire oenax = rtena && rtrw;
  wire ienax = rtena && !rtrw;
  wire ienaxd; delayp #(2) dpxd (tclk,ienax,ienaxd);
  always @(posedge tclk) begin
    rtrdys <= rtrdys_;
    rtnrdys <= ~rtrdys_;
    ibusx <= rtbuss[rseli];
    rtrd <= srds && saddrx[3];	// read from one of the FIFOs
    rdyany <= (rtrdys!=0);
    rseli <= saddrx[18:16];
    if (rtnrdyi) rselx <= rselx+1;
    if (rtstr) ioaddr <= swrbusx[25:18]; else if (oenax|ienaxd) ioaddr <= ioaddr+1;
    if (rtstr) rtcnt <= swrbusx[9:2]; else if (rtena) rtcnt <= rtcnt-1;
    if (rtstr) rtoff <= swrbusx[1];
    if (rtstr) rtrw <= rtrw_;
    if (rtstr) oreq <= rtrw_; else if (rtena) oreq <= F;
    if (rtstr) rselo <= saddrx[18:16];
    rtena <= (rtstr && !rtrw_) || (oreq && rtseli) || (rtena && rtcnt>1);
    rtenax <= rtena && (rtcnt==1) && rtoff;
    rtval <= rtena && rtrw;
    rtval2 <= rtenax && rtrw;
  end
  wire rtrdd; delayp #(6) dp (tclk,rtrd,rtrdd);

  dpram #(4,32,32) dram (sclk,T, baddr[15:2],bwr, bwrbus,brdbus,
                         tclk,T, ioaddr,ienaxd, ibusx,obusx);

  // Main Transceiver Clocking Block
  wire refclk = refclks[0];
  wire refclkcopy = refclks[1];
  assign txoutclk = txoutclks[0];
  assign streams[NC*38] = txusrclk;
  wire qpllreset;

  tge_0_shared_clock_and_reset_mod ten_gig_eth_pcs_pma_shared_clock_reset_block (
     .areset(arst),
//     .refclk_p(refclks[2]),
//     .refclk_n(refclks[3]),
     .qpll0reset(qpll0reset[0]),
//     .refclk(refclk_),
     .refclkcopy(refclkcopy),
     .coreclk(coreclk),
     .txoutclk(txoutclk),
     .qplllock(qpll0lock[0]),
     .areset_coreclk(areset_coreclk),
     .areset_txusrclk2(areset_txusrclk2),
     .gttxreset(gttxreset),
     .gtrxreset(gtrxreset),
     .txuserrdy(txuserrdy),
     .txusrclk(txusrclk),
     .txusrclk2(txusrclk2),
     .qpllreset(qpllreset),
     .reset_counter_done(reset_counter_done)
  );

  wire qpll0outclk,qpll0outrefclk;
  tge_0_gt_common ten_gig_eth_pcs_pma_gt_common_block (
     .refclk(refclk),
     .qpllreset(qpllreset),
     .qpll0lock(qpll0lock[0]),
     .qpll0outclk(qpll0outclk),
     .qpll0outrefclk(qpll0outrefclk)
  );

  wire [PW-1:0] xgmii_mimd [3:0];
  wire [PWC-1:0] xgmii_mimc [3:0];

  genvar i;
  generate
  for (i=0; i<NC; i=i+1) begin	// for each TGe

  localparam j  = i & 1;
  localparam k  = i >> 1;
  localparam im = i ^ 1;
  localparam iq = i & 15;

  wire [7:0] core_status;
  wire [PW-1:0] xgmii_txd,xgmii_rxd,tbus,tfbus;
  wire [PWC-1:0] xgmii_txc,xgmii_rxc;
  wire rstat,tstat,rxclk,rxstat,txstat,tval,trdy,tbyp;
  wire [3:0] tfstat;
  wire [3:0] tfena;
  wire [31:0] tdbus,rtbus;
  wire [3:0] tcbus,tfsel;
  reg rtsel,tvalx,tvaly,tvalz,rtrdy;
  reg [31:0] tbusx; 
  wire [7:0] dtest,ptest;

  reg swrti; always @(posedge tclk) swrti <= swrt && (tchn==i) && (tios==0);
  reg swrtj; always @(posedge tclk) swrtj <= swrt && (tchn==i) && (tios==1);
  reg srstx; always @(posedge tclk) srstx <= ptest[0];
  reg srsty; always @(posedge tclk) srsty <= srstx || ignores[i];
  reg srstz; always @(posedge tclk) srstz <= srstx || srstpc;
  reg reset; always @(posedge sclk) reset <= rst;

  wire xena,xstat; wire [31:0] xbus; wire [7:0] xsel=0;
  wire yena,ystat; wire [31:0] ybus; wire tack;
  eth2pkt e2p (rxclk,srsty, xgmii_rxc,xgmii_rxd, xena,xbus, yena,ybus);

  PKT2DAT_core #(.PORT(i),.IBW(PW),.OBW(CW),.IOCLKS(2),.IKR(NKRI),.OKR(16)) p2d (
	rclk,srst, T,taddr, swrtj,twrbus,F,srdbusj[i],tack,
	{rclk,rxclk}, xstat,xena,xsel,xbus, ordys[i],oenas[i],osels[i],obuss[i],
	 ystat,yena,ybus, rtrdys_[i],rtenas[i],rtbuss[i], ptest);

  assign rtenas[i] = (ienax||rtrdd) && (rseli==i);
  assign rtsels[i] = rtsel;

  // stream output all QSFP channels RAW or packetized for MultiChannel processing
  reg [36:0] strx; always @(posedge rxclk) strx <= {raw || (xgmii_rxc!=15), xgmii_rxc, xgmii_rxd};
  assign streams[i*38+37:i*38] = {rxclk,strx};

  // this iena is not 1 cycle early like all others
  reg ienac; always @(posedge clk) ienac <= iena && ((iauxm==1)? (isel[6]==k && ichn[0]==j) : (iauxm==2)? (ichn[1:0]==i) : isel[i+4]);
  wire [3:0] ienas = {vchnd,ienac};
  wire [3:0] irdys_;
  wire tok = !(rtrdy || (rtval && rtsel));
  wire tval2,twait; delayp #(6) (tclk,tfena[0] && tok,twait);

  // need to support 4 input channels per fiber for virtual channels
`ifdef NIO_FMLB
  reg qena; always @(posedge rclk) begin oenas[im] <= ordys[im] & irdys[i]; qena <= oenas[im]; end
  fifoNxM #(CWX,PWX,4,5,`BPAR,`DBLBUF) tfifo (rclk,srstx, irdys[i],qena,{osels[im],obuss[im]}, tclk,srstx, tfstat[0],tfena,{tfsel,tfbus});
  pkt2pkt #(PW,1) d2p (tclk,srstx, tfstat,tfena,tfbus, tok,tval,tval2,tbus);
`else
  qcfifoNxM #(CWX,PWX,NKRO/2,5,`BPAR,`DBLBUF) tfifo (clk,reset, irdys_,ienas,ibusd, tclk,reset, tfstat,tfena,{tfsel,tfbus}, cmode);
  assign irdys[i]=(!irdys_==0); assign tval2=F;
  dat2pkt #(PW,2) d2p (tclk,srstx, swrti,taddr,twrbus,srdbusi[i], tfstat,tfena,tfsel,tfbus, tok,tval,tbus, tbyp,dtest);
`endif

/*
    trdy&tsel -> cstart -> cseq -> chdr|cdata -> oena -> tval -> !tval  
                                       oreq   -> rtrdy                  -> rtsel -> rtena-> rtval -> rtval -> !rtval -> !rtsel -> tsel
*/
  reg [16:0] tcnt;
  reg [31:0] opkts;
  wire tdone = (tvalx&!rtsel) && !tval;
  always @(posedge tclk) begin
    if (!tmode) tcnt <= 0; else if (tdone) tcnt <= tcnt+1;
    rtrdy <= oreq && (rselo==i);
    rtsel <= (rtrdy && !tvalx && !twait) || (rtsel && (oreq|rtval));	// needs 4 clks between tval and rtval
    tvalx <= (rtval && rtsel) || tval;
    tvaly <= (rtval2 && rtsel) || tval2;
    tbusx <= rtsel? obusx : tbus;
    tvalz <= (rtval && rtsel) || (tval && !tcnt[16]);
    if (srstz) opkts <= 0; else if (tcbus==1) opkts <= opkts+1;
  end
  pkt2eth tpkte  (tclk,srsty, trdy,tvalz,tvaly,tbusx, tcbus,tdbus);

  if (i==0) begin
    assign testout = {oena,pena,rst};
  end
  assign srdbusk[i] = opkts;

`ifdef NIO_MIM
  wire mim = mims[iq];
  rsfifo (rxclk,xgmii_rxc,xgmii_rxd, tclk,xgmii_mimc[i],xgmii_mimd[i]);
`else
  wire mim = F;
`endif
  
  assign xgmii_txd = mim? xgmii_mimd[im] : tdbus;
  assign xgmii_txc = mim? xgmii_mimc[im] : tcbus;

  wire drp_req;
  wire drpc=drp_req;
  wire drp_gnt=drpc;
  wire core_to_gt_drpen;
  wire core_to_gt_drpwe;
  wire [15:0] core_to_gt_drpaddr;
  wire [15:0] core_to_gt_drpdi;
  wire drprdyx; assign drprdy[i]=drprdyx;
  wire core_to_gt_drprdy=drprdyx;
  wire [15:0] drpdox; assign drpdo[15+i*16:i*16]=drpdox;
  wire [16:0] dmondox; assign dmondo[16+i*17:i*17]=dmondox;
  wire [15:0] core_to_gt_drpdo=drpdox;
  wire tx_resetdone_int,rx_resetdone_int; 

  tge_0_block_32 ten_gig_eth_pcs_pma_block_i (
      .coreclk(coreclk),
      .dclk(drpclk),
      .txusrclk(txusrclk),
      .txusrclk2(txusrclk2),
      .txoutclk(txoutclks[i]),
      .areset_coreclk(areset_coreclk),
      .txuserrdy(txuserrdy),
      .rxrecclk_out(rxclk),
      .areset(arst),
      .gttxreset(gttxreset),
      .gtrxreset(gtrxreset),
      .qpll0lock(qpll0lock),
      .qpll0outclk(qpll0outclk),
      .qpll0outrefclk(qpll0outrefclk),
      .qpll0reset(qpll0reset[i]),
      .reset_counter_done(reset_counter_done),
      .xgmii_txd(xgmii_txd),
      .xgmii_txc(xgmii_txc),
      .xgmii_rxd(xgmii_rxd),
      .xgmii_rxc(xgmii_rxc),
      .txp(txp[i]),
      .txn(txn[i]),
      .rxp(rxp[i]),
      .rxn(rxn[i]),
      .core_status(core_status),
      .tx_resetdone(tx_resetdone_int),
      .rx_resetdone(rx_resetdone_int),
      .signal_detect(signal_detect),
      .tx_fault(tx_fault),
      .drp_req(drp_req),
      .drp_gnt(drp_gnt),
      .core_to_gt_drpen(core_to_gt_drpen),
      .core_to_gt_drpwe(core_to_gt_drpwe),
      .core_to_gt_drpaddr(core_to_gt_drpaddr),
      .core_to_gt_drpdi(core_to_gt_drpdi),
      .core_to_gt_drprdy(core_to_gt_drprdy),
      .core_to_gt_drpdo(core_to_gt_drpdo),
      .gt_drprdy(drprdyx),
      .gt_drpdo(drpdox),
      .gt_drpen(drpc?core_to_gt_drpen:drpen),
      .gt_drpwe(drpc?core_to_gt_drpwe:drpwe),
      .gt_drpaddr(drpc?core_to_gt_drpaddr:drpaddr),
      .gt_drpdi(drpc?core_to_gt_drpdi:drpdi),
      .gt_dmonitorout(dmondox),
      .pma_pmd_type(pma_pmd_type),
      .tx_disable(tx_disable)
  );

  end
  endgenerate

  reg sss; always @(posedge sclk) sss <= !sss;
  reg rrr; always @(posedge rclk) rrr <= !rrr;
  reg ttt; always @(posedge tclk) ttt <= !ttt;
  reg ddd; always @(posedge coreclk) ddd <= !ddd;
//  assign testout = {rtval,rtena,rtrdyi,rtrdd};
//  assign testout = {isel[6],isel[4],irdy,iena,irdys};
//  assign testout = {ddd,ttt,rrr,sss};

  assign dbgout = 0;
//  assign dbgsys = {16'hF0F0,drp_req,drp_gnt,tx_fault,tx_disable,reset,tx_resetdone_int,reset_counter_done,signal_detect,core_status};
//  assign testout = {gttxreset,gtrxreset,tval,rval,ttt,rrr,xgmii_rxc[0],reset};

endmodule

/*
 resynchronize Rx and Tx streams by stuffing comma frames (note: must be at least 3x4by between packets)

 ictl	0	C	F	F	F	F	3
 idat			F7	F7	F7	F7	
 iena	1	1	1	1	1	0	1
 icnt	5	6	7	8	9	10	10

 octl	0	7	15	15	15	15
 odat			F7	F7	F7	F7
 oena	1	1	0	0	1	1
 ocnt	5	6	7	7	7	8

*/

module  rsfifo (iclk,ictl,idat, oclk,octl,odat);

input iclk;  input [3:0] ictl;  input [31:0] idat;
input oclk; output [3:0] octl; output [31:0] odat;

wire H=1;
reg [7:0] icnt,ocnt;
wire [7:0] diff = icnt-ocnt;
reg [2:0] icoms,ocoms,idifs,odifs;
wire icom = (ictl==15);
wire ocom = (octl==15);
wire iena = !( (icoms==7) && icom && (idifs==7) );
wire oena = !( ocom && (odifs==7) );
always @(posedge iclk) begin
  icoms <= {icom,icoms[2:1]};
  idifs <= {diff[7:6]>2,idifs[2:1]};
  if (iena) icnt <= icnt+1;
end
always @(posedge oclk) begin
  odifs <= {diff[7:6]<1,odifs[2:1]};
  if (oena) ocnt <= ocnt+1;
end
sdpram #(1,36,36) dp (iclk,H, icnt,iena, {ictl,idat},   oclk,oena, ocnt,{octl,odat});
endmodule
