/**********************************************
 ICE Proprietary Software - do NOT disseminate
 **********************************************/
/*
  ICE-K8M Controller Defines

  Jeff Schoen
  Innovative Computer Engineering, Inc.
  1/15/2003

*/
`define ICE_PM 1
`define ICE_K8 1
`define VIRTEX8

`define JVM 1
`define DMA_NR 4
`define PRC_NOALTBUS	// for sysbusser
`define PRC_BCLK 1
`define PRC_BBUS 1	// for RIO JVM
`define PRC_SBUS 1	// for RIO JVM
`define PRC_FBUS 1	// for RIO JVM
`define DMA_PIPE_MIBUS 1
`define BSCAN_SPI_FLASH 1
`define BSCAN_GEN2 1
`define SDRAM4 1
`define SDRAM4X 1
`define PX_LW 8
`define PY_LW 8
`define RIO_GEN3 1
`define RIO_BSDRP 1
`define DMA_PKT_4X 1
`define HYP_RIO 1
`define TP_NONE 1

// add XIO for SPAC and TRAY by default
`ifndef K8P
`define DMA_NIO 1
`define DMA_NVM 1
`endif

`define SYS_CLKX 240

// default core engines
`define ENGINE1 noopengine 
`define ENGINE2 noopengine

// default multicore 1 & 2 engines
`define ENGINE3 mcengine
`define ENGINE4 mcengine
`define MC_ENGINE tfddengine
`define MC_ENGINES 16
`define MC_COMSTAT 1

// specific processor engine configurations
`ifdef PE_NOOP
  `define ENGINE1 noopengine 
  `define ENGINE2 noopengine
  `define SYS_CLKF 266
  `define SYS_CLKF2 250
  `define SYS_CLKF2_MASK 12
  `define MC_ENGINES 4
  `define MC_ENGINE noopengine
  `define NIO_SWAP12 1
  `define NIO_NKRO 32
  `define DMA_NIOX 1

`elsif PE_M
  `define ENGINE1 noopengine 
  `define ENGINE2 noopengine
  `define ENGINE3 NoOp_core 
  `define ENGINE4 NoOp_core
  `define SYS_CLKF 266
  `define MC_ENGINES 4
  `define MC_ENGINE noopengine
  `define NIO_FMLB 1

`elsif PE_DEF
  `define TFDD_RTAPS 8
  `define TFDD_XTAPS 1
  `define CORE_FFT 1
  `define FFT_PEAK 1
  `define FFT_ORDER 12
  `define ENGINE1 fftengine
  `define ENGINE2 fftengine
  `define SYS_CLKF 266

`elsif PE_X2
  `define MC_ENGINES 32
  `define ENGINE1 noopengine
  `define ENGINE2 noopengine
  `define SYS_CLKF 256.25
  `define NOXIO 1

`elsif PE_BOT
  `define CORE_FFT 1
  `define R2C_I2X 1
  `define BOT_ORDER 10
  `define BOT_I2X 1
  `define ENGINE3 botengine
  `define ENGINE4 botengine
  `define SYS_CLKF 320
  `define MCF_CTBE 1
  `define NOXIO 1

`elsif PE_WBR
  `define CORE_WBR 1
  `define ENGINE1 WBR_core
  `define ENGINE2 WBR_core
  `define ENGINE3 nullengine
  `define ENGINE4 nullengine
  `define SYS_CLKF 280
  `define NOXIO 1
  `define PE_GROUP_ALLCLEAN 1

`elsif PE_FFT
  `define CORE_FFT 1
  `define FFT_PEAK 1
  `define FFT_ORDER 14
  `define ENGINE1 fftengine
  `define ENGINE2 fftengine
  `define SYS_CLKF 266
  `define MC_ENGINES 2

`elsif PE_FFTX
  `define PE_GROUP_ALL 1
  `define CORE_FFT 1
  `define ENGINE1 fftengine
  `define ENGINE2 nullengine
  `define ENGINE3 nullengine
  `define ENGINE4 nullengine
  `define SYS_CLKF 266
  `define MC_ENGINES 1
  `define FFT_ORDER 16

`elsif PE_TF
  `define MC_ENGINES 4
  `define TFDD_ORDER 3
  `define TFDD_DMOD
  `define ENGINE1 firengine
  `define ENGINE2 firengine

`elsif PE_TR
  `define MC_ENGINES 4
  `define TFDD_ORDER 3
  `define TFDD_RTAPS 10
  `define TFDD_MDW 8
  `define R2C_TUNER 1
  `define ENGINE1 r2cengine
  `define ENGINE2 r2cengine
  `define SYS_CLKF 266

`elsif PE_TS
  `define MC_ENGINES 8
  `define TFDD_ORDER 2
  `define TFDD_RTAPS 10
  `define TFDD_MDW 8
  `define ENGINE1 noopengine
  `define ENGINE2 noopengine
  `define SYS_CLKF 266

`elsif PE_TQ
  `define MC_ENGINES 6
  `define TFDD_NPS 2
  `define TFDD_MDW 16
  `define TFDD_CFXO 1
  `define TFDD_ORDER 3
  `define TFDD_RTAPS 10
  `define CORE_FFT 1
  `define FFT_PEAK 1
  `define FFT_ORDER 14
  `define ENGINE1 fftengine
  `define ENGINE2 fftengine
  `define SYS_CLKF 256
//  `define PE_GROUP_ALL 1
  `define NOXNIO 1
//  `define TP_ONE 1

`elsif PE_TX
  `define MC_ENGINES 4
  `define TFDD_NPS 2
  `define TFDD_MDW 16
  `define TFDD_ORDER 3
  `define TFDD_RTAPS 10
  `define SYS_CLKF 300

`elsif PE_G
  `define ENGINE1 noopengine
  `define ENGINE2 noopengine
  `define MC_ENGINES 20
  `define NOTESTMUX 1
  `define TFDD_RTAPS 0
  `define TFDD_MDW 8
  `define SYS_CLKF 225
  `define JVM_NR 8

`elsif PE_WG
//  `define MC_FEEDBACK 1
  `define MC_ENGINES 12
  `define MC_ENGINE MOD_core
  `define ENGINE3 mcengine
  `define ENGINE4 mcengine
  `define MC_UPS 1
  `define SYS_CLKF 250
  `define NOMEM 1
  `define NOXIO 1
  `define PE_GROUP_ALL 1

`elsif PE_TEST
  `define ENGINE1 Test_core
  `define ENGINE2 Test_core
  `define ENGINE3 noopengine
  `define ENGINE4 noopengine

`elsif PE_NULL
  `define ENGINE1 nullengine
  `define ENGINE2 nullengine

`else 
// user defined processor engine configurations
//  `define NOXIO 1
  `define PE_GROUP_ALL 1
  `include "mdefs_user.h"
`endif

`include "../lib/mdefs_comp.h"

