`include "../lib/ramdefs.h"
`include "../lib/crc32.v"
module
pktengine
(
sclk
,
srst
,
scs
,
saddr
,
swr
,
swrbus
,
srd
,
srdbus
,
sack
,
ioclk
,
istat
,
iena
,
isel
,
ibus
,
ostat
,
oena
,
osel
,
obus
,
test
);
parameter
PORT
=
1
;
parameter
IBW
=
64
;
parameter
OBW
=
IBW
;
localparam
SBW
=
32
;
localparam
DBW
=
32
;
input
sclk
;
input
srst
;
input
scs
;
input
swr
;
input
srd
;
input
[
31
:
0
]
saddr
;
input
[
31
:
0
]
swrbus
;
output
[
31
:
0
]
srdbus
;
output
sack
;
input
ioclk
;
output
istat
;
input
iena
;
input
[
7
:
0
]
isel
;
input
[
IBW
-
1
:
0
]
ibus
;
output
ostat
;
input
oena
;
output
[
7
:
0
]
osel
;
output
[
IBW
-
1
:
0
]
obus
;
output
[
7
:
0
]
test
;
wire
z1
=
0
,
z2
=
1
;
assign
sack
=
z2
;
wire
[
11
:
0
]
z3
;
swrbank
#
(
0
,
1
)
swb
(
sclk
,
scs
,
swr
,
saddr
,
z3
);
wire
z4
=
z3
[
0
];
reg
[
31
:
0
]
z5
;
always
@(
posedge
sclk
)
begin
if
(
srst
)
z5
<=
0
;
else
if
(
z4
)
z5
<=
swrbus
;
end
wire
z6
=
z5
[
0
];
wire
z7
=
z5
[
1
];
wire
z8
=
!
z6
;
wire
z9
,
z10
,
z11
,
z12
,
z13
,
z14
,
z15
,
z16
;
wire
[
DBW
-
1
:
0
]
z17
,
z18
,
z19
,
z20
;
wire
z21
,
z22
,
z23
,
z24
,
z25
;
wire
[
3
:
0
]
z26
,
z27
;
wire
[
31
:
0
]
z28
;
wire
[
7
:
0
]
z29
;
reg
z30
;
always
@(
posedge
ioclk
)
z30
<=
iena
;
fifoNxM
#
(
IBW
,
DBW
,
4
,
3
)
fi
(
ioclk
,
z8
,
istat
,
z30
,
ibus
,
sclk
,
z8
,
z13
,
z9
,
z17
);
dat2pkt
d2p
(
sclk
,
srst
,
scs
&
swr
,
saddr
,
swrbus
,
srdbus
,
z13
,
z9
,
z27
,
z17
,
z15
&
z23
,
z10
,
z18
,
z21
,
test
);
`ifdef PKTETH
pkt2eth
p2e
(
sclk
,
z8
,
z23
,
z10
,
z1
,
z18
,
z26
,
z28
,
z22
);
eth2pkt
e2p
(
sclk
,
z8
,
z26
,
z28
,
z11
,
z19
);
`else
assign
z19
=
z18
;
assign
z11
=
z10
;
assign
z23
=
z15
;
`endif
`ifdef PKTENGINE
wire
[
SBW
-
1
:
0
]
z31
;
wire
z32
;
wire
[
7
:
0
]
z33
;
`PKTENGINE #(0,DBW,IBW,0,1) p2d (sclk,srst, scs,saddr, swr,swrbus, srd,z31, z32,
ioclk
,
z15
,
z11
,
z33
,
z19
,
ostat
,
oena
,
osel
,
obus
,
test
);
`else
fifoNxM
#
(
DBW
,
IBW
,
4
,
3
)
fo
(
sclk
,
z8
,
z15
,
z11
,
z19
,
ioclk
,
z8
,
ostat
,
oena
,
obus
);
assign
osel
=
0
;
`endif
assign
test
=
{
oena
,
ostat
,
iena
,
istat
,
z10
,
z9
,
z7
,
z8
};
endmodule
module
pkt2pkt
(
clk
,
z8
,
z13
,
z9
,
z17
,
z14
,
z10
,
wena2
,
z18
);
parameter
DBW
=
32
;
parameter
NC
=
1
;
input
clk
,
z8
;
input
[
1
:
0
]
z13
;
output
z9
;
input
[
DBW
-
1
:
0
]
z17
;
input
z14
;
output
reg
z10
,
wena2
;
output
[
DBW
-
1
:
0
]
z18
;
wire
z1
=
0
,
z2
=
1
;
reg
z34
,
z35
,
z36
;
reg
[
15
:
0
]
z37
;
always
@(
posedge
clk
)
begin
z34
<=
z13
&&
z14
&&
!
z34
&&
!
z35
;
if
(
z34
)
z37
<=
z17
[
15
:
0
];
else
if
(
z35
)
z37
<=
z37
-
4
;
z35
<=
(
z34
&&
(
z17
[
31
:
16
]==
16'h1CEF
)
&&
z17
[
15
:
0
]!=
0
)
||
(
z35
&&
(
z37
>
4
));
z36
<=
z35
;
z10
<=
z35
&&
z36
;
wena2
<=
z1
;
end
assign
z9
=
z34
||
z35
;
assign
z18
=
z17
;
endmodule
module
dat2pkt
(
clk
,
z8
,
pwr
,
paddr
,
pdata
,
pdatar
,
z13
,
z9
,
z27
,
z17
,
z14
,
z10
,
z18
,
bypass
,
test
);
parameter
DBW
=
32
;
parameter
NC
=
1
;
input
clk
,
z8
;
input
pwr
;
input
[
15
:
0
]
paddr
;
input
[
31
:
0
]
pdata
;
output
[
31
:
0
]
pdatar
;
input
[
3
:
0
]
z13
;
output
[
2
:
0
]
z9
;
input
[
3
:
0
]
z27
;
input
[
DBW
-
1
:
0
]
z17
;
input
z14
;
output
z10
;
output
[
DBW
-
1
:
0
]
z18
;
output
bypass
;
output
[
7
:
0
]
test
;
wire
z1
=
0
,
z2
=
1
;
reg
[
3
:
0
]
z38
;
reg
[
2
:
0
]
z39
;
reg
[
7
:
0
]
z40
,
z41
;
reg
[
11
:
0
]
z42
;
reg
[
31
:
0
]
z43
;
reg
[
3
:
0
]
z44
;
reg
z45
,
z46
,
z47
,
z48
,
z49
,
z50
;
reg
z51
,
z52
,
z53
,
z54
,
z55
,
z56
;
reg
z57
,
z58
;
reg
[
31
:
0
]
z59
;
wire
z6
=
z59
[
0
];
wire
z60
=
z59
[
1
];
assign
bypass
=
z59
[
4
];
wire
z61
=
z59
[
6
];
wire
[
31
:
0
]
z62
,
z63
;
dpram
#
(
4
,
32
,
32
)
rseq
(
clk
,
z2
,
paddr
[
11
:
2
],
pwr
,
pdata
,
z63
,
clk
,
z2
,
{
z38
,
z40
},
z1
,
32'h0
,
z62
);
wire
[
7
:
0
]
z64
=
z43
[
7
:
0
];
wire
[
10
:
0
]
z65
=
z43
[
7
:
0
];
wire
[
3
:
0
]
z66
=
z43
[
11
:
8
];
wire
[
1
:
0
]
z67
=
z43
[
13
:
12
];
wire
z68
=
z1
;
wire
z69
=
z43
[
20
];
wire
z70
=
z62
[
21
];
wire
z71
=
z62
[
22
];
wire
z72
=
z43
[
23
]&
z57
;
wire
z73
=
z43
[
24
];
wire
z74
=
z43
[
25
];
wire
z75
=
z43
[
26
];
wire
z76
=
z43
[
27
];
wire
z77
=
z43
[
28
];
wire
z78
=
z43
[
29
];
wire
z79
=
z43
[
30
];
wire
z80
=
z43
[
31
];
wire
z81
=
z62
[
31
]&&
z49
;
wire
z82
=
z45
||
z49
||
z46
;
wire
z83
=
z71
;
wire
[
1
:
0
]
z84
=
z13
[
0
]?
0
:
z13
[
1
]?
1
:
z13
[
2
]?
2
:
3
;
wire
[
7
:
0
]
z85
=
z44
[
z84
]?
z59
[
31
:
24
]
:
z59
[
23
:
16
];
wire
z86
=
(
z17
==
32'h7FDE1CED
);
wire
z87
=
z60
&&
z13
[
0
]
&&
z14
;
wire
z88
=
z60
?
z86
:
z39
[
2
];
always
@(
posedge
clk
)
begin
z54
<=
pwr
&&
(
paddr
[
11
:
0
]==
0
);
z55
<=
pwr
&&
(
paddr
[
11
:
2
]==
0
);
if
(
z8
)
z59
<=
0
;
else
if
(
z54
)
z59
<=
pdata
;
if
(
z8
)
z56
<=
0
;
else
if
(
z55
)
z56
<=
pdata
[
0
];
z39
<=
{
z39
,
z42
==
4
};
z45
<=
(
z13
!=
0
)
&&
z14
&&
!
z45
&&
!
z50
&&
z56
;
z46
<=
(
z49
&&
z81
)
||
(
z46
&&
!
z88
&&
!
z8
)
||
z87
;
z47
<=
(
z49
&&
z70
)
||
(
z47
&&
!
z39
[
0
]
&&
!
z8
);
z48
<=
z47
;
z49
<=
z45
||
(
z49
&&
!
z83
&&
!
z8
);
z50
<=
z82
;
if
(
z60
)
z38
<=
0
;
else
if
(
z45
)
z38
<=
z84
;
if
(
z81
)
z42
<=
z62
[
11
:
0
];
else
if
(
z46
)
z42
<=
z42
-
1
;
if
(
z81
)
z51
<=
z62
[
12
];
if
(
z81
)
z52
<=
z62
[
13
];
if
(
z81
)
z53
<=
z62
[
14
];
if
(!
z82
)
z40
<=
z85
;
else
if
(
z72
)
z40
<=
z43
[
7
:
0
];
else
if
(!
z47
)
z40
<=
z40
+
1
;
if
(!
z49
||
z47
||
z48
)
z43
<=
0
;
else
z43
<=
z62
;
end
assign
z9
=
{
z38
,
z46
};
wire
[
3
:
0
]
z89
;
reg
[
3
:
0
]
z90
;
wire
[
4
:
0
]
z91
=
{
z1
,
z89
}
+
z66
+
z58
;
always
@(
posedge
clk
)
begin
if
(
z73
)
z90
<=
z66
;
else
if
(
z74
)
z90
<=
z91
;
if
(
z77
)
z57
<=
z67
[
0
];
else
if
(
z79
)
z57
<=
z58
^
z67
[
0
];
if
(
z78
)
z58
<=
z67
[
1
];
else
if
(
z74
)
z58
<=
z91
[
4
];
if
(
z55
)
z44
<=
{
4
{
pdata
[
5
]}};
else
if
(
z69
)
z44
[
z38
]
<=
z58
;
end
wire
z92
=
(
pwr
&&
!
z76
)
||
z68
;
wire
[
9
:
0
]
z93
=
(
z76
|
z68
)?
{
z38
,
z64
}
:
paddr
[
11
:
2
];
wire
[
12
:
0
]
z94
=
{
z38
,
z65
};
wire
[
31
:
0
]
z95
;
dpram
#
(
4
,
4
,
32
)
rhdr
(
clk
,
z2
,
z94
,
z75
&
z57
,
z90
,
z89
,
clk
,
z2
,
z93
,
z92
,
z68
?
z17
:
pdata
,
z95
);
reg
z21
,
z96
,
z10
,
z97
;
reg
[
1
:
0
]
z98
,
z99
;
reg
[
31
:
0
]
z20
;
wire
[
31
:
0
]
z19
;
always
@(
posedge
clk
)
begin
z98
<=
z76
?
3
:
z52
?
2
:
z51
?
1
:
0
;
z96
<=
z76
||
z46
;
z10
<=
z96
&&
(!
z60
||
!
z86
);
z97
<=
z46
&&
z53
;
if
(
z76
)
z99
<=
0
;
else
if
(
z97
)
z99
<=
(
z99
==
3
)?
1
:
z99
+
1
;
z20
<=
z19
;
end
mux4xNp
#
(
DBW
)
dom
(
z19
,
z17
,
{
z17
[
23
:
16
],
z17
[
31
:
24
],
z17
[
7
:
0
],
z17
[
15
:
8
]},
{
z17
[
7
:
0
],
z17
[
15
:
8
],
z17
[
23
:
16
],
z17
[
31
:
24
]},
z95
,
z98
,
clk
);
`ifdef NIO_SWAP12
mux4xN
#
(
DBW
)
dox
(
z18
,
z19
,
{
z17
[
3
:
0
],
z19
[
31
:
28
],
z19
[
19
:
12
],
z19
[
3
:
0
],
z19
[
23
:
20
],
z19
[
11
:
4
]},{
z19
[
19
:
16
],
z17
[
7
:
4
],
z19
[
27
:
20
],
z19
[
11
:
4
],
z20
[
27
:
24
],
z19
[
15
:
12
]},{
z19
[
27
:
20
],
z19
[
11
:
8
],
z19
[
31
:
28
],
z19
[
19
:
12
],
z19
[
3
:
0
],
z20
[
31
:
28
]},
z99
);
`else
assign
z18
=
z19
;
`endif
assign
test
=
{
z9
,
z46
,
z13
,
z96
};
assign
pdatar
=
z95
;
endmodule
module
pkt2eth
(
clk
,
z8
,
trdy
,
tval
,
tvax
,
tbus
,
z26
,
z28
);
parameter
DBW
=
32
;
input
clk
,
z8
;
output
trdy
;
input
tval
,
tvax
;
input
[
31
:
0
]
tbus
;
output
[
3
:
0
]
z26
;
output
[
31
:
0
]
z28
;
wire
z1
=
0
,
z2
=
1
;
wire
[
31
:
0
]
z100
;
wire
[
31
:
0
]
z101
=
~
z100
;
reg
[
63
:
0
]
z102
;
reg
[
31
:
0
]
z28
;
reg
[
3
:
0
]
z26
;
reg
z103
,
z104
;
wire
z105
=
tval
&&
!
z103
;
wire
z106
=
z103
&&
!(
tval
|
tvax
);
wire
z107
;
delaypipe
#
(
1
)
dlst1
(
clk
,
z105
,
z107
);
wire
z108
;
delaypipe
#
(
2
)
dlst2
(
clk
,
z105
,
z108
);
wire
z109
;
delaypipe
#
(
2
)
dlval
(
clk
,
tval
|
tvax
,
z109
);
wire
z110
;
delaypipe
#
(
2
)
dlend
(
clk
,
z106
,
z110
);
wire
z111
;
delaypipe
#
(
3
)
dlvax
(
clk
,
tvax
,
z111
);
delaypipe
#
(
3
)
dlrdy
(
clk
,!
z103
,
trdy
);
always
@(
posedge
clk
)
begin
z104
<=
tvax
;
z103
<=
tval
||
tvax
;
z102
<=
z104
?
{
z101
,
z102
[
47
:
32
]}
:
z106
?
{
z101
,
z102
[
63
:
32
]}
:
{
tbus
,
z102
[
63
:
32
]};
z28
<=
z105
?
32'h555555FB
:
z107
?
32'hD5555555
:
z109
?
z102
[
47
:
16
]
:
z111
?
32'h070707FD
:
z110
?
{
16'h07FD
,
z102
[
31
:
16
]}
:
32'h07070707
;
z26
<=
z105
?
4'h1
:
z107
?
4'h0
:
z109
?
4'h0
:
z111
?
4'hF
:
z110
?
4'hC
:
4'hF
;
end
crc32_d32
txcrc
(
clk
,
z1
,!
z103
,
tval
,
tvax
,
tbus
,
z100
);
endmodule
module
eth2pkt
(
clk
,
rst
,
z26
,
z28
,
z96
,
obus
,
pena
,
pbus
);
parameter
DBW
=
32
;
parameter
NP
=
12
;
input
clk
,
rst
;
input
[
3
:
0
]
z26
;
input
[
31
:
0
]
z28
;
output
z96
,
pena
;
output
[
31
:
0
]
obus
,
pbus
;
wire
z1
=
0
,
z2
=
1
;
reg
[
63
:
0
]
z102
;
reg
z112
,
z113
,
z105
,
z114
,
z115
,
z116
;
reg
[
NP
-
1
:
0
]
z117
;
wire
z106
=
z113
&&
!
z112
;
always
@(
posedge
clk
)
begin
z116
<=
(
z26
==
4'h1
)
&&
(
z28
==
32'h555555FB
);
if
(
rst
)
z112
<=
0
;
else
z112
<=
z112
?
(
z26
==
0
)
:
z116
;
if
(
rst
)
z113
<=
0
;
else
z113
<=
z112
;
if
(
rst
)
z105
<=
0
;
else
z105
<=
(
z117
==
7
);
if
(!
z113
)
z117
<=
0
;
else
z117
<=
z117
+
1
;
z102
<=
{
z28
,
z102
[
63
:
32
]};
z114
<=
z105
;
z115
<=
z106
;
end
assign
z96
=
z112
;
assign
obus
=
z102
[
47
:
16
];
assign
pena
=
z105
||
z106
;
assign
pbus
=
{
z115
,
z114
,
2'b0
,
z117
,
2'b0
};
endmodule
module
pkt2dat
(
clk
,
rst
,
pwr
,
paddr
,
pdata
,
pdatar
,
z113
,
tbus
,
oval
,
obus
);
parameter
DBW
=
32
;
parameter
NP
=
12
;
parameter
INST
=
0
;
input
clk
,
rst
;
input
pwr
;
input
[
15
:
0
]
paddr
;
input
[
31
:
0
]
pdata
;
output
[
31
:
0
]
pdatar
;
input
z113
;
input
[
31
:
0
]
tbus
;
output
oval
;
output
[
31
:
0
]
obus
;
wire
z1
=
0
,
z2
=
1
;
reg
z118
;
reg
[
31
:
0
]
z119
,
z120
,
z121
,
z122
;
wire
z105
=
z113
&&
!
z118
;
wire
z106
=
!
z113
&&
z118
;
wire
[
1
:
0
]
z38
=
INST
;
wire
z8
=
rst
||
z119
[
0
];
wire
[
31
:
0
]
z123
=
{
16'h01CE
,
3'h0
,
z8
,
2'h0
,
z38
};
always
@(
posedge
clk
)
begin
if
(
pwr
)
z119
<=
pdata
;
if
(
z113
)
z122
<=
tbus
;
z118
<=
z113
;
if
(
z8
)
z121
<=
0
;
else
if
(
z106
)
z121
<=
z121
+
1
;
if
(
z8
)
z120
<=
~
0
;
else
if
(
z113
)
z120
<=
z120
^
tbus
;
end
muxMxNp
#
(
4
,
32
)
rm
(
pdatar
,
{
z122
,
z123
,
z120
,
z121
},
paddr
[
3
:
2
],
clk
);
assign
oval
=
z118
;
assign
obus
=
z122
;
endmodule
