/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public final class BuildProps
extends Properties {
    private static final long serialVersionUID = 2011051700292L;
    private static final int MAX_NESTED_LEVEL = 10;
    private static final String ARCH_BIT = BuildProps.getArchType() + "bit";
    static final String[] PREPEND_SUFFIXES = new String[]{".prepend." + ARCH_BIT, ".prepend"};
    static final String[] APPEND_SUFFIXES = new String[]{".append", ".append." + ARCH_BIT};
    private static Hashtable<String, BuildProps> allBuildProps = new Hashtable();
    private long lastModified = 0L;
    private File propertyFile;
    private final String optNameUC;

    private BuildProps(String opt, Object ref) {
        super(opt.equalsIgnoreCase("SYS") ? System.getProperties() : BuildProps.getPropsFor("SYS"));
        this.optNameUC = opt.toUpperCase();
        try {
            String fileName = BuildProps.getNmRoot() + File.separator + "nxm" + File.separator + opt.toLowerCase() + File.separator + "cfg" + File.separator + "build.props";
            if (ref != null) {
                Method getOptPathMethod = ref.getClass().getMethod("getOptPath", String.class, String.class);
                fileName = "" + getOptPathMethod.invoke(ref, (Object[])new String[]{opt, "cfg"}) + "build.props";
            }
            this.propertyFile = new File(fileName);
            if (this.propertyFile.exists()) {
                this.lastModified = this.propertyFile.lastModified();
                this.load(new FileInputStream(this.propertyFile));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to load properties file for the [" + this.optNameUC + "] option tree.", exception);
        }
        this.put("nmroot", BuildProps.getNmRoot());
        this.put("nmlibpath", BuildProps.getNmLibPath());
        allBuildProps.put(this.optNameUC, this);
    }

    public static void clearCache() {
        allBuildProps.clear();
    }

    private static String getNmRoot() {
        String nmroot = System.getProperty("NMROOT");
        if (nmroot == null) {
            String errmsg = "ERROR: The value of NMROOT is undefined. Try running this application again with '-DNMROOT=???' specified (where ??? is the path to your NMROOT).";
            System.err.println(errmsg);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(-1);
            throw new RuntimeException(errmsg);
        }
        return nmroot;
    }

    @Deprecated
    private static String getNmLibPath() {
        File[] jars = BuildProps.getNmLibs();
        StringBuffer classpath = new StringBuffer();
        if (jars.length > 0) {
            classpath.append(jars[0]);
            for (int i = 1; i < jars.length; ++i) {
                classpath.append(File.pathSeparator);
                classpath.append(jars[i]);
            }
        }
        return classpath.toString();
    }

    @Deprecated
    private static File[] getNmLibs() {
        File nxmDir = new File(BuildProps.getNmRoot() + File.separator + "nxm");
        File[] optDirs = nxmDir.listFiles();
        ArrayList<String> dirs = new ArrayList<String>();
        Hashtable<String, File> jars = new Hashtable<String, File>();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") && !name.startsWith("nxm-");
            }
        };
        dirs.add(BuildProps.getNmRoot() + File.separator + "jars");
        if (optDirs != null) {
            for (File dir : optDirs) {
                dirs.add(dir.getAbsolutePath() + File.separator + "jars");
            }
        }
        dirs.add(System.getProperty("javahome") + File.separator + "lib");
        for (String dir : dirs) {
            File[] files;
            File jarDir = new File(dir);
            if (!jarDir.exists() || !jarDir.isDirectory()) continue;
            for (File file : files = jarDir.listFiles(filter)) {
                jars.put(file.getName(), file);
            }
        }
        return jars.values().toArray(new File[0]);
    }

    private void checkForChanges() {
        try {
            if (this.propertyFile.lastModified() > this.lastModified && this.propertyFile.exists()) {
                this.lastModified = this.propertyFile.lastModified();
                this.load(new FileInputStream(this.propertyFile));
            }
        }
        catch (Exception e) {
            BuildProps.warn("BuildProps.checkForChanges: unable to check for changes to properties file: " + this.propertyFile);
            e.printStackTrace(System.err);
        }
    }

    public static final String getSysProp(String prop) {
        return BuildProps.getPropFor("SYS", prop);
    }

    public static final String getSysPath(String prop) {
        return BuildProps.getPathFor("SYS", prop);
    }

    public static final String getPropFor(String opt, String prop) {
        return BuildProps.getPropFor(opt, prop, null);
    }

    public static final String getPropFor(String opt, String prop, Object ref) {
        return BuildProps.getPropsFor(opt, ref).getProperty(prop);
    }

    public static final String getPathFor(String opt, String prop) {
        return BuildProps.getPathFor(opt, prop, null);
    }

    public static final String getPathFor(String opt, String prop, Object ref) {
        return BuildProps.getPropsFor(opt, ref).getPath(prop);
    }

    public static final BuildProps getPropsFor(String opt) {
        return BuildProps.getPropsFor(opt, null);
    }

    public static final BuildProps getPropsFor(String opt, Object ref) {
        if (opt == null) {
            throw new NullPointerException("option tree cannot be null!");
        }
        BuildProps props = allBuildProps.get(opt.toUpperCase());
        if (props != null) {
            props.checkForChanges();
        } else {
            props = new BuildProps(opt, ref);
        }
        return props;
    }

    private String expandVariables(String value, int nestedLevel) {
        int iDollar;
        int lenValue;
        if (value == null) {
            return value;
        }
        int jj = lenValue = value.length();
        while ((iDollar = value.lastIndexOf(36, jj)) >= 0) {
            block13: {
                int iEnd;
                String expandedValue;
                block12: {
                    block11: {
                        expandedValue = null;
                        if (iDollar + 1 >= lenValue || value.charAt(iDollar + 1) != '{') break block11;
                        iEnd = value.indexOf(125, iDollar);
                        if (iEnd < iDollar + 1) {
                            throw new RuntimeException("Error loading property. Syntax Error: Can not evaluate variable: Missing '}' character in ( " + value + " ).");
                        }
                        String varName = value.substring(iDollar + 2, iEnd);
                        if (nestedLevel >= 10) {
                            throw new RuntimeException("Error loading property. Too many nested levels [" + nestedLevel + "] trying to expand variable(s) in property [" + varName + "] from value [" + value + "]. Check for any recursive property variables to expand.");
                        }
                        expandedValue = this.getProperty(varName, nestedLevel + 1);
                        if (expandedValue == null) {
                            throw new RuntimeException("Error loading property. Unknown variable '${" + varName + "}'.");
                        }
                        ++iEnd;
                        break block12;
                    }
                    if (jj < 1) break block13;
                    iEnd = iDollar + jj + 1;
                }
                if (expandedValue != null) {
                    if (iEnd < lenValue) {
                        expandedValue = expandedValue + value.substring(iEnd);
                    }
                    if (iDollar == 0) {
                        return expandedValue;
                    }
                    value = value.substring(0, iDollar) + expandedValue;
                    lenValue = value.length();
                }
            }
            jj = iDollar - 1;
        }
        return value;
    }

    @Override
    public final String getProperty(String key) {
        return this.getProperty(key, 0);
    }

    private final String getProperty(String key, int nestedLevel) {
        String prop = null;
        try {
            if (key.startsWith("env.")) {
                prop = System.getProperty(key.substring(4));
            } else {
                this.checkForChanges();
                prop = super.getProperty(key);
            }
        }
        catch (RuntimeException exception) {
            BuildProps.warn("Unable to get '" + key + "' property. " + exception.getMessage());
            prop = null;
        }
        return this.expandVariables(prop, nestedLevel);
    }

    public final String getProperty(String key, String[] prependSuffixes, String[] appendSuffixes) {
        String val;
        String optDotKey = this.optNameUC + "." + key;
        StringBuilder sb = new StringBuilder();
        if (prependSuffixes != null) {
            for (String suffix : prependSuffixes) {
                val = this.getProperty(optDotKey + suffix);
                if (val == null) {
                    val = this.getProperty(key + suffix);
                }
                if (val == null || val.length() <= 0) continue;
                sb.append(val).append(" ");
            }
        }
        if ((val = this.getProperty(optDotKey)) == null) {
            val = this.getProperty(key);
        }
        if (val != null && val.length() > 0) {
            sb.append(val);
        }
        if (appendSuffixes != null) {
            for (String suffix : appendSuffixes) {
                val = this.getProperty(optDotKey + suffix);
                if (val == null) {
                    val = this.getProperty(key + suffix);
                }
                if (val == null || val.length() <= 0) continue;
                sb.append(" ").append(val);
            }
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    public final String getPath(String key) {
        return this.getPath(key, null);
    }

    public final String getPath(String key, String def) {
        String prop = this.getProperty(key, def);
        if (prop != null) {
            prop = !File.separator.equals("\\") ? prop.replaceAll("[\\\\/]", File.separator) : prop.replaceAll("[\\\\/]", "\\\\");
            return prop;
        }
        return prop;
    }

    private static final void warn(CharSequence msg) {
        System.err.println("WARN: " + msg);
    }

    static String getArchType() {
        String bits = System.getProperty("sun.arch.data.model");
        if (bits == null || bits.length() == 0 || bits.equalsIgnoreCase("unknown")) {
            String arch = System.getProperty("os.arch");
            if (arch.equals("i386")) {
                bits = "32";
            } else if (arch.equals("x86")) {
                bits = "32";
            } else if (arch.equals("ppc")) {
                bits = "32";
            } else if (arch.equals("arm")) {
                bits = "32";
            } else if (arch.equals("sparc")) {
                bits = "64";
            } else if (arch.equals("amd64")) {
                bits = "64";
            } else if (arch.equals("alpha")) {
                bits = "64";
            } else if (arch.equals("x86_64")) {
                bits = "64";
            } else {
                BuildProps.warn("Could not determine if '" + arch + "' was 32-Bit or 64-Bit, assuming 32-Bit.");
                bits = "32";
            }
        }
        return bits;
    }

    public static void main(String[] args) {
        boolean error = false;
        boolean convert2 = false;
        String prop = null;
        String opt = "sys";
        if (args == null || args.length == 0) {
            System.err.println("ERROR: No property specified.");
            error = true;
        } else if (args.length == 1) {
            prop = args[0];
        } else if (args.length == 2) {
            if (args[0].equals("-p")) {
                convert2 = true;
                prop = args[1];
            } else {
                prop = args[0];
                opt = args[1];
            }
        } else if (args.length == 3) {
            if (args[0].equals("-p")) {
                convert2 = true;
                prop = args[1];
                opt = args[2];
            } else {
                prop = args[0];
                opt = args[1];
                System.out.print("set " + args[2] + "=");
            }
        } else if (args.length == 4 && args[0].equals("-p")) {
            convert2 = true;
            prop = args[1];
            opt = args[2];
            System.out.print("set " + args[3] + "=");
        } else {
            System.err.println("ERROR: Invalid number of arguments.");
            error = true;
        }
        if (!error) {
            String value = convert2 ? BuildProps.getPathFor(opt, prop) : BuildProps.getPropsFor(opt).getProperty(prop, PREPEND_SUFFIXES, APPEND_SUFFIXES);
            System.out.println(value);
        } else {
            System.err.println();
            System.err.println("tools.BuildProps usage: [-p] PROPERTY [OPT [VNAME]]");
            System.err.println("  Gets the value of the <PROPERTY> from the build.props");
            System.err.println("  file of the <OPT> option tree (default is SYS).");
            System.err.println();
            System.err.println("  -p  Translates any path separators in the prop to");
            System.err.println("      that of the current system.");
            System.err.println("");
            System.err.println("      If optional VNAME is specified it will print out the");
            System.err.println("      property value in a 'set VNAME=' syntax (used by");
            System.err.println("      the Windows shell scripts).");
            System.exit(-1);
        }
    }
}

