/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.test;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.libg.Feature;
import nxm.sys.libg.MPlot;
import nxm.sys.prim.plot;

public class plotellipsetester
extends Primitive {
    private DataFile outFile;
    private Data outData;
    private boolean rt;
    private String rframe;
    private double tdelta;
    private double tnext;
    private double size;
    private long offset;
    private double[] pos;
    private double[] elps;
    private boolean byQuadrants;
    private boolean diagonal = false;
    private double lat = 0.0;
    private double lon = 0.0;
    private static final int HALF_LAT_RANGE = MPlot.LATITUDE_RANGE / 2;
    private static final int HALF_LON_RANGE = MPlot.LONGITUDE_RANGE / 2;
    private static final int NW_QUADRANT = 0;
    private static final int NE_QUADRANT = 1;
    private static final int SW_QUADRANT = 2;
    private static final int SE_QUADRANT = 3;
    private static final int NUM_QUADRANTS = 4;
    private static final int DIAGONAL = 4;
    private static final int RANDOM = 5;
    private static final int SNAKE = 6;
    private int quadrant;
    private byte color;
    private String directColor;
    private boolean noFlags;
    private String noteModeType = "";
    private char noteMode = (char)48;
    private char noteType = (char)65;
    private boolean useSymbols = false;
    private String symbolName = "";
    private static final String NOTE_A = "__note_";
    private String note = "";
    private double timeAdjustment = 0.0;
    private boolean outOfBounds;
    private static boolean running;
    private boolean isSnake;
    private int snakeRepeat = 0;
    private static final int NUM_SNAKE_REPEATS = 5;
    private boolean snakeAddLat = Math.random() > 0.5;
    private boolean snakeAddLon = Math.random() > 0.5;

    @Override
    public int open() {
        this.size = this.MA.getD("ELEM", 32768.0);
        this.rframe = this.MA.getS("RF", "ECR");
        this.rt = this.MA.getState("/RT");
        this.tdelta = 1.0 / this.MA.getD("/RATE", 1.0);
        this.xfer = this.MA.getL("/TL", 1);
        this.tnext = 0.0;
        this.outFile = this.MA.getDataFile("OUT");
        this.color = this.MA.getB("/COLOR", Byte.valueOf("2"));
        this.directColor = this.MA.getS("/DIRECTCOLOR", "GREEN");
        this.noteModeType = this.MA.getS("/NOTEMODETYPE", "0A");
        this.noteMode = this.noteModeType.charAt(0);
        if (this.noteModeType.length() > 1 && this.noteModeType.charAt(1) == 'Z') {
            this.noteType = (char)90;
        }
        if (this.noteMode != '\uffffffff' && ("SCVQMTA".indexOf(this.noteMode) >= 0 || "123456789X".indexOf(this.noteMode) >= 0)) {
            this.createNote();
        }
        this.useSymbols = this.MA.isPresent("/SYMBOL");
        if (this.useSymbols) {
            this.symbolName = this.MA.getS("/SYMBOL", "CROSS");
        }
        String timeString = this.MA.getS("/STARTTIME", "");
        Time startTime = Time.currentTime();
        if (!timeString.isEmpty()) {
            startTime = new Time(timeString);
            this.timeAdjustment = Time.currentTime().getSec() - startTime.getSec();
        }
        this.pos = new double[3];
        this.elps = new double[3];
        this.byQuadrants = this.MA.getState("/BQ");
        if (!this.byQuadrants) {
            this.diagonal = this.MA.getState("/DIAGONAL");
        }
        this.quadrant = this.byQuadrants ? 0 : (this.diagonal ? 4 : 5);
        this.isSnake = this.MA.getState("/SNAKE");
        if (this.isSnake) {
            this.quadrant = 6;
            this.lat = plotellipsetester.randomLat();
            this.lon = plotellipsetester.randomLon();
        }
        this.noFlags = this.MA.getState("/NOFLAGS");
        this.outOfBounds = this.MA.getState("/OUTOFBOUNDS");
        String noteComponent = this.note.isEmpty() ? "" : ",NOTE/" + this.noteMode + "" + this.noteType + "/0/0";
        String flagComponent = this.noFlags ? "" : ",FLAG/8B/0/0";
        String symbolComponent = !this.useSymbols ? "" : ",SYMBOL/2A/0/0";
        this.outFile.setComponents("POS/VD/6/5,ELPS/VD/0/0,NAME/2A/0/0,COLOR/2A/0/0" + flagComponent + noteComponent + symbolComponent);
        this.outFile.setSize(this.size);
        this.outFile.open(2);
        this.outFile.setTime(startTime);
        this.outFile.setDelta(this.tdelta);
        this.outFile.setReferenceFrame(this.rframe);
        this.outData = this.outFile.getDataBuffer(1);
        return 0;
    }

    @Override
    public int process() {
        int status = 0;
        double time = Time.current() - this.timeAdjustment;
        if (this.rt && time < this.tnext) {
            status = -1;
        } else {
            double latSubtract;
            double lonSubtract;
            double lonFactor;
            double latFactor;
            switch (this.quadrant) {
                case 0: {
                    latFactor = this.outOfBounds ? 85.0 : 70.0;
                    lonFactor = this.outOfBounds ? -190.0 : -180.0;
                    lonSubtract = 0.0;
                    latSubtract = 0.0;
                    break;
                }
                case 1: {
                    latFactor = this.outOfBounds ? 85.0 : 70.0;
                    lonFactor = this.outOfBounds ? 190.0 : 180.0;
                    lonSubtract = 0.0;
                    latSubtract = 0.0;
                    break;
                }
                case 3: {
                    latFactor = this.outOfBounds ? -85.0 : -70.0;
                    lonFactor = this.outOfBounds ? 190.0 : 180.0;
                    lonSubtract = 0.0;
                    latSubtract = 0.0;
                    break;
                }
                case 2: {
                    latFactor = this.outOfBounds ? -85.0 : -70.0;
                    lonFactor = this.outOfBounds ? -190.0 : -180.0;
                    lonSubtract = 0.0;
                    latSubtract = 0.0;
                    break;
                }
                case 4: {
                    latFactor = 1.0;
                    lonFactor = 2.0;
                    lonSubtract = 0.0;
                    latSubtract = 0.0;
                    break;
                }
                case 6: {
                    lonSubtract = 0.0;
                    latSubtract = 0.0;
                    lonFactor = 0.0;
                    latFactor = 0.0;
                    break;
                }
                default: {
                    latFactor = this.outOfBounds ? 170.0 : 140.0;
                    lonFactor = this.outOfBounds ? 380.0 : 360.0;
                    latSubtract = this.outOfBounds ? 85.0 : 70.0;
                    double d = lonSubtract = this.outOfBounds ? 190.0 : 180.0;
                }
            }
            if (this.byQuadrants) {
                this.quadrant = (this.quadrant + 1) % 4;
            }
            for (int i = 0; i < this.xfer && (double)this.offset < this.size; ++i) {
                if (this.quadrant == 6) {
                    if (this.isSnake) {
                        this.snakeRepeat = this.snakeRepeat++ % 5;
                        if (this.snakeRepeat == 0) {
                            this.lat += this.snakeAddLat ? Math.random() * 0.5 : Math.random() * -0.5;
                            this.lon += this.snakeAddLon ? Math.random() * 0.5 : Math.random() * -0.5;
                        }
                    }
                    if (this.lat > 90.0) {
                        this.lat = 90.0;
                        this.snakeAddLat = !this.snakeAddLat;
                    } else if (this.lat < -90.0) {
                        this.lat = -90.0;
                        boolean bl = this.snakeAddLat = !this.snakeAddLat;
                    }
                    if (this.lon > 180.0) {
                        this.lon = -180.0;
                    } else if (this.lon < -180.0) {
                        this.lon = 180.0;
                    }
                } else if (this.quadrant != 4) {
                    this.lat = Math.random() * latFactor - latSubtract;
                    this.lon = Math.random() * lonFactor - lonSubtract;
                } else {
                    this.lat = (this.lat + (double)HALF_LAT_RANGE + latFactor) % (double)MPlot.LATITUDE_RANGE - (double)HALF_LAT_RANGE;
                    this.lon = (this.lon + (double)HALF_LON_RANGE + lonFactor) % (double)MPlot.LONGITUDE_RANGE - (double)HALF_LON_RANGE;
                }
                this.outData.packD(0, 0.0);
                this.outData.packD(8, this.lat);
                this.outData.packD(16, this.lon);
                this.outData.packD(24, 30000.0);
                this.outData.packD(32, 7000.0);
                this.outData.packD(40, 45.0);
                this.outData.packS(48, 16, "POINT_" + this.offset);
                this.outData.packS(64, 16, this.directColor);
                if (!this.noFlags) {
                    this.outData.packB(80, (byte)0);
                    this.outData.packB(81, (byte)0);
                    this.outData.packB(82, this.color);
                    this.outData.packB(83, (byte)2);
                    this.outData.packB(84, Byte.valueOf("-9"));
                    this.outData.packB(85, (byte)1);
                    this.outData.packB(86, (byte)4);
                    this.outData.packB(87, (byte)4);
                }
                int symbolStart = 0;
                if (!this.note.isEmpty()) {
                    int noteStart = this.noFlags ? 80 : 88;
                    int len = Data.getSPA(this.noteMode) * Data.getBPS(this.noteType);
                    this.outData.packS(noteStart, len, this.note);
                    symbolStart = noteStart + len;
                }
                if (this.useSymbols) {
                    this.outData.packS(symbolStart, 16, this.symbolName);
                }
                this.outFile.write(this.outData);
                ++this.offset;
            }
            this.tnext = this.tnext == 0.0 ? time + this.tdelta : (this.tnext += this.tdelta * (double)this.xfer);
        }
        return (double)this.offset < this.size ? status : 9;
    }

    @Override
    public int close() {
        if (this.outFile != null) {
            this.outFile.close();
        }
        running = false;
        return 0;
    }

    public static void resetPlot(final plot plot2, int sleep) {
        running = true;
        final int waitTime = sleep * 1000;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                int factorX = 1;
                int factorY = 1;
                while (running) {
                    if (System.currentTimeMillis() - start <= (long)waitTime) continue;
                    Table feat = new Table();
                    Table line = new Table();
                    line.put("Color", (Object)"RED");
                    feat.put("NAME", (Object)("FEAT" + start));
                    feat.put("TYPE", (Object)"Circle");
                    feat.put("LINE", (Object)line);
                    feat.put("X", Math.random() * 180.0 * (double)factorX);
                    feat.put("Y", Math.random() * 90.0 * (double)factorY);
                    feat.put("DX", Math.random() * 20.0);
                    plot2.MP.clearData();
                    if (start % 2L == 0L) {
                        factorY *= -1;
                    }
                    plot2.MP.addFeature(new Feature(feat));
                    factorX *= -1;
                    start = System.currentTimeMillis();
                }
            }
        });
        t.start();
    }

    private void createNote() {
        int atypeMultiplier = this.noteType == 'Z' ? 32 : 1;
        int repeats = Data.getSPA(this.noteMode) * atypeMultiplier;
        for (int i = 1; i <= repeats; ++i) {
            this.note = this.note + NOTE_A + i % 10;
        }
    }

    public static double randomLon() {
        return Math.random() * 355.0 - 177.5;
    }

    public static double randomLat() {
        return Math.random() * 175.0 - 87.5;
    }
}

