/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import nxm.sys.lib.Data;
import nxm.sys.lib.Table;

public final class TestUtil {
    private TestUtil() {
    }

    public static final void throwRuntimeException() {
        throw new RuntimeException("Sample RuntimeException");
    }

    public static final void throwAnonClassRuntimeException() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                TestUtil.throwRuntimeException();
            }
        };
        r.run();
    }

    public static final void throwNestedClassRuntimeException() {
        MyRunnable r = new MyRunnable();
        r.run();
    }

    public static final Object exceptionInToString() {
        return new Object(){

            public String toString() {
                throw new RuntimeException("Sample RuntimeException");
            }
        };
    }

    public static double[] createDoubleArray(String commaSeparatedValues) {
        String[] sValues = commaSeparatedValues.split(",");
        double[] dArray = new double[sValues.length];
        int i = 0;
        for (String value : sValues) {
            dArray[i++] = Double.valueOf(value);
        }
        return dArray;
    }

    public static boolean tablesEqual(Table table1, Table table2) {
        if (table1 == null) {
            return table2 == null;
        }
        if (table1.getKeys().length != table2.getKeys().length) {
            return false;
        }
        return TestUtil.tableSubset(table1, table2);
    }

    public static boolean tableSubset(Table table1, Table table2) {
        if (table1 == null) {
            return table2 == null;
        }
        if (table2 == null) {
            return false;
        }
        for (String t1_key : table1.getKeys()) {
            if (!table2.containsKey(t1_key)) {
                return false;
            }
            Object tab1value = table2.getKey(t1_key);
            Object tab2value = table2.getKey(t1_key);
            if (tab1value instanceof Data && tab1value instanceof Data) {
                return ((Data)tab1value).equals((Data)tab2value, 512, 0.006);
            }
            if (table2.getKey(t1_key).toString().equals(table1.getKey(t1_key).toString())) continue;
            return false;
        }
        return true;
    }

    public static String getPermutations(String list3) {
        if (list3.charAt(0) == '|') {
            list3 = list3.substring(1);
        }
        if (list3.endsWith("|")) {
            list3 = list3.substring(0, list3.length() - 1);
        }
        list3 = list3.replace('|', ',');
        String[] split2 = list3.split(",");
        ArrayList<String> allPerms = new ArrayList<String>();
        TestUtil.strPermutations(split2.length, split2, "", allPerms);
        String perms = allPerms.toString();
        perms = perms.substring(1, perms.length() - 1);
        return perms;
    }

    private static void strPermutations(int num, String[] options, String currentPermutation, ArrayList<String> result) {
        if (num == 0) {
            HashSet<String> unique;
            String[] components = currentPermutation.split("::");
            if (components.length == (unique = new HashSet<String>(Arrays.asList(components))).size()) {
                result.add(currentPermutation);
            }
        } else {
            for (int i = 0; i < options.length; ++i) {
                String beginning = currentPermutation.isEmpty() ? "" : currentPermutation + "::";
                TestUtil.strPermutations(num - 1, options, beginning + options[i], result);
            }
        }
    }

    public static final class MyRunnable
    implements Runnable {
        @Override
        public void run() {
            TestUtil.throwRuntimeException();
        }
    }
}

