/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.test;

import java.io.File;
import java.io.IOException;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Time;

public class LayerKmlTestHelper {
    private static volatile boolean isRunning;
    private static String baseDir;
    static long swapCount;
    static final String mainFile;
    static final String newFile;
    static final String origFile;
    static File fileOrig;
    static File fileNew;
    static File fileMain;

    @Deprecated
    public LayerKmlTestHelper() {
    }

    private static Thread getThread() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (isRunning) {
                    if (swapCount % 2L == 0L) {
                        LayerKmlTestHelper.swapFile(fileOrig, fileMain);
                    } else {
                        LayerKmlTestHelper.swapFile(fileNew, fileMain);
                    }
                    for (int count = 0; isRunning && count < 50; ++count) {
                        Time.sleep(0.1);
                    }
                    ++swapCount;
                }
                LayerKmlTestHelper.close();
            }
        });
        return t;
    }

    public static void startSwapping() {
        if (isRunning) {
            return;
        }
        isRunning = true;
        Thread t = LayerKmlTestHelper.getThread();
        t.start();
    }

    private static void swapFile(File src, File dst) {
        try {
            FileUtil.copy(src, dst);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void close() {
        LayerKmlTestHelper.swapFile(fileOrig, fileMain);
    }

    public static void setRunning(boolean isRunning) {
        LayerKmlTestHelper.isRunning = isRunning;
    }

    public static boolean isRunning() {
        return isRunning;
    }

    public static void setupLayerKmlTest() {
        LayerKmlTestHelper.swapFile(fileOrig, fileMain);
    }

    static {
        baseDir = Shell.isRunningFromJarFile() ? Shell.getAuxPath("WRITE") : Shell.getNmRoot() + "nxm/sys/test/";
        swapCount = 0L;
        mainFile = baseDir + "kmlTest.kml";
        newFile = baseDir + "kmlTestLeft.kml";
        origFile = baseDir + "kmlTestRight.kml";
        fileOrig = new File(origFile);
        fileNew = new File(newFile);
        fileMain = new File(mainFile);
    }
}

