/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.awt.Color;
import java.util.concurrent.atomic.AtomicInteger;
import nxm.sys.inc.Installation;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.XGeoPlotIF;
import nxm.sys.lib.Args;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.MaskValue;
import nxm.sys.lib.Message;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Position;
import nxm.sys.lib.StateVector;
import nxm.sys.lib.Table;
import nxm.sys.lib.Util;
import nxm.sys.lib.XmUtil;
import nxm.sys.libg.Feature;
import nxm.sys.libg.Layer;
import nxm.sys.libg.LayerGeo;
import nxm.sys.libg.LayerT5;
import nxm.sys.libg.Line;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MPlot;
import nxm.sys.prim.plot;

public class xgeoplot
extends plot
implements XGeoPlotIF {
    private boolean debug = false;
    private String resName_XCLICK = null;
    private String resName_YCLICK = null;
    private LayerGeo[] geoLayers = null;
    private StateVector[] stateVectors = null;
    private String markerName = null;
    private double referenceTime = 0.0;
    private static final int XGEO_SETVIEW_LATLON = 1;
    private static final int XGEO_SETVIEW_PERSPECTIVE = 2;
    private static final int XGEO_SETVIEW_SVA = 3;
    private static final int XGEO_SETVIEW_SVB = 4;
    private static AtomicInteger t5AutoNameCounter = new AtomicInteger(1);

    @Override
    public int open() {
        int status = super.open();
        this.debug = this.MA.getState("/DEBUG", this.debug);
        String xmTitle = this.MA.getCS("/XN", "XGEOPLOT");
        String mtag = this.MA.getS("/MTAG", null);
        this.parseMTAG(mtag);
        this.MW.setTitle(xmTitle);
        this.info("mtag " + mtag + " res names X -> " + this.resName_XCLICK + ", Y -> " + this.resName_YCLICK);
        String siteFile = this.MA.getS("SITE", "SITE");
        Position sitePos = new Position(this.M, (Object)siteFile);
        this.info("SITE FILE = " + siteFile + ", pos " + sitePos);
        String svString = this.MA.getRaw("SV");
        if (svString == null) {
            svString = "";
        }
        Args.SplitArg splitSVs = this.MA.getSplitArg(svString, '|');
        int numSVs = splitSVs.getFields();
        this.info("State Vectors " + svString + " # = " + numSVs);
        if (numSVs > 0) {
            this.stateVectors = new StateVector[numSVs];
            for (int i = 0; i < splitSVs.getFields(); ++i) {
                this.stateVectors[i] = new StateVector(this.M, (Object)splitSVs.getField(i));
                this.debug("SV[" + i + "] = " + this.stateVectors[i]);
            }
        }
        this.referenceTime = this.MA.getD("REFTIME", this.referenceTime);
        this.initGeoLayers(sitePos);
        return status;
    }

    @Override
    public int processMessage(Message msg) {
        boolean fromMe = msg.from == this;
        boolean fromMPlot = msg.from instanceof MPlot;
        int retStatus = 0;
        String msgName = msg.getName();
        if (!(!this.debug || "POINTER".equals(msgName) || "FOCUS".equals(msgName) || "REFRESH".equals(msgName) || "DRAG".equals(msgName) || "RESIZE".equals(msgName) || "PAINT".equals(msgName))) {
            this.debug("got message " + msgName + " from " + Util.getClassName(msg.from) + " fid " + msg.getFromID() + " info " + msg.info + " data " + msg.data);
            this.debug("  fromMe? " + fromMe + " from MPlot " + fromMPlot);
        }
        if (fromMe) {
            if (!this.processMessageFromMe(msg)) {
                retStatus = super.processMessage(msg);
            }
        } else if (fromMPlot) {
            retStatus = super.processMessage(msg);
        } else if (!this.processExternalMessage(msg)) {
            retStatus = super.processMessage(msg);
        }
        return retStatus;
    }

    private boolean processMessageFromMe(Message msg) {
        boolean processed = true;
        if (msg.getName().equals("MARK")) {
            Position pos = (Position)msg.data;
            this.MR.put("XM." + this.resName_XCLICK, pos.getLon());
            this.MR.put("XM." + this.resName_YCLICK, pos.getLat());
        } else {
            processed = false;
        }
        return processed;
    }

    private boolean processExternalMessage(Message msg) {
        boolean processed = true;
        try {
            if (msg.getName().equals("T5REC") || msg.getName().equals("T5TEXT")) {
                this.processT5TEXTorT5REC(msg);
            } else if (msg.getName().equals("T5LAYER")) {
                this.processT5LAYER(msg);
            } else if (msg.getName().equals("TRACE")) {
                this.processTRACE(msg);
            } else if (msg.getName().equals("MARKER")) {
                this.processMARKER(msg);
            } else if (msg.getName().equals("SETD")) {
                this.processSETD(msg);
            } else if (msg.getName().equals("NEWFILE")) {
                this.processNEWFILE(msg);
            } else if (msg.getName().equals("REREAD")) {
                this.processREREAD(msg);
            } else if (msg.getName().equals("SETVIEW")) {
                this.processSETVIEW(msg);
            } else if (msg.getName().equals("ZOOM")) {
                this.processZOOM(msg);
            } else if (msg.getName().equals("OVERLAY")) {
                this.openFileWithLimits(msg);
            } else {
                processed = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.warn("Could not process " + msg.getName() + " message - exception " + e);
        }
        return processed;
    }

    private int processREREAD(Message msg) {
        int status = 0;
        if (msg.info == 0) {
            for (int n = 1; n < this.MP.layers.getSize(); ++n) {
                Layer layer = (Layer)this.MP.layers.get(n);
                this.print("REREAD - > Layer = " + layer + ", file " + layer.getFile().getURL());
                Table layerTable = this.getLayerTable(layer, "" + msg.data);
                layer.close();
                this.setFile(layer.getFile().getURL() + layerTable.toString());
            }
        } else {
            Layer layer = this.getLayer(msg.info);
            if (layer != null) {
                this.print("REREAD - > Layer = " + layer + ", file='" + layer.getFile().getURL() + "'");
                Table layerTable = this.getLayerTable(layer, "" + msg.data);
                layer.close();
                this.setFile(layer.getFile().getURL() + layerTable.toString());
            } else {
                this.warn("REREAD Could not find layer number" + msg.info);
            }
        }
        return status;
    }

    private Table getLayerTable(Layer layer, String fileStr) {
        FileName fname = new FileName(fileStr);
        Table qualTable = fname.getQualifierTable();
        Color prevColor = layer.getLine().getColor();
        Table tempTab = new Table();
        tempTab.put("COLOR", (Object)MColor.toString(prevColor));
        Table layerTable = new Table();
        layerTable.put("LAYER", (Object)tempTab);
        if (qualTable != null) {
            layerTable.merge(qualTable);
        }
        return layerTable;
    }

    private int processSETD(Message msg) {
        Table dataTab = Convert.o2t(msg.data);
        String key = dataTab.getS("OBJECT");
        double dval = dataTab.getD("VALUE");
        this.debug("Processing " + msg.getName() + " info " + msg.info + " key " + key + " dval " + dval);
        int modMask = (int)dval;
        int status = 0;
        if (key.equals("LAYER") && msg.info >= 0) {
            status = this.processSETD_LAYER(msg.info, modMask);
        } else if (key.equals("EVENT") && msg.info > 0) {
            status = this.processSETD_EVENT(msg.info, modMask);
        } else {
            this.warn("Unrecognized key: " + key + " for SETD message");
        }
        return status;
    }

    private int processSETD_LAYER(int layNum, int modMask) {
        Layer layer = this.getLayer(layNum);
        if (layer != null) {
            this.debug("SETD_LAYER for layer '" + layer.getClass() + "'");
            if (modMask == 0) {
                layer.setEnable("-GLOBAL");
            }
            if (modMask == 1) {
                layer.setEnable("+GLOBAL");
            }
            if (modMask > 1) {
                StringBuffer sb = new StringBuffer("|");
                if (xgeoplot.btest(modMask, 1)) {
                    sb.append("GLOBAL|");
                }
                if (xgeoplot.btest(modMask, 2)) {
                    sb.append("LABELS|");
                }
                if (xgeoplot.btest(modMask, 3)) {
                    sb.append("BSTORE|");
                }
                if (xgeoplot.btest(modMask, 4)) {
                    sb.append("BASE|");
                }
                if (xgeoplot.btest(modMask, 5)) {
                    sb.append("ZOOM|");
                }
                if (xgeoplot.btest(modMask, 6)) {
                    sb.append("FASTBASE|");
                }
                if (xgeoplot.btest(modMask, 7)) {
                    sb.append("FASTZOOM|");
                }
                this.debug("Enables string '" + sb + "'");
                layer.setEnable(sb.toString());
            }
        } else {
            this.warn("Could not find layer number " + layNum + ", # layers = " + this.MP.getLayers().size());
        }
        return 0;
    }

    private int processSETD_EVENT(int eventNum, int modMask) {
        int glNum = eventNum - 1;
        if (glNum <= this.geoLayers.length - 1) {
            LayerGeo geoLay = this.geoLayers[glNum];
            if (modMask == 0) {
                geoLay.setEnable("-GLOBAL");
            }
            if (modMask == 1) {
                geoLay.setEnable("+GLOBAL");
            }
            if (modMask > 1) {
                StringBuffer sb = new StringBuffer("|");
                if (xgeoplot.btest(modMask, 1)) {
                    sb.append("GLOBAL|");
                }
                if (xgeoplot.btest(modMask, 2)) {
                    sb.append("LABELS|");
                }
                if (xgeoplot.btest(modMask, 3)) {
                    sb.append("BSTORE|");
                }
                if (xgeoplot.btest(modMask, 4)) {
                    sb.append("BASE|");
                }
                if (xgeoplot.btest(modMask, 5)) {
                    sb.append("ZOOM|");
                }
                if (xgeoplot.btest(modMask, 6)) {
                    sb.append("FASTBASE|");
                }
                if (xgeoplot.btest(modMask, 7)) {
                    sb.append("FASTZOOM|");
                }
                this.debug("Enables string '" + sb + "'");
                geoLay.setEnable(sb.toString());
            }
        } else {
            this.warn("SETD_EVENT - Invalid event number " + eventNum + " num events = " + this.geoLayers.length);
        }
        return 0;
    }

    private int processNEWFILE(Message msg) {
        int retStatus = 0;
        Table dataTab = Convert.o2t(msg.data);
        int fileTypes = msg.info;
        String filenames = dataTab.getS("FILENAME");
        if (fileTypes == 0) {
            fileTypes = 3;
        }
        switch (fileTypes) {
            case 1: {
                break;
            }
            case 2: {
                retStatus = this.processNEWFILE_STATEVECTOR(filenames);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                retStatus = this.processNEWFILE_EVENT(filenames);
                break;
            }
            case 5: {
                break;
            }
        }
        return 0;
    }

    private int processNEWFILE_EVENT(String filenames) {
        this.debug("Processing NEWFILE event " + filenames);
        Args.SplitArg sa = this.MA.getSplitArg(filenames, '|');
        int numEvents = sa.getFields();
        if (numEvents > 0) {
            for (int i = 0; i < numEvents; ++i) {
                String name = sa.getField(i);
                this.debug("Event[" + i + "] = " + name);
                this.loadEventFile(name);
            }
        }
        return 0;
    }

    private int processNEWFILE_STATEVECTOR(String filenames) {
        this.debug("Processing NEWFILE state vector " + filenames);
        this.warn("------------> TBD -- how to process new state vectors...");
        Args.SplitArg sa = this.MA.getSplitArg(filenames, '|');
        int numSVs = sa.getFields();
        if (numSVs > 0) {
            this.stateVectors = new StateVector[numSVs];
            for (int i = 0; i < numSVs; ++i) {
                String name = sa.getField(i);
                this.debug("SV[" + i + "] = " + name);
            }
        } else {
            this.warn("No files found in string " + filenames);
        }
        return 0;
    }

    private int processMARKER(Message msg) {
        int colorNum = msg.info;
        Table dataTab = Convert.o2t(msg.data);
        String oldMarkerName = this.markerName;
        Feature marker = null;
        if (this.markerName == null) {
            this.debug("MARKER - creating feature for PLOT ...");
            this.markerName = new String("MARKER");
            marker = new Feature();
            marker.setType("OSYMBOL");
            this.MP.addFeature(this.markerName, marker);
        } else {
            this.debug("MARKER - getting '" + this.markerName + "' feature from PLOT ...");
            marker = (Feature)this.MP.getFeatures().get(this.markerName);
        }
        this.debug("MARKER - marker name '" + this.markerName + "' marker " + marker);
        if (dataTab != null) {
            this.debug("MARKER - setting X = " + dataTab.getD("VAL2") + " Y = " + dataTab.getD("VAL1") + " Z = " + dataTab.getD("VAL3"));
            double lat = dataTab.getD("VAL1", -999.0);
            double lon = dataTab.getD("VAL2", -999.0);
            double alt = dataTab.getD("VAL3");
            String newMarkerName = dataTab.getS("VAL4", "");
            String text = dataTab.getS("VAL5");
            if (lon != -999.0) {
                marker.setX(lon);
            }
            if (lat != -999.0) {
                marker.setY(lat);
            }
            if (dataTab.containsKey("VAL3")) {
                marker.setZ(alt);
            }
            if (!newMarkerName.equals("")) {
                this.debug("MARKER --------==============> newMarkerName '" + newMarkerName + "'");
                this.markerName = newMarkerName;
                marker.setName(this.markerName);
            }
            if (dataTab.containsKey("VAL5")) {
                marker.setText(text);
            }
            this.debug("Lat " + dataTab.getD("VAL1") + " lon " + dataTab.getD("VAL2") + " alt " + dataTab.getD("VAL3") + " markerName " + this.markerName + " colornum " + colorNum + " text '" + dataTab.getS("VAL5") + "'");
        }
        if (colorNum > 0) {
            marker.getLine().setColor(colorNum);
        } else {
            marker.getLine().setColor("RED");
        }
        return 0;
    }

    private int processT5TEXTorT5REC(Message msg) {
        Table dataTab = Convert.o2t(msg.data);
        int layerNum = dataTab.getL("LAYER");
        int modMask = msg.info;
        String maskStr = dataTab.getS("MODMASK");
        if (maskStr != null && maskStr.length() != 0) {
            MaskValue<Enum> maskVal;
            if (msg.getName().equals("T5REC")) {
                maskVal = MaskValue.fromString(maskStr, T5REC_MODMASK_BITS.class);
                modMask = maskVal.getHexValue() * 2;
            } else {
                maskVal = MaskValue.fromString(maskStr, T5TEXT_MODMASK_BITS.class);
                modMask = maskVal.getHexValue() * 2;
            }
        }
        int index = dataTab.getL("INDEX");
        int offset = index - 1;
        boolean mergeAllPoints = index == 0;
        this.debug(msg.getName() + " - Layer number " + layerNum + " index " + index + " allpts? " + mergeAllPoints + " mod mask " + modMask + " DATA: " + dataTab);
        Table rowTab = new Table();
        Table posTab = new Table();
        if (xgeoplot.btest(modMask, 1)) {
            posTab.put("ALT", dataTab.getD("ALT"));
        }
        if (xgeoplot.btest(modMask, 2)) {
            posTab.put("LAT", dataTab.getD("LAT"));
        }
        if (xgeoplot.btest(modMask, 3)) {
            posTab.put("LON", dataTab.getD("LON"));
        }
        if (xgeoplot.btest(modMask, 4)) {
            rowTab.put("NAME", (Object)dataTab.getS("NAME"));
        }
        if (msg.getName().equals("T5REC")) {
            double range = dataTab.getD("R");
            Table posPTab = new Table();
            Table elpsTab = new Table();
            Table coneInfoTab = new Table();
            if (range == -1.0) {
                if (xgeoplot.btest(modMask, 5)) {
                    posPTab.put("ALT", dataTab.getD("AZIM"));
                }
                if (xgeoplot.btest(modMask, 6)) {
                    posPTab.put("LAT", dataTab.getD("ELEV"));
                }
                if (xgeoplot.btest(modMask, 7)) {
                    posPTab.put("LON", dataTab.getD("ROLL"));
                }
            } else if (range == 0.0) {
                if (xgeoplot.btest(modMask, 9)) {
                    elpsTab.put("SEMIMAJOR", dataTab.getD("A"));
                }
                if (xgeoplot.btest(modMask, 10)) {
                    elpsTab.put("SEMIMINOR", dataTab.getD("B"));
                }
                if (xgeoplot.btest(modMask, 5)) {
                    elpsTab.put("TILT", dataTab.getD("AZIM"));
                }
            } else {
                this.warn("T5REC: POSP conversion from Az El Roll Range(R) SemiMajor(A) SemiMinor(B) is not implemented yet");
                if (xgeoplot.btest(modMask, 5)) {
                    coneInfoTab.put("AZIM", dataTab.getD("AZIM"));
                }
                if (xgeoplot.btest(modMask, 6)) {
                    coneInfoTab.put("ELEV", dataTab.getD("ELEV"));
                }
                if (xgeoplot.btest(modMask, 7)) {
                    coneInfoTab.put("ROLL", dataTab.getD("ROLL"));
                }
                coneInfoTab.put("HEIGHT", range);
                if (xgeoplot.btest(modMask, 9)) {
                    coneInfoTab.put("SEMIMAJOR", dataTab.getD("A"));
                }
                if (xgeoplot.btest(modMask, 10)) {
                    coneInfoTab.put("SEMIMINOR", dataTab.getD("B"));
                }
            }
            Table flagTab = new Table();
            if (xgeoplot.btest(modMask, 11)) {
                flagTab.put("COLOR", dataTab.getB("COLOR"));
            }
            if (xgeoplot.btest(modMask, 12)) {
                flagTab.put("SYMBOLID", dataTab.getB("SYMBOL"));
            }
            if (xgeoplot.btest(modMask, 13)) {
                flagTab.put("SYMBOLSIZE", dataTab.getB("SIZE"));
            }
            if (xgeoplot.btest(modMask, 14)) {
                flagTab.put("CONE", dataTab.getB("CONE"));
            }
            if (xgeoplot.btest(modMask, 15)) {
                flagTab.put("INVERT", dataTab.getB("INVERT"));
            }
            if (posTab.getSize() > 0) {
                rowTab.put("POS", (Object)posTab);
            }
            if (posPTab.getSize() > 0) {
                rowTab.put("POSP", (Object)posPTab);
            }
            if (elpsTab.getSize() > 0) {
                rowTab.put("ELPS", (Object)elpsTab);
            }
            if (flagTab.getSize() > 0) {
                rowTab.put("FLAG", (Object)flagTab);
            }
        } else {
            this.debug(msg.getName() + " SYMBOL id " + dataTab.getB("SYMBOL") + " name " + XmUtil.getXmSymbolName(dataTab.getB("SYMBOL")));
            Table flagTab = new Table();
            this.debug(msg.getName() + " data table " + dataTab);
            if (xgeoplot.btest(modMask, 5)) {
                rowTab.put("NOTE", (Object)dataTab.getS("TEXT"));
            }
            if (xgeoplot.btest(modMask, 6)) {
                flagTab.put("COLOR", dataTab.getB("COLOR"));
            }
            if (xgeoplot.btest(modMask, 7)) {
                flagTab.put("SYMBOLID", dataTab.getB("SYMBOL"));
            }
            if (xgeoplot.btest(modMask, 8)) {
                flagTab.put("SYMBOLSIZE", dataTab.getB("SIZE"));
            }
            if (xgeoplot.btest(modMask, 10)) {
                flagTab.put("INVERT", dataTab.getB("INVERT"));
            }
            if (posTab.getSize() > 0) {
                rowTab.put("POS", (Object)posTab);
            }
            if (flagTab.getSize() > 0) {
                rowTab.put("FLAG", (Object)flagTab);
            }
        }
        this.debug(msg.getName() + " ROW " + rowTab + " layer at " + layerNum + " " + this.getLayer(layerNum));
        Layer layer = this.getLayer(layerNum);
        if (layer instanceof LayerT5) {
            LayerT5 layt5 = (LayerT5)layer;
            if (!Installation.ApplyBugFix.XGEOPLOT_T5REC_MSG_MERGE_PROPERTIES) {
                layt5.setPoint(offset, rowTab);
            } else if (mergeAllPoints) {
                layt5.mergeAllPoints(rowTab);
            } else {
                layt5.mergePoint(offset, rowTab);
            }
        } else {
            this.M.warning("The layer I got, " + layer.getName() + ", is not the right type, LayerT5");
        }
        return 0;
    }

    private int processT5LAYER(Message msg) {
        Table dataTab = Convert.o2t(msg.data);
        String action = dataTab.getS("ACTION");
        int layerNum = msg.info;
        if (action.equals("CREATE")) {
            int nelem = dataTab.getL("P1");
            LayerT5 createdT5 = new LayerT5(nelem);
            createdT5.setName("T5_" + t5AutoNameCounter.getAndIncrement());
            this.MP.addLayer(createdT5);
        } else if (action.equals("DELETE")) {
            Layer layer;
            int indexFirstDelete = dataTab.getL("P1") - 1;
            int indexLastDelete = dataTab.getL("P2");
            int n = indexLastDelete = indexLastDelete == -1 ? -1 : indexLastDelete - 1;
            if (indexLastDelete != -1 && indexLastDelete < indexFirstDelete) {
                this.M.error("T5LAYER DELETE Message has P2 less than P1:" + msg);
            }
            if ((layer = this.getLayer(layerNum)) instanceof LayerT5) {
                LayerT5 layt5 = (LayerT5)layer;
                layt5.deletePoints(indexFirstDelete, indexLastDelete);
            } else {
                this.M.warning("The layer I got, " + layer.getName() + ", is not the right type, LayerT5");
            }
        } else if (action.equals("COPY")) {
            int indexOriginal = dataTab.getL("P1") - 1;
            int indexForCopy = dataTab.getL("P2") - 1;
            Layer layer = this.getLayer(layerNum);
            if (layer instanceof LayerT5) {
                LayerT5 layt5 = (LayerT5)layer;
                layt5.copyPoint(indexOriginal, indexForCopy);
            } else {
                this.M.warning("The layer I got, " + layer.getName() + ", is not the right type, LayerT5");
            }
        } else {
            this.warn("Unsupported T5LAYER message action: " + action);
        }
        return 0;
    }

    private int processTRACE(Message msg) {
        Table dataTab = Convert.o2t(msg.data);
        int layerNum = msg.info;
        Layer layer = this.getLayer(layerNum);
        this.debug("TRACE: layer number " + layerNum + " layer " + layer);
        if (layer != null) {
            int colorNum = dataTab.getL("COLOR");
            if (colorNum == 999) {
                this.M.warning("Special processing for TRACE with COLOR=999 is TBD");
            } else {
                Line line = layer.getLine();
                this.debug("Current line " + line);
                this.debug("Current symbol " + line.getSymbol());
                if (line.getSymbol() != null) {
                    this.debug("Current symbol name " + line.getSymbol().getName());
                    int lineTypeNum = dataTab.getL("LINETYPE");
                    int thickness = dataTab.getL("THICK");
                    String xmSymbol = dataTab.getS("SYMBOL");
                    String symbol = this.convertXMSymbolToNXM(xmSymbol, line.getSymbol().getName());
                    int radius = dataTab.getL("RADIUS");
                    line.setColor(colorNum);
                    line.setRadius(radius);
                    line.setSymbol(symbol);
                    if (lineTypeNum != 0) {
                        // empty if block
                    }
                    if (thickness > 0) {
                        line.setThickness(thickness);
                    }
                    this.debug("New line " + line);
                } else {
                    this.warn("TRACE - SYMBOL is NULL, WHY????????????");
                }
            }
        }
        return 0;
    }

    public String convertXMSymbolToNXM(String xmsym, String def) {
        String symbol = def;
        if (xmsym.length() != 0) {
            if (this.M_SEARCH("NONE", xmsym)) {
                symbol = "NONE";
            } else if (this.M_SEARCH("PIXELS", xmsym)) {
                this.M.warning("PIXEL symbol is TBD");
            } else if (this.M_SEARCH("CIRCLES", xmsym)) {
                symbol = "CIRCLE";
            } else if (this.M_SEARCH("SQUARES", xmsym)) {
                symbol = "SQUARE";
            } else if (xmsym.equals("+")) {
                symbol = "PLUS";
            } else if (xmsym.equals("X")) {
                symbol = "CROSS";
            } else if (this.M_SEARCH("TRIANGLES", xmsym)) {
                symbol = "TRIANGLE";
            } else if (this.M_SEARCH("ITRIANGLES", xmsym)) {
                symbol = "UTRIANGLE";
            } else if (xmsym.startsWith("ASCII:")) {
                symbol = "ASCII-" + xmsym.substring(6);
            } else {
                this.M.warning("TRACE unknown symbol " + xmsym + " ignored.");
            }
        }
        return symbol;
    }

    private boolean M_SEARCH(String toSearch, String sub) {
        return toSearch.indexOf(sub) > 0;
    }

    private int processSETVIEW(Message msg) {
        Table dataTab = Convert.o2t(msg.data);
        this.debug(" SETVIEW -> data " + msg.data);
        Table zTab = new Table();
        zTab.put("XMIN", dataTab.getD("VAL1"));
        zTab.put("XMAX", dataTab.getD("VAL2"));
        zTab.put("YMIN", dataTab.getD("VAL3"));
        zTab.put("YMAX", dataTab.getD("VAL4"));
        this.debug(" SETVIEW -> zoom table " + zTab);
        if (msg.info == 1 && !this.MP.getView().equals("LatLon")) {
            this.MP.setView("LatLon");
        } else if (msg.info == 2 && !this.MP.getView().equals("Geodetic")) {
            this.MP.setView("Geodetic");
        }
        if (this.MP.zoom(zTab, 0)) {
            this.MP.refresh();
        }
        return 0;
    }

    private int processZOOM(Message msg) {
        Table zTab = Convert.o2t(msg.data);
        if (this.MP.zoom(zTab, 0)) {
            this.MP.refresh();
        }
        return 0;
    }

    private String getLayerName(int lnum) {
        Layer lay = this.getLayer(lnum);
        return lay.getName();
    }

    private Layer getLayer(int lnum) {
        Layer lay = null;
        int layerNum = lnum;
        for (int n = 1; n < this.MP.layers.size(); ++n) {
            Layer tmplay = (Layer)this.MP.layers.get(n);
            this.debug("Layer num " + n + " = " + tmplay);
        }
        if (layerNum < 0) {
            layerNum = this.MP.layers.size() + layerNum + 1;
        }
        if (layerNum > 0) {
            lay = (Layer)this.MP.layers.get(layerNum);
        } else {
            this.M.warning("Invalid layer number " + lnum);
        }
        return lay;
    }

    private void parseMTAG(String mtag_in) {
        if (mtag_in == null) {
            return;
        }
        try {
            if (!mtag_in.startsWith("(") || !mtag_in.endsWith(")")) {
                this.M.warning("Unable to parse MTAG='" + mtag_in + "' . It should start and end with parenthesis");
            } else {
                String mtag = mtag_in.substring(1, mtag_in.length() - 1);
                Parser p = new Parser(mtag, ',');
                while (p.more()) {
                    String str = p.next();
                    if (str.startsWith("X:")) {
                        this.resName_XCLICK = str.substring(2);
                        continue;
                    }
                    if (str.startsWith("Y:")) {
                        this.resName_YCLICK = str.substring(2);
                        continue;
                    }
                    if (str.startsWith("Z:")) {
                        this.warn("Do not handle MTAG string " + str + " yet");
                        continue;
                    }
                    if (str.startsWith("XY:")) {
                        this.warn("Do not handle MTAG string " + str + " yet");
                        continue;
                    }
                    if (str.startsWith("X+Y:")) {
                        this.warn("Do not handle MTAG string " + str + " yet");
                        continue;
                    }
                    this.warn("Unrecognized MTAG string " + str);
                }
            }
        }
        catch (Exception e) {
            this.warn("Unable to set result names from string " + mtag_in);
        }
    }

    public void initGeoLayers(Position sitePos) {
        if (this.stateVectors != null && this.stateVectors.length > 0) {
            int numGeoLayers = this.getNumLayerGeos(this.stateVectors.length);
            this.geoLayers = new LayerGeo[numGeoLayers];
            for (int i = 0; i < this.stateVectors.length; ++i) {
                for (int j = i + 1; j < this.stateVectors.length; ++j) {
                    this.debug("Initializing GEO layers " + i + " and " + j);
                    this.geoLayers[i] = this.initGeoLayer("GEO" + (i + 1), sitePos, this.stateVectors[i], this.stateVectors[j]);
                    this.geoLayers[i].setEnable("-GLOBAL");
                    this.MP.addLayer(this.geoLayers[i]);
                }
            }
        } else {
            this.geoLayers = null;
        }
    }

    public int getNumLayerGeos(int numSVs) {
        int numLGs = 0;
        if (numSVs > 1) {
            if (numSVs == 2) {
                numLGs = 1;
            } else if (numSVs == 3) {
                numLGs = 3;
            } else if (numSVs == 4) {
                numLGs = 6;
            } else {
                this.M.error("Too many state vectors " + numSVs);
            }
        }
        return numLGs;
    }

    public LayerGeo initGeoLayer(String name, Position sitePos, StateVector sv1, StateVector sv2) {
        LayerGeo lg = new LayerGeo();
        lg.setName(name);
        lg.setSite(sitePos);
        lg.setSiteMode("Current");
        lg.setSVecMode("Current");
        lg.setTdoaMode("Contour");
        lg.setFdoaMode("Contour");
        lg.setFLinkT(1.0E8);
        lg.setFLinkA(-1.0E8);
        lg.setFLinkB(-1.0E8);
        lg.setSVA(sv1);
        lg.setSVB(sv2);
        return lg;
    }

    public void changeStateVectors() {
        if (this.geoLayers == null) {
            this.initGeoLayers(new Position());
        } else if (this.stateVectors != null && this.stateVectors.length > 0) {
            for (int i = 0; i < this.stateVectors.length; ++i) {
                this.debug("Changing state vectors GEO layer " + i);
                for (int j = i + 1; j < this.stateVectors.length; ++j) {
                    this.debug("Initializing GEO layers " + i + " and " + j);
                    this.geoLayers[i].setSVA(this.stateVectors[i]);
                    this.geoLayers[i].setSVB(this.stateVectors[j]);
                }
            }
        } else {
            this.geoLayers = null;
        }
    }

    public void loadEventFile(String eventFileName) {
        this.debug("Load Event file " + eventFileName);
        try {
            DataFile hevent = new DataFile(this.M, (Object)eventFileName, "5011", "NH", 0);
            hevent.open(1);
            String referenceFrame = hevent.getReferenceFrame();
            int numEvents = (int)hevent.getSize();
            this.debug("Event file reference frame '" + referenceFrame + "', num events " + numEvents);
            if (numEvents > 0) {
                LayerGeo lg = null;
                for (int offset = 0; offset < numEvents; ++offset) {
                    if (this.geoLayers == null || offset > this.geoLayers.length) {
                        this.debug("Creating a new GEO layer for offset " + offset);
                        lg = new LayerGeo();
                        lg.setName("GEO" + (offset + 1));
                    } else {
                        lg = this.geoLayers[offset];
                    }
                    this.debug("------------------------------------------------------------------");
                    this.debug("Changing attributes for layer " + lg.getName());
                    Table tab = hevent.getDataTable(offset);
                    this.debug("Event table '" + tab + "'");
                    Data dataMode = tab.getData("MODE");
                    byte gsMode = dataMode.getB(0);
                    byte tdMode = dataMode.getB(1);
                    byte fdMode = dataMode.getB(2);
                    byte svMode = dataMode.getB(3);
                    byte iballa = dataMode.getB(4);
                    byte iballb = dataMode.getB(5);
                    this.debug("MODE -> gsmode=" + gsMode + " tdmode=" + tdMode + " fdmode=" + fdMode + " svmode=" + svMode + " iballa=" + iballa + " iballb=" + iballb);
                    Data dataFlag = tab.getData("FLAG");
                    int enables = dataFlag.getL(0);
                    int flags = dataFlag.getL(1);
                    this.debug("FLAG: first long, enable=" + enables + " 2nd long flags=" + flags);
                    Data dataTIME = tab.getData("TIME");
                    double time = dataTIME.getD(0);
                    double dtime = dataTIME.getD(1);
                    this.debug("TIME/DTIME old " + lg.getTime() + " dtime??? new -> " + time + " / " + dtime);
                    Data dataTDOA = tab.getData("TDOA");
                    double tdoa = dataTDOA.getD(0);
                    double dtdoa = dataTDOA.getD(1);
                    this.debug("TDOA/DTDOA old -> " + lg.getTdoa() + " " + lg.getDTdoa() + " new -> " + tdoa + " / " + dtdoa);
                    Data dataFDOA = tab.getData("FDOA");
                    double fdoa = dataFDOA.getD(0);
                    double dfdoa = dataFDOA.getD(1);
                    this.debug("FDOA/DFDOA old -> " + lg.getFdoa() + " " + lg.getDFdoa() + " new -> " + fdoa + " / " + dfdoa);
                    double flinkt = tab.getD("FRQT");
                    double flinka = tab.getD("FRQA");
                    double flinkb = tab.getD("FRQB");
                    this.debug("FLINK (old) -> t=" + lg.getFLinkT() + " a=" + lg.getFLinkA() + " b=" + lg.getFLinkB());
                    this.debug("FLINK (new) -> t=" + flinkt + " a=" + flinka + " b=" + flinkb);
                    Data dataPOSS = tab.getData("POSS");
                    double xs = dataPOSS.getD(0);
                    double ys = dataPOSS.getD(1);
                    double zs = dataPOSS.getD(2);
                    Position sitePos = new Position();
                    sitePos.setCar(xs, ys, zs);
                    this.debug("SITE POS old=" + lg.getSite().toString(1));
                    this.debug("SITE POS new=" + sitePos.toString(1));
                    Data dataPOSA = tab.getData("POSA");
                    Data dataVELA = tab.getData("VELA");
                    double xa = dataPOSA.getD(0);
                    double ya = dataPOSA.getD(1);
                    double za = dataPOSA.getD(2);
                    double vxa = dataVELA.getD(0);
                    double vya = dataVELA.getD(1);
                    double vza = dataVELA.getD(2);
                    StateVector sva = new StateVector();
                    sva.setCar(xa, ya, za);
                    sva.setKey("VX", "" + vxa);
                    sva.setKey("VY", "" + vya);
                    sva.setKey("VZ", "" + vza);
                    this.debug("SVA old=" + lg.getSVA());
                    this.debug("SVA new=" + sva);
                    Data dataPOSB = tab.getData("POSB");
                    Data dataVELB = tab.getData("VELB");
                    double xb = dataPOSB.getD(0);
                    double yb = dataPOSB.getD(1);
                    double zb = dataPOSB.getD(2);
                    double vxb = dataVELB.getD(0);
                    double vyb = dataVELB.getD(1);
                    double vzb = dataVELB.getD(2);
                    StateVector svb = new StateVector();
                    svb.setCar(xb, yb, zb);
                    svb.setVel(vxb, vyb, vzb);
                    this.debug("SVB old=" + lg.getSVB());
                    this.debug("SVB new=" + svb);
                    String oldModes = "Site=" + lg.getSiteMode() + ", TDOA=" + lg.getTdoaMode() + ", FDOA=" + lg.getFdoaMode() + ", SVEC=" + lg.getSVecMode();
                    lg.setSiteMode(gsMode);
                    lg.setTdoaMode(tdMode);
                    lg.setFdoaMode(fdMode);
                    lg.setSVecMode(svMode);
                    String newModes = "Site=" + lg.getSiteMode() + ", TDOA=" + lg.getTdoaMode() + ", FDOA=" + lg.getFdoaMode() + ", SVEC=" + lg.getSVecMode();
                    this.debug("MODES: old=" + oldModes);
                    this.debug("MODES: new=Site  " + newModes);
                    lg.setFlags("-AUTOTFDOA");
                    lg.setTime(time);
                    lg.setTdoa(tdoa);
                    lg.setDTdoa(dtdoa);
                    lg.setFdoa(fdoa);
                    lg.setDFdoa(dfdoa);
                    lg.setFLinkT(flinkt);
                    lg.setFLinkA(flinka);
                    lg.setFLinkB(flinkb);
                    lg.setSVA(sva);
                    lg.setSVB(svb);
                    lg.setSite(sitePos);
                }
                if (hevent != null) {
                    hevent.close();
                }
            } else {
                this.warn("Event file " + eventFileName + " size is <= 0, no events");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.warn("Unable to load event file " + eventFileName);
        }
    }

    public static boolean btest(int val, int bit) {
        int bitValue = 1 << bit;
        if (Installation.ApplyBugFix.XGEOPLOT_USE_ORIGINAL_BTEST) {
            bitValue = 1 << bit - 1;
        }
        return (val & bitValue) != 0;
    }

    @InternalUseOnly
    public int getNextNumForLayerName() {
        return t5AutoNameCounter.get();
    }

    public void print(String str) {
        System.out.println("XGEO: " + str);
    }

    public void info(String str) {
        this.M.info("XGEO: " + str);
    }

    public void warn(String str) {
        this.M.warning("XGEO: " + str);
    }

    public void debug(String str) {
        if (this.debug) {
            System.out.println("XGEO: " + str);
        }
    }

    private static enum T5TEXT_MODMASK_BITS {
        ALT,
        LAT,
        LON,
        NAME,
        TEXT,
        COLOR,
        SYMBOL,
        SIZE,
        INVERT;

    }

    private static enum T5REC_MODMASK_BITS {
        ALT,
        LAT,
        LON,
        NAME,
        AZIM,
        ELEV,
        ROLL,
        R,
        A,
        B,
        COLOR,
        SYMBOL,
        SIZE,
        CONE,
        INVERT;

    }
}

