/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import nxm.sys.lib.FileName;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;

public class makedocs
extends Primitive {
    private static final int TAB_SPACES = 2;
    private static final String DEF_TITLE = "Index";
    private static final int MAX_TOC_LENGTH = 28;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private FileInfo[] files;
    private File srcDir;
    private File destDir;
    private int fileIndex;
    private Table options;
    private String style;
    private String printStyle;
    private String noarrow;
    private String larrow;
    private String rarrow;
    private String docTitle;

    @Override
    public int open() {
        this.options = this.MA.getTable("OPTIONS", new Table());
        String defSrc = makedocs.fixPath(this.options.getS("SRCDIR", ""));
        String defDest = makedocs.fixPath(this.options.getS("DESTDIR", ""));
        String defToc = makedocs.fixPath(this.options.getS("TOCFILE", ""));
        this.style = this.options.getS("STYLESHEET", "style.css");
        this.printStyle = this.options.getS("PRINTSTYLESHEET", "print.css");
        FileName src = this.MA.getFileName("SRCDIR", defSrc);
        FileName dest = this.MA.getFileName("DESTDIR", defDest);
        FileName toc = this.MA.getFileName("TOCFILE", defToc);
        TextFile tocFile = new TextFile(this, (Object)toc);
        tocFile.open(8192);
        String[] tocLines = tocFile.readAll().split("\n");
        tocFile.close();
        this.srcDir = new File(src.toString());
        this.destDir = new File(dest.toString());
        this.files = makedocs.getFileInfo(tocLines);
        this.fileIndex = 0;
        this.noarrow = this.options.getS("NOARROW", null);
        this.larrow = this.options.getS("LARROW", null);
        this.rarrow = this.options.getS("RARROW", null);
        this.docTitle = this.options.getS("TITLE", null);
        if (!this.srcDir.exists() || !this.srcDir.isDirectory()) {
            throw new MidasException("MAKEDOCS: Can not find directory " + this.srcDir);
        }
        if (!this.destDir.exists() || !this.destDir.isDirectory()) {
            throw new MidasException("MAKEDOCS: Can not find directory " + this.destDir);
        }
        return 0;
    }

    @Override
    public int process() {
        int status = 0;
        if (this.fileIndex >= this.files.length) {
            try {
                this.writeIndexPage();
            }
            catch (Exception e) {
                this.M.printStackTrace("MAKEDOCS: Error while creating index.html file.", e);
            }
            try {
                this.writeScmIgnore();
            }
            catch (Exception e) {
                this.M.printStackTrace("MAKEDOCS: Error while creating .gitignore file.", e);
            }
            status = 9;
        } else {
            try {
                this.processContentPage(this.fileIndex);
            }
            catch (Exception e) {
                this.M.printStackTrace("MAKEDOCS: Error while processing " + this.files[this.fileIndex], e);
            }
            ++this.fileIndex;
        }
        return status;
    }

    @Override
    public int close() {
        return 0;
    }

    private static String fixPath(String str) {
        if (str.startsWith("$NMROOT")) {
            str = Shell.getNmRoot() + str.substring(7);
        }
        return str.replace('/', File.separatorChar);
    }

    private String getLink(FileInfo file) {
        return this.getLink(file, file.getTitle());
    }

    private String getLink(FileInfo file, String title) {
        return this.getLink(file, title, -1);
    }

    private String getLink(FileInfo file, int maxLength) {
        return this.getLink(file, file.getTitle(), maxLength);
    }

    private String getLink(FileInfo file, String title, int maxLength) {
        title = this.fixTitle(title, maxLength);
        return "<a href='" + file.getRootName() + ".html'>" + title + "</a>";
    }

    private String fixTitle(FileInfo file) {
        return this.fixTitle(file, -1);
    }

    private String fixTitle(FileInfo file, int maxLength) {
        return this.fixTitle(file.getTitle(), maxLength);
    }

    private String fixTitle(String title, int maxLength) {
        if (title.startsWith("\"") && title.endsWith("\"")) {
            title = title.substring(1, title.length() - 1);
        }
        return title;
    }

    private void writeScmIgnore() throws IOException {
        File outFile = new File(this.destDir, ".gitignore");
        PrintStream out = new PrintStream(new FileOutputStream(outFile));
        if (this.verbose) {
            this.M.info(StringUtil.padRight("Writing " + outFile, 60));
        }
        out.println(".gitignore");
        out.println("index.html");
        for (int i = 0; i < this.files.length; ++i) {
            FileInfo fileInfo = this.files[i];
            if (fileInfo == null) continue;
            out.println("/" + fileInfo.getRootName() + ".html");
        }
        out.close();
    }

    private void writeIndexPage() throws IOException {
        File outFile = new File(this.destDir, "index.html");
        ArrayList<String> lines = new ArrayList<String>();
        String title = this.docTitle == null ? DEF_TITLE : this.docTitle;
        lines.add("        <h1>" + title + "</h1>");
        lines.add("        <ul class='top'><li>Modules");
        lines.add("          <ul>");
        for (int i = 0; i < this.files.length; ++i) {
            FileInfo fileInfo = this.files[i];
            if (fileInfo == null || fileInfo.getDepth() != 0) continue;
            lines.add("            <li>" + this.getLink(fileInfo) + "</li>");
        }
        lines.add("          </ul></li>");
        lines.add("        </ul>");
        String[] content = lines.toArray(EMPTY_STRING_ARRAY);
        this.writePage(outFile, title, this.getNav(-1), this.getToc(-1), content);
    }

    private void processContentPage(int pageNum) throws IOException {
        File outFile = new File(this.destDir, this.files[pageNum].getRootName() + ".html");
        String title = this.files[pageNum].getTitle();
        if (this.docTitle != null) {
            title = this.docTitle + ": " + title;
        }
        this.writePage(outFile, title, this.getNav(pageNum), this.getToc(pageNum), this.readHtmlBody(this.files[pageNum]));
    }

    private void writePage(File file, String title, String[] nav, String[] toc, String[] body) throws IOException {
        int j;
        if (this.verbose) {
            this.M.info(StringUtil.padRight("Writing " + file, 60));
        }
        PrintStream out = new PrintStream(new FileOutputStream(file));
        out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        out.println("<html>");
        out.println("  <!-- ************************************************************** -->");
        out.println("  <!-- ** WARNING: This file is autogenerated any modifications to ** -->");
        out.println("  <!-- **          this file may be lost.                          ** -->");
        out.println("  <!-- ************************************************************** -->");
        out.println("  <head>");
        out.println("    <title>" + title + "</title>");
        out.println("    <link rel='stylesheet' type='text/css' href='" + this.style + "' media='all'>");
        out.println("    <link rel='stylesheet' type='text/css' href='" + this.printStyle + "' media='print'>");
        out.println("    <link rel='shortcut icon' href='../NXM.ico'>");
        out.println("    <script type='text/javascript'>");
        out.println("    function toggleToc() {");
        out.println("     if (document.getElementById) {");
        out.println("       var toccol = document.getElementById('toccol');");
        out.println("       var toc = document.getElementById('toc');");
        out.println("       var tocimg_top = document.getElementById('tocimgtop');");
        out.println("       var tocimg_bottom = document.getElementById('tocimgbottom');");
        out.println("        if (toc.style.display == 'none') { toc.style.display = 'block';  toccol.width = '200'; tocimg_top.src = '../back.png'; tocimg_bottom.src = '../back.png'; }");
        out.println("          else { toc.style.display = 'none'; toccol.width = '15'; tocimg_top.src = '../next.png'; tocimg_bottom.src = '../next.png'; } } }");
        out.println("    </script>");
        out.println("  </head>");
        out.println("  <body bgcolor='#330066'>");
        out.println("  <table width='95%' border='1' id='maintable'>");
        out.println("    <tr>");
        out.println("      <td class='maintable' valign='top' colspan='2' bgcolor='#FFFFCC'>");
        out.println("<!-- ******************** BEGIN NAVIGATION AREA ******************** -->");
        for (j = 0; j < nav.length; ++j) {
            out.println(nav[j]);
        }
        out.println("<!-- ******************** END NAVIGATION AREA ******************** -->");
        out.println("      </td>");
        out.println("    </tr>");
        out.println("    <tr>");
        out.println("      <td id='toccol' class='maintable noprint' valign='top' bgcolor='#FFFFCC' width='200'>");
        out.println("       <div style='display:inline;float:right;'>");
        out.println("        <a onclick='javascript:toggleToc()' href='#' class='noprint' title='Toggle Table of Contents'>");
        out.println("         <img id='tocimgtop' src='../back.png' border='0' alt='back'>");
        out.println("        </a>");
        out.println("       </div>");
        out.println("       <div id='toc'>");
        out.println("        <code>");
        out.println("<!-- ******************** BEGIN TOC AREA ******************** -->");
        for (j = 0; j < toc.length; ++j) {
            out.println(toc[j]);
        }
        out.println("          <br>");
        out.println("          <br>");
        out.println("<!-- ******************** END TOC AREA ******************** -->");
        out.println("        </code>");
        out.println("       </div>");
        out.println("      </td>");
        out.println("      <td class='maintable' valign='top' bgcolor='#FFFFFF'>");
        out.println("<!-- ******************** BEGIN CONTENT AREA ******************** -->");
        for (j = 0; j < body.length; ++j) {
            out.println(body[j]);
        }
        out.println("<!-- ******************** END CONTENT AREA ******************** -->");
        out.println("        <br>");
        out.println("      </td>");
        out.println("    </tr>");
        out.println("<!-- ******************** BEGIN FOOTER NAVIGATION AREA ******************** -->");
        out.println("    <tr>");
        out.println("    <td class='maintable noprint' valign='top' bgcolor='#FFFFCC'>");
        out.println("      <div style='display:inline;float:right;'>");
        out.println("        <a onclick='javascript:toggleToc()' href='#' class='noprint' title='Toggle Table of Contents'>");
        out.println("          <img id='tocimgbottom' src='../back.png' border='0' alt='back'>");
        out.println("        </a>");
        out.println("      </div>");
        out.println("    </td>");
        out.println("    <td class='maintable' valign='top' bgcolor='#FFFFFF'>");
        out.println("    </td>");
        out.println("    </tr>");
        out.println("<!-- ******************** END FOOTER NAVIGATION AREA ******************** -->");
        out.println("  </table>");
        out.println("  </body>");
        out.println("</html>");
        out.close();
    }

    private String[] getNav(int index) {
        String rootTitle;
        ArrayList<String> lines = new ArrayList<String>();
        Stack<FileInfo> depth = new Stack<FileInfo>();
        String string = rootTitle = this.docTitle == null ? DEF_TITLE : this.docTitle;
        if (index == -1) {
            lines.add("           <b>" + rootTitle + "</b>");
        } else {
            for (int i = 0; i < this.files.length && i <= index; ++i) {
                while (depth.size() > this.files[i].getDepth() && !depth.empty()) {
                    depth.pop();
                }
                depth.push(this.files[i]);
                if (i != index) continue;
                if (this.larrow != null) {
                    if (i - 1 >= 0) {
                        lines.add(this.getLink(this.files[i - 1], "<img src='" + this.larrow + "' class='navtable noprint' alt='Previous'>") + " ");
                    } else if (this.noarrow != null) {
                        lines.add("<img src='" + this.noarrow + "' class='navtable noprint' alt='Previous'>");
                    }
                } else if (i - 1 >= 0) {
                    lines.add(this.getLink(this.files[i - 1], "&lt;-- Previous") + " ");
                } else {
                    lines.add("<font color='gray'>&lt;-- Previous</font> ");
                }
                if (this.rarrow != null) {
                    if (i + 1 < this.files.length) {
                        lines.add(this.getLink(this.files[i + 1], "<img src='" + this.rarrow + "' class='navtable noprint' alt='Next'>") + " ");
                    } else if (this.noarrow != null) {
                        lines.add("<img src='" + this.noarrow + "' class='navtable noprint' alt='Next'>");
                    }
                } else if (i + 1 < this.files.length) {
                    lines.add(this.getLink(this.files[i + 1], "Next --&gt;") + " ");
                } else {
                    lines.add("<font color='gray'>Next --&gt;</font> ");
                }
                lines.add("<span class='noprint'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span><i>Current Page:</i>");
                if (depth.size() == 0) {
                    lines.add("           <b>" + rootTitle + "</b>");
                } else {
                    lines.add("           <a href='index.html'>" + rootTitle + "</a>");
                }
                for (int j = 0; j < depth.size(); ++j) {
                    if (this.rarrow == null) {
                        lines.add("           / ");
                    } else {
                        lines.add("           <img src='" + this.rarrow + "' class='navtable' alt='/'> ");
                    }
                    if (j == depth.size() - 1) {
                        lines.add("           <b>" + this.fixTitle((FileInfo)depth.get(j)) + "</b>");
                        continue;
                    }
                    lines.add("           " + this.getLink((FileInfo)depth.get(j)));
                }
            }
        }
        return lines.toArray(EMPTY_STRING_ARRAY);
    }

    private String[] getToc(int pageNum) {
        FileInfo page;
        int i;
        ArrayList<FileInfo> pages = new ArrayList<FileInfo>(Arrays.asList(this.files));
        ArrayList<String> lines = new ArrayList<String>();
        boolean inSect = true;
        boolean inSubSect = true;
        for (i = pageNum + 1; i < pages.size(); ++i) {
            page = pages.get(i);
            inSect = inSect && page.getDepth() > 0;
            boolean bl = inSubSect = inSubSect && page.getDepth() > 1;
            if (inSubSect || inSect && page.getDepth() == 1 || page.getDepth() == 0) continue;
            pages.set(i, null);
        }
        inSect = true;
        inSubSect = true;
        for (i = pageNum; i >= 0; --i) {
            page = pages.get(i);
            if (!(inSubSect || inSect && page.getDepth() == 1 || page.getDepth() == 0)) {
                pages.set(i, null);
            }
            inSect = inSect && page.getDepth() > 0;
            inSubSect = inSubSect && page.getDepth() > 1;
        }
        for (i = 0; i < pages.size(); ++i) {
            FileInfo next;
            page = pages.get(i);
            FileInfo fileInfo = next = i + 1 < pages.size() ? pages.get(i + 1) : null;
            if (page == null) continue;
            StringBuffer str = new StringBuffer("          <span class=\"nobr\">");
            int length = 28 - page.getDepth() * 5 - 4;
            for (int k = 0; k < page.getDepth(); ++k) {
                str.append("&nbsp;&nbsp;&nbsp;");
            }
            if (next == null) {
                str.append("+&nbsp;");
            } else {
                str.append("-&nbsp;");
            }
            if (i == pageNum) {
                str.append("<b>").append(this.fixTitle(page, length)).append("</b>");
            } else {
                str.append(this.getLink(page, length));
            }
            str.append("&nbsp;&nbsp;&nbsp;</span><br>");
            lines.add(str.toString());
        }
        return lines.toArray(EMPTY_STRING_ARRAY);
    }

    private static FileInfo[] getFileInfo(String[] lines) {
        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
        for (int i = 0; i < lines.length; ++i) {
            try {
                String line = lines[i].trim();
                if (line.length() == 0 || line.startsWith("#")) continue;
                int index = line.indexOf(32) > 0 ? line.indexOf(32) : line.length();
                String name = line.substring(0, index);
                String title = line.substring(index).trim();
                int depth = makedocs.getDepth(lines[i]);
                boolean hidden = name.startsWith("*");
                if (hidden) {
                    name = name.substring(1);
                }
                int pthidx = Math.max(0, name.lastIndexOf(47));
                int extidx = Math.max(0, name.lastIndexOf(46));
                String rootName = name.substring(pthidx, extidx);
                if (extidx < 0) {
                    throw new RuntimeException("No extension given for file name, expected '.htm' or '.html'.");
                }
                files.add(new FileInfo(name, rootName, title, depth, hidden));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading line " + (i + 1) + ": " + e.getMessage());
            }
        }
        return files.toArray(new FileInfo[0]);
    }

    private static int getDepth(String line) {
        int spaces;
        for (spaces = 0; spaces < line.length() && line.charAt(spaces) == ' '; ++spaces) {
        }
        if (spaces % 2 != 0) {
            throw new RuntimeException("Number of leading spaces in line must be a multiple of 2.");
        }
        return spaces / 2;
    }

    private static String[] readFile(File file) throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((line = in.readLine()) != null) {
            lines.add(line);
        }
        in.close();
        return lines.toArray(EMPTY_STRING_ARRAY);
    }

    private String[] readHtmlBody(FileInfo file) throws IOException {
        return this.readHtmlBody(new File(this.srcDir, file.getName()));
    }

    private String[] readHtmlBody(File file) throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new FileReader(file));
        boolean inBody = false;
        while ((line = in.readLine()) != null) {
            int index;
            if (inBody) {
                index = line.toLowerCase().indexOf("</body>");
                if (index >= 0) {
                    lines.add(line.substring(0, index));
                    inBody = false;
                    continue;
                }
                lines.add(line);
                continue;
            }
            index = line.toLowerCase().indexOf("<body>");
            if (index < 0) continue;
            lines.add(line.substring(index + 6));
            inBody = true;
        }
        in.close();
        return lines.toArray(EMPTY_STRING_ARRAY);
    }

    private static class FileInfo {
        private final String name;
        private final String rootName;
        private final String title;
        private final int depth;
        private final boolean hidden;

        public FileInfo(String name, String rootName, String title, int depth, boolean hidden) {
            if (title.startsWith("\"") && title.endsWith("\"")) {
                title = title.substring(1, title.length() - 1);
            }
            this.name = name;
            this.rootName = rootName;
            this.title = title;
            this.depth = depth;
            this.hidden = hidden;
        }

        public String getName() {
            return this.name;
        }

        public String getRootName() {
            return this.rootName;
        }

        public String getTitle() {
            return this.title;
        }

        public int getDepth() {
            return this.depth;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public String toString() {
            return this.getRootName();
        }
    }
}

