/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataOp;
import nxm.sys.lib.Primitive;

public class group
extends Primitive {
    private DataFile ho;
    private DataFile[] hi;
    private Data dbo;
    private Data[] dbi;
    private int nrec;
    private int rlen;
    private int nfiles;
    private int iper;

    @Override
    public int open() {
        int i;
        this.nfiles = this.MA.nargs - 1;
        this.hi = new DataFile[this.nfiles];
        this.dbi = new Data[this.nfiles];
        boolean warn = this.MA.getState("/WARN", true);
        double size = 0.0;
        for (i = 0; i < this.nfiles; ++i) {
            String name;
            int irec;
            DataFile h = this.MA.getDataFile(this.MA.getKey(i + 2), "1000,2000,3000,5000", "", 0);
            h.open();
            if (i == 0) {
                this.ho = this.MA.getDataFile("OUT", h, 0);
                this.ho.setSubSize(0);
                this.ho.setRecLength(0);
                if (h.typeClass != 3 && h.typeClass != 5) {
                    this.ho.setType(3000);
                }
            }
            if (h.typeClass == 3) {
                for (irec = 0; irec < h.getSubSize(); ++irec) {
                    name = this.ho.getUniqueRecName("SR00", this.ho.getSubSize() + 1, h.getRecName(irec), warn);
                    this.ho.addSubRec(name, h.getRecFormat(irec));
                }
            } else if (h.typeClass == 5) {
                for (irec = 0; irec < h.getSubSize(); ++irec) {
                    name = this.ho.getUniqueRecName("SR00", this.ho.getSubSize() + 1, h.getRecName(irec), warn);
                    this.ho.addComp(name, h.getCompFormat(irec), h.getCompType(irec), h.getCompUnits(irec));
                }
            } else {
                this.nrec = h.typeClass == 2 ? h.getSubSize() : 1;
                for (irec = 0; irec < this.nrec; ++irec) {
                    name = this.ho.getUniqueRecName("SR00", this.ho.getSubSize() + 1, null, warn);
                    this.ho.addSubRec(name, h.getFormat());
                }
            }
            if (i == 0 || h.getSize() < size) {
                size = h.getSize();
            }
            this.hi[i] = h;
        }
        this.ho.setSize(size);
        this.ho.open(2);
        this.rlen = (int)this.ho.dbpe;
        this.iper = this.MA.getL("/TL", 16384 / this.rlen);
        this.dbo = this.ho.getDataBuffer(this.iper);
        for (i = 0; i < this.nfiles; ++i) {
            this.dbi[i] = this.hi[i].getDataBuffer(this.iper);
        }
        return 0;
    }

    @Override
    public int process() {
        int ioff = 0;
        for (int i = 0; i < this.nfiles; ++i) {
            int ngot = this.hi[i].read(this.dbi[i]);
            if (ngot <= 0) {
                return 9;
            }
            if (ngot < this.iper) {
                this.iper = ngot;
            }
            int bytes = (int)this.hi[i].dbpe;
            DataOp.copy(this.dbi[i], 0, bytes, this.dbo, ioff, this.rlen, bytes, this.iper);
            ioff += bytes;
        }
        this.ho.write(this.dbo, this.iper);
        return 0;
    }

    @Override
    public int close() {
        this.ho.close();
        for (int i = 0; i < this.nfiles; ++i) {
            this.hi[i].close();
        }
        return 0;
    }
}

