/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import nxm.sys.lib.Message;
import nxm.sys.lib.Time;
import nxm.sys.libg.GPrimitive;
import nxm.sys.libg.MWText;

public class display
extends GPrimitive
implements ActionListener {
    int nargs;
    int exit;
    double pause;
    double tlast;
    Arg[] args;
    MWText MWT;
    private static final int EXIT_RETURN = 1;
    private static final int EXIT_MENU = 2;
    private static final int EXIT_MESSAGE = 4;
    private static final int EXIT_WINDOW = 8;
    private static final int EXIT_ALL = 15;
    private static final int EXIT_AUTO = 16;
    private static final String exitList = "RETURN,MENU,MESSAGE,WINDOW,AUTO";
    boolean exiting;

    @Override
    public int open() {
        this.nargs = this.MA.numberOf();
        this.pause = this.MA.getD("/PAUSE", 0.5);
        int fontsz = this.MA.getL("/FONTSZ", 12);
        int flags = 1344;
        this.exit = this.M.pipeMode == 1 ? 0 : 15;
        this.exit = this.MA.getOptionMask("/EXIT", exitList, this.exit);
        int rows = this.MA.getL("/ROWS", this.nargs + 1);
        int cols = this.MA.getL("/COLS", 40);
        this.MWT = new MWText("Display", this.nargs, rows, cols, fontsz, flags, this);
        this.MWT.mtext.addActionListener(this);
        this.MW = this.MWT;
        this.MW.open();
        this.MW.addTo(this);
        this.args = new Arg[this.nargs];
        for (int i = 0; i < this.nargs; ++i) {
            this.parseArg(i);
        }
        return 0;
    }

    @Override
    public int process() {
        if (this.exiting) {
            return 9;
        }
        double time = Time.current();
        if (time - this.tlast < this.pause) {
            return -1;
        }
        this.tlast = time;
        for (int i = 0; i < this.nargs; ++i) {
            this.checkArg(i);
        }
        return 0;
    }

    @Override
    public int processMessage(Message msg) {
        int status = 0;
        if (msg.name.equals("EXIT")) {
            this.exiting = (this.exit & 4) != 0;
        } else if (msg.name.equals("RESIZE")) {
            this.MW.resize(0);
        } else if (msg.name.equals("WINDOW")) {
            String action = (String)msg.data;
            if (action.equals("CLOSING")) {
                this.exiting = (this.exit & 8) != 0;
            }
        } else {
            status = this.MW.processMessage(msg);
        }
        return status;
    }

    @Override
    public int close() {
        this.MW.close();
        return 0;
    }

    private void parseArg(int i) {
        String line = this.MA.getU(i + 1);
        String separator = " ==> ";
        Arg arg = new Arg();
        int j = line.indexOf("//");
        if (j > 0) {
            separator = line.substring(j + 2);
            line = line.substring(0, j);
        }
        if (separator.charAt(0) == '\"') {
            separator = separator.substring(1, separator.length() - 1);
        }
        String prompt = line;
        j = line.indexOf("/");
        if (j > 0) {
            prompt = line.substring(j + 1);
            line = line.substring(0, j);
        }
        if (prompt.charAt(0) == '\"') {
            prompt = prompt.substring(1, prompt.length() - 1);
        }
        arg.name = line;
        arg.prompt = prompt + separator;
        this.args[i] = arg;
        this.MWT.mtext.add(arg.prompt);
        this.checkArg(i);
    }

    private void checkArg(int i) {
        Arg arg = this.args[i];
        Object obj = this.MR.get(arg.name);
        if (obj == null) {
            return;
        }
        String value = obj.toString();
        if (arg.value == null || !value.equals(arg.value)) {
            arg.value = value;
            this.MWT.mtext.setLine(i + 1, arg.prompt + arg.value);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String action = ae.getActionCommand();
    }

    public class Arg {
        String name;
        String prompt;
        String value;
    }
}

