/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.prim;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import nxm.sys.inc.LegacyMethod;
import nxm.sys.inc.MapKBT;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.CsvFile;
import nxm.sys.lib.Data;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.DataFileHeader;
import nxm.sys.lib.FileName;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.FortranUtil;
import nxm.sys.lib.ImageFile;
import nxm.sys.lib.JsonUtilities;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.Keywords;
import nxm.sys.lib.MFormat;
import nxm.sys.lib.MaskValue;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Primitive;
import nxm.sys.lib.Results;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StateVector;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.TextFile;
import nxm.sys.lib.Time;
import nxm.sys.lib.Transform;
import nxm.sys.lib.XmUtil;
import nxm.sys.lib.XmlFile;
import nxm.sys.libg.GraphicsUtil;
import nxm.sys.libg.MColor;

public class convert
extends Primitive {
    private static final String DEF_DUPKEY_DELIM_TBL2XML = "__";
    private static final String DEF_DUPKEY_DELIM_TAB2XML = "_";

    @Override
    public int open() {
        String conv = this.MA.getS("CONV");
        if (conv.equals("T2B")) {
            this.convertText2Blue1000or3000();
        } else if (conv.startsWith("XML2TBL")) {
            this.convertXMLText2Table(conv);
        } else if (conv.startsWith("XML2TAB")) {
            this.xmlToTable(conv);
        } else if (conv.startsWith("TAB2XML")) {
            this.tableToXML(conv);
        } else if (conv.startsWith("TBL2XML")) {
            this.convertTable2XMLText(conv);
        } else if (conv.startsWith("XML2MAPKBT")) {
            this.xmlToMapKBT(conv);
        } else if (conv.startsWith("SV2KML")) {
            this.convertStateVector2KML(conv);
        } else if (conv.startsWith("POLY2KML")) {
            this.convertPoly2KML(conv);
        } else if (conv.startsWith("TEMPLATE2TBL")) {
            this.convertTemplate2Table(conv);
        } else if (conv.startsWith("MSGCFG2TBL")) {
            this.genmsg(1);
        } else if (conv.startsWith("MSGCFG2INC")) {
            this.genmsg(2);
        } else if (conv.startsWith("BBDEF2JAVA")) {
            this.bbdef2java();
        } else if (conv.startsWith("FSTRUCT2JAVA")) {
            this.fstruct2java();
        } else if (conv.startsWith("PLAT2BLUE")) {
            this.convertPlatToBlue();
        } else if (conv.startsWith("KWCONV")) {
            this.convertKeywords();
        } else if (conv.startsWith("BLUE2JSON")) {
            this.convertBlueToJson();
        } else if (conv.startsWith("BLUE2XML")) {
            this.convertToXml(conv);
        } else if (conv.startsWith("FILE2XML")) {
            this.convertToXml(conv);
        } else if (conv.startsWith("XML2BLUE")) {
            this.convertXmlToBlue(conv);
        } else if (conv.equals("TBL2HTML")) {
            this.convertTable2HTMLText();
        } else if (conv.equals("TXT2TBL")) {
            this.convertText2Table();
        } else if (conv.equals("TBL2TXT")) {
            this.convertTable2Text();
        } else if (conv.equals("TBL2B")) {
            this.convertTable2BlueT3000();
        } else if (conv.equals("BLUE2IMG")) {
            this.convertBlue2Img();
        } else if (conv.equals("XML2B")) {
            this.convertXMLText2Blue();
        } else if (conv.equals("CSV2TBL")) {
            this.convertCSV("TABLE");
        } else if (conv.equals("CSV2XML")) {
            this.convertCSV("XML");
        } else if (conv.equals("BLUE")) {
            this.convertColor("BLUE");
        } else if (conv.equals("GOLD")) {
            this.convertColor("GOLD");
        } else if (conv.equals("OPAL")) {
            this.convertColor("OPAL");
        } else if (conv.equals("IEEE")) {
            this.convertRep("IEEE");
        } else if (conv.equals("EEEI")) {
            this.convertRep("EEEI");
        } else if (conv.equals("VAX")) {
            this.convertRep("VAX ");
        } else if (conv.equals("PACKED")) {
            this.convertType((byte)80);
        } else if (conv.equals("BYTE")) {
            this.convertType((byte)66);
        } else if (conv.equals("INT")) {
            this.convertType((byte)73);
        } else if (conv.equals("LONG")) {
            this.convertType((byte)76);
        } else if (conv.equals("FLOAT")) {
            this.convertType((byte)70);
        } else if (conv.equals("DOUBLE")) {
            this.convertType((byte)68);
        } else if (conv.equals("ECI")) {
            this.convertRefFrame("ECI", "CARTESIAN");
        } else if (conv.equals("ECR")) {
            this.convertRefFrame("ECR", "CARTESIAN");
        } else if (conv.equals("TOP")) {
            this.convertRefFrame("TOP", "CARTESIAN");
        } else if (conv.equals("TOPOCENT")) {
            this.convertRefFrame("TOPOCENT", "CARTESIAN");
        } else if (conv.equals("CARTESIAN")) {
            this.convertRefFrame(null, "CARTESIAN");
        } else if (conv.equals("SPHERICAL")) {
            this.convertRefFrame(null, "SPHERICAL");
        } else if (conv.equals("CYLINDRIC")) {
            this.convertRefFrame(null, "CYLINDRIC");
        } else if (conv.equals("ELLIPSOID")) {
            this.convertRefFrame(null, "ELLIPSOID");
        } else if (conv.equals("GEODETIC")) {
            this.convertRefFrame(null, "GEODETIC");
        } else if (conv.equals("SVINTERP")) {
            this.svinterp();
        } else if (conv.equals("LLA2ECR")) {
            this.lla2ecr();
        } else if (conv.equals("LLA2ECI")) {
            this.lla2eci();
        } else if (conv.equals("SV2BLUE")) {
            this.sv2blue5001();
        } else {
            throw new MidasException("Unsupported conversion: " + conv);
        }
        return 9;
    }

    private void convertStateVector2KML(String conv) {
        double size;
        DataFile df = this.MA.getDataFile("IN");
        String outfile = this.MA.getCS("OUT", df.getName().getRoot() + ".kml");
        Table options = this.MA.getTable("OPTIONS");
        String styleid = options.getS("STYLEID", "styleID");
        StringBuilder kmlString = new StringBuilder(1024);
        ArrayList<Double> beginTArray = new ArrayList<Double>();
        ArrayList<Double> endTArray = new ArrayList<Double>();
        ArrayList<double[]> pntArray = new ArrayList<double[]>();
        String format = options.getS("FORMAT", "Point");
        MFormat timeform = MFormat.getDateFormatFor("yyyy-MM-dd'T'hh:mm:ss'Z'", 0);
        long beginTime = options.getI("BEGIN");
        long endTime = options.getL("END", 0);
        long persist = options.getL("PERSIST", 0);
        String prepend = options.getS("PREPEND");
        String altMode = options.getS("ALTMODE", "clampToGround");
        long extrude = options.getL("EXTRUDE", 0);
        long tess = options.getL("TESSELLATE", 0);
        long heading = options.getL("HEADING", 0);
        String href = options.getS("HREF");
        String iconcolor = options.getS("ICONCOLOR", "FFFFFFFF");
        String labelcolor = options.getS("LABELCOLOR", "FFFFFFFF");
        String linecolor = options.getS("LINECOLOR", "FFFF0000");
        long tilt = options.getL("TILT", 0);
        long roll = options.getL("ROLL", 0);
        long iconscale = options.getL("ICONSCALE", 1);
        long labelscale = options.getL("LABELSCALE", 1);
        long linewidth = options.getL("LINEWIDTH", 1);
        long xscale = options.getL("XSCALE", 1);
        long yscale = options.getL("YSCALE", 1);
        long zscale = options.getL("ZSCALE", 1);
        df.open();
        double time = 0.0;
        int etime = 0;
        double inc = 0.0;
        double delta = options.getD("DELTA", df.getDelta());
        Data timeData = new Data();
        try {
            timeData = options.getData("TIME");
        }
        catch (Exception e1) {
            this.M.printStackTrace(e1);
        }
        if (endTime != 0L) {
            if (beginTime >= endTime) {
                this.M.warning("BEGIN time cannot be larger than END time.");
            }
            while (beginTime % 300L != 0L) {
                ++beginTime;
            }
            size = Math.floor((double)(endTime - beginTime) / delta) + 1.0;
            time = beginTime;
        } else {
            size = timeData != null ? (double)timeData.spa : df.getNumberOfRows();
        }
        int dfSize = (int)df.size;
        Data data = df.getDataBuffer(dfSize);
        int ndo = (int)df.avail();
        df.read(data, ndo);
        int ii = 0;
        while ((double)ii < size) {
            if (timeData != null) {
                time = timeData.getIndex(ii).toD();
            } else {
                time += inc;
                inc = delta;
            }
            if (time > 8640000.0) {
                time -= df.getXDelta() * df.getSize();
            }
            double offset1 = df.getIndex(time, 3, 3);
            double absTime1 = df.getTimeAt(offset1);
            beginTArray.add(absTime1);
            if (endTime != 0L && !format.equalsIgnoreCase("POINT") && persist == 0L) {
                if ((etime = (int)((double)etime + inc)) > 8640000) {
                    etime = (int)((double)etime - df.getXDelta() * df.getSize());
                }
                double offset2 = df.getIndex(time, 3, 3);
                double absTime2 = df.getTimeAt(offset2);
                endTArray.add(absTime2);
            }
            double[] vals = StateVector.getPosVelAccAtTime(df, time, data, true);
            double[] pos = new double[]{vals[0], vals[1], vals[2]};
            pntArray.add(pos);
            ++ii;
        }
        df.close();
        kmlString.append("<kml>\n");
        kmlString.append("  <Document>\n");
        int i = 0;
        String absTime = timeform.format(beginTArray.get(i));
        if (format.equalsIgnoreCase("MODEL")) {
            for (double[] d : pntArray) {
                if (endTArray.size() > 0) {
                    // empty if block
                }
                kmlString.append("    <Placemark>\n");
                kmlString.append("      <TimeSpan>\n");
                kmlString.append("        <begin>").append(absTime).append("</begin>\n");
                if (persist == 1L) {
                    if (endTArray.isEmpty()) {
                        this.M.warning("PERSIST ERROR: END option not defined");
                    } else {
                        kmlString.append("        <end>").append(timeform.format(endTArray.get(i))).append("</end>\n");
                    }
                }
                kmlString.append("      </TimeSpan>\n");
                kmlString.append("      <Model id=\"").append(styleid).append("\">\n");
                kmlString.append("        <altitudeMode>").append(altMode).append("</altitudeMode>\n");
                kmlString.append("        <Location>\n");
                kmlString.append("          <longitude>").append(d[0]).append("</longitude>\n");
                kmlString.append("          <latitude>").append(d[1]).append("</latitude>\n");
                kmlString.append("          <altitude>").append(d[2]).append("</altitude>\n");
                kmlString.append("        </Location>\n");
                kmlString.append("        <Orientation>\n");
                kmlString.append("          <heading>").append(heading).append("</heading>\n");
                kmlString.append("          <tilt>").append(tilt).append("</tilt>\n");
                kmlString.append("          <roll>").append(roll).append("</roll>\n");
                kmlString.append("        </Orientation>\n");
                kmlString.append("        <Scale>\n");
                kmlString.append("          <x>").append(xscale).append("</x>\n");
                kmlString.append("          <y>").append(yscale).append("</y>\n");
                kmlString.append("          <z>").append(zscale).append("</z>\n");
                kmlString.append("        </Scale>\n");
                kmlString.append("        <Link>\n");
                kmlString.append("          <href>").append(href).append("</href>\n");
                kmlString.append("        </Link>\n");
                kmlString.append("      </Model>\n");
                kmlString.append("    </Placemark>\n");
                ++i;
            }
        } else if (prepend != null) {
            kmlString.append(prepend);
        } else {
            kmlString.append("    <Style id=\"").append(styleid).append("\">\n");
            kmlString.append("      <IconStyle>\n");
            kmlString.append("        <color>").append(iconcolor).append("</color>\n");
            kmlString.append("        <scale>").append(iconscale).append("</scale>\n");
            kmlString.append("        <heading>").append(heading).append("</heading>\n");
            kmlString.append("        <Icon>\n");
            kmlString.append("          <href>").append(href).append("</href>\n");
            kmlString.append("        </Icon>\n");
            kmlString.append("      </IconStyle>\n");
            kmlString.append("      <LabelStyle>\n");
            kmlString.append("        <color>").append(labelcolor).append("</color>\n");
            kmlString.append("        <scale>").append(labelscale).append("</scale>\n");
            kmlString.append("      </LabelStyle>\n");
            kmlString.append("      <LineStyle>\n");
            kmlString.append("        <color>").append(linecolor).append("</color>\n");
            kmlString.append("        <width>").append(linewidth).append("</width>\n");
            kmlString.append("      </LineStyle>\n");
            kmlString.append("    </Style>\n");
            if (format.equalsIgnoreCase("POINT")) {
                for (double[] d : pntArray) {
                    kmlString.append("    <Placemark>\n");
                    kmlString.append("      <TimeStamp>\n");
                    kmlString.append("        <when>").append(absTime).append("</when>\n");
                    kmlString.append("      </TimeStamp>\n");
                    kmlString.append("      <styleUrl>#").append(styleid).append("</styleUrl>\n");
                    kmlString.append("      <Point>\n");
                    kmlString.append("        <extrude>").append(extrude).append("</extrude>\n");
                    kmlString.append("        <altitudeMode>").append(altMode).append("</altitudeMode>\n");
                    kmlString.append("        <coordinates>").append(d[0]).append(",").append(d[1]).append(",").append(d[2]).append("</coordinates>\n");
                    kmlString.append("      </Point>\n");
                    kmlString.append("    </Placemark>\n");
                    ++i;
                }
            } else {
                kmlString.append("    <Placemark>\n");
                kmlString.append("      <TimeSpan>\n");
                kmlString.append("        <begin>").append(timeform.format(beginTArray.get(i))).append("</begin>\n");
                kmlString.append("        <end>").append(timeform.format(beginTArray.get(beginTArray.size() - 1))).append("</end>\n");
                kmlString.append("      </TimeSpan>\n");
                kmlString.append("      <styleUrl>#").append(styleid).append("</styleUrl>\n");
                kmlString.append("      <LineString>\n");
                kmlString.append("        <extrude>").append(extrude).append("</extrude>\n");
                kmlString.append("        <tessellate>").append(tess).append("</tessellate>\n");
                kmlString.append("        <altitudeMode>").append(altMode).append("</altitudeMode>\n");
                kmlString.append("        <coordinates>\n");
                for (double[] d : pntArray) {
                    kmlString.append("          ").append(d[0]).append(",").append(d[1]).append(",").append(d[2]).append("\n");
                }
                kmlString.append("        </coordinates>\n");
                kmlString.append("      </LineString>\n");
                kmlString.append("    </Placemark>\n");
            }
        }
        kmlString.append("  </Document>\n");
        kmlString.append("</kml>");
        if (outfile == null || outfile.length() == 0) {
            this.M.error("CONVERT: No output result specified for conversion SV2KML");
        }
        try {
            if (conv.indexOf("/S") > 0) {
                String resname = this.MA.getU("OUT");
                if (resname.length() == 0) {
                    this.M.type(kmlString);
                } else {
                    this.MR.put(resname, (Object)kmlString.toString());
                }
            } else {
                TextFile tf = new TextFile(this.M, (Object)outfile);
                tf.open(2);
                tf.write(kmlString.toString());
                tf.close();
            }
        }
        catch (Exception e) {
            this.M.printStackTrace("CONVERT: Unable to convert table to KML (internal error: " + e + ").", e);
        }
    }

    private void convertPoly2KML(String conv) {
        DataFile df = this.MA.getDataFile("IN");
        String outfile = this.MA.getCS("OUT", df.getName().getRoot() + ".kml");
        Table options = this.MA.getTable("OPTIONS");
        boolean toString = conv.indexOf("/S") >= 0;
        StringBuilder kmlString = new StringBuilder(2048);
        int lineWidth = 2;
        if (options != null && options.containsKey("LINEWIDTH")) {
            lineWidth = options.getL("LINEWIDTH", lineWidth);
        }
        Color[] cmap = MColor.getColorMap(8, -1);
        if (options != null && options.containsKey("CMAP")) {
            cmap = MColor.getColorMap(options.getS("CMAP"), -1);
        }
        df.open();
        int dim = df.getMode();
        double[] rowData = new double[dim];
        kmlString.append("<kml>\n");
        kmlString.append("  <Document>\n");
        int index = 0;
        while ((double)index < df.getNumberOfRows()) {
            Data row = df.getData(index);
            row.toArray(rowData);
            int objSize = (int)rowData[0];
            int colorNum = (int)rowData[1];
            if (colorNum == -998 || colorNum == -999) {
                index += 2;
            } else {
                Color color;
                if (colorNum < 1) {
                    color = MColor.RGBtoBGR(MColor.getSpecialXMidasColor(colorNum));
                } else {
                    int colorIndex = (colorNum - 1) % (cmap.length - 1) + 1;
                    color = MColor.RGBtoBGR(cmap[colorIndex]);
                }
                String scolor = MColor.toString(color);
                if (scolor.indexOf("0X") > -1) {
                    scolor = scolor.substring(scolor.indexOf("0X") + 2);
                }
                double stopPoint = (index += 2) + objSize;
                String styleid = "Style_" + index;
                kmlString.append("    <Style id=\"").append(styleid).append("\">\n");
                kmlString.append("      <LineStyle>\n");
                kmlString.append("        <color>").append(scolor).append("</color>\n");
                kmlString.append("        <width>").append(lineWidth).append("</width>\n");
                kmlString.append("      </LineStyle>\n");
                kmlString.append("    </Style>\n");
                double[] coords = new double[objSize * dim];
                int counter = 0;
                kmlString.append("    <Placemark>\n");
                kmlString.append("      <styleUrl>#").append(styleid).append("</styleUrl>\n");
                kmlString.append("      <LineString>\n");
                kmlString.append("        <coordinates>\n");
                while ((double)index < stopPoint) {
                    row = df.getData(++index);
                    row.toArray(rowData);
                    coords[counter++] = rowData[0];
                    coords[counter++] = rowData[1];
                    if (dim == 3) {
                        coords[counter++] = rowData[2];
                    }
                    kmlString.append("          ").append(rowData[0]).append(",").append(rowData[1]);
                    if (dim == 3) {
                        kmlString.append(",").append(rowData[2]).append("\n");
                        continue;
                    }
                    kmlString.append("\n");
                }
                kmlString.append("        </coordinates>\n");
                kmlString.append("      </LineString>\n");
                kmlString.append("    </Placemark>\n");
            }
            ++index;
        }
        kmlString.append("  </Document>\n");
        kmlString.append("</kml>");
        df.close();
        if (toString) {
            String resname = this.MA.getU("OUT");
            if (resname.isEmpty()) {
                this.M.type(kmlString);
            } else {
                this.MR.put(resname, (Object)kmlString.toString());
            }
        } else {
            TextFile tf = new TextFile(this.M, (Object)outfile);
            tf.open(2);
            tf.write(kmlString.toString());
            tf.close();
        }
    }

    private int convertText2Blue1000or3000() {
        String line;
        int maxrec = 100;
        String formats = "ABILFDXZ";
        boolean parse = this.MA.getState("/PARSE");
        TextFile tf = this.MA.getTextFile("IN");
        tf.setExtDefault("txt");
        DataFile df = this.MA.getDataFile("OUT", "3000", "NH", 0);
        String format = this.MA.getU("FORM");
        int skip = this.MA.getL("SKIP");
        Parser fp = new Parser(format, '|');
        int nfp = fp.elements();
        int[] offsets = new int[maxrec];
        int[] lengths = new int[maxrec];
        char[] types = new char[maxrec];
        int[] offs = new int[maxrec];
        int offset = 0;
        char type = '?';
        int irec = 0;
        for (int n = 1; n <= nfp; ++n) {
            int i;
            String ff = fp.get(n);
            int off = -1;
            for (i = 0; i < formats.length() && off < 0; ++i) {
                type = formats.charAt(i);
                off = ff.indexOf(type);
            }
            if (off < 0) {
                this.M.error("Unsupported type in format string: " + format);
            }
            int mult = 1;
            if (off > 0) {
                mult = Convert.s2l(ff.substring(0, off));
            }
            int length = 1;
            if (off < ff.length() - 1) {
                length = Convert.s2l(ff.substring(off + 1));
            }
            if (type == 'X') {
                offset += mult * length;
                continue;
            }
            for (i = 0; i < mult; ++i) {
                int la;
                String recName = df.getUniqueRecName("TR00", irec + 1, null);
                int origBPS = Data.getBPS(type);
                int n2 = la = origBPS <= 8 ? (length + 7) / 8 : (length + (origBPS - 1)) / origBPS;
                String mode = !Data.isString((byte)type) ? String.valueOf('S') : (la > 10 ? String.valueOf('T') : (la == 10 ? String.valueOf('X') : "" + la));
                offs[irec] = df.getRecLength();
                df.addSubRec(recName, mode + type);
                offsets[irec] = offset;
                lengths[irec] = length;
                types[irec] = type;
                offset += length;
                ++irec;
            }
        }
        String pad = "";
        for (int i = 0; i < offset; ++i) {
            pad = pad + ' ';
        }
        if (irec == 1) {
            df.setType(1000);
        }
        df.open(2);
        Data data = df.getDataBuffer(1);
        tf.open(8193);
        while ((line = tf.read()) != null) {
            Parser p = null;
            if (skip-- > 0) continue;
            if (parse) {
                p = new Parser(line);
            } else if (line.length() < pad.length()) {
                line = line + pad.substring(line.length());
            }
            block14: for (int i = 0; i < irec; ++i) {
                String sline = parse ? p.get(i + 1) : line.substring(offsets[i], offsets[i] + lengths[i]);
                switch (types[i]) {
                    case 'D': {
                        data.packD(offs[i], Convert.s2d(sline));
                        continue block14;
                    }
                    case 'F': {
                        data.packF(offs[i], (float)Convert.s2d(sline));
                        continue block14;
                    }
                    case 'L': {
                        data.packL(offs[i], Convert.s2l(sline));
                        continue block14;
                    }
                    case 'I': {
                        data.packI(offs[i], (short)Convert.s2l(sline));
                        continue block14;
                    }
                    case 'B': {
                        data.packB(offs[i], (byte)Convert.s2l(sline));
                        continue block14;
                    }
                    case 'A': {
                        data.packS(offs[i], lengths[i], sline);
                        continue block14;
                    }
                    case 'Z': {
                        data.packS(offs[i], lengths[i], sline);
                    }
                }
            }
            df.write(data);
        }
        tf.close();
        df.close();
        return 0;
    }

    private int convertColor(String color) {
        return 0;
    }

    private int convertRep(String conversion) {
        byte convertFrom;
        DataFile dfi = this.MA.getDataFile("IN");
        String key = "OUT";
        if (this.MA.getLength(key) <= 0) {
            key = "IN";
            dfi.open(3);
        } else {
            dfi.open(1);
        }
        if (!dfi.isOpen()) {
            this.M.error("Unable to open " + dfi.getFileName().getFullName());
            return 9;
        }
        DataFile dfo = this.MA.getDataFile(key, dfi, 0);
        byte convertTo = DataFile.testRep(conversion);
        if (convertTo != (convertFrom = DataFile.testRep(dfi.getDataRep())) || !dfo.getURL().equals(dfi.getURL())) {
            dfo.setDataRep(conversion);
            dfo.open(2);
            this.xfer = this.MA.getL("/TL", Math.max(1, (int)((double)this.bufSize / dfi.dbpe)));
            Data dfdata = dfi.getDataBuffer(this.xfer);
            int n = this.xfer;
            while (n > 0) {
                n = dfi.read(dfdata);
                if (n <= 0) continue;
                dfo.write(dfdata, n);
            }
            dfi.close();
            dfo.convertHeaderRep(conversion);
            dfo.update();
            dfo.close();
            return 0;
        }
        convertFrom = DataFile.testRep(dfi.getHeadRep());
        if (convertTo != convertFrom) {
            dfi.convertHeaderRep(conversion);
            dfi.update();
            dfi.close();
        }
        return 0;
    }

    private int convertType(byte convertTo) {
        DataFile df = this.MA.getDataFile("IN");
        String key = "OUT";
        if (this.MA.getLength(key) <= 0) {
            key = "IN";
            df.open(3);
        } else {
            df.open(1);
        }
        if (!df.isOpen()) {
            this.M.error("Unable to open " + df.getFileName().getFullName());
            return 9;
        }
        DataFile dfOut = this.MA.getDataFile(key, df, 0);
        if (df.getProtected()) {
            df.close();
            this.M.error("File is protected.");
            return 9;
        }
        if (convertTo != df.dataType) {
            Data dfdata = df.getDataBuffer((int)df.size);
            int df2 = df.getFrameSize() > 0 ? (int)(df.size * (double)df.getFrameSize()) : (int)df.size;
            Data dfdata2 = new Data(df.getFormat().substring(0, 1) + (char)convertTo, df2);
            df.read(dfdata);
            Convert.type(dfdata.buf, 0, df.dataType, dfdata2.buf, 0, convertTo, (int)df.size * df.ape * df.spa);
            dfOut.open();
            dfOut.seek(0.0);
            dfOut.setFormatType(convertTo);
            dfOut.setSize(df.size);
            dfOut.write(dfdata2, (int)df.size);
        }
        df.close();
        dfOut.close();
        return 0;
    }

    private void convertText2Table() {
        TextFile tf = this.MA.getTextFile("IN");
        Table t = new Table(tf);
        String out = this.MA.getU("OUT");
        if (out == null || out.length() == 0) {
            this.M.error("CONVERT: No output specified for conversion of text to table of " + tf.getName());
        } else {
            this.MR.put(this.MA.getU("OUT"), (Object)t);
        }
    }

    private void convertTable2Text() {
        Table t = this.MA.getTable("IN");
        TextFile tf = this.MA.getTextFile("OUT");
        tf.open(8194);
        String s = t.toString();
        tf.write(s);
        tf.close();
    }

    private int convertTable2BlueT3000() {
        Table inTable = this.MA.getTable("IN");
        DataFile df = this.MA.getDataFile("OUT");
        String formatString = this.MA.getU("FORM");
        char formatDelim = this.MA.getS("/DELIM", "|").charAt(0);
        boolean defaultRecNames = this.MA.getState("/DEFAULTNAMES", false);
        if (formatDelim != ',') {
            formatString = formatString.replace(formatDelim, ',');
        }
        this.convertTable2BlueT3000(inTable, formatString, defaultRecNames, df);
        return 0;
    }

    private int convertTable2BlueT3000(Table inTable, String formatString, boolean defaultRecNames, DataFile df) {
        Table.Iterator ti = inTable.iterator();
        ti.getNext();
        Object obj = ti.value;
        if (obj instanceof Table) {
            Table recTable = Convert.o2t(obj);
            String[] formatList = this.getFormatList(formatString, recTable);
            String[] recordNameList = null;
            if (!defaultRecNames) {
                recordNameList = this.getRecNamesFromTable(recTable);
            }
            this.make3000Header(formatList, recordNameList, df);
            if (df.open(2)) {
                this.writeTableTo3000(inTable, formatList, df);
                df.close();
            } else {
                this.M.error("Unable to open file " + df.getURL());
            }
        } else {
            this.M.error("There should be sub-Table(s) within input Table!");
        }
        return 0;
    }

    private int convertBlue2Img() {
        DataFile df = this.MA.getDataFile("IN");
        String fileName = this.MA.getS("OUT", df.getName().getRoot() + ".png");
        Table t = this.MA.getTable("IMGOPTS", new Table());
        String fmt = this.MA.getS("FORM", "PNG");
        String cmap = t.getS("CMAP", "RAMP");
        String colormap = t.getS("COLORS", null);
        int ncolors = t.getL("NC", 256);
        double minVal = t.getD("ZMIN", -1.7976931348623157E308);
        double maxVal = t.getD("ZMAX", Double.MAX_VALUE);
        minVal = t.getD("Z1", minVal);
        maxVal = t.getD("Z2", maxVal);
        boolean cthru = t.getState("CTHRU", false);
        int cnt = t.getL("CNT", 50);
        int brt = t.getL("BRT", 50);
        int alpha = t.getL("ALPHA", -1);
        boolean grayscale = t.getState("GRAYSCALE", false);
        grayscale = t.getState("GREYSCALE", grayscale);
        String cxMode = t.getS("CXMODE", "MAG");
        boolean terrain = cmap.equals("TERRAIN");
        String cols = colormap != null ? colormap : cmap;
        Color[] colors = MColor.getColorMap(cols, ncolors);
        this.convertBlue2Img(df, colors, fileName, minVal, maxVal, cthru, cnt, brt, alpha, grayscale, fmt, cxMode, terrain);
        return 0;
    }

    private int convertBlue2Img(DataFile df, Color[] colors, String fileName, double minVal, double maxVal, boolean cthru, int cnt, int brt, int alpha, boolean grayscale, String fmt, String cxMode, boolean terrain) {
        ImageFile file = new ImageFile(this.M, (Object)fileName);
        GraphicsUtil.createImageFile(df, colors, minVal, maxVal, fmt, file, cnt, brt, alpha, grayscale, cxMode, terrain);
        return 0;
    }

    private void convertPlatToBlue() {
        FileName inFileName = this.MA.getFileName("IN");
        FileName outFileName = this.MA.getFileName("OUT");
        Table plat2blueTable = Table.fromTableFile(this, "nxm.sys.dat.kwconv_plat2blue.tbl");
        Table overridingOptionsTbl = this.MA.getTable("OPTIONS");
        Table mergedTable = overridingOptionsTbl != null ? Table.merge(plat2blueTable, overridingOptionsTbl, true) : plat2blueTable;
        FileUtil.convertKeywords(this, inFileName, outFileName, mergedTable);
    }

    private void convertKeywords() {
        FileName inFileName = this.MA.getFileName("IN");
        FileName outFileName = this.MA.getFileName("OUT");
        Table conversionTable = this.MA.getTable("OPTIONS");
        if (conversionTable == null) {
            throw new MidasException("No conversion table found");
        }
        FileUtil.convertKeywords(this, inFileName, outFileName, conversionTable);
    }

    private void convertBlueToJson() {
        Table conversionTable;
        FileName inFileName = this.MA.getFileName("IN");
        FileName outFileName = this.MA.getFileName("OUT");
        boolean omitData = this.MA.isPresent("/OMITDATA");
        String tableString = this.MA.getCS("OPTIONS", "{}");
        if (tableString.startsWith("{")) {
            conversionTable = new Table(tableString, 64);
        } else {
            TextFile tf = new TextFile(tableString);
            conversionTable = new Table(tf, 64);
        }
        if (!conversionTable.isEmpty()) {
            FileUtil.convertBlue2JSON(this.M, inFileName, outFileName, conversionTable);
        } else {
            DataFile df = new DataFile(this.M, (Object)inFileName);
            df.open();
            DataFileHeader dfHeader = new DataFileHeader(df);
            Table table4JSON = dfHeader.getHeaderAndKeywordsAsTableCS();
            if (!omitData) {
                if (df.isRecordBased()) {
                    table4JSON.put("FileData", (Object)FileUtil.getRecordDataAsList(df));
                } else {
                    int numRead;
                    int xf = df.getXFrame();
                    int tl = xf > 1 ? 1 : (int)Math.min(df.size, 32.0);
                    Data data = df.getDataBuffer(tl);
                    if (!data.isString()) {
                        if (xf > 1) {
                            if (df.spa == 1) {
                                ArrayList<List<Number>> oneSPA = new ArrayList<List<Number>>();
                                while ((numRead = df.read(data, data.size)) >= 0) {
                                    oneSPA.add(data.toList());
                                }
                                table4JSON.put("FileData", (Object)oneSPA);
                            } else {
                                ArrayList<List<List<Number>>> multSPA = new ArrayList<List<List<Number>>>();
                                while ((numRead = df.read(data, data.size)) >= 0) {
                                    multSPA.add(data.toListSPA());
                                }
                                table4JSON.put("FileData", (Object)multSPA);
                            }
                        } else if (df.spa == 1) {
                            ArrayList<Number> oneSPA = new ArrayList<Number>();
                            while ((numRead = df.read(data, data.size)) >= 0) {
                                oneSPA.addAll(data.toList());
                            }
                            table4JSON.put("FileData", (Object)oneSPA);
                        } else {
                            ArrayList<List<Number>> multSPA = new ArrayList<List<Number>>();
                            while ((numRead = df.read(data, data.size)) >= 0) {
                                multSPA.addAll(data.toListSPA());
                            }
                            table4JSON.put("FileData", (Object)multSPA);
                        }
                    } else if (xf > 1) {
                        ArrayList<List<String>> strList = new ArrayList<List<String>>();
                        while ((numRead = df.read(data, data.size)) >= 0) {
                            strList.add(data.toStringList());
                        }
                        table4JSON.put("FileData", (Object)strList);
                    } else {
                        ArrayList<String> strList = new ArrayList<String>();
                        while ((numRead = df.read(data, data.size)) >= 0) {
                            strList.addAll(data.toStringList());
                        }
                        table4JSON.put("FileData", (Object)strList);
                    }
                }
            }
            df.close();
            String json = JsonUtilities.toJSON(table4JSON).toString();
            TextFile out = new TextFile(outFileName);
            out.open(2);
            out.write(json);
            out.close();
        }
    }

    private void convertToXml(String conv) {
        BaseFile inFile;
        Table options = this.MA.getTable("OPTIONS");
        if (conv.startsWith("BLUE2XML")) {
            inFile = this.MA.getDataFile("IN");
        } else if (conv.startsWith("FILE2XML")) {
            inFile = this.MA.getFile("IN");
        } else {
            throw new MidasException("Unsupported conversion: " + conv);
        }
        inFile.open(1);
        CharSequence xml = XmlFile.fileToXml(inFile, options);
        inFile.close();
        if (conv.contains("/S")) {
            String outRes = this.MA.getU("OUT");
            this.MR.put(outRes, (Object)xml.toString());
        } else {
            TextFile outFile = this.MA.getTextFile("OUT");
            outFile.open(2);
            outFile.write(xml.toString());
            outFile.close();
        }
    }

    private void convertXmlToBlue(String conv) {
        Table options = this.MA.getTable("OPTIONS");
        DataFile outDataFile = this.MA.getDataFile("OUT");
        if (conv.contains("/S")) {
            String xmlstr = this.MA.getU("IN");
            XmlFile.xmlToFile(xmlstr, outDataFile, options);
        } else {
            TextFile inTextFile = this.MA.getTextFile("IN", 16);
            String mimeType = TextFile.getMimeType(null, inTextFile.filename);
            if (!mimeType.startsWith("text")) {
                this.M.error("Input file must be of type TEXT (wrong conversion direction?)");
            } else {
                XmlFile.xmlToFile(inTextFile, outDataFile, options);
            }
        }
    }

    private void writeTableTo3000(Table inTable, String[] formatList, DataFile df) {
        double df_offset = 0.0;
        Data dfdata = new Data();
        dfdata.setSize(df.getRecLength());
        dfdata.setFormatType(df.dataType);
        dfdata.setRecLength(df.getRecLength());
        Table.Iterator ti = inTable.iterator();
        while (ti.getNext()) {
            int boff = 0;
            Table.Iterator dti = Convert.o2t(ti.value).iterator();
            for (int i = 0; i < dti.size; ++i) {
                String dataString = "" + dti.values[i];
                String format = formatList[i];
                int width = Data.getBPA(format);
                if (format.indexOf(65) > 0) {
                    dfdata.packS(boff, width, dataString);
                } else if (format.indexOf(68) > 0) {
                    dfdata.packD(boff, Convert.s2d(dataString));
                } else if (format.indexOf(76) > 0) {
                    dfdata.packL(boff, Convert.s2l(dataString));
                } else if (format.indexOf(70) > 0) {
                    dfdata.packF(boff, Convert.o2f(Convert.s2o(dataString, 'F', (Object)this.M)));
                } else if (format.indexOf(73) > 0) {
                    dfdata.packI(boff, Convert.o2i(Convert.s2o(dataString, 'I', (Object)this.M)));
                } else if (format.indexOf(66) > 0) {
                    dfdata.packB(boff, Convert.o2b(Convert.s2o(dataString, 'B', (Object)this.M)));
                }
                boff += width;
            }
            df.write(dfdata, df_offset, 1);
            df_offset += 1.0;
        }
    }

    private String[] getRecNamesFromTable(Table recTable) {
        int MAX_RECORD_NAME_LENGTH = 4;
        String[] nameList = new String[recTable.size()];
        int fieldNum = 0;
        Table.Iterator ti = recTable.iterator();
        while (ti.getNext()) {
            String keyStr = ti.key;
            int len = 4;
            if (keyStr.length() < 4) {
                len = keyStr.length();
            }
            nameList[fieldNum] = keyStr.substring(0, len);
            fieldNum = (short)(fieldNum + 1);
        }
        return nameList;
    }

    private String[] getFormatList(String formatString, Table recTable) throws ClassCastException {
        String[] formatList = new String[recTable.size()];
        boolean useDefaultFormats = formatString == null;
        int fieldNum = 0;
        Table.Iterator ti = recTable.iterator();
        while (ti.getNext()) {
            Data data;
            String keyStr = ti.key;
            try {
                data = recTable.getData(keyStr);
            }
            catch (Exception e) {
                throw new ClassCastException();
            }
            String recFormat = null;
            if (!useDefaultFormats) {
                String formatKeyValString = StringUtil.getWordByString(formatString, keyStr);
                if (formatKeyValString != null && !formatKeyValString.startsWith(keyStr)) {
                    formatKeyValString = null;
                }
                if (formatKeyValString != null) {
                    recFormat = this.getKeyValue(formatKeyValString);
                }
            }
            if (useDefaultFormats || recFormat == null) {
                try {
                    double d = Double.parseDouble("" + data);
                    formatList[fieldNum] = "SD";
                }
                catch (Exception e) {
                    formatList[fieldNum] = "SA";
                }
            } else {
                formatList[fieldNum] = recFormat;
            }
            fieldNum = (short)(fieldNum + 1);
        }
        return formatList;
    }

    private String getKeyValue(String s) {
        int delimIndex = s.indexOf(61);
        return s.substring(delimIndex + 1);
    }

    private void make3000Header(String[] formatList, String[] recNameList, DataFile df) {
        df.setType(3000);
        for (int i = 0; i < formatList.length; ++i) {
            String recName = recNameList != null ? recNameList[i] : df.getUniqueRecName("TR00", i + 1, null);
            df.addSubRec(recName, formatList[i]);
        }
    }

    private int convertCSV(String toWhat) {
        String csvFileName = this.MA.getFileName("IN").toString();
        CsvFile csvFile = new CsvFile(this.M, (Object)csvFileName);
        csvFile.open(1);
        if (toWhat.equals("TABLE")) {
            String outputResultName = this.MA.getU("OUT");
            Table tab = csvFile.toTable();
            this.MR.put(outputResultName, (Object)tab);
        } else {
            String outFile = this.MA.getCS("OUT");
            if (outFile != null && outFile.indexOf(46) == -1) {
                outFile = outFile + ".xml";
            }
            TextFile tf = new TextFile(this.M, (Object)outFile);
            int indent = 2;
            if (tf != null) {
                tf.open(8194);
                tf.writeln("<XML>");
                tf.writeln(csvFile.toXmlBrief(indent));
                tf.writeln("</XML>");
                tf.close();
            } else {
                this.M.error("Need an output file name to convert CSV file " + csvFileName);
            }
        }
        csvFile.close();
        return 0;
    }

    private int xmlToTable(String conv) {
        String delim = this.MA.getS("/DELIM", DEF_DUPKEY_DELIM_TAB2XML);
        String cname = "CDATA";
        int start = this.MA.getL("/BASE", 1);
        boolean comp = this.MA.getState("/COMP");
        boolean useRootForRes = this.MA.getState("/USEROOTFORRES");
        String resName = this.MA.getS("OUT");
        if (!(resName != null && resName.length() != 0 || useRootForRes)) {
            this.M.error("CONVERT: No output table name or useRootForRes switch for XML2TAB conversion of " + this.MA.getFileName("IN"));
        } else {
            try {
                Table tbl;
                MaskValue xml2TblconversionOptions = MaskValue.forType(XmlFile.Xml2TblConversionOptions.class, (Enum[])new XmlFile.Xml2TblConversionOptions[0]);
                if (comp) {
                    xml2TblconversionOptions.set(XmlFile.Xml2TblConversionOptions.Compression);
                }
                if (useRootForRes) {
                    xml2TblconversionOptions.set(XmlFile.Xml2TblConversionOptions.IncludeRootName);
                }
                if (conv.indexOf("/S") > 0) {
                    tbl = XmlFile.fastXmlToTable(this.MA.getS("IN"), delim, cname, start, xml2TblconversionOptions);
                } else {
                    TextFile tf = this.MA.getTextFile("IN");
                    tbl = XmlFile.fastXmlFileToTable(tf, delim, cname, start, xml2TblconversionOptions);
                }
                if (useRootForRes) {
                    resName = tbl.getS("ROOTNAME");
                    if (!this.MA.getState("/KEEPROOTKEY")) {
                        tbl.remove("ROOTNAME");
                    }
                }
                if (tbl != null) {
                    if (XmlFile.getDotKeyFixEnabled()) {
                        tbl.hasDotsInKeys(resName);
                    }
                    this.MR.put(resName, (Object)tbl);
                } else {
                    this.M.warning("CONVERT: Unable to convert XML to table (missing close tag?).");
                }
            }
            catch (MidasException me) {
                throw new MidasException(me);
            }
            catch (Exception e) {
                this.M.printStackTrace("CONVERT: Unable to convert XML to table.", e);
            }
        }
        return 0;
    }

    private int tableToXML(String conv) {
        Table inputTable = this.MA.getTable("IN");
        String mainKey = this.MA.getS("/XMLKEY", "XML");
        String delim = this.MA.getS("/DELIM", DEF_DUPKEY_DELIM_TAB2XML);
        String cname = "CDATA";
        boolean comp = this.MA.getState("/COMP");
        boolean newLines = this.MA.getState("/NEWLINES", true);
        try {
            if (conv.indexOf("/S") > 0) {
                String xml = XmlFile.fastTableToXml(inputTable, mainKey, delim, cname, comp, newLines);
                if (xml != null) {
                    String resName = this.MA.getU("OUT");
                    this.MR.put(resName, (Object)xml);
                } else {
                    this.M.warning("CONVERT: Unable to convert table to XML.");
                }
            } else {
                String outFile = this.MA.getCS("OUT");
                if (outFile != null && outFile.indexOf(46) == -1) {
                    outFile = outFile + ".xml";
                }
                TextFile tf = new TextFile(this.M, (Object)outFile);
                XmlFile.fastTableToXmlFile(tf, inputTable, mainKey, delim, cname, comp, newLines);
            }
        }
        catch (Exception e) {
            this.M.printStackTrace("CONVERT: Unable to convert table to XML.", e);
        }
        return 0;
    }

    private int xmlToMapKBT(String conv) {
        boolean useRootForRes = this.MA.getState("/USEROOTFORRES");
        String resName = this.MA.getS("OUT");
        if (!(resName != null && resName.length() != 0 || useRootForRes)) {
            this.M.error("CONVERT: No output table name or useRootForRes switch for XML2TAB conversion of " + this.MA.getFileName("IN"));
        } else {
            try {
                MapKBT mapkbt;
                if (conv.indexOf("/S") > 0) {
                    mapkbt = XmlFile.fromXML(this.MA.getS("IN"));
                } else {
                    TextFile tf = this.MA.getTextFile("IN");
                    tf.open();
                    String xml = tf.readAll();
                    mapkbt = XmlFile.fromXML(xml);
                    tf.close();
                }
                if (useRootForRes) {
                    resName = mapkbt.getS("ROOTNAME");
                    if (!this.MA.getState("/KEEPROOTKEY")) {
                        mapkbt.remove("ROOTNAME");
                    }
                }
                if (mapkbt != null) {
                    this.MR.put(resName, (Object)mapkbt);
                } else {
                    this.M.warning("CONVERT: Unable to convert XML to MapKBT (missing close tag?).");
                }
            }
            catch (MidasException me) {
                throw new MidasException(me);
            }
            catch (Exception e) {
                this.M.printStackTrace("CONVERT: Unable to convert XML to MapKBT.", e);
            }
        }
        return 0;
    }

    private int convertXMLText2Blue() {
        Table mainTable;
        TextFile xmltf = this.MA.getTextFile("IN");
        DataFile dfout = this.MA.getDataFile("OUT");
        String subTableKeys = this.MA.getS("/XMLKEY", "XML");
        String formatString = this.MA.getU("FORM");
        char delim = this.MA.getS("/DELIM", "|").charAt(0);
        boolean defaultRecNames = this.MA.getState("/DEFAULTNAMES", false);
        if (delim != ',') {
            formatString = formatString.replace(delim, ',');
        }
        if (subTableKeys != null) {
            subTableKeys = subTableKeys.toUpperCase();
        }
        if ((mainTable = convert.convertXMLText2Table(xmltf)) != null) {
            StringTokenizer subkeyST = new StringTokenizer(subTableKeys, "" + delim);
            Table subTable = mainTable;
            String token = null;
            while (subkeyST.hasMoreTokens()) {
                token = subkeyST.nextToken();
                if (token == null || token.isEmpty()) continue;
                subTable = subTable.getTable(token);
            }
            if (subTable != null) {
                this.convertTable2BlueT3000(subTable, formatString, defaultRecNames, dfout);
            } else {
                this.M.error("FINAL TABLE: key = " + token + " is null");
            }
        } else {
            this.M.error("Unable to convert table to BLUE file");
        }
        return 0;
    }

    private int convertTable2XMLText(String conv) {
        boolean newLines;
        String delim;
        String mainKey;
        int status;
        boolean formString = conv.indexOf("/S") > 0;
        Table tin = this.MA.getTable("IN");
        String outResult = this.MA.getS("OUT");
        if (outResult == null || outResult.length() == 0) {
            this.M.error("CONVERT: No output result specified for conversion TBL2XML");
        }
        if ((status = convert.convertTable2XMLText(tin, formString, mainKey = this.MA.getS("/XMLKEY", "XML"), outResult, this.MR, delim = this.MA.getS("/DELIM", DEF_DUPKEY_DELIM_TBL2XML), newLines = this.MA.getState("/NEWLINES", false), this.M)) < 0) {
            this.M.error("Must specify table name. Use /TABLE argument.");
        }
        return 0;
    }

    public static int convertTable2XMLText(Table tin, boolean formString, String mainKey, String outResult, Results MR) {
        return convert.convertTable2XMLText(tin, formString, mainKey, outResult, MR, DEF_DUPKEY_DELIM_TBL2XML, false);
    }

    public static int convertTable2XMLText(Table tin, boolean formString, String mainKey, String outResult, Results MR, String duplicateKeyDelim, boolean newLines) {
        return convert.convertTable2XMLText(tin, formString, mainKey, outResult, MR, duplicateKeyDelim, newLines, Shell.getMidasContext());
    }

    private static int convertTable2XMLText(Table tin, boolean formString, String mainKey, String outResult, Results MR, String duplicateKeyDelim, boolean newLines, Midas M) {
        if (tin != null) {
            StringBuffer sbout = new StringBuffer();
            sbout.append("<").append(mainKey);
            int retval = convert.innerTablesToXML(tin, sbout, duplicateKeyDelim, newLines, true);
            if (retval == 0) {
                String attrs = convert.getXMLAttributes(tin);
                sbout.append(attrs).append("/>");
            } else {
                sbout.append("</").append(mainKey).append(">");
            }
            if (newLines) {
                sbout.append("\n");
            }
            if (formString) {
                if (outResult != null && outResult.length() > 0) {
                    MR.put(outResult, (Object)("" + sbout));
                }
            } else if (outResult.length() > 0) {
                TextFile tf = new TextFile(M, (Object)outResult);
                tf.open(8194);
                tf.write(sbout.toString());
                tf.close();
            } else {
                Shell.getSharedMidasContext().println(sbout.toString());
            }
        } else {
            return -1;
        }
        return 0;
    }

    private int convertTable2HTMLText() {
        Table tin = this.MA.getTable("IN");
        TextFile tf = this.MA.getTextFile("OUT");
        String mainKey = this.MA.getS("/HTMLKEY", "HTML");
        String duplicateKeyDelim = this.MA.getS("/DELIM", DEF_DUPKEY_DELIM_TBL2XML);
        FileName fileName = tf.getFileName();
        if (fileName.getExt() == null || fileName.getExt().length() == 0) {
            fileName.setExt("html");
        }
        if (tin != null) {
            if (tf.filename.length() > 0) {
                this.createHTMLOutput(tin, mainKey, tf, duplicateKeyDelim);
            } else {
                this.createHTMLOutput(tin, mainKey, null, duplicateKeyDelim);
            }
        } else {
            this.M.error("Must specify table name.  Use /TABLE argument.");
        }
        return 0;
    }

    private int convertXMLText2Table(String conv) {
        Table out;
        Table output;
        String inString = this.MA.getS("IN").toUpperCase();
        String mainKey = this.MA.getS("/XMLKEY", "XML");
        String tout = this.MA.getU("OUT");
        if (tout == null || tout.length() == 0) {
            this.M.error("CONVERT: No output specified for XML to Table conversion.");
            return 0;
        }
        if (conv.indexOf("/S") >= 0) {
            output = new Table();
            try {
                convert.fromXML(inString, output);
            }
            catch (NoSuchElementException e) {
                this.M.warning("Unable to convert XML, '" + inString + "'");
            }
        } else {
            TextFile tf = this.MA.getTextFile("IN");
            output = convert.convertXMLText2Table(tf);
            if (output == null) {
                this.M.warning("CONVERT: An error occurred while reading '" + tf + "'.");
                output = new Table();
            }
        }
        if (output != null && (out = output.getTable(mainKey)) != null) {
            this.MR.put(tout, (Object)out);
        }
        return 0;
    }

    public static Table convertXMLText2Table(TextFile tf) {
        StringBuilder data = new StringBuilder();
        Table output = new Table();
        try {
            String line;
            tf.open(8193);
            while (tf.isOpen && (line = tf.read()) != null) {
                if (data.length() == 0) {
                    data.append(line.trim());
                    continue;
                }
                data.append(" ").append(line.trim());
            }
            tf.close();
        }
        catch (Exception e) {
            Shell.printStackTrace(e);
            return null;
        }
        String xmlString = data.toString();
        if (xmlString.indexOf("<XML") < 0) {
            Shell.warning("No XML tag, will attempt to convert anyway. xml=" + xmlString);
        }
        convert.fromXML(xmlString, output);
        return output;
    }

    private void createHTMLOutput(Table table, String key, TextFile tf, String duplicateKeyDelim) {
        if (tf != null) {
            tf.open(8194);
        }
        this.textWriteln(tf, "<" + key + ">");
        this.textWriteln(tf, "<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" width=\"50%\" BGCOLOR=\"CCCCCC\" >");
        this.getHTMLInnerTables(table, tf, duplicateKeyDelim, true);
        this.textWriteln(tf, "</table>");
        this.textWriteln(tf, "</" + key + ">");
        if (tf != null) {
            tf.close();
        }
    }

    private static String fixXmlInnerTableName(String _innerTable, String duplicateKeyDelim) {
        int backnum = _innerTable.lastIndexOf(duplicateKeyDelim);
        String innerTableXMLname = backnum > 0 ? _innerTable.substring(0, backnum) : _innerTable;
        return innerTableXMLname;
    }

    private static int innerTablesToXML(Table table, StringBuffer sbout, String duplicateKeyDelim, boolean newLines, boolean init) {
        int retval = 1;
        StringBuilder sb = new StringBuilder();
        Table.Iterator ti = table.iterator();
        while (ti.getNext()) {
            String keyval = ti.key;
            Object obj = ti.value;
            if (!(obj instanceof Table)) continue;
            sb.append(keyval).append(",");
        }
        String nameStr = sb.toString();
        if (nameStr.length() > 0) {
            nameStr = nameStr.substring(0, nameStr.length() - 1);
            sbout.append(">");
            if (newLines) {
                sbout.append("\n");
            }
            StringTokenizer mainST = new StringTokenizer(nameStr, ",", false);
            while (mainST.hasMoreTokens()) {
                int ret;
                String innerTable = mainST.nextToken();
                String innerTableXML = convert.fixXmlInnerTableName(innerTable, duplicateKeyDelim);
                sbout.append("<").append(innerTableXML);
                Table t = table.getTable(innerTable);
                String attrs = convert.getXMLAttributes(t);
                if (attrs.length() > 0) {
                    sbout.append(" ").append(attrs);
                }
                if ((ret = convert.innerTablesToXML(t, sbout, duplicateKeyDelim, newLines, false)) != 1) continue;
                sbout.append("</").append(innerTableXML).append(">");
                if (!newLines) continue;
                sbout.append("\n");
            }
        } else {
            if (init) {
                sbout.append(" ");
            } else {
                sbout.append("/>");
                if (newLines) {
                    sbout.append("\n");
                }
            }
            retval = 0;
        }
        return retval;
    }

    private void textWriteln(TextFile tf, String s) {
        this.textWrite(tf, s + "\n");
    }

    private void textWrite(TextFile tf, String s) {
        if (tf == null) {
            this.M.terminal.print(s);
        } else {
            tf.write(s);
        }
    }

    private int getHTMLInnerTables(Table table, TextFile tf, String duplicateKeyDelim, boolean init) {
        int retval = 1;
        StringBuilder sb = new StringBuilder();
        Table.Iterator ti = table.iterator();
        while (ti.getNext()) {
            String keyval = ti.key;
            Object obj = ti.value;
            if (!(obj instanceof Table)) continue;
            sb.append(keyval).append(",");
        }
        String nameStr = sb.toString();
        if (nameStr.length() > 0) {
            nameStr = nameStr.substring(0, nameStr.length() - 1);
            if (!init) {
                this.textWrite(tf, ">");
            }
            StringTokenizer mainST = new StringTokenizer(nameStr, ",", false);
            while (mainST.hasMoreTokens()) {
                int ret;
                String innerTable = mainST.nextToken();
                String innerTableHTML = convert.fixXmlInnerTableName(innerTable, duplicateKeyDelim);
                this.textWrite(tf, "<tr><td border=\"1\"><i> " + innerTableHTML + "</i></td>");
                Table t = table.getTable(innerTable);
                String attrs = this.getHTMLAttributes(t);
                if (attrs.length() > 0) {
                    this.textWrite(tf, " " + attrs);
                }
                if ((ret = this.getHTMLInnerTables(t, tf, duplicateKeyDelim, false)) != 1) continue;
                this.textWrite(tf, "</" + innerTableHTML + ">");
            }
        } else {
            retval = 0;
        }
        return retval;
    }

    @LegacyMethod(value="use lib.XmlFile.fromXML(String, Table) - functionality moved to library Class in 3.9.2")
    public static void fromXML(String bufferString, Table output) throws NoSuchElementException {
        XmlFile.fromXML(bufferString, output);
    }

    @LegacyMethod(value="use XmlFile.fromXML(String, Table, String) - functionality moved to library Class in 3.9.2")
    public static void fromXML(String bufferString, Table output, String duplicateKeyDelim) throws NoSuchElementException {
        XmlFile.fromXML(bufferString, output, duplicateKeyDelim);
    }

    @LegacyMethod(value="use XmlFile.makeXMLTableFromLine(StringTokenizer) - functionality moved to library Class in 3.9.2")
    public static Table makeXMLTableFromLine(StringTokenizer st) {
        return XmlFile.makeXMLTableFromLine(st);
    }

    public static String getXMLAttributes(Table t) {
        StringBuilder sb = new StringBuilder();
        Table.Iterator ti = t.iterator();
        while (ti.getNext()) {
            String keyval = ti.key;
            Object obj = ti.value;
            if (obj instanceof Table) continue;
            sb.append(keyval).append("=").append('\"').append(obj).append('\"').append(" ");
        }
        return sb.toString();
    }

    public String getHTMLAttributes(Table t) {
        StringBuilder sb = new StringBuilder();
        Table.Iterator ti = t.iterator();
        while (ti.getNext()) {
            String keyval = ti.key;
            Object obj = ti.value;
            if (obj instanceof Table) continue;
            String cellColor = "CCCCCC";
            if (obj.toString().equals("-1")) {
                cellColor = "F00000";
            }
            if (obj.toString().startsWith("FAILED SOME TESTS")) {
                cellColor = "F00000";
            }
            if (obj.toString().equals("1")) {
                cellColor = "009900";
            }
            if (obj.toString().startsWith("PASSED ALL TESTS")) {
                cellColor = "009900";
            }
            String borderString = " BORDER = \"1\"";
            String bgColorString = " BGCOLOR = \"" + cellColor + "\"";
            sb.append("<tr><td ").append(borderString).append(bgColorString).append(">").append(keyval).append("</td><td").append(borderString).append(bgColorString).append(" >").append(obj).append("</td></tr><tr><td>");
        }
        return sb.toString();
    }

    private void convertTemplate2Table(String conv) {
        Table tbl = convert.convertTemplate2Table(this.MA.getDataFile("IN"));
        if (conv.equals("TEMPLATE2TBL/F")) {
            tbl.toTextFile(this.MA.getTextFile("OUT"));
        } else {
            this.MR.put(this.MA.getU("OUT"), (Object)tbl);
        }
    }

    public static Table convertTemplate2Table(DataFile template) {
        template.open();
        Keywords keywds = template.keywords;
        Table tbl = new Table();
        Keywords.Iterator kwi = keywds.iterator();
        Keywords.Key val = null;
        while (kwi.hasNext()) {
            val = kwi.next();
            if (!val.name.equals("SECTION") || !val.value.equals("XDATALIST")) continue;
        }
        if (val != null) {
            Table global = new Table();
            int fields = -1;
            tbl.setKey("_GLOBAL_", global);
            global.setKey("TYPE", "XDATALIST");
            while (kwi.hasNext()) {
                val = kwi.next();
                if (val.name.equals("FIELD")) break;
                global.setKey(val.name, val.value);
                if (!val.name.equals("FIELDS")) continue;
                fields = Convert.o2l(val.value);
            }
            for (int i = 1; i <= fields; ++i) {
                String label = DEF_DUPKEY_DELIM_TAB2XML + i + DEF_DUPKEY_DELIM_TAB2XML;
                Table field = new Table();
                if (keywds.setScope("FIELD=" + i) == 1) {
                    kwi = keywds.iterator();
                    while (kwi.hasNext()) {
                        val = kwi.next();
                        if (val.name.equals("SUBR")) {
                            label = Convert.o2s(val.value);
                            continue;
                        }
                        if (val.name.equals("SECTION")) continue;
                        field.setKey(val.name, val.value);
                    }
                }
                tbl.setKey(label, field);
            }
        } else {
            tbl = null;
        }
        template.close();
        return tbl;
    }

    private void bbdef2java() {
        String fname = this.MA.getFileName("IN").toString();
        try {
            FortranUtil.wrapperByteBuffer(new File(fname));
        }
        catch (Exception e) {
            throw new MidasException("BYTEBUFFER: Error running MAKE on '" + fname + "'.", e);
        }
    }

    private void fstruct2java() {
        String inFile = this.MA.getFileName("IN").toString();
        String outFile = this.MA.getFileName("OUT").toString();
        String struct = this.MA.getS("FORM", null);
        String varName = this.MA.getS("/VARIABLE", null);
        String classSub = this.MA.getS("/CLASSSUB", null);
        String includes = this.MA.getS("/INCLUDE", null);
        boolean pkgPrivate = this.MA.getState("/PACKAGE");
        if (inFile == null || inFile.trim().length() == 0) {
            this.M.error("No input file specified.");
        }
        if (outFile == null || outFile.trim().length() == 0) {
            this.M.error("No output file specified.");
        } else if (!outFile.endsWith(".java")) {
            this.M.error("Name of output file must end in '.java', given '" + outFile + "'.");
        }
        String jniFile = outFile.substring(0, outFile.lastIndexOf(46)) + ".c";
        try {
            FortranUtil.wrapFortranStruct(new File(inFile), new File(outFile), new File(jniFile), struct, varName, classSub, includes, pkgPrivate);
        }
        catch (Exception e) {
            throw new MidasException("BYTEBUFFER: Error running TRANSF: " + e.getMessage(), e);
        }
    }

    private void genmsg(int fmt) {
        String opt = this.MA.getS("IN");
        String path = this.MA.getS("/PATH", this.MR.getS("OPT.PATH"));
        String xmdisk = this.MA.getS("/XMDISK");
        if (xmdisk == null || xmdisk.length() == 0) {
            xmdisk = null;
        }
        XmUtil.genmsg(this.M, xmdisk, opt, path, fmt);
    }

    private void convertRefFrame(String outRefFrame, String outType) {
        DataFile in = this.MA.getDataFile("IN", "5000", "NH|VD", 1);
        in.open();
        DataFile out = this.MA.getDataFile("OUT", in, 2);
        out.open();
        Table inRecDefs = in.getRecordDefs();
        Table outRecDefs = out.getRecordDefs();
        Table qw = this.MA.getTable("QUADWORDS", new Table());
        Time epoch = this.MA.getTime("EPOCH", out.getTime());
        StateVector sv = new StateVector(this, (Object)in.getName());
        if (outRefFrame == null) {
            outRefFrame = in.getReferenceFrame();
        }
        if (inRecDefs.containsKey("POS")) {
            outRecDefs.put("POS.TYPE", (Object)outType);
        }
        if (inRecDefs.containsKey("VEL")) {
            outRecDefs.put("VEL.TYPE", (Object)outType);
        }
        if (inRecDefs.containsKey("ACC")) {
            outRecDefs.put("ACC.TYPE", (Object)outType);
        }
        out.setRecordDefs(outRecDefs);
        out.setReferenceFrame(outRefFrame);
        if (qw.containsKey("ALT")) {
            out.setQuadword(1, qw.getD("ALT"));
        }
        if (qw.containsKey("LAT")) {
            out.setQuadword(2, qw.getD("LAT"));
        }
        if (qw.containsKey("LON")) {
            out.setQuadword(3, qw.getD("LON"));
        }
        if (qw.containsKey("AZIM")) {
            out.setQuadword(4, qw.getD("AZIM"));
        }
        if (qw.containsKey("ELEV")) {
            out.setQuadword(5, qw.getD("ELEV"));
        }
        if (qw.containsKey("ROLL")) {
            out.setQuadword(6, qw.getD("ROLL"));
        }
        out.setQuadword(9, epoch.getYear());
        out.setQuadword(10, epoch.getSoY());
        out.setQuadword(11, epoch.getGHA());
        Transform xform = new Transform(out);
        xform.toDataFile(out);
        if (inRecDefs.containsKey("TIME")) {
            ArrayList<Time> times = new ArrayList<Time>((int)in.getSize());
            int i = 0;
            while ((double)i < in.getSize()) {
                times.add(Time.toTime(in.getData((double)i, "TIME")));
                ++i;
            }
            for (Table row : sv.toFileEntries(times, out)) {
                out.writeDataTable(row);
            }
        } else {
            for (Table row : sv.toFileEntries(out)) {
                out.writeDataTable(row);
            }
        }
        in.close();
        out.close();
    }

    private void svinterp() {
        DataFile in = this.MA.getDataFile("IN", "5000", "NH|VD", 1);
        in.open();
        DataFile out = this.MA.getDataFile("OUT", in, 2);
        out.open();
        StateVector sv = new StateVector(this, (Object)in.getName());
        ArrayList<Time> times = new ArrayList<Time>();
        Table options = this.MA.getTable("OPTIONS");
        Table outRecDefs = out.getRecordDefs();
        DataFile inTimes = null;
        boolean generateTimes = false;
        KeyObject.setKeys(sv, options, this, 0);
        if (!outRecDefs.containsKey("TIME")) {
            outRecDefs.put("TIME", (Object)FileUtil.recDef("TIME", "SD", null, 1, 1));
            out.setRecordDefs(outRecDefs);
        }
        if (this.MA.find("FUNC") && !this.MA.find("TIMES")) {
            inTimes = this.MA.getDataFile("FUNC", "3000|5000|6000", "", 1);
        } else if (this.MA.find("TIMESPEC")) {
            generateTimes = true;
        } else {
            inTimes = this.MA.getDataFile("TIMES", "3000|5000|6000", "", 1);
        }
        if (generateTimes) {
            Table timeSpec = this.MA.getTable("TIMESPEC");
            Time startTime = Time.toTime(timeSpec.get("START"));
            Time stopTime = Time.toTime(timeSpec.get("STOP"));
            double timeDelta = timeSpec.getD("DELTA");
            double deltaWSec = Math.floor(timeDelta);
            double deltaFSec = timeDelta % 1.0;
            int row_minus_1 = 0;
            Time currentTime = new Time(startTime);
            while (currentTime.getSec() < stopTime.getSec()) {
                times.add(currentTime);
                currentTime = new Time(startTime);
                currentTime.addSec(deltaFSec * (double)(++row_minus_1));
                currentTime.addSec(deltaWSec * (double)row_minus_1);
            }
        } else {
            Object row;
            inTimes.open();
            if (inTimes.findRec("TIME") >= 0) {
                row = new Table();
                while (inTimes.readDataTable((Table)row) > 0) {
                    times.add(new Time(((Table)row).getD("TIME")));
                }
            } else if (inTimes.findRec("TCWS") >= 0 && inTimes.findRec("TCFS") >= 0) {
                row = new Table();
                while (inTimes.readDataTable((Table)row) > 0) {
                    Time t = new Time(((Table)row).getD("TCWS"), ((Table)row).getD("TCFS"));
                    if (((Table)row).containsKey("TCO")) {
                        t.addSec(-1.0 * ((Table)row).getD("TCO") * inTimes.getDelta());
                    }
                    times.add(t);
                }
            } else {
                throw new MidasException("No TIME column found in " + inTimes.getName());
            }
        }
        for (Table row : sv.toFileEntries(times, null)) {
            out.writeDataTable(row);
        }
        if (times.size() > 1) {
            double dtTotal = 0.0;
            double dtConst = ((Time)times.get(1)).diff((Time)times.get(0));
            for (int i = 1; i < times.size(); ++i) {
                dtTotal += ((Time)times.get(i)).diff((Time)times.get(i - 1));
            }
            double dt = dtTotal / (double)(times.size() - 1);
            if (Math.abs(dt - dtConst) < 1.0E-12) {
                dt = dtConst;
            }
            out.setDelta(dt);
        } else {
            out.setDelta(1.0);
        }
        out.setUnits(1);
        out.setStart(0.0);
        out.setTime((Time)times.get(0));
        if (!generateTimes) {
            inTimes.close();
        }
        in.close();
        out.close();
    }

    private void sv2blue5001() {
        FileName in = this.MA.getFileName("IN");
        DataFile out = this.MA.getDataFile("OUT");
        StateVector sv = new StateVector(this, (Object)in);
        Table options = this.MA.getTable("OPTIONS");
        Table quals = out.getQualifiers();
        Double xd = quals.getD("XDELTA", 0.0);
        Double size = quals.getD("SIZE", 0.0);
        String timeName = quals.getS("TIME_NAME", "NONE");
        KeyObject.setKeys(sv, options, this, 0);
        if (xd == 0.0) {
            xd = null;
        }
        if (size == 0.0) {
            size = null;
        }
        quals.addIfNotPresent("TYPE", 5001);
        quals.addIfNotPresent("TIME", sv.getStartTime());
        quals.addIfNotPresent("XSTART", 0);
        quals.addIfNotPresent("XDELTA", 60);
        quals.addIfNotPresent("XUNITS", 1);
        out.open(2);
        sv.getTransform().toDataFile(out);
        Time startTime = out.getTimeAtCurrent();
        Time endTime = xd == null || size == null ? null : new Time(startTime).addSec(size * xd);
        List<Table> entries = sv.toFileEntries(startTime, endTime, xd, null);
        Table outRecDefs = out.getRecordDefs();
        Table svRecDefs = sv.toFileRecDefs();
        if (outRecDefs.getSize() == 0) {
            if (!timeName.equals("TIME")) {
                svRecDefs.remove("TIME");
            }
            out.setRecordDefs(svRecDefs);
        }
        if (xd == null && entries.size() >= 2) {
            Time t0 = (Time)entries.get(0).getO("TIME");
            Time t1 = (Time)entries.get(1).getO("TIME");
            out.setXDelta(t1.diff(t0));
        }
        for (Table row : entries) {
            out.writeDataTable(row);
        }
        out.close();
    }

    private void lla2ecr() {
        this.lla2xxx(Transform.toTransform("ECR"));
    }

    private void lla2eci() {
        this.lla2xxx(Transform.toTransform("ECI"));
    }

    private void lla2xxx(Transform t) {
        Table lla = this.MA.getTable("IN", new Table());
        Table options = this.MA.getTable("OPTIONS", new Table());
        DataFile out = this.MA.getDataFile("OUT");
        Time epoch = this.MA.getTime("EPOCH", out.getTime());
        double start = options.getD("START", epoch.getSec());
        double startSec = start % 86400.0;
        double startDay = start - startSec;
        double delta = options.getD("DELTA", 60.0);
        StateVector sv = new StateVector();
        int size = options.getL("ELEM", (int)(86400.0 / out.getDelta() + 1.0));
        sv.setTransform(Transform.toTransform("ECR"));
        out.open(2);
        out.setType(5001);
        out.setRecordDefs(sv.toFileRecDefs());
        out.setTimeCode(startDay);
        out.setStart(startSec);
        out.setDelta(delta);
        out.setSize(size);
        sv.setGeo(lla.getD("ALT"), lla.getD("LAT"), lla.getD("LON"));
        t.setEpoch(epoch);
        t.toDataFile(out);
        for (Table row : sv.toFileEntries(out)) {
            out.writeDataTable(row);
        }
        out.close();
    }
}

