/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.net;

import java.util.Date;
import java.util.Hashtable;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.Convert;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.KeyObject;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.libg.GMenu;
import nxm.sys.libg.GPrompt;
import nxm.sys.libg.GValue;
import nxm.sys.libg.GWidget;
import nxm.sys.net.HPage;
import nxm.sys.net.HQuery;
import nxm.sys.net.HSource;

public class HFile
extends HSource {
    private BaseFile bf;
    private static boolean debug = false;
    private static final String htmlContentType = "text/html";
    private static final String textContentType = "text/plain";
    private static final String binaryContentType = "application/octet-stream";
    private static final String jarContentType = "application/x-java-archive";
    private static final String jnlpContentType = "application/x-java-jnlp-file";
    private static Hashtable<String, String> types;

    public HFile(String name, BaseFile bf) {
        this.name = name;
        this.bf = bf;
        if (debug) {
            Shell.writeln("HFile() name=" + name + " bf=" + bf);
        }
    }

    public static void setDebug(boolean val) {
        debug = val;
    }

    public static boolean isDebug() {
        return debug;
    }

    @Override
    public boolean canHandleRequest(String uri) {
        String rname = this.getName();
        return uri.equals(rname);
    }

    @Override
    public void handleRequest(String uri, HPage hp) {
        HFile.handle(this.bf, hp, null);
    }

    public static void handle(BaseFile bf, HPage hp, String args) {
        if (debug) {
            Shell.writeln("HFile.handle() " + hp.getMethod() + " bf.url=" + bf.getURL());
        }
        boolean isHeadRequest = hp.getMethod().equals("HEAD");
        bf.open(33);
        if (!bf.isOpen) {
            hp.setStatus(404);
            hp.open();
            if (!isHeadRequest) {
                hp.writeNotFound();
            }
            hp.close();
            return;
        }
        int bytes = 0;
        int bufsize = 32768;
        double tbytes = bf.getSize();
        double offset = hp.getHeaderD("Range");
        String mime = HFile.getContentType(bf.getFileName().getExt(), null);
        if (mime == null) {
            mime = BaseFile.getMimeType(null, bf.getName());
        }
        long lastModified = bf.getResource().lastModified();
        if (offset > 0.0) {
            bf.seek(offset);
            hp.setContentRange((long)offset, (long)(tbytes - 1.0), (long)tbytes);
            tbytes -= offset;
        }
        if (lastModified > 0L) {
            hp.setLastModified(new Date(lastModified));
        }
        hp.setContentType(mime);
        hp.setContentLength((long)tbytes);
        if (isHeadRequest) {
            hp.open();
        } else if (jnlpContentType.equals(mime)) {
            bytes = (int)tbytes;
            byte[] buf = new byte[bytes];
            bf.read(buf, 0, bytes);
            String sbuf = new String(buf);
            if (hp.server != null) {
                sbuf = sbuf.replaceAll("MYHOST", hp.server.getHost());
                sbuf = sbuf.replaceAll("MYPORT", "" + hp.server.getPort());
                sbuf = hp.server.parent.MA.evaluateCarets(sbuf);
                buf = sbuf.getBytes();
                hp.setContentLength(buf.length);
            }
            hp.open();
            hp.write(buf);
        } else if (tbytes <= (double)bufsize) {
            bytes = (int)tbytes;
            byte[] buf = new byte[bytes];
            bytes = bf.read(buf, 0, bytes);
            if (!binaryContentType.equals(mime) && !jarContentType.equals(mime)) {
                String str = new String(buf, 0, Math.min(200, bytes));
                if (hp.server != null && str.indexOf("NMSSPP=ON") > 0) {
                    StringBuffer sb = new StringBuffer(new String(buf, 0, bytes));
                    bytes = HFile.serverSidePreProcess(sb, hp, args);
                    buf = sb.toString().getBytes();
                    hp.setContentLength(bytes);
                }
            }
            hp.open();
            hp.write(buf, 0, bytes);
        } else {
            int bytesRead;
            byte[] buf = new byte[bufsize];
            hp.open();
            while (tbytes > 0.0 && (bytesRead = bf.read(buf, 0, bytes = (int)Math.min(tbytes, (double)bufsize))) >= 0 && hp.write(buf, 0, bytesRead) >= 0) {
                tbytes -= (double)bytes;
            }
        }
        hp.close();
        bf.close();
    }

    private static int serverSidePreProcess(StringBuffer sb, HPage hp, String args) {
        String value;
        int j;
        int i;
        int id = 1;
        if (hp == null || hp.server == null) {
            return sb.length();
        }
        Midas M = hp.server.getMidas();
        while ((i = sb.indexOf("<!-- FORALL")) >= 0) {
            j = sb.indexOf("<!-- ENDFOR -->", i);
            int k = sb.indexOf(">", i);
            String sx = HFile.serverSideSub(sb.substring(i + 12, k - 2), M);
            int l = sx.indexOf(58);
            int l1 = Convert.s2l(sx.substring(l - 1, l));
            int l2 = Convert.s2l(sx.substring(l + 1));
            String s = sb.substring(k + 1, j);
            value = "";
            for (int n = l1; n <= l2; ++n) {
                value = value + StringUtil.replaceAll(s, "#", "" + n);
            }
            sb.replace(i, j + 15, value);
        }
        while ((i = sb.lastIndexOf("^{")) >= 0) {
            j = sb.indexOf("}", i);
            String key = sb.substring(i + 2, j).toUpperCase();
            Object obj = null;
            value = "XXX";
            if (key.startsWith("HS.")) {
                obj = KeyObject.getKey(hp.server, key.substring(3), null, M);
            } else if (M != null) {
                obj = M.results.get(key);
            }
            if (obj instanceof GWidget) {
                GWidget gw = (GWidget)obj;
                value = HFile.getControlWidget(gw, id, hp.server.getMidas());
                ++id;
            } else if (obj != null) {
                value = obj.toString();
            }
            sb.replace(i, j + 1, value);
        }
        return sb.length();
    }

    private static String serverSideSub(String sb, Midas M) {
        int i;
        while ((i = sb.lastIndexOf("^{")) >= 0) {
            int j = sb.indexOf("}", i);
            String key = sb.substring(i + 2, j).toUpperCase();
            Object obj = null;
            String value = "XXX";
            if (M != null) {
                value = M.results.getS(key);
            }
            sb = sb.substring(0, i) + value + sb.substring(j + 1);
        }
        return sb;
    }

    @InternalUseOnly(value="Since added in NeXtMidas 3.7.0")
    public static String getControlWidget(GWidget gw, int id, Midas M) {
        String seed = gw.getValueString();
        String tag = "'he" + id + "'";
        String tagq = "'he" + id + "q'";
        String value = "<a id=" + tag + ">" + seed + "</a>";
        boolean noedit = gw.getFlag(8);
        if (noedit) {
            value = "<span id=" + tag + " onmouseover=gnoedit(" + tag + ")>" + seed + "</span>";
        } else if (gw instanceof GPrompt) {
            GPrompt gwp = (GPrompt)gw;
            String list3 = "&ltEnter&gt";
            if (gwp.isFileChooser()) {
                String uext;
                String path;
                String[] files;
                String raux = gwp.getAux();
                String auxList = M.results.getString("AUX.READ");
                if (auxList.indexOf(raux) < 0) {
                    auxList = raux + "|" + auxList;
                }
                list3 = list3 + ",&ltAux:" + auxList + "&gt";
                list3 = list3 + ",&lt--Aux=" + raux + "--&gt";
                String ext = "tmp|prm";
                String root = gwp.getFilter();
                int ip = root.indexOf(46);
                if (ip > 0) {
                    ext = root.substring(ip + 1);
                    root = root.substring(0, ip);
                }
                if ((files = M.io.listFiles(path = M.io.getAuxPath(raux), root, uext = raux.equals("RAM") ? "" : ext)) != null) {
                    for (int i = 0; i < files.length; ++i) {
                        list3 = list3 + "," + files[i];
                    }
                }
            }
            value = "<span id=" + tag + " onmouseover=gselect(" + tag + ",'" + gw.label + "','" + list3 + "','" + seed + "')>" + seed + "</span><span id=" + tagq + "> </span>";
        } else if (gw instanceof GPrompt) {
            GPrompt gwp = (GPrompt)gw;
            value = "<span id=" + tag + " onclick=gprompt(" + tag + ",'" + gw.label + "','" + seed + "')>" + seed + "</span>";
        } else if (gw instanceof GMenu) {
            GMenu gwm = (GMenu)gw;
            String input = gwm.getFlag(0x200000) ? "&ltEnter&gt," : "";
            value = "<span id=" + tag + " onmouseover=gselect(" + tag + ",'" + gw.label + "','" + input + gwm.getItems() + "','" + seed + "')>" + seed + "</span>";
        } else if (gw instanceof GValue) {
            GValue gwv = (GValue)gw;
            value = "<span id=" + tag + " onmouseover=gvalue(" + tag + ",'" + gw.label + "','" + seed + "')>" + seed + "</span>";
        } else if (gw instanceof GValue) {
            GValue gwv = (GValue)gw;
            value = "<span id=" + tag + " onclick=gselect(" + tag + ",'" + gw.label + "','" + seed + "')>" + seed + "</span>";
            value = "<span id=" + tag + " onclick=gprompt(" + tag + ",'" + gw.label + "','" + seed + "')>" + seed + "</span>";
            value = "<span id=" + tag + " onclick=gvalue(" + tag + ",'" + gw.label + "','" + seed + "')>" + seed + "</span>";
        }
        return value;
    }

    @InternalUseOnly(value="Since added in NeXtMidas 3.7.0")
    public static String getControlWidgetOrig(GWidget gw, String args, Midas M) {
        boolean expand = args != null && args.equals(gw.label) && !gw.getFlag(8);
        String value = null;
        if (!expand) {
            String seed = gw.getValueString();
            if (seed == null || seed.length() == 0) {
                seed = "[]";
            }
            value = "<a href=\"?" + gw.label + "\">" + seed + "</a>";
        } else if (gw instanceof GPrompt) {
            GPrompt gwp = (GPrompt)gw;
            String seed = gw.getValueString();
            if (seed == null || seed.length() == 0) {
                seed = "[]";
            }
            if (gwp.isFileChooser()) {
                value = "[<a id=\"" + gw.label + "\" onClick=\"gcprompt('" + gw.label + "','" + seed + "')\">Enter:</a>,<b>" + seed + "</b>,Auxes";
                String auxList = M.results.getString("AUX.READ");
                Parser auxes = new Parser(auxList, '|');
                auxes.reset();
                while (auxes.more()) {
                    String aux = auxes.next();
                    String path = M.io.getAuxPath(aux);
                    value = value + ",<a href='filesPage.html?Aux" + aux + "' target='filesFrame'>" + aux + "</a>";
                }
                value = value + "]";
            } else {
                value = "[" + seed + "] <a id=\"" + gw.label + "\" onClick=\"gcprompt('" + gw.label + "','" + seed + "')\">Enter</a> <a href=\"?" + gw.label + "=" + seed + ">Default</a>";
            }
        } else {
            value = gw.toString();
            value = HQuery.lookForChoices(gw.label, value, false);
            int lb = value.indexOf("[");
            int rb = value.lastIndexOf("]");
            if (lb >= 0 && rb > lb) {
                value = value.substring(lb, rb + 1);
            }
        }
        if (expand) {
            value = "<a href=\"?\">&lt</a>" + value;
        }
        return value;
    }

    public static void handlePipe(DataFile bf, HPage hp) {
        bf.open(33);
        boolean isHeadRequest = hp.getMethod().equals("HEAD");
        if (!bf.isOpen) {
            hp.setStatus(404);
            hp.open();
            if (!isHeadRequest) {
                hp.writeNotFound();
            }
            hp.close();
            return;
        }
        int bytes = 0;
        int bufsize = 1024;
        hp.setContentType(binaryContentType);
        hp.setContentLength(0x6400000L);
        hp.open();
        if (!isHeadRequest) {
            int bytesRead;
            bf.setDataStart(512.0);
            bf.setDataSize(1048576.0);
            hp.write(bf.hb, 0, 512);
            byte[] buf = new byte[bufsize];
            while ((bytesRead = bf.read(buf, 0, bytes = bufsize)) >= 0 && hp.write(buf, 0, bytesRead) >= 0) {
            }
        }
        hp.close();
        bf.close();
    }

    @InternalUseOnly
    public static String getContentType(String ext, String def) {
        String type;
        ext = ext.toLowerCase();
        if (types == null) {
            Hashtable<String, String> typesMap = new Hashtable<String, String>();
            typesMap.put("xhtml", htmlContentType);
            typesMap.put("html", htmlContentType);
            typesMap.put("htm", htmlContentType);
            typesMap.put("mm", textContentType);
            typesMap.put("key", textContentType);
            typesMap.put("txt", textContentType);
            typesMap.put("java", textContentType);
            typesMap.put("c", textContentType);
            typesMap.put("h", textContentType);
            typesMap.put("tmp", binaryContentType);
            typesMap.put("prm", binaryContentType);
            typesMap.put("pkt", binaryContentType);
            typesMap.put("det", binaryContentType);
            typesMap.put("jnlp", jnlpContentType);
            typesMap.put("jar", jarContentType);
            typesMap.put("jardiff", "application/x-java-archive-diff");
            types = typesMap;
        }
        if ((type = types.get(ext)) == null) {
            type = def;
        }
        return type;
    }
}

