/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.net;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Midas;
import nxm.sys.lib.Table;
import nxm.sys.libg.GWidget;
import nxm.sys.libg.MBox;
import nxm.sys.libg.MPanel;
import nxm.sys.libg.Theme;
import nxm.sys.net.HPage;
import nxm.sys.net.HSource;
import nxm.sys.prim.panel;

@ProvisionalUseOnly(value="contributed but not tested in test matrix")
public class HDisplay
extends HSource {
    private Midas M;
    private panel panel;
    private GraphicsEnvironment ge;
    private GraphicsDevice gd;
    private Robot robot;
    private boolean headless;
    int[] rgb = null;
    int[] rgbs = null;

    public HDisplay(String name, Midas M) {
        this.M = M;
        this.name = name + "/";
        this.headless = Theme.isHeadless();
        if (!this.headless) {
            this.ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.gd = this.ge.getDefaultScreenDevice();
            try {
                this.robot = new Robot();
            }
            catch (Exception e) {
                M.printStackTrace("Unable to instantiate Robot class for event generation ", e);
            }
        }
    }

    @Override
    public void handleRequest(String uri, HPage hp) {
        String option = uri.substring(this.name.length() + 1);
        if (this.panel == null && this.M != null) {
            this.panel = (panel)this.M.registry.get("PANEL");
        }
        if (option.length() == 0) {
            option = this.panel != null ? "js/Pane0" : "js/Screen";
        }
        int ia = option.indexOf(63);
        String args = null;
        if (ia > 0) {
            args = option.substring(ia + 1);
            option = option.substring(0, ia);
        }
        if (option.startsWith("sc/")) {
            this.scPage(hp, option.substring(3), args);
        } else if (option.startsWith("js/")) {
            this.jsPage(hp, option.substring(3), args);
        } else if (option.startsWith("ws/")) {
            this.wsPage(hp, option.substring(3), args);
        } else {
            this.homePage(hp, option);
        }
    }

    public void homePage(HPage hp, String name) {
        String key;
        int i;
        hp.openToBody("HDisplay " + name);
        hp.writeln("<br>");
        hp.writeln("<center><h3> Display Capture </h3></center>");
        hp.writeln("<br>");
        GraphicsDevice[] devs = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        for (int i2 = 0; i2 < devs.length; ++i2) {
            GraphicsDevice dev = devs[i2];
            Rectangle rect = dev.getDefaultConfiguration().getBounds();
            int w = (int)rect.getWidth();
            int h = (int)rect.getHeight();
            hp.writeln("<center><a href='sc/Screen'>Full Session Screen (" + w + "x" + h + ")</a></center>");
        }
        panel.Pane[] panes = this.panel.getPanesArray();
        for (i = 0; i < panes.length; ++i) {
            key = i == 0 ? "APP" : panes[i].name;
            String value = i == 0 ? this.M.macro.args.name : panes[i].title;
            hp.writeln("<center><a href='sc/Pane" + i + "'>" + key + " = " + value + "</a></center>");
        }
        hp.writeln("<br>");
        hp.writeln("<center><h3> Display Server </h3></center>");
        hp.writeln("<br>");
        hp.writeln("<center><a href='js/Screen'>Full Session Screen</a></center>");
        for (i = 0; i < panes.length; ++i) {
            key = i == 0 ? "APP" : panes[i].name;
            String value = i == 0 ? this.M.macro.args.name : panes[i].title;
            hp.writeln("<center><a href='js/Pane" + i + "'>" + key + " = " + value + "</a></center>");
        }
        hp.closeFromBody();
    }

    public void scPage(HPage hp, String name, String args) {
        Rectangle rect = null;
        if (!this.headless) {
            rect = this.gd.getDefaultConfiguration().getBounds();
        }
        if (name.startsWith("Pane")) {
            int ip = Convert.s2l(name.substring(4));
            panel.Pane[] panes = this.panel.getPanesArray();
            panel.Pane pane = panes[ip];
            MBox pos = this.panel.MW.pos;
            if (ip == 0) {
                rect.setBounds(pos.x, pos.y, pos.w, pos.h);
            } else {
                rect.setBounds(pos.x + pane.pos.x, pos.y + pane.pos.y, pane.pos.w, pane.pos.h);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            BufferedImage image = this.robot.createScreenCapture(rect);
            ImageIO.write((RenderedImage)image, "png", baos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        hp.setContentType("image/png");
        hp.setContentLength(baos.size());
        hp.open();
        if (!hp.getMethod().equals("HEAD")) {
            hp.write(baos);
        }
        hp.close();
    }

    public void jsPage(HPage hp, String name, String args) {
        MBox pos = new MBox(0, 0, 100, 100);
        if (name.startsWith("Pane")) {
            int ip = Convert.s2l(name.substring(4));
            panel.Pane[] panes = this.panel.getPanesArray();
            panel.Pane pane = panes[ip];
            pos = new MBox(this.panel.MW.pos);
            if (ip > 0) {
                pos.setBounds(pos.x + pane.pos.x, pos.y + pane.pos.y, pane.pos.w, pane.pos.h);
            }
        } else {
            Rectangle rect = this.gd.getDefaultConfiguration().getBounds();
            pos.w = (int)rect.getWidth();
            pos.h = (int)rect.getHeight();
        }
        String host = this.server.getHost();
        int port = this.server.getPort();
        hp.openUpToBody("HDisplay " + name);
        hp.writeln("<script type='text/javascript' src='/nmroot/nxm/sys/net/hdisplay.js'></script>");
        hp.writeln("<body onload=\"hdisplay('" + host + "'," + port + "," + pos.x + "," + pos.y + "," + pos.w + "," + pos.h + ",'" + name + "');\">");
        hp.writeln("<canvas id=canvas width='" + pos.w + "' height='" + pos.h + "'></canvas>");
        hp.closeFromBody();
    }

    public void wsPage(HPage hp, String name, String args) {
        int len;
        Rectangle rect = null;
        rect = this.headless ? new Rectangle(0, 0, 1280, 1024) : this.gd.getDefaultConfiguration().getBounds();
        if (name.startsWith("Pane")) {
            int ip = Convert.s2l(name.substring(4));
            panel.Pane[] panes = this.panel.getPanesArray();
            panel.Pane pane = panes[ip];
            MBox pos = this.panel.MW.pos;
            if (ip == 0) {
                rect.setBounds(pos.x, pos.y, pos.w, pos.h);
            } else {
                rect.setBounds(pos.x + pane.pos.x, pos.y + pane.pos.y, pane.pos.w, pane.pos.h);
            }
        }
        hp.openWS("vnc-client");
        if (this.rgbs != null) {
            for (int i = 0; i < this.rgbs.length; ++i) {
                this.rgbs[i] = 0;
            }
        }
        byte[] b = new byte[1040];
        while (this.panel.state == 2 && (len = hp.recvWS(b, 0, b.length)) >= 0) {
            int bm;
            int bu;
            int ab;
            if (len == 3 && b[0] == 82 && b[1] == 85) {
                this.updateRFB(hp, rect, b);
                for (int i = 0; i < 8; ++i) {
                    b[i] = 0;
                }
                hp.sendWS(b, 0, 8);
                continue;
            }
            b[2] = 123;
            b[len] = 125;
            Table t = new Table(b, 2, len - 1);
            int x = t.getL("X", 0);
            int y = t.getL("Y", 0);
            if (x > 0 || y > 0) {
                this.robot.mouseMove(x + (int)rect.getX(), y + (int)rect.getY());
            }
            int n = (ab = Math.abs(bu = t.getL("B", 0))) == 3 ? 4096 : (bm = ab == 2 ? 2048 : 1024);
            if (bu > 0) {
                this.robot.mousePress(bm);
            }
            if (bu < 0) {
                this.robot.mouseRelease(bm);
            }
            int kp = t.getL("K", 0);
            int km = this.keymap(Math.abs(kp));
            if (kp > 0) {
                this.robot.keyPress(km);
            }
            if (kp >= 0) continue;
            this.robot.keyRelease(km);
        }
        hp.closeWS();
    }

    private void updateRFB(HPage hp, Rectangle r, byte[] b) {
        int w = (int)r.getWidth();
        int h = (int)r.getHeight();
        int nt = h * w;
        int nr = 0;
        int ns = 0;
        if (this.rgb == null || nt > this.rgb.length) {
            this.rgb = new int[nt];
            this.rgbs = new int[nt];
        }
        BufferedImage image = this.getImage1(r);
        image.getRGB(0, 0, w, h, this.rgb, 0, w);
        for (int y = 0; y < h; y += 16) {
            if (y + 16 > h) {
                y = h - 16;
            }
            for (int x = 0; x < w; x += 16) {
                if (x + 16 > w) {
                    x = w - 16;
                }
                int[] rgba = Convert.castL(b, false);
                boolean same = true;
                int i = y * w + x;
                int j = 2;
                int iy = 0;
                while (iy < 16) {
                    int ix = 0;
                    while (ix < 16) {
                        int p;
                        rgba[j] = p = this.rgb[i];
                        if (p != this.rgbs[i]) {
                            same = false;
                            this.rgbs[i] = p;
                        }
                        ++ix;
                        ++i;
                        ++j;
                    }
                    ++iy;
                    i += w - 16;
                }
                rgba[0] = y << 16 | x;
                rgba[1] = 0x100010;
                Convert.uncast(rgba, b, false);
                if (!same) {
                    for (int k = 8; k < 1032; k += 4) {
                        byte bs = b[k];
                        b[k] = b[k + 2];
                        b[k + 2] = bs;
                    }
                    hp.sendWS(b, 0, 1032);
                    ++ns;
                }
                ++nr;
            }
        }
    }

    private BufferedImage getImage1(Rectangle rect) {
        BufferedImage image = this.robot.createScreenCapture(rect);
        return image;
    }

    private BufferedImage getImage2(Rectangle rrect) {
        Container p = this.panel.MW.panel;
        Rectangle rect = p.getBounds();
        int x = p.getX();
        int y = p.getY();
        int w = p.getWidth();
        int h = p.getHeight();
        try {
            BufferedImage image = new BufferedImage(w, h, 1);
            Graphics gc = image.getGraphics();
            p.paint(gc);
            for (int i = 0; i < p.getComponentCount(); ++i) {
                Component o = p.getComponent(i);
                if (!(o instanceof MPanel)) continue;
                MPanel mp = (MPanel)o;
                Rectangle r = mp.getBounds();
                if (!(mp.MW instanceof GWidget) || !rect.contains(r.getX(), r.getY())) continue;
                gc.translate((int)r.getX() - x, (int)r.getY() - y);
                mp.paint(gc);
            }
            return image;
        }
        catch (Exception e) {
            System.out.println("Unable to export image: " + e);
            return null;
        }
    }

    private int keymap(int key) {
        switch (key) {
            case 13: {
                key = 10;
                break;
            }
            case 46: {
                key = 127;
                break;
            }
            case 188: {
                key = 44;
                break;
            }
            case 190: {
                key = 46;
                break;
            }
        }
        return key;
    }
}

