/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import nxm.sys.lib.BaseFile;
import nxm.sys.lib.FileName;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Util;

public class Symbol
implements Icon {
    public static final int DEFAULT_SIZE = 6;
    public static final String symbolList = "Aero,Arrow,Circle,Cross,Diamond,Dot,Plus,Square,Star,Triangle,UTri,DTri,RTri,LTri,A,B,C,D,Ascii-XYZ,None";
    protected int r = 3;
    protected boolean isFilled = false;
    protected float heading = 0.0f;

    public final void draw(int x, int y, Graphics g) {
        float hdg = this.getHeading();
        if (hdg == 0.0f) {
            this.draw(x, y, g, this.r);
        } else {
            double radians = (double)hdg * (Math.PI / 180);
            Graphics g2 = g.create();
            ((Graphics2D)g2).rotate(radians, x, y);
            this.draw(x, y, g2, this.r);
            g2.dispose();
        }
    }

    protected void draw(int x, int y, Graphics g, int r) {
        g.drawLine(x - r, y - r, x + r, y + r);
        g.drawLine(x - r, y + r, x + r, y - r);
    }

    @Deprecated
    public final void drawIcon(int x, int y, Graphics g) {
        this.draw(x, y, g, g.getFontMetrics().getHeight());
    }

    @Deprecated
    public void drawIcon(int x, int y, Graphics g, int r) {
        this.draw(x, y, g, r);
    }

    @Deprecated
    public final void draw(int[] x, int[] y, int n, Graphics g) {
        for (int i = 0; i < n; ++i) {
            this.draw(x[i], y[i], g);
        }
    }

    public BufferedImage getImage(int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 2);
        img.createGraphics();
        Graphics2D g2d = (Graphics2D)img.getGraphics();
        this.draw(width / 2, height / 2, g2d);
        return img;
    }

    public int getSize() {
        return this.r * 2;
    }

    public void setSize(int value) {
        this.r = value / 2;
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setFilled(boolean isFilled) {
        this.isFilled = isFilled;
    }

    public final float getAngle() {
        return this.getAngleDeg() * ((float)Math.PI / 180);
    }

    public final void setAngle(float radians) {
        this.setAngleDeg(radians * 57.29578f);
    }

    public final void setAngleDeg(float deg) {
        this.setHeading(360.0f - deg);
    }

    public final float getAngleDeg() {
        return 360.0f - this.getHeading();
    }

    public void setHeading(float deg) {
        if (deg >= 360.0f) {
            deg %= 360.0f;
        }
        if (deg < 0.0f) {
            deg = 360.0f - -deg % 360.0f;
        }
        this.heading = deg;
    }

    public float getHeading() {
        return this.heading;
    }

    public String getName() {
        return Util.getClassName(this);
    }

    @Override
    public int getIconWidth() {
        return this.getSize() * 2;
    }

    @Override
    public int getIconHeight() {
        return this.getSize() * 2;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color bgColor = c == null ? Color.GRAY : c.getBackground();
        Color fgColor = c == null ? Color.BLACK : c.getForeground();
        int offset = this.getSize();
        g.setColor(fgColor);
        this.draw(x + offset, y + offset, g);
        g.setColor(bgColor);
    }

    public static Symbol getSymbol(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Symbol) {
            return (Symbol)obj;
        }
        if (obj instanceof Icon) {
            return new IconSymbol((Icon)obj);
        }
        if (obj instanceof Image) {
            return new IconSymbol(new ImageIcon((Image)obj));
        }
        if (obj instanceof FileName) {
            return Symbol.loadSymbol((FileName)obj);
        }
        return Symbol.getSymbol(obj.toString(), 6);
    }

    public static Symbol get(String name, int size) {
        return Symbol.getSymbol(name, size);
    }

    public static Symbol getSymbol(String name, int size) {
        if (name == null || name.isEmpty()) {
            name = "NULL";
        }
        String sname = name.trim().toUpperCase();
        Symbol s = null;
        if (sname.startsWith("ASCII-")) {
            s = new Ascii(name.substring(6));
        } else if (sname.length() == 1) {
            s = new Ascii(name);
        } else if (sname.equals("AERO")) {
            s = new Aero();
        } else if (sname.equals("ARROW")) {
            s = new Arrow();
        } else if (sname.equals("CIRCLE")) {
            s = new Circle();
        } else if (sname.equals("CROSS")) {
            s = new Cross();
        } else if (sname.equals("DIAMOND")) {
            s = new Diamond();
        } else if (sname.equals("DOT")) {
            s = new Dot();
        } else if (sname.equals("PLUS")) {
            s = new Plus();
        } else if (sname.equals("SQUARE")) {
            s = new Square();
        } else if (sname.equals("STAR")) {
            s = new Star();
        } else if (sname.equals("NONE")) {
            s = new None();
        } else if (sname.equals("TRIANGLE") || sname.equals("TRI")) {
            s = new Triangle();
        } else if (sname.equals("UTRIANGLE") || sname.equals("UTRI")) {
            s = new UTriangle();
        } else if (sname.equals("DTRIANGLE") || sname.equals("DTRI")) {
            s = new DTriangle();
        } else if (sname.equals("RTRIANGLE") || sname.equals("RTRI")) {
            s = new RTriangle();
        } else if (sname.equals("LTRIANGLE") || sname.equals("LTRI")) {
            s = new LTriangle();
        } else if (sname.equals("NULL")) {
            s = null;
            Shell.warning("Cannot set to 'NULL' Symbol, leaving as default. Use 'NONE' or other symbol from: Aero,Arrow,Circle,Cross,Diamond,Dot,Plus,Square,Star,Triangle,UTri,DTri,RTri,LTri,A,B,C,D,Ascii-XYZ,None");
        } else if (name.indexOf(46) > 0 || name.indexOf(58) > 0 || name.indexOf(123) > 0) {
            FileName fname = FileName.toFileName(name);
            s = Symbol.loadSymbol(fname);
        } else {
            Shell.warning("Unrecognized symbol name '" + name + "', valid symbols: " + symbolList);
        }
        if (s != null) {
            s.setSize(size);
        }
        return s;
    }

    private static Symbol loadSymbol(FileName fname) {
        BaseFile in = BaseFile.getInstanceFor(Shell.getSharedMidasContext(), (Object)fname);
        try {
            in.open();
            InputStream is = in.getResource().getInputStream();
            BufferedImage img = ImageIO.read(is);
            is.close();
            in.close();
            ImageIcon icon = new ImageIcon(img);
            return new IconSymbol(icon, fname.toString());
        }
        catch (Exception e) {
            throw new MidasException("Symbol: Unable to read '" + fname + "'", e);
        }
    }

    static final class None
    extends Symbol {
        None() {
        }

        @Override
        public boolean isFilled() {
            return false;
        }

        @Override
        public void draw(int x, int y, Graphics g, int r) {
        }
    }

    static final class ScrollEnd
    extends DTriangle {
        public ScrollEnd() {
            this.setFilled(true);
        }

        @Override
        public void draw(int x, int y, Graphics g, int r) {
            super.draw(x, y, g, r);
            g.drawLine(x + r, y + r, x - r, y + r);
        }
    }

    public static final class CheckBox
    extends Square {
        private boolean selected;

        public CheckBox(boolean sel) {
            this.selected = sel;
        }

        @Override
        public void draw(int x, int y, Graphics g, int r) {
            super.draw(x, y, g, (int)((float)r * 1.5f));
            if (this.selected) {
                g.drawLine(x - r, y - r, x + r, y + r);
                g.drawLine(x + r, y - r, x - r, y + r);
            }
        }
    }

    public static final class LTriangle
    extends Triangle {
        @Override
        protected int[][] getPoints(int x, int y, int r) {
            int[] xPoints = new int[]{x - r, x + r, x + r};
            int[] yPoints = new int[]{y, y - r, y + r};
            return new int[][]{xPoints, yPoints};
        }
    }

    public static final class RTriangle
    extends Triangle {
        @Override
        protected int[][] getPoints(int x, int y, int r) {
            int[] xPoints = new int[]{x + r, x - r, x - r};
            int[] yPoints = new int[]{y, y - r, y + r};
            return new int[][]{xPoints, yPoints};
        }
    }

    public static class DTriangle
    extends Triangle {
        @Override
        protected int[][] getPoints(int x, int y, int r) {
            int[] xPoints = new int[]{x, x + r, x - r};
            int[] yPoints = new int[]{y + r, y - r, y - r};
            return new int[][]{xPoints, yPoints};
        }
    }

    public static final class UTriangle
    extends Triangle {
    }

    public static class Triangle
    extends Polygon {
        @Override
        protected int[][] getPoints(int x, int y, int r) {
            int[] xPoints = new int[]{x, x + r, x - r};
            int[] yPoints = new int[]{y - r, y + r, y + r};
            return new int[][]{xPoints, yPoints};
        }
    }

    public static final class Diamond
    extends Polygon {
        @Override
        protected int[][] getPoints(int x, int y, int r) {
            int[] xPoints = new int[]{x - r, x, x + r, x};
            int[] yPoints = new int[]{y, y + r, y, y - r};
            return new int[][]{xPoints, yPoints};
        }
    }

    public static class Square
    extends Polygon {
        @Override
        protected int[][] getPoints(int x, int y, int r) {
            int[] xPoints = new int[]{x - r, x + r, x + r, x - r};
            int[] yPoints = new int[]{y - r, y - r, y + r, y + r};
            return new int[][]{xPoints, yPoints};
        }
    }

    public static final class Aero
    extends Polygon {
        @Override
        protected int[][] getPoints(int x, int y, int r) {
            boolean d0 = false;
            int d1 = r / 4;
            int d2 = r / 2;
            int d3 = 3 * r / 4;
            int d4 = r;
            int[] xPoints = new int[]{x - 0, x - d2, x - d2, x - d1, x - d1, x - d4, x - d4, x - d1, x - d1, x - 0, x + d1, x + d1, x + d4, x + d4, x + d1, x + d1, x + d2, x + d2};
            int[] yPoints = new int[]{y + d3, y + d4, y + d3, y + d2, y + 0, y + d1, y + 0, y - d2, y - d3, y - d4, y - d3, y - d2, y + 0, y + d1, y + 0, y + d2, y + d3, y + d4};
            return new int[][]{xPoints, yPoints};
        }
    }

    public static class Arrow
    extends Polygon {
        @Override
        protected int[][] getPoints(int x, int y, int r) {
            int d = r / 4;
            int[] xPoints = new int[]{x - d, x - d, x - r, x, x + r, x + d, x + d};
            int[] yPoints = new int[]{y + r, y, y, y - r, y, y, y + r};
            return new int[][]{xPoints, yPoints};
        }
    }

    public static abstract class Polygon
    extends Symbol {
        protected abstract int[][] getPoints(int var1, int var2, int var3);

        @Override
        public void draw(int x, int y, Graphics g, int r) {
            int[][] points = this.getPoints(x, y, r);
            g.drawPolygon(points[0], points[1], points[0].length);
            if (this.isFilled()) {
                g.fillPolygon(points[0], points[1], points[0].length);
            }
        }
    }

    public static final class Dot
    extends Symbol {
        @Override
        public boolean isFilled() {
            return true;
        }

        @Override
        public float getHeading() {
            return 0.0f;
        }

        @Override
        public void draw(int x, int y, Graphics g, int r) {
            g.drawOval(x - (r /= 4), y - r, r + r, r + r);
            g.fillOval(x - r, y - r, r + r, r + r);
        }
    }

    public static final class Circle
    extends Symbol {
        @Override
        public float getHeading() {
            return 0.0f;
        }

        @Override
        public void draw(int x, int y, Graphics g, int r) {
            g.drawOval(x - r, y - r, r + r, r + r);
            if (this.isFilled()) {
                g.fillOval(x - r, y - r, r + r, r + r);
            }
        }
    }

    public static final class Star
    extends Symbol {
        @Override
        public boolean isFilled() {
            return false;
        }

        @Override
        public void draw(int x, int y, Graphics g, int r) {
            g.drawLine(x - r, y, x + r, y);
            g.drawLine(x, y - r, x, y + r);
            g.drawLine(x - r, y - r, x + r, y + r);
            g.drawLine(x - r, y + r, x + r, y - r);
        }
    }

    public static final class Plus
    extends Symbol {
        @Override
        public boolean isFilled() {
            return false;
        }

        @Override
        public void draw(int x, int y, Graphics g, int r) {
            g.drawLine(x - r, y, x + r, y);
            g.drawLine(x, y - r, x, y + r);
        }
    }

    public static final class Cross
    extends Symbol {
        @Override
        public boolean isFilled() {
            return false;
        }

        @Override
        public void draw(int x, int y, Graphics g, int r) {
            g.drawLine(x - r, y - r, x + r, y + r);
            g.drawLine(x - r, y + r, x + r, y - r);
        }
    }

    public static final class Ascii
    extends Symbol {
        private String text;

        public Ascii(String text) {
            this.text = text;
        }

        @Override
        public void draw(int x, int y, Graphics g, int r) {
            g.drawString(this.text, x - r, y + r);
        }

        @Override
        public void drawIcon(int x, int y, Graphics g, int r) {
            int fontHeight = g.getFontMetrics().getHeight();
            int offset = fontHeight * 5 / 16;
            if (this.text.length() == 1) {
                g.drawString(this.text, x - r, y + r + offset);
            } else {
                Font oldFont = g.getFont();
                Font newFont = oldFont.deriveFont(2);
                g.setFont(newFont);
                g.drawString("S", x - r, y + r + offset);
                g.setFont(oldFont);
            }
        }

        @Override
        public String getName() {
            return this.text.length() == 1 ? this.text : "ASCII-" + this.text;
        }
    }

    static class IconSymbol
    extends Symbol {
        final Icon icon;
        final String name;

        public IconSymbol(Icon icon) {
            this(icon, null);
        }

        public IconSymbol(Icon icon, String name) {
            if (icon == null) {
                throw new NullPointerException("IconSymbol: icon can not be null");
            }
            this.name = name != null ? name : icon.toString();
            this.icon = icon;
        }

        @Override
        public void draw(int x, int y, Graphics g, int r) {
            int xoff = this.icon.getIconWidth() / 2;
            int yoff = this.icon.getIconHeight() / 2;
            this.paintIcon(null, g, x - xoff, y - yoff);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.icon.paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        @Override
        public int getSize() {
            return (this.getIconWidth() + this.getIconHeight()) / 2;
        }

        @Override
        public boolean isFilled() {
            return false;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

