/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.libg.GraphicsUtil;
import nxm.sys.libg.Layer;
import nxm.sys.libg.Line;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.Pix;
import nxm.sys.libg.Symbol;

public class PlotCanvas {
    public static final String optionsList = "Vertical,Horizontal,YAsTime,Connect";
    @Deprecated
    public static final String OPTIONS = "Vertical,Horizontal,YAsTime,Connect";
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;
    public static final int YASTIME = 4;
    public static final int CONNECT = 8;
    private BufferedImage canvas;
    private MPlot MP;
    private Color color;
    private Table objs;
    private int objID;
    private int[] bounds;
    private int pointSize;
    private Symbol pointSymbol;
    private boolean needUpdate;
    private boolean isPlotCanvasThatNeedsLegacyPaint;
    private volatile boolean inPaintComponent = false;

    public PlotCanvas(MPlot mp) {
        this.MP = mp;
        this.setup();
        this.init();
    }

    private void init() {
        this.objs = new Table();
        this.color = Color.white;
        this.objID = 0;
        this.bounds = new int[4];
        this.pointSize = 5;
        this.pointSymbol = Symbol.getSymbol("CROSS", this.pointSize);
    }

    private void setup() {
        if (this.MP == null || this.MP.panel == null) {
            return;
        }
        this.canvas = new BufferedImage(this.MP.panel.getWidth(), this.MP.panel.getHeight(), 2);
        this.needUpdate = false;
        this.isPlotCanvasThatNeedsLegacyPaint = GraphicsUtil.checkIfNeedLegacyPaint(this);
    }

    public void setColor(Color c) {
        if (c != null) {
            this.color = c;
        }
    }

    public void setObjColor(String id, Color c) {
        if (id == null || c == null) {
            return;
        }
        Table tab = this.objs.getTable("ID");
        tab.remove("COLOR");
        tab.put("COLOR", (Object)c);
    }

    public void setColor(String c) {
        this.setColor(MColor.getColor(c));
    }

    public void setObjColor(String id, String c) {
        this.setObjColor(id, MColor.getColor(c));
    }

    public Color getColor() {
        return this.color;
    }

    public Color getObjColor(String id) {
        return (Color)this.objs.getTable(id).get("COLOR");
    }

    public String getObjectId(double x1, double y1, double x2, double y2) {
        String[] keys = this.objs.getKeys();
        Table tab = null;
        Table data = null;
        for (String key : keys) {
            tab = this.objs.getTable(key);
            if (tab == null || (data = tab.getTable("DATA")) == null || data.getD("X1") != x1 || data.getD("X2") != x2 || data.getD("Y1") != y1 || data.getD("Y2") != y2) continue;
            return tab.getS("ID");
        }
        return null;
    }

    public void addToCanvas(Table obj) {
        if (obj == null) {
            return;
        }
        if (this.canvas == null) {
            this.setup();
        }
        String type = obj.getS("TYPE", "LINE").toUpperCase();
        String id = obj.getS("ID");
        Table data = obj.getTable("DATA");
        Color color = MColor.getColor(obj.get("COLOR", this.color));
        this.addObject(id, type, color, data);
    }

    private void addObject(String id, String type, Color color, Table data) {
        if (type == null || data == null) {
            return;
        }
        if (color == null) {
            color = this.color;
        }
        if (type.equals("LINE")) {
            this.addLine(id, data.getD("X1"), data.getD("Y1"), data.getD("X2"), data.getD("Y2"), data.getState("ISTIME"), color);
        } else if (type.equals("POINT")) {
            this.addPoint(id, data.getD("X1"), data.getD("Y1"), data.getState("ISTIME"), color);
        } else if (type.startsWith("CIRC")) {
            this.addCircle(id, data.getD("X1"), data.getD("Y1"), data.getD("RADIUS"), data.getL("NPTS"), data.getState("ISTIME"), color);
        } else if (type.startsWith("ELL")) {
            this.addEllipse(id, data.getD("X1"), data.getD("Y1"), data.getD("ALT"), data.getD("SEMIMAJOR"), data.getD("SEMIMINOR"), data.getD("TILT"), data.getL("DIV"), data.getState("ISTIME"), color);
        }
    }

    public void addLine(String id, double x1, double y1, double x2, double y2, boolean isTime, Object color) {
        Color col;
        if (this.canvas == null) {
            this.setup();
        }
        if ((col = MColor.getColor(color)) == null) {
            col = this.color;
        }
        double newY1 = y1;
        double newY2 = y2;
        if (isTime) {
            Layer lay = (Layer)this.MP.getLayers().get(1);
            newY1 = lay.getPosAtTime(y1);
            newY2 = lay.getPosAtTime(y2);
        }
        this.addLine(id, x1, newY1, x2, newY2, col);
        this.updateObject("LINE", id, new Table("{X1=" + x1 + ",Y1=" + y1 + ",X2=" + x2 + ",Y2=" + y2 + ",ISTIME=" + isTime + "}"), col);
    }

    private void addLine(String id, double x1, double y1, double x2, double y2, Color color) {
        if (this.canvas == null) {
            this.setup();
        }
        Graphics2D gc = this.canvas.createGraphics();
        double[] buf = new double[]{x1, y1, x2, y2};
        int pixFlags = this.MP.isMapView() ? 2 : 1;
        Pix pix = new Pix(4, pixFlags);
        this.MP.viewer.rwc2pix(buf, 0, 2, 2, pix);
        int pixX1 = Math.min(pix.x[0], pix.x[1]);
        int pixX2 = Math.max(pix.x[1], pix.x[0]);
        int pixY1 = Math.min(pix.y[0], pix.y[1]);
        int pixY2 = Math.max(pix.y[0], pix.y[1]);
        this.updateBounds(pixX1, pixY1, pixX2, pixY2);
        if (this.MP.isMapView()) {
            Line line = this.MP.getBaseLayer().getLine().copy();
            line.setColor(color);
            this.MP.drawLine(buf, 0, 2, 2, line, 2, gc, true);
        } else {
            gc.setColor(color);
            gc.drawLine(pixX1, pixY1, pixX2, pixY2);
            gc.setColor(this.color);
        }
    }

    public void addCircle(String id, double x, double y, double radius, int div, boolean isTime, Object color) {
        Color col;
        if (this.canvas == null) {
            this.setup();
        }
        if ((col = MColor.getColor(color)) == null) {
            col = this.color;
        }
        if (div == -1) {
            div = 90;
        }
        double newY = y;
        if (isTime) {
            Layer lay = (Layer)this.MP.getLayers().get(1);
            newY = lay.getPosAtTime(y);
        }
        this.addCircle(x, newY, radius, div, col);
        this.updateObject("CIRC", id, new Table("{X1=" + x + ",Y1=" + y + ",X2=" + x + ",Y2=" + y + ",ISTIME=" + isTime + ",RADIUS=" + radius + ",NPTS=" + div + "}"), col);
    }

    private void addCircle(double x, double y, double radius, int div, Color color) {
        if (this.canvas == null) {
            this.setup();
        }
        Graphics2D gc = this.canvas.createGraphics();
        if (color == null) {
            color = this.color;
        }
        if (this.MP.isMapView()) {
            Line line = this.MP.getBaseLayer().getLine().copy();
            line.setColor(color);
            this.MP.drawCircleLonLat(x, y, radius, div, line, gc);
            double xMax = x + radius;
            double xMin = x - radius;
            double yMax = y - radius;
            double yMin = y + radius;
            double[] buf = new double[]{xMin, yMin, xMax, yMax};
            Pix pix = new Pix(4, 2);
            this.MP.viewer.rwc2pix(buf, 0, 2, 2, pix);
            this.updateBounds(pix.x[0], pix.y[0], pix.x[1], pix.y[1]);
        } else {
            gc.setColor(color);
            double[] buf = new double[]{x, y, x, y + radius};
            Pix pix = new Pix(4, 1);
            this.MP.viewer.rwc2pix(buf, 0, 2, 2, pix);
            int pixRadius = Math.abs(pix.y[1] - pix.y[0]);
            gc.drawOval(pix.x[0] - pixRadius, pix.y[0] - pixRadius, pixRadius * 2, pixRadius * 2);
            this.updateBounds(pix.x[0] + pixRadius, pix.y[0] + pixRadius, pix.x[1] - pixRadius, pix.y[1] - pixRadius);
            gc.setColor(this.color);
        }
    }

    public void addEllipse(String id, double x, double y, double alt, double semiMajor, double semiMinor, double tilt, int div, boolean isTime, Object color) {
        Color col;
        if (this.canvas == null) {
            this.setup();
        }
        if ((col = MColor.getColor(color)) == null) {
            col = this.color;
        }
        double newY = y;
        if (isTime) {
            Layer lay = (Layer)this.MP.getLayers().get(1);
            newY = lay.getPosAtTime(y);
        }
        this.addEllipse(x, newY, alt, semiMajor, semiMinor, tilt, div, col);
        this.updateObject("ELLIPSE", id, new Table("{X1=" + x + ",Y1=" + y + ",X2=" + x + ",Y2=" + y + ",ALT=" + alt + ",TILT=" + tilt + ",ISTIME=" + isTime + ",DIV=" + div + ",SEMIMAJOR=" + semiMajor + ",SEMIMINOR=" + semiMinor + "}"), col);
    }

    private void addEllipse(double x, double y, double alt, double semiMajor, double semiMinor, double tilt, int div, Color color) {
        if (this.canvas == null) {
            this.setup();
        }
        Graphics2D gc = this.canvas.createGraphics();
        if (color == null) {
            color = this.color;
        }
        gc.setColor(color);
        if (this.MP.isMapView()) {
            Line line = this.MP.getBaseLayer().getLine().copy();
            line.setColor(color);
            line.updateGraphics(gc);
            this.MP.drawEllipseOnMap(x, y, alt, semiMajor, semiMinor, tilt, div, line, gc);
            double bigAxis = Math.max(semiMajor, semiMinor);
            double semiMajorInDeg = bigAxis / 111000.0;
            double[] buf = new double[]{x - semiMajorInDeg, y - semiMajorInDeg, x + semiMajorInDeg, y + semiMajorInDeg};
            Pix pix = new Pix(4, 2);
            this.MP.viewer.rwc2pix(buf, 0, 2, 2, pix);
            this.updateBounds(pix.x[0], pix.y[0], pix.x[1], pix.y[1]);
        } else {
            tilt = 360.0 - (90.0 - tilt);
            double[] buf = new double[]{x - semiMajor, y - semiMinor, x + semiMajor, y + semiMinor, x, y};
            Pix pix = new Pix(4, 1);
            this.MP.viewer.rwc2pix(buf, 0, 2, 3, pix);
            int xTopPix = pix.x[0];
            int yTopPix = pix.y[0];
            int width = pix.x[1] - pix.x[0];
            int height = pix.y[1] - pix.y[0];
            int centerX = pix.x[2];
            int centerY = pix.y[2];
            Ellipse2D.Double ell = new Ellipse2D.Double(xTopPix, yTopPix, width, height);
            gc.rotate(Math.toRadians(tilt), centerX, centerY);
            gc.draw(ell);
            int maxRadius = Math.max(width, height) / 2;
            this.updateBounds(centerX - maxRadius, centerY - maxRadius, centerX + maxRadius, centerY + maxRadius);
        }
        gc.setColor(this.color);
    }

    public void addPoint(String id, double x, double y, boolean isTime, Object color) {
        Color col;
        if (this.canvas == null) {
            this.setup();
        }
        if ((col = MColor.getColor(color)) == null) {
            col = this.color;
        }
        Layer lay = (Layer)this.MP.getLayers().get(1);
        double newY = y;
        if (isTime) {
            newY = lay.getPosAtTime(y);
        }
        this.addPoint(id, x, newY, col);
        this.updateObject("POINT", id, new Table("{X1=" + x + ",Y1=" + y + ",X2=" + x + ",Y2=" + y + ",IST=" + isTime + "}"), col);
    }

    private void addPoint(String id, double x, double y, Color color) {
        if (this.canvas == null) {
            this.setup();
        }
        Graphics2D gc = this.canvas.createGraphics();
        double[] buf = new double[]{x, y};
        int pixFlags = this.MP.isMapView() ? 2 : 1;
        Pix pix = new Pix(2, pixFlags);
        this.MP.viewer.rwc2pix(buf, 0, 2, 1, pix);
        int pixX = pix.x[0];
        int pixY = pix.y[0];
        this.updateBounds(pixX, pixY, pixX, pixY);
        gc.setColor(color);
        this.getPointSymbol().draw(pixX, pixY, gc);
        gc.setColor(this.color);
    }

    private void updateBounds(int x1, int y1, int x2, int y2) {
        if (x1 > x2) {
            int tmpX = x1;
            x1 = x2;
            x2 = tmpX;
        }
        if (y1 > y2) {
            int tmpY = y1;
            y1 = y2;
            y2 = tmpY;
        }
        if (x1 < this.bounds[0]) {
            this.bounds[0] = x1;
        } else if (x2 > this.bounds[1]) {
            this.bounds[1] = x2;
        }
        if (y1 < this.bounds[2]) {
            this.bounds[2] = y1;
        } else if (y2 > this.bounds[3]) {
            this.bounds[3] = y2;
        }
    }

    @Deprecated
    public synchronized void paint() {
        if (!this.inPaintComponent) {
            this.MP.refresh();
        }
    }

    @InternalUseOnly
    public synchronized void paintComponent(Graphics g) {
        if (this.isPlotCanvasThatNeedsLegacyPaint) {
            this.inPaintComponent = true;
            this.paint();
            this.inPaintComponent = false;
        }
        if (this.MP.panel == null || this.canvas == null || (this.MP.holdRefresh & 4) != 0) {
            return;
        }
        if (this.needUpdate) {
            this.update();
        }
        int x1 = Math.max(this.bounds[0], this.MP.ix1);
        int y1 = Math.max(this.bounds[2], this.MP.iy1);
        int x2 = Math.min(this.bounds[1] - this.bounds[0], this.MP.ix21);
        int y2 = Math.min(this.bounds[3] - this.bounds[2], this.MP.iy21);
        g.setClip(x1, y1, x2, y2);
        g.drawImage(this.canvas, 0, 0, this.MP);
    }

    public void needUpdate() {
        this.needUpdate = true;
    }

    public void update() {
        this.undraw();
        String[] keys = this.objs.getKeys();
        Table data = null;
        for (String key : keys) {
            Table tab = this.objs.getTable(key);
            if (tab == null || tab.toString().equals("{}")) continue;
            String type = tab.getS("TYPE", "LINE").toUpperCase();
            data = tab.getTable("DATA");
            Color color = MColor.getColor(tab.get("COLOR", this.color));
            this.addObject(key, type, color, data);
        }
        this.needUpdate = false;
    }

    public void clear() {
        this.canvas = null;
    }

    public void undraw() {
        if (this.canvas == null) {
            return;
        }
        this.clear();
        Graphics gc = this.MP.panel.getGraphics();
        gc.setClip(this.bounds[0], this.bounds[2], this.bounds[1] - this.bounds[0], this.bounds[3] - this.bounds[2]);
        this.MP.panel.repaint();
        for (int i = 0; i < 4; ++i) {
            this.bounds[i] = 0;
        }
    }

    public void draw(double[] buf, int dim, int offset, int npts, String idPrefix, int options, Object color) {
        block10: {
            int pts;
            boolean isTime;
            Color col;
            block9: {
                col = MColor.getColor(color);
                if (col == null) {
                    col = this.color;
                }
                isTime = (options & 4) != 0;
                int n = pts = npts == -1 ? buf.length - offset : npts;
                if (dim != 1) break block9;
                for (int i = offset; i < pts * 2; i += 2) {
                    this.addPoint(idPrefix + "_" + this.objID++, buf[i], buf[i + 1], isTime, col);
                }
                break block10;
            }
            if (dim != 2 && dim != 4) break block10;
            if (dim == 2) {
                boolean vert;
                boolean bl = vert = (options & 1) != 0;
                if (vert) {
                    for (int i = offset; i < pts; ++i) {
                        this.addLine(idPrefix + "_" + this.objID++, buf[i], this.MP.ry1, buf[i], this.MP.ry2, isTime, col);
                    }
                } else {
                    for (int i = offset; i < pts; ++i) {
                        this.addLine(idPrefix + "_" + this.objID++, this.MP.rx1, buf[i], this.MP.rx2, buf[i], isTime, col);
                    }
                }
            } else {
                for (int i = offset; i < pts * 4; i += 4) {
                    this.addLine(idPrefix + "_" + this.objID++, buf[i], buf[i + 1], buf[i + 2], buf[i + 3], isTime, col);
                    if ((8 & options) == 0) continue;
                    this.addLine(idPrefix + "_" + this.objID++, buf[i + 2], buf[i + 3], buf[i + 4], buf[i + 5], isTime, col);
                }
            }
        }
    }

    public boolean moveObject(String id, double newX1, double newY1, double newX2, double newY2, boolean doRepaint) {
        Table data;
        if (this.objs == null || id == null) {
            return false;
        }
        Table tab = this.objs.getTable(id);
        if (tab != null && (data = tab.getTable("DATA")) != null) {
            data.remove("X1");
            data.remove("X2");
            data.remove("Y1");
            data.remove("Y2");
            data.put("X1", newX1);
            data.put("X2", newX2);
            data.put("Y1", newY1);
            data.put("Y2", newY2);
            this.needUpdate = true;
            if (doRepaint) {
                this.MP.refresh();
            }
            return true;
        }
        return false;
    }

    public boolean moveObject(double oldX1, double oldY1, double oldX2, double oldY2, double newX1, double newY1, double newX2, double newY2, boolean doRepaint) {
        String[] keys = this.objs.getKeys();
        Table tab = null;
        Table data = null;
        for (String key : keys) {
            tab = this.objs.getTable(key);
            if (tab == null || (data = tab.getTable("DATA")) == null || data.getD("X1") != oldX1 || data.getD("X2") != oldX2 || data.getD("Y1") != oldY1 || data.getD("Y2") != oldY2) continue;
            return this.moveObject(tab.getS("ID"), newX1, newY1, newX2, newY2, doRepaint);
        }
        return false;
    }

    public void removeObject(String id) {
        if (this.objs != null) {
            if (this.objs.containsKey(id)) {
                this.objs.remove(id);
            } else {
                Shell.warning("Could not remove Canvas object. Id [" + id + "] does not exist.");
            }
            this.needUpdate = true;
        }
    }

    public boolean removePoint(double x, double y) {
        return this.removeObj("POINT", x, y, x, y);
    }

    public boolean removeLine(double x1, double y1, double x2, double y2) {
        return this.removeObj("LINE", x1, y1, x2, y2);
    }

    public boolean removeCircle(double x, double y) {
        return this.removeObj("CIRC", x, y, x, y);
    }

    public boolean removeEllipse(double x, double y) {
        return this.removeObj("ELLIPSE", x, y, x, y);
    }

    private boolean removeObj(String type, double x1, double y1, double x2, double y2) {
        boolean removed = false;
        if (this.objs != null) {
            String[] keys;
            for (String key : keys = this.objs.getKeys()) {
                Table d;
                Table t = this.objs.getTable(key);
                if (t == null || !t.getS("TYPE").equals(type) || (d = t.getTable("DATA")) == null || x1 != d.getD("X1") || x2 != d.getD("X2") || y1 != d.getD("Y1") || y2 != d.getD("Y2")) continue;
                this.removeObject(key);
                removed = true;
            }
        }
        if (!removed) {
            Shell.warning("Could not remove Canvas object. Object with coords " + x1 + "," + y1 + " " + x2 + "," + y2 + " does not exist.");
        } else {
            this.needUpdate = true;
        }
        return removed;
    }

    private void updateObject(String type, String id, Table data, Color color) {
        if (this.objs == null) {
            this.objs = new Table();
        }
        if (type == null || type.equals("")) {
            type = "LINE";
        }
        type = type.toUpperCase();
        if (id == null || id.equals("")) {
            id = type + "_" + ++this.objID;
        }
        id = id.toUpperCase();
        Table tab = new Table();
        tab.put("TYPE", (Object)type);
        tab.put("ID", (Object)id);
        tab.put("DATA", (Object)data);
        tab.put("COLOR", (Object)color);
        this.objs.remove(id);
        this.objs.put(id, (Object)tab);
    }

    public Table getObjects() {
        return this.objs;
    }

    public void setPointSize(int pix) {
        if (pix > -1) {
            this.pointSize = pix;
        }
    }

    public int getPointSize() {
        return this.pointSize;
    }

    public void setPointSymbol(String sym) {
        if ("Aero,Arrow,Circle,Cross,Diamond,Dot,Plus,Square,Star,Triangle,UTri,DTri,RTri,LTri,A,B,C,D,Ascii-XYZ,None".toLowerCase().indexOf(sym.toLowerCase()) >= 0) {
            this.setPointSymbol(Symbol.get(sym, this.getPointSize()));
        } else {
            Shell.warning("Unknown symbol type: [" + sym + "]. Symbol must be in " + "Aero,Arrow,Circle,Cross,Diamond,Dot,Plus,Square,Star,Triangle,UTri,DTri,RTri,LTri,A,B,C,D,Ascii-XYZ,None");
        }
    }

    public void setPointSymbol(Symbol sym) {
        this.pointSymbol = sym;
    }

    public Symbol getPointSymbol() {
        return this.pointSymbol;
    }
}

