/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

public class Pix {
    public static final int CHECK = 1;
    public static final int CLIP = 2;
    public static final int HIDE = 4;
    public static final int NORM = 8;
    public static final int KEEP = 16;
    static final int NEVERCLIP = 32;
    static final int FULLKEEP = 64;
    public int max;
    public int off;
    public int n;
    public int flags;
    public int[] x;
    public int[] y;
    public float[] z;
    boolean save;
    int[] sx = new int[2];
    int[] sy = new int[2];
    float[] sz = new float[2];

    public Pix(int maxsize, int flags) {
        this.max = maxsize + 1;
        this.x = new int[this.max];
        this.y = new int[this.max];
        this.z = new float[this.max];
        this.setFlags(flags);
    }

    public int setSize(int npts) {
        if (npts > this.max) {
            this.n = this.max;
            this.off = this.max - 1;
        } else {
            this.n = npts;
            this.off = npts;
        }
        return this.n;
    }

    public void setFlags(int mask) {
        this.flags = mask;
    }

    public void setFlag(int mask) {
        this.flags |= mask;
    }

    public void clrFlag(int mask) {
        this.flags &= ~mask;
    }

    public int[] getXYMinMax(int num) {
        int[] r = new int[]{this.x[0], this.y[0], this.x[1], this.y[1]};
        return this.getXYMinMax(r, num);
    }

    public int[] getXYMinMax(int[] ini, int num) {
        int xmin = ini[0];
        int ymin = ini[1];
        int xmax = ini[2];
        int ymax = ini[3];
        for (int i = 0; i < num; ++i) {
            xmax = Math.max(xmax, this.x[i]);
            xmin = Math.min(xmin, this.x[i]);
            ymax = Math.max(ymax, this.y[i]);
            ymin = Math.min(ymin, this.y[i]);
        }
        int[] retVal = new int[]{xmin, ymin, xmax, ymax};
        return retVal;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Pix: {");
        for (int i = 0; i < this.n; ++i) {
            str.append(" (");
            str.append(this.x[i]);
            str.append(',');
            str.append(this.y[i]);
            str.append(',');
            str.append(this.z[i]);
            str.append(')');
        }
        str.append(" }");
        return str.toString();
    }
}

