/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.filechooser.FileFilter;
import nxm.sys.intr.Generate;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;

public class MJGenerateJnlp
extends JFrame {
    private final Generate generator;
    private JButton browseFileName;
    private JButton browseTemplateName;
    private JButton cancelButton;
    private JTextField codebase;
    private JTextField command;
    private JTextField fileName;
    private JRadioButton filesArbitrary;
    private JRadioButton filesRelative;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField jnlpHref;
    private JTextField nmroot;
    private JButton okButton;
    private JTextField optionTrees;
    private JCheckBox saveTemplate;
    private ButtonGroup serverConfigType;
    private JTextField templateName;
    private JCheckBox useNativeLibs;

    public MJGenerateJnlp() {
        this((Table)null);
    }

    public MJGenerateJnlp(Table table) {
        this(null, null, null, table);
    }

    public MJGenerateJnlp(Generate generator, String fname, String tname, Table table) {
        String root;
        this.initComponents();
        this.generator = generator;
        if (table == null) {
            table = new Table();
        }
        if (fname == null) {
            fname = "";
        }
        if (tname == null) {
            tname = "";
        }
        this.fileName.setText(fname);
        this.templateName.setText(tname);
        this.command.setText(table.getS("COMMAND", "SD360 1e9"));
        this.optionTrees.setText(table.getS("OPTS", "DSP|SYS"));
        String nmrootUrl = "";
        String hrefUrl = table.getS("JNLPHREF", "http://" + MJGenerateJnlp.getHostName() + "/nmroot/htdocs/demo.jnlp");
        String codebaseUrl = table.getS("CODEBASE", "http://" + MJGenerateJnlp.getHostName() + "/nmroot/jars");
        if (codebaseUrl.endsWith("/jars") && hrefUrl.startsWith((root = codebaseUrl.substring(0, codebaseUrl.length() - 5)) + "/htdocs")) {
            nmrootUrl = root;
        }
        this.nmroot.setText(nmrootUrl.trim());
        this.codebase.setText(nmrootUrl.trim());
        this.jnlpHref.setText(codebaseUrl.trim());
        this.saveTemplate.setSelected(false);
        this.useNativeLibs.setSelected(table.getState("USENATIVE", false));
        this.filesRelative.setSelected(this.nmroot.getText().length() == 0);
        this.update();
    }

    public static void createJnlpFile(Generate generator, String fname, String tname, Table table) {
        final MJGenerateJnlp frame = new MJGenerateJnlp(generator, fname, tname, table);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    private static String getHostName() {
        return Shell.getSharedMidasContext().getResults().getS("ENV.HOSTNAME");
    }

    public static void test() {
        MJGenerateJnlp frame = new MJGenerateJnlp();
        frame.pack();
        frame.setVisible(true);
    }

    private void update() {
        this.templateName.setEnabled(this.saveTemplate.isSelected());
        this.browseTemplateName.setEnabled(this.saveTemplate.isSelected());
        if (this.filesRelative.isSelected()) {
            this.nmroot.setEnabled(true);
            this.jnlpHref.setEnabled(false);
            this.codebase.setEnabled(false);
            if (this.nmroot.getText().trim().length() == 0) {
                this.nmroot.setText("http://" + MJGenerateJnlp.getHostName() + "/nmroot");
            }
            this.jnlpHref.setText(this.nmroot.getText() + "/htdocs/" + new File(this.fileName.getText().trim()).getName());
            this.codebase.setText(this.nmroot.getText() + "/jars");
        } else {
            this.nmroot.setEnabled(false);
            this.jnlpHref.setEnabled(true);
            this.codebase.setEnabled(true);
            this.nmroot.setText("");
        }
    }

    private void initComponents() {
        this.serverConfigType = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel5 = new JLabel();
        this.optionTrees = new JTextField();
        this.useNativeLibs = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.jLabel7 = new JLabel();
        this.command = new JTextField();
        this.jPanel2 = new JPanel();
        this.filesRelative = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.nmroot = new JTextField();
        this.jnlpHref = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel4 = new JLabel();
        this.codebase = new JTextField();
        this.filesArbitrary = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.saveTemplate = new JCheckBox();
        this.fileName = new JTextField();
        this.browseFileName = new JButton();
        this.templateName = new JTextField();
        this.browseTemplateName = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("JNLP Config Wizard");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Application Config"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("OptionTrees=");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.optionTrees.setToolTipText("The required option trees (specified same as OPT.PATH).");
        this.optionTrees.setPreferredSize(new Dimension(50, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.optionTrees, gridBagConstraints);
        this.useNativeLibs.setToolTipText("Select this to enable the use of native libraries (when available).");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.useNativeLibs, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("UseNativeLibs=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("Command=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel7, gridBagConstraints);
        this.command.setToolTipText("The command to run (e.g. \"SD360 1e9\").");
        this.command.setPreferredSize(new Dimension(50, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.command, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Web Server Config"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.serverConfigType.add(this.filesRelative);
        this.filesRelative.setSelected(true);
        this.filesRelative.setText("Files in default location (relative to $NMROOT)");
        this.filesRelative.setToolTipText("JNLP file in $NMROOT/htdocs, Jars in $NMROOT/jars");
        this.filesRelative.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MJGenerateJnlp.this.filesRelativeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.filesRelative, gridBagConstraints);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("NMROOT=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.nmroot.setToolTipText("$NMROOT as seen via the network (e.g. \"http://myserver/nmroot\")");
        this.nmroot.setPreferredSize(new Dimension(50, 19));
        this.nmroot.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                MJGenerateJnlp.this.nmrootCaretUpdate(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.nmroot, gridBagConstraints);
        this.jnlpHref.setToolTipText("The location of the JNLP file as seen via the network");
        this.jnlpHref.setPreferredSize(new Dimension(50, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jnlpHref, gridBagConstraints);
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText("CODEBASE=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("HREF=");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.codebase.setToolTipText("The directory holding the JAR files as seen via the network.");
        this.codebase.setPreferredSize(new Dimension(50, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.codebase, gridBagConstraints);
        this.serverConfigType.add(this.filesArbitrary);
        this.filesArbitrary.setText("Files in arbitrary location");
        this.filesArbitrary.setToolTipText("Must set HREF and CODEBASE manually");
        this.filesArbitrary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MJGenerateJnlp.this.filesArbitraryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.filesArbitrary, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "JNLP File Properties"));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel1.setText("File Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.saveTemplate.setText("Save Template");
        this.saveTemplate.setToolTipText("Indicates if a template should be saved.");
        this.saveTemplate.setPreferredSize(new Dimension(115, 19));
        this.saveTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MJGenerateJnlp.this.saveTemplateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.saveTemplate, gridBagConstraints);
        this.fileName.setToolTipText("The file name of the JNLP file.");
        this.fileName.setPreferredSize(new Dimension(50, 19));
        this.fileName.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                MJGenerateJnlp.this.fileNameCaretUpdate(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.fileName, gridBagConstraints);
        this.browseFileName.setText("Browse");
        this.browseFileName.setPreferredSize(new Dimension(89, 19));
        this.browseFileName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MJGenerateJnlp.this.browseFileNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.browseFileName, gridBagConstraints);
        this.templateName.setToolTipText("The file name of the template that can be used to recreate the JNLP file in the future.");
        this.templateName.setPreferredSize(new Dimension(50, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.templateName, gridBagConstraints);
        this.browseTemplateName.setText("Browse");
        this.browseTemplateName.setPreferredSize(new Dimension(89, 19));
        this.browseTemplateName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MJGenerateJnlp.this.browseTemplateNameActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.browseTemplateName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.okButton.setText("OK");
        this.okButton.setPreferredSize(new Dimension(75, 25));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MJGenerateJnlp.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MJGenerateJnlp.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        this.pack();
    }

    private void fileNameCaretUpdate(CaretEvent evt) {
        this.update();
    }

    private void nmrootCaretUpdate(CaretEvent evt) {
        this.update();
    }

    private void filesArbitraryActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void filesRelativeActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void saveTemplateActionPerformed(ActionEvent evt) {
        this.templateName.setEnabled(this.saveTemplate.isSelected());
        this.browseTemplateName.setEnabled(this.saveTemplate.isSelected());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        int status;
        String tname;
        this.update();
        String fname = this.fileName.getText().trim();
        String string = tname = this.saveTemplate.isSelected() ? this.templateName.getText().trim() : null;
        if (new File(fname).exists() && (status = JOptionPane.showConfirmDialog(this, "File " + fname + " exists and will be overwritten.", "File Exists", 2, 2)) != 0) {
            return;
        }
        if (tname != null && new File(tname).exists() && (status = JOptionPane.showConfirmDialog(this, "File " + tname + " exists and will be overwritten.", "File Exists", 2, 2)) != 0) {
            return;
        }
        Table table = new Table();
        table.put("COMMAND", (Object)this.command.getText().trim());
        table.put("OPTS", (Object)this.optionTrees.getText().trim());
        table.put("USENATIVE", (Object)(this.useNativeLibs.isSelected() ? "TRUE" : "FALSE"));
        table.put("JNLPHREF", (Object)this.jnlpHref.getText().trim());
        table.put("CODEBASE", (Object)this.codebase.getText().trim());
        if (this.generator != null) {
            this.generator.writeJnlpFile(fname, tname, table);
        } else {
            System.out.println("fname=" + fname + "  tname=" + tname + "  table=" + table);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void browseFileNameActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(MJGenerateJnlp.makeFileFilter("JNLP Files", ".jnlp"));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.fileName.setText(chooser.getSelectedFile().toString());
        }
    }

    private static FileFilter makeFileFilter(final String name, final String ext) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(ext);
            }

            @Override
            public String getDescription() {
                return name;
            }
        };
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.update();
        if (this.generator != null) {
            this.generator.writeJnlpFile(null, null, null);
        } else {
            System.out.println("fname=" + null + "  tname=" + null + "  table=" + null);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void browseTemplateNameActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(MJGenerateJnlp.makeFileFilter("NeXtMidas Table Files", ".tbl"));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.templateName.setText(chooser.getSelectedFile().toString());
        }
    }
}

