/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.FontMetrics;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.Convert;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Position;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Transform;
import nxm.sys.lib.Vehicle;
import nxm.sys.libg.Layer;
import nxm.sys.libg.Line;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MPoint;

public class LayerVehicle
extends Layer
implements ChangeListener {
    public static final String flagsList = "Markers,Horizon,FootPrint,ReadOut";
    public static final int MARKERS = 1;
    public static final int HORIZON = 2;
    public static final int FOOTPRINT = 4;
    public static final int READOUT = 8;
    public static final int LAST_FLAG = 8;
    public static final int DEF_FLAGS = 7;
    public static final Vehicle.Location[] EMPTY_LOCATION_ARRAY = new Vehicle.Location[0];
    protected final Table vehicles = new Table(2, 8);
    protected int coneMode = 1;
    protected boolean coneFill = false;
    protected Vehicle.Location selected = null;
    protected Color selectColor = Color.red;
    protected Color deselectColor = Color.blue;
    protected int conic = 1;
    protected int cdiv = 60;
    protected double cangle = Double.NaN;
    protected double crange = 0.0;
    protected int flags = 7;
    protected int fillAlpha = 112;
    public static final String coneModeList = "Both,Vertical,Horizon";

    public LayerVehicle() {
        this("VEHICLE");
    }

    protected LayerVehicle(String name) {
        this.name = name;
        this.xstart = -180.0;
        this.xdelta = 15.0;
        this.frame = 25;
        this.ystart = -90.0;
        this.ydelta = 15.0;
        this.size = 13;
        this.line.setColor(Color.PINK);
        this.enable &= 0xFFFFFFFB;
    }

    @Override
    public boolean clear() {
        if (this.vehicles.size() == 0) {
            return false;
        }
        this.vehicles.clear(16);
        this.refresh();
        return true;
    }

    public String getFlags() {
        return Parser.mask2s(flagsList, this.getFlagsMask());
    }

    public void setFlags(String value) {
        this.setFlagsMask(Parser.mask(flagsList, value, this.flags));
    }

    public int getFlagsMask() {
        return this.flags;
    }

    public void setFlagsMask(int value) {
        if (value != this.flags) {
            this.flags = value;
            this.refresh();
        }
    }

    @Override
    public boolean setFile(PlotFile pf, Table tab, Args MA) {
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (this.vehicles.containsValue(src)) {
            this.refresh();
        } else {
            System.err.println("LayerVehicle: Got change event from unknown source, event=" + e);
        }
    }

    public Vehicle useVehicle(String name) {
        Vehicle veh = this.getVehicle(name);
        if (veh == null) {
            veh = new Vehicle(this.ref);
            this.addVehicle(name, veh);
        }
        return veh;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    @Override
    public void setTime(double value) {
        String[] names = this.getVehicleNames();
        this.time = value;
        for (int i = 0; i < names.length; ++i) {
            this.getVehicle(names[i]).setTime(this.time);
        }
    }

    public Table getVehicles() {
        return this.vehicles;
    }

    public String[] getVehicleNames() {
        return this.vehicles.getKeys();
    }

    public void setVehicle(String name, Vehicle vehicle) {
        Vehicle veh = this.getVehicle(name);
        if (veh != vehicle) {
            if (veh != null) {
                this.vehicles.remove(name, 16);
                veh.removeChangeListener(this);
            }
            if (vehicle != null) {
                vehicle.setTime(this.getTime());
                vehicle.addChangeListener(this);
                this.vehicles.put(name, (Object)vehicle, 16);
            }
            this.vehiclesUpdated();
            this.refresh();
        }
    }

    public final void setVehicle(String name, Table tbl) {
        if (tbl != null) {
            this.useVehicle(name).setValues(tbl);
        }
    }

    public final void setVehiclePoint(String name, String point, Table tbl) {
        if (tbl != null) {
            this.useVehicle(name).usePointingPos(point).setValues(tbl);
        }
    }

    public final Table getVehiclePoint(String name, String point) {
        Vehicle veh = this.getVehicle(name);
        Vehicle.PointingPos pnt = veh == null ? null : veh.getPointingPos(point);
        return pnt == null ? null : pnt.toTable();
    }

    public Vehicle getVehicle(String name) {
        return (Vehicle)this.vehicles.get(name);
    }

    public final Table getVehicleTable(String name) {
        Vehicle veh = this.getVehicle(name);
        return veh == null ? null : veh.toTable();
    }

    public final void setVehicleTable(String name, Table tbl) {
        this.setVehicle(name, tbl);
    }

    public final void addVehicle(String name, Vehicle vehicle) {
        this.setVehicle(name, vehicle);
    }

    public final void removeVehicle(String name) {
        this.setVehicle(name, (Vehicle)null);
    }

    public void removeAllVehicles() {
        if (!this.vehicles.isEmpty()) {
            this.vehicles.clear(16);
            this.vehiclesUpdated();
            this.refresh();
        }
    }

    protected void vehiclesUpdated() {
    }

    public void setConeMode(String mode) {
        int val = Parser.find(coneModeList, mode, this.coneMode, -2, 1);
        if (val != this.coneMode) {
            this.coneMode = val;
            this.refresh();
        }
    }

    public String getConeMode() {
        return Parser.get(coneModeList, this.coneMode, -2);
    }

    public void setConeFill(boolean fill) {
        if (fill != this.coneFill) {
            this.coneFill = fill;
            this.refresh();
        }
    }

    public boolean getConeFill() {
        return this.coneFill;
    }

    @Override
    public void findRange() {
        this.x1 = -180.0;
        this.x2 = 180.0;
        this.y1 = -90.0;
        this.y2 = 90.0;
        this.z1 = 0.0;
        this.z2 = 0.0;
        this.a1 = this.y1;
        this.a2 = this.y2;
    }

    @Override
    public void findFullRange() {
        this.findFullRange(this.pf);
    }

    protected boolean is(int val) {
        return (this.flags & val) != 0;
    }

    private boolean isVisible(Vehicle loc) {
        Object vis = loc.getAttribute("VISIBLE");
        return vis == null || StringUtil.isTrue(vis.toString());
    }

    private boolean isVisible(Vehicle.Location loc) {
        Object vis = loc.getAttribute("VISIBLE");
        return vis == null || StringUtil.isTrue(vis.toString());
    }

    private boolean isMarked(Vehicle veh) {
        Object marked = veh.getAttribute("MARKER");
        return marked == null && this.is(1) || StringUtil.isTrue(marked.toString());
    }

    public void setOpaqueness(int percent) {
        int val = MColor.pct2alpha(percent);
        this.setAlpha(val);
    }

    public int getOpaqueness() {
        return MColor.alpha2pct(this.fillAlpha);
    }

    public void setAlpha(int alpha) {
        if (alpha != this.fillAlpha) {
            this.fillAlpha = alpha;
            this.refresh();
        }
    }

    public int getAlpha() {
        return this.fillAlpha;
    }

    @Override
    public void draw(int flag) {
        this.draw(flag, true);
    }

    protected void draw(int flag, boolean doVehicles) {
        super.draw(flag);
        if (doVehicles) {
            String[] names = this.getVehicleNames();
            for (int v = 0; v < names.length; ++v) {
                Vehicle veh = this.getVehicle(names[v]);
                if (!this.isVisible(veh)) continue;
                this.drawVehicle(veh);
            }
        }
    }

    protected void drawVehicle(Vehicle vehicle) {
        this.drawVehicle(vehicle, null, this.cangle, this.crange, Double.NaN);
    }

    protected void drawVehicle(Vehicle vehicle, Position pospOR, double cangleOR, double crangeOR, double radiusOR) {
        Vehicle.Location loc = vehicle.getLocation();
        Vehicle.Site site = vehicle.getSite();
        Position pos = loc.getPos();
        String[] keys = vehicle.getPointingPosNames();
        if (this.is(4)) {
            for (int i = 0; i < keys.length; ++i) {
                Vehicle.PointingPos point = vehicle.getPointingPos(keys[i]);
                if (!this.isVisible(point)) continue;
                Position posp = pospOR != null ? pospOR : point.getPos();
                double angle = cangleOR == cangleOR ? cangleOR : point.getConeAngle();
                double range = crangeOR == crangeOR ? crangeOR : 0.0;
                double radius = radiusOR == radiusOR ? radiusOR : point.getRadius();
                double[][] footprint = point.getFootprint();
                if (!(angle > 0.0) && !(radius > 0.0) && footprint == null) continue;
                Line tline = this.line.copy();
                this.setLineColor(tline, "COLOR", vehicle, point);
                if (this.coneFill) {
                    tline.setType(tline.getTypeInt() | 8);
                    tline.setFillColor(MColor.getColor((Object)tline.getColor(), this.fillAlpha));
                }
                if (footprint != null) {
                    for (int fp = 0; fp < footprint.length; ++fp) {
                        this.MP.drawLineLonLat(footprint[fp], 0, 3, footprint[fp].length / 3, tline);
                    }
                } else if (radius > 0.0) {
                    this.MP.drawEllipse(posp.getLon(), posp.getLat(), 0.0, radius, radius, 0.0, -1, tline, true);
                } else {
                    this.MP.drawCone(pos, posp, this.conic, this.cdiv, angle, range, tline, this.coneMode, true);
                }
                this.drawLabel(vehicle, point, tline, posp);
            }
        }
        Line lin = this.line.copy();
        this.setLineColor(lin, "HORIZONCOLOR", vehicle, null);
        if (this.isMarked(vehicle)) {
            this.drawLabel(vehicle, loc, lin, null);
            this.drawLabel(vehicle, site, lin, null);
        }
        if (this.is(2)) {
            double radius = loc.getRadius();
            if (radius > 0.0) {
                this.MP.drawEllipse(pos.getLon(), pos.getLat(), 0.0, radius, radius, 0.0, -1, lin, true);
            } else {
                this.drawHorizon(pos, lin);
            }
        }
    }

    private void drawLabel(Vehicle vehicle, Vehicle.Location point, Line line, Position posOR) {
        if (!this.isVisible(vehicle) || !this.isVisible(point)) {
            return;
        }
        String label = point.getLabel();
        Position pos = posOR != null ? posOR : point.getPos();
        Line tline = line.copy();
        if (label == null) {
            label = "";
        }
        this.setLineColor(tline, "COLOR", vehicle, point);
        this.setLineSymbol(tline, vehicle, point);
        tline.setSymbolHeading((float)pos.getHeading());
        this.drawLabel(pos, label, tline);
    }

    protected void drawLabel(Position pos, String label, Line line) {
        if (this.MP.gc == null) {
            return;
        }
        MPoint pix = this.MP.getPoint(pos);
        if (pix.x < this.MP.ix1 || pix.x > this.MP.ix2) {
            return;
        }
        if (pix.y < this.MP.iy1 || pix.y > this.MP.iy2) {
            return;
        }
        int radius = 0;
        this.MP.gc.setColor(line.getColor());
        if (line.getSymbol() != null) {
            radius = line.getSymbol().getSize() / 2;
            line.getSymbol().draw(pix.x, pix.y, this.MP.gc);
        }
        if (label != null) {
            int xoff = this.getLabelxoffset(radius, false, this.name);
            if (label.indexOf(10) < 0) {
                this.MP.gc.drawString(label, pix.x + xoff, pix.y + line.getRadius());
            } else {
                String[] lines = label.split("\n");
                int lineHeight = this.MP.gc.getFontMetrics().getHeight();
                for (int lineNum = 0; lineNum < lines.length; ++lineNum) {
                    int delta = lineHeight * lineNum;
                    this.MP.gc.drawString(lines[lineNum], pix.x + xoff, pix.y + line.getRadius() + delta);
                }
            }
        }
    }

    private int getLabelxoffset(int radius, boolean left, String label) {
        if (this.MP.gc == null) {
            return -1;
        }
        int xoff = 2 + radius;
        if (left) {
            FontMetrics fm = this.MP.gc.getFontMetrics();
            xoff = -1 * (fm.bytesWidth(label.getBytes(), 0, label.length()) + xoff);
        }
        return xoff;
    }

    protected void drawPoint(Line lin, MPoint pix, String label) {
        if (this.MP.gc == null) {
            return;
        }
        if (pix.x < this.MP.ix1 || pix.x > this.MP.ix2) {
            return;
        }
        if (pix.y < this.MP.iy1 || pix.y > this.MP.iy2) {
            return;
        }
        int r = lin.getRadius();
        this.MP.gc.drawLine(pix.x - r, pix.y - r, pix.x + r, pix.y + r);
        this.MP.gc.drawLine(pix.x - r, pix.y + r, pix.x + r, pix.y - r);
        this.MP.gc.drawString(label, pix.x + r, pix.y + r);
    }

    private void drawHorizon(Position pos, Line line) {
        this.MP.drawCircleLonLat(pos.lon, pos.lat, this.computeHorizonDistance(pos.alt), -1, line);
    }

    public double computeHorizonDistance(double alt) {
        double r = 6378137.0;
        double d = alt + r;
        double w = Math.asin(r / d);
        return 90.0 - Math.toDegrees(w);
    }

    protected final Vehicle.Location[] getAllLocations() {
        return this.doGetAllLocations().toArray(EMPTY_LOCATION_ARRAY);
    }

    protected Vector<Vehicle.Location> doGetAllLocations() {
        Vector<Vehicle.Location> locations = new Vector<Vehicle.Location>(this.vehicles.size() * 8);
        String[] names = this.getVehicleNames();
        for (int i = 0; i < names.length; ++i) {
            Vehicle veh = this.getVehicle(names[i]);
            locations.add(veh.getLocation());
            locations.add(veh.getSite());
            String[] pposNames = veh.getPointingPosNames();
            for (int j = 0; j < pposNames.length; ++j) {
                locations.add(veh.getPointingPos(pposNames[j]));
            }
        }
        return locations;
    }

    @Override
    public void refresh() {
        this.checkSelection();
        super.refresh();
    }

    private void checkSelection() {
        if (this.selected != null && !this.doGetAllLocations().contains(this.selected)) {
            this.selected = null;
        }
    }

    public Vehicle.Location getSelected() {
        return this.selected;
    }

    public void setSelected(Vehicle.Location location) {
        if (this.selected != location) {
            if (location == null || this.doGetAllLocations().contains(location)) {
                this.selected = location;
                this.refresh();
            } else {
                throw new MidasException(this.getName() + ": Invalid location setSelected(" + location + "), location does not match any of the vehicles in this layer.");
            }
        }
    }

    public final void clearSelected() {
        this.setSelected(null);
    }

    public final Vehicle.Location selectNearest2D(Position position) {
        return this.selectNearest2D(position, -1.0);
    }

    public final Vehicle.Location selectNearest3D(Position position) {
        return this.selectNearest3D(position, -1.0);
    }

    public final Vehicle.Location selectNearestPoint(Position position) {
        return this.selectNearestPoint(position, -1);
    }

    public final Vehicle.Location getNearest2D(Position position) {
        return this.getNearest2D(position, -1.0);
    }

    public final Vehicle.Location getNearest3D(Position position) {
        return this.getNearest3D(position, -1.0);
    }

    public final Vehicle.Location getNearestPoint(Position position) {
        return this.getNearestPoint(position, -1);
    }

    public final Vehicle.Location selectNearest2D(Position position, double range) {
        this.setSelected(this.getNearest3D(position, range));
        return this.getSelected();
    }

    public final Vehicle.Location selectNearest3D(Position position, double range) {
        this.setSelected(this.getNearest3D(position, range));
        return this.getSelected();
    }

    public final Vehicle.Location selectNearestPoint(Position position, int range) {
        this.setSelected(this.getNearestPoint(position, range));
        return this.getSelected();
    }

    public final Vehicle.Location getNearest2D(Position position, double range) {
        return this.getNearest(position, range, true);
    }

    public final Vehicle.Location getNearest3D(Position position, double range) {
        return this.getNearest(position, range, false);
    }

    public Vehicle.Location getNearestPoint(Position position, int range) {
        if (position.referenceFrame == 0) {
            position.car2geo();
        }
        Vehicle.Location[] locations = this.getAllLocations();
        Vehicle.Location nearest = null;
        int lastDist = range < 0 ? 625 : range * range;
        MPoint pos = this.MP.getPoint(position);
        int pos_x = pos.x;
        int pos_y = pos.y;
        for (int i = 0; i < locations.length; ++i) {
            int dy;
            int dx;
            int dist;
            MPoint loc = this.MP.getPoint(locations[i].getPos());
            int loc_x = loc.x;
            int loc_y = loc.y;
            if (!this.MP.isInRange(loc_x, loc_y) || (dist = (dx = pos_x - loc_x) * dx + (dy = pos_y - loc_y) * dy) >= lastDist) continue;
            nearest = locations[i];
            lastDist = dist;
        }
        return nearest;
    }

    protected Vehicle.Location getNearest(Position position, double range, boolean twoD) {
        if (position.referenceFrame == 0) {
            position.car2geo();
        }
        Vehicle.Location[] locations = this.getAllLocations();
        Vehicle.Location nearest = null;
        double lastDist = range < 0.0 ? Double.MAX_VALUE : range;
        Position pos = this.newPos(position, twoD);
        for (int i = 0; i < locations.length; ++i) {
            Position loc = this.newPos(locations[i].getPos(), twoD);
            double dist = Transform.greatArc(position, loc);
            pos.car2geo();
            if (!(dist <= lastDist)) continue;
            nearest = locations[i];
            lastDist = dist;
        }
        return nearest;
    }

    private Position newPos(Position pos, boolean twoD) {
        if (twoD) {
            return Position.fromGeo(0.0, pos.lat, pos.lon);
        }
        return Position.fromGeo(pos.alt, pos.lat, pos.lon);
    }

    private Object getAttr(String name, Vehicle veh, Vehicle.Location point, Object def) {
        Object val;
        Object object = val = point == null ? null : point.getAttributes().getO(name);
        if (val == null) {
            val = veh.getAttributes().getO(name);
        }
        if (val == null) {
            val = def;
        }
        return val;
    }

    private void setLineColor(Line line, String name, Vehicle veh, Vehicle.Location point) {
        Vehicle.Location sel = this.getSelected();
        if (sel == null) {
            Object val = this.getAttr(name, veh, point, null);
            if (val == null) {
                val = this.getAttr("COLOR", veh, null, null);
            }
            if (val != null) {
                line.setColor(val);
            }
        } else if (sel == point) {
            line.setColor(this.selectColor);
        } else {
            line.setColor(this.deselectColor);
        }
    }

    private void setLineSymbol(Line line, Vehicle veh, Vehicle.Location point) {
        Object symbol = this.getAttr("SYMBOL", veh, point, null);
        Object size = this.getAttr("SYMBOLSIZE", veh, point, null);
        Object fill = this.getAttr("SYMBOLFILL", veh, point, null);
        Object hdg = this.getAttr("SYMBOLHEADING", veh, point, null);
        if (symbol != null) {
            line.setSymbol(symbol);
        }
        if (size != null) {
            line.setSymbolSize(Convert.o2l(size));
        }
        if (fill != null) {
            line.setSymbolFill(Convert.o2z(fill));
        }
        if (hdg != null) {
            line.setSymbolHeading(Convert.o2f(hdg));
        }
    }

    public int getConic() {
        return this.conic;
    }

    public void setConic(int value) {
        this.conic = value;
        this.refresh();
    }

    public int getConeDiv() {
        return this.cdiv;
    }

    public void setConeDiv(int value) {
        this.cdiv = value;
        this.refresh();
    }

    public double getConeAngle() {
        return this.cangle;
    }

    public void setConeAngle(double value) {
        this.cangle = value;
        this.refresh();
    }

    public double getConeRange() {
        return this.crange;
    }

    public void setConeRange(double value) {
        this.crange = value;
        this.refresh();
    }
}

