/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.logging.Level;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.CsvFile;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.GeoJSONFile;
import nxm.sys.lib.ImageFile;
import nxm.sys.lib.KmlFile;
import nxm.sys.lib.LogUtilities;
import nxm.sys.lib.Midas;
import nxm.sys.lib.OptionTree;
import nxm.sys.lib.PropsUtilities;
import nxm.sys.lib.ShapeFile;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.libg.Layer;
import nxm.sys.libg.Layer1D;
import nxm.sys.libg.Layer2D;
import nxm.sys.libg.LayerGeoJSON;
import nxm.sys.libg.LayerImage;
import nxm.sys.libg.LayerKML;
import nxm.sys.libg.LayerMulti;
import nxm.sys.libg.LayerPoly;
import nxm.sys.libg.LayerShape;
import nxm.sys.libg.LayerT5;
import nxm.sys.libg.LayerXY;

public class LayerUtil {
    private static Map<Class<?>, Function<PlotFile, Layer>> getLayerRegistry = new HashMap();
    private static Map<String, Boolean> optionTrees = new HashMap<String, Boolean>();

    @Deprecated
    public LayerUtil() {
    }

    public static Layer plotFileWrapperGetLayer(PlotFile pf) {
        return LayerUtil.getFunction(pf.getClass()).apply(pf);
    }

    public static Layer dataFileGetLayer(PlotFile pf) {
        return LayerUtil.getDataFileLayer((DataFile)pf, 0);
    }

    @InternalUseOnly
    public static Layer getDataFileLayer(DataFile df, int plotType) {
        switch (df.getType()) {
            case 1998: {
                return new LayerPoly(8);
            }
            case 1999: {
                return new LayerPoly(8);
            }
        }
        boolean oneFrame = df.getSize() == 1.0 && !df.isStream();
        boolean isLinePlot = plotType == 1 || plotType == 5 || plotType == 6;
        switch (df.getTypeCodeClass()) {
            case 1: {
                return new Layer1D();
            }
            case 2: {
                return oneFrame || isLinePlot ? new Layer1D() : new Layer2D();
            }
            case 3: {
                return df.findRec("ABSC") >= 0 || df.findRec("TIME") >= 0 ? new LayerXY() : new LayerMulti();
            }
            case 6: {
                return df.findRec("ABSC") >= 0 || df.findRec("TIME") >= 0 ? new LayerXY() : new LayerMulti();
            }
            case 5: {
                return new LayerT5();
            }
        }
        return null;
    }

    public static boolean addFunction(Class<?> clazz, Function<PlotFile, Layer> method) {
        if (getLayerRegistry.containsKey(clazz) && clazz.getPackage().getName().equals("nxm.sys.lib")) {
            System.out.println("Hello");
            Midas.log("Overwriting of " + clazz + " not allowed. Not adding to the registry", 1);
            return false;
        }
        getLayerRegistry.put(clazz, method);
        return true;
    }

    public static Function<PlotFile, Layer> getFunction(Class<?> clazz) {
        return getLayerRegistry.get(clazz);
    }

    public static void refreshRegistry() {
        String[] opts;
        for (String opt : opts = Shell.getSharedMidasContext().getCurrentPathArray()) {
            if (optionTrees.containsKey(opt)) continue;
            LayerUtil.loadFunctionFromPropsFile(opt);
        }
    }

    private static final void loadFunctionFromPropsFile(String opt) {
        Table optionTrees = OptionTree.getAllOptions(Shell.getMidasContext());
        LayerUtil.loadOptionTreeFunction(optionTrees, opt);
    }

    private static final void loadFunctionsFromPropsFile() {
        Table optionTrees = OptionTree.getAllOptions(Shell.getMidasContext());
        for (String opt : optionTrees.getKeys()) {
            LayerUtil.loadOptionTreeFunction(optionTrees, opt);
        }
    }

    private static final void loadOptionTreeFunction(Table optionTrees, String opt) {
        LayerUtil.optionTrees.put(opt.toUpperCase(), true);
        Table optionTree = (Table)optionTrees.get(opt);
        String propsFile = optionTree.get("CFGROOT").toString() + "cfg" + File.separator + "PlotFileLayer.props";
        if (propsFile.startsWith("classpath:")) {
            propsFile = propsFile.replace("classpath:", File.separator);
        }
        Properties props = new Properties();
        try {
            props.load(LayerUtil.class.getResourceAsStream(propsFile));
        }
        catch (IOException | NullPointerException e) {
            if (!new File(propsFile).exists()) {
                return;
            }
            props = PropsUtilities.loadProps(propsFile);
        }
        if (props == null) {
            return;
        }
        for (String classNameFileType : props.stringPropertyNames()) {
            Class<?> clazz = null;
            String methodName = null;
            String classNameGetLayer = null;
            try {
                boolean needPlotFile;
                clazz = Class.forName(classNameFileType);
                if (!PlotFile.class.isAssignableFrom(clazz)) {
                    LogUtilities.log(Level.WARNING, "The file type provided in PlotFileLayer.props is not a PlotFile type. PlotFile=" + classNameFileType);
                    continue;
                }
                if (getLayerRegistry.containsKey(clazz)) {
                    LogUtilities.log(Level.FINE, "Class:" + classNameFileType + " already loaded into the registry.");
                    continue;
                }
                String value = props.getProperty(classNameFileType).trim();
                int indexOfDot = value.lastIndexOf(".");
                classNameGetLayer = value.substring(0, indexOfDot);
                methodName = value.substring(indexOfDot + 1);
                if (classNameGetLayer.startsWith("p->") || classNameGetLayer.startsWith("pf->")) {
                    needPlotFile = true;
                    classNameGetLayer = classNameGetLayer.substring(classNameGetLayer.indexOf(">") + 1).trim();
                } else {
                    needPlotFile = false;
                }
                try {
                    Method m = needPlotFile ? Class.forName(classNameGetLayer).getMethod(methodName, PlotFile.class) : Class.forName(classNameGetLayer).getMethod(methodName, new Class[0]);
                    LayerUtil.addFunction(clazz, pf -> {
                        try {
                            return needPlotFile ? (Layer)m.invoke(null, pf) : (Layer)m.invoke(null, new Object[0]);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            LogUtilities.log(Level.WARNING, "Exception Loading getLayer Functions for " + value, e);
                            return null;
                        }
                    });
                }
                catch (NoSuchMethodException | SecurityException e) {
                    LogUtilities.log(Level.WARNING, "Exception Loading getLayer Functions for " + value, e);
                }
            }
            catch (ClassNotFoundException e) {
                LogUtilities.log(Level.WARNING, "Exception Loading getLayer Functions for class " + classNameFileType, e);
            }
        }
    }

    static {
        LayerUtil.addFunction(CsvFile.class, pf -> LayerMulti.getLayer());
        LayerUtil.addFunction(ImageFile.class, pf -> LayerImage.getLayer());
        LayerUtil.addFunction(ShapeFile.class, pf -> LayerShape.getLayer());
        LayerUtil.addFunction(KmlFile.class, pf -> LayerKML.getLayer());
        LayerUtil.addFunction(GeoJSONFile.class, pf -> LayerGeoJSON.getLayer());
        LayerUtil.addFunction(DataFile.class, pf -> LayerUtil.dataFileGetLayer(pf));
        LayerUtil.addFunction(FileUtil.PlotFileWrapper.class, pf -> LayerUtil.plotFileWrapperGetLayer(pf));
        optionTrees.put("SYS", true);
        LayerUtil.loadFunctionsFromPropsFile();
    }
}

