/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.DataFile;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Table;
import nxm.sys.libg.LayerMulti;
import nxm.sys.libg.Line;

public class LayerMulti2D
extends LayerMulti {
    protected float[] fbuf;
    protected boolean rescale;

    public LayerMulti2D() {
        this.name = "Multi2D";
    }

    @Override
    public boolean setFile(PlotFile pf, Table tab, Args MA) {
        this.setFile(pf);
        if (!(pf instanceof DataFile)) {
            throw new MidasException("Only Type 2000 BLUE files are supported in " + this.name + ".");
        }
        DataFile df = (DataFile)pf;
        if (df.typeClass != 2) {
            throw new MidasException("Only Type 2000 BLUE files are supported in " + this.name + ".");
        }
        if (df.getSize() > 2.147483647E9) {
            throw new MidasException("Currently, " + this.name + " is limited to a max size of " + Integer.MAX_VALUE + ", given file of size " + df.getSize() + ".");
        }
        int nels = df.getFrameSize();
        int numRec = (int)df.getSize();
        this.setXAxis(pf.getXStart(), pf.getXDelta());
        this.setXUnits(pf.getXUnits());
        this.setYAxis(0.0, 1.0);
        this.setYUnits(0);
        this.setColorMap(6, numRec);
        this.recData = null;
        this.recNames = new String[numRec];
        this.recIndex = 0;
        String legend = (String)df.getKeywordsObject().get("LEGEND");
        if (legend == null) {
            this.recNames = new String[0];
        } else {
            Parser parser = new Parser(legend);
            this.recNames = new String[parser.elements()];
            for (int i = 0; i < this.recNames.length; ++i) {
                this.recNames[i] = parser.get(i + 1);
            }
        }
        this.showColsChanged = true;
        if (df.isPipe()) {
            throw new MidasException("Pipes not supported in " + this.getClass());
        }
        int lpb = 1;
        this.setSize(lpb);
        this.setFrame(nels);
        this.setData(pf.getDataBuffer(lpb));
        this.realtime = false;
        this.isPaged = lpb < numRec;
        this.frameReady = false;
        this.frameDrawn = false;
        this.lastRow = 0;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getData(int mode) {
        int stat = 0;
        if (this.pf == null || !this.pf.isOpen() || this.isDone || this.getDrawFrame()) {
            return stat;
        }
        if (!this.lock()) {
            return stat;
        }
        try {
            this.frameReady = false;
            this.frameDrawn = false;
            if (this.rereadFile) {
                this.pf.seek(0.0);
                this.ndata = 0;
                this.rereadFile = false;
            }
            double avail = this.pf.avail();
            this.fseek = this.pf.seek();
            boolean bl = this.rescale = this.fseek == 0.0;
            while (avail > 0.0 && !this.show((int)this.fseek)) {
                avail -= 1.0;
                this.fseek += 1.0;
                this.pf.seek(this.fseek);
            }
            int ndo = (int)avail;
            if (avail > 0.0) {
                for (ndo = 1; avail > (double)ndo && !this.show((int)this.fseek + ndo) && ndo < this.data.getSize(); ++ndo) {
                }
            }
            if (ndo > 0) {
                int count = this.pf.read(this.data, ndo);
                this.process(count);
                stat = this.getNeedRefresh() ? 1 : (this.isReset ? 1 : (this.isPaged ? 2 : this.defmode));
                this.frameReady = true;
            } else if (this.isPaged) {
                this.pf.seek(this.pf.getSize());
                this.ndata = 0;
            } else if (!this.realtime) {
                stat = 0;
            } else if (this.pf.isStream() && !this.pf.isStreaming()) {
                stat = -1;
            }
        }
        finally {
            this.unlock();
        }
        return stat;
    }

    @Override
    public void process(int elem) {
        if (this.data == null) {
            this.ndata = 0;
            return;
        }
        this.ndata = elem;
        this.fbuf = this.data2fa(this.data, this.ndata * this.data.ape, this.fbuf, 0, this.MP.mode);
        if (this.rescale) {
            this.minY = this.fbuf[0];
            this.maxY = this.fbuf[0];
            this.rescale = false;
        }
        for (int i = 0; i < this.ndata * this.data.ape; ++i) {
            float y = this.fbuf[i];
            if ((double)y > this.maxY) {
                this.maxY = y;
            }
            if (!((double)y < this.minY)) continue;
            this.minY = y;
        }
        this.frameReady = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(int flag) {
        if (this.fbuf == null) {
            return;
        }
        if (!this.lock()) {
            return;
        }
        try {
            this.clearNeedRefresh();
            this.isReset = false;
            if (flag != 0 && !this.getDrawFrame()) {
                return;
            }
            Line lin = this.line.copy();
            for (int i = 0; i < this.ndata; ++i) {
                int irec = (int)this.fseek + i;
                lin.setColor(this.colors[irec % (this.colors.length - 1) + 1]);
                this.MP.drawLine(this.fbuf, i * this.data.ape, 1, this.data.ape, lin, this.xstart, this.xdelta);
            }
            this.frameDrawn = true;
        }
        finally {
            this.unlock();
        }
    }
}

