/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.PlotFile;
import nxm.sys.inc.ProvisionalUseOnly;
import nxm.sys.lib.Args;
import nxm.sys.lib.Cache;
import nxm.sys.lib.Midas;
import nxm.sys.lib.MidasException;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Shell;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.libg.Layer;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MPlot;

public abstract class LayerMap
extends Layer
implements ImageObserver {
    private static final BufferedImage NULL_IMAGE = new BufferedImage(1, 1, 2);
    private static final Color TRANSPARENT = new Color(0, true);
    private static final String CLASS_PREFIX = "nxm.sys.libg.Layer";
    private static final String LIBG_PREFIX = "nxm.sys.libg.";
    private static long instanceCount = 0L;
    private static final double MAX_COMP_DEF = 1.0;
    private static final double MIN_COMP_DEF = 0.001;
    private static final int GEO_LEVEL_DEF = 3;
    private static final int GWC_4326_X_MIN = MPlot.LONGITUDE_DEFAULT_MIN;
    static final int GWC_4326_X_MAX = MPlot.LONGITUDE_DEFAULT_MAX;
    private static final int GWC_4326_Y_MIN = MPlot.LATITUDE_DEFAULT_MIN;
    private static final int TILED_CACHE_SIZE_DEF = 1024;
    private static final int OLD_TILED_CACHE_SIZE_DEF = 16;
    private static final int CACHE_SIZE_DEF = 4;
    private int currentCacheSizeDefault = 4;
    private long jvmMaxMemoryGB = Runtime.getRuntime().maxMemory() / 1024L / 1024L / 1024L;
    private int smartFractionOfTileCacheDefault = (int)Math.min(1L, this.jvmMaxMemoryGB / 4L);
    protected static final WeakHashMap<String, Cache.TimeStampedValue> SHARED_VCACHE = new WeakHashMap();
    protected String mapServer = null;
    protected ArrayList<String> mapServerList = new ArrayList();
    protected int brightness = 50;
    protected int contrast = 50;
    protected boolean greyscale = false;
    protected int progress = -1;
    protected boolean mercator = this.getDefMercator();
    protected final Cache imgCache = this.getDefImgCache();
    private int imgCacheSize = -1;
    private final long instance = LayerMap.getInstance();
    private final Stack<DownloadRequest> toDownload = new Stack();
    private DownloadThread[] downloadThreads = null;
    private BufferedImage lastBlankImage = null;
    private String lastBlankText = null;
    protected final boolean tileDefault = this.getDefUseTile();
    protected boolean tileEnable = this.getDefUseTile();
    protected final int tileHeight = this.getDefTileWidth();
    protected final int tileWidth = this.getDefTileHeight();
    protected double tileMaxComp = 1.0;
    protected double tileMinComp = 0.001;
    protected final int tileMaxLevel = this.getDefTileLevels();
    protected int tileGeoLevel = 3;
    protected int gwcLevel = 0;
    protected double connectTimeout = 15.0;
    protected double readTimeout = 300.0;
    protected double reconnectInterval = 30.0;
    private double pause = 0.0125;
    protected final String className = this.getDefClassName();
    protected Midas midas = null;
    protected boolean debug = false;
    int numRetriesIfBGColor = 0;
    private static boolean useOldCacheSizeDefault = false;
    private int lastNumRetries = -1;
    private boolean imageAdjustOnPan = true;
    private boolean legacyImageAdjust = false;
    private boolean geoWebCacheConfig = false;
    public static final String debugList = "Connection,TileRequest,TilesBBox";
    public static final int D_CONNECTION = 1;
    public static final int D_TILEREQUEST = 2;
    public static final int D_TILESBBOX = 4;
    private int debugOptions = 0;

    protected LayerMap(String name) {
        this.name = name;
        this.midas = Shell.getSharedMidasContext();
        if (this.midas != null) {
            this.pause = this.midas.pause;
        }
        this.setDownloadThreads(0);
        this.setCacheSize(-1);
    }

    final Object getLockObj() {
        return this.toDownload;
    }

    private String getDefClassName() {
        String _className = this.getClass().getName();
        if (_className.startsWith(LIBG_PREFIX)) {
            return _className.substring(LIBG_PREFIX.length());
        }
        return _className;
    }

    protected int getDefTileLevels() {
        return 32;
    }

    protected int getDefTileWidth() {
        return 256;
    }

    protected int getDefTileHeight() {
        return 256;
    }

    protected boolean getDefMercator() {
        return false;
    }

    private Cache getDefImgCache() {
        return new Cache(2, 4, 3600.0, SHARED_VCACHE);
    }

    protected boolean getDefUseTile() {
        return false;
    }

    private static synchronized long getInstance() {
        return instanceCount++;
    }

    public void setCacheSize(int size) {
        this.setDefaultCacheSize();
        this.setCacheSize(size, 0, this.currentCacheSizeDefault);
    }

    private void setDefaultCacheSize() {
        int smartDefault = Math.max(1024 * this.smartFractionOfTileCacheDefault, 16);
        this.currentCacheSizeDefault = this.tileEnable ? (!useOldCacheSizeDefault ? smartDefault : 16) : 4;
    }

    protected final void setCacheSize(int size, int min, int def) {
        if (size == -1) {
            this.imgCache.setMaxSize(Math.max(def, min));
            this.imgCacheSize = -1;
        } else {
            if (size < min) {
                this.warn("Current image cache (CacheSize=" + this.imgCacheSize + ") is too small given the current configuration and current size of the PLOT window, increasing size to " + size + ".");
                size = min;
            }
            this.imgCache.setMaxSize(size);
            this.imgCacheSize = this.imgCache.getMaxSize();
        }
    }

    public final int getCacheSize() {
        return this.imgCacheSize;
    }

    public final int getCurrentCacheSize() {
        return this.imgCache.getMaxSize();
    }

    public void setUseTiles(boolean tile) {
        if (tile != this.tileEnable) {
            this.tileEnable = tile;
            this.setCacheSize(-1);
            this.refresh();
        }
    }

    public boolean getUseTiles() {
        return this.tileEnable;
    }

    public void setMinComp(double val) {
        if (this.tileMinComp != val && val > 0.0) {
            this.tileMinComp = val;
            this.refresh();
        }
    }

    public double getMinComp() {
        return this.tileMinComp;
    }

    public void setMaxComp(double val) {
        if (this.tileMaxComp != val && val > 0.0) {
            this.tileMaxComp = val;
            this.refresh();
        }
    }

    public double getMaxComp() {
        return this.tileMaxComp;
    }

    public void setGeoResLevel(int level) {
        if ((level = Math.max(0, Math.min(level, 5))) == 1) {
            level = 2;
        }
        if (level != this.tileGeoLevel) {
            this.tileGeoLevel = level;
            this.refresh();
        }
    }

    public int getGeoResLevel() {
        return this.tileGeoLevel;
    }

    public void setGeoWebCache(boolean useGeoWebCacheConfig) {
        this.geoWebCacheConfig = useGeoWebCacheConfig;
        this.setUseTiles(true);
    }

    public boolean getGeoWebCache() {
        return this.geoWebCacheConfig;
    }

    public Table getConfig() {
        Table tbl = new Table();
        String clazz = this.getClass().getName();
        if (clazz.startsWith(CLASS_PREFIX)) {
            clazz = clazz.substring(CLASS_PREFIX.length());
        }
        tbl.put("LT", (Object)clazz);
        if (this.debug) {
            tbl.put("DEBUG", (Object)"TRUE");
        }
        tbl.put("URL", (Object)this.getURL());
        if (this.brightness != 50) {
            tbl.put("BRIGHTNESS", this.brightness);
        }
        if (this.contrast != 50) {
            tbl.put("CONTRAST", this.contrast);
        }
        if (this.greyscale) {
            tbl.put("GREYSCALE", this.greyscale);
        }
        if (this.downloadThreads != null) {
            tbl.put("DOWNLOADTHREADS", this.getDownloadThreads());
        }
        if (this.tileEnable != this.tileDefault) {
            tbl.put("USETILES", this.getUseTiles());
        }
        if (this.tileMaxComp != 1.0) {
            tbl.put("MAXCOMP", this.getMaxComp());
        }
        if (this.tileMinComp != 0.001) {
            tbl.put("MINCOMP", this.getMinComp());
        }
        if (this.tileGeoLevel != 3) {
            tbl.put("GEOLEVEL", this.getGeoResLevel());
        }
        if (this.imgCacheSize != -1) {
            tbl.put("CACHESIZE", this.getCacheSize());
        }
        return tbl;
    }

    @Override
    public boolean setFile(PlotFile pf, Table tab, Args MA) {
        return true;
    }

    public void setURL(String url) {
        if (url != null && !this.isReachable(url, true)) {
            url = null;
        }
        if (!(url == this.mapServer || url != null && url.equals(this.mapServer))) {
            this.mapServer = url;
            this.setNeedsRescale(true);
            this.refresh();
        }
        this.updateMapServerList(this.mapServer);
        if (this.debug) {
            Shell.info("LayerMap url=" + url + " mapServer=" + this.mapServer + " mapListSize=" + this.mapServerList.size());
        }
    }

    public String getURL() {
        return this.mapServer;
    }

    public String updateMapServerList(String url) {
        if (url == null || url.isEmpty()) {
            return null;
        }
        int comma = url.indexOf(44);
        if (comma >= 0) {
            String[] urls;
            String first = null;
            for (String u : urls = url.split(",")) {
                if (first == null) {
                    first = u;
                }
                if (u == null || this.mapServerList.contains(u)) continue;
                this.mapServerList.add(u);
            }
            return first;
        }
        if (url != null && !this.mapServerList.contains(url)) {
            this.mapServerList.add(url);
        }
        return url;
    }

    public void disconnect() {
        this.mapServer = null;
        this.setNeedsRescale(true);
        this.refresh();
    }

    boolean isReachable(String href, boolean warn) {
        boolean valid;
        try {
            this.checkReachable(href);
            valid = true;
        }
        catch (Exception e) {
            if (warn) {
                this.warn(e.getMessage());
            }
            valid = false;
        }
        return valid;
    }

    void checkReachable(String href) {
        URL url = null;
        try {
            url = new URI(href).toURL();
            String host = url.getHost();
            int port = this.getPort(url.getProtocol(), url.getPort());
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), (int)(this.connectTimeout * 1000.0));
            socket.close();
        }
        catch (Exception e) {
            if (url == null) {
                throw new MidasException("Unable to access '" + href + "' invalid URL: " + e.getMessage(), e);
            }
            throw new MidasException("Unable to access '" + url.getHost() + "' using port " + this.getPort(url.getProtocol(), url.getPort()) + ": " + e.getMessage(), e);
        }
    }

    private int getPort(String protocol, int urlPort) {
        if (urlPort != -1) {
            return urlPort;
        }
        if (protocol.equals("http")) {
            return 80;
        }
        if (protocol.equals("https")) {
            return 443;
        }
        return -1;
    }

    protected String getHostPort() {
        String hostPort;
        try {
            URL url = new URI(this.getURL()).toURL();
            hostPort = url.getHost();
            if (url.getPort() > 0) {
                hostPort = hostPort + ":" + url.getPort();
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            hostPort = "<invalid url>";
        }
        return hostPort;
    }

    public abstract boolean isConnected();

    public void setDebug(boolean dbg) {
        this.info("Turning debug " + (dbg ? "on" : "off") + " for " + this.getName());
        this.debug = dbg;
    }

    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void findRange() {
        this.x1 = -180.0;
        this.x2 = 180.0;
        this.y1 = -90.0;
        this.y2 = 90.0;
        this.z1 = 0.0;
        this.z2 = 0.0;
        this.a1 = this.y1;
        this.a2 = this.y2;
    }

    @Override
    public void findFullRange() {
        this.findFullRange(this.pf);
    }

    protected abstract int drawArea(double var1, double var3, double var5, double var7, int var9, int var10, boolean var11, String var12);

    @Override
    public void process() {
        double maxLon;
        double minLon = Math.max(-180.0, this.MP.rx1);
        if (this.MP.view == 14) {
            double maxAsideFromViewArea = Math.min(minLon + (double)MPlot.LONGITUDE_RANGE, (double)MPlot.LONGITUDE_CONTINUOUS_MAX);
            maxLon = Math.min(this.MP.rx2, maxAsideFromViewArea);
        } else {
            maxLon = Math.min(180.0, this.MP.rx2);
        }
        double minLat = Math.max(-90.0, this.MP.ry1);
        double maxLat = Math.min(90.0, this.MP.ry2);
        int xMin = this.MP.getix(minLon);
        int xMax = this.MP.getix(maxLon);
        int yMin = this.MP.getiy(minLat);
        int yMax = this.MP.getiy(maxLat);
        int width = xMax - xMin;
        int height = yMin - yMax;
        boolean hiRes = false;
        if (this.MP.view == 12) {
            hiRes = minLat > 60.0 || minLat < -60.0 || maxLat > 60.0 || maxLat < -60.0;
        } else if (this.MP.view == 13) {
            minLon = -180.0;
            maxLon = 180.0;
            minLat = -90.0;
            maxLat = 90.0;
            width = Math.max(this.MP.panel.getWidth(), this.MP.panel.getHeight());
            height = width / 2;
            hiRes = true;
        }
        if (this.tileEnable) {
            this.drawTiles(minLon, maxLon, minLat, maxLat, width, height, hiRes);
        } else {
            this.drawArea(minLon, maxLon, minLat, maxLat, width, height, hiRes, null);
        }
    }

    protected void drawTiles(double minLon, double maxLon, double minLat, double maxLat, int width, int height, boolean hiRes) {
        double draw2;
        HashMap<String, double[]> tiles = new HashMap<String, double[]>();
        int[] levelAndDiv = this.calcTileLevel(minLon, maxLon, minLat, maxLat, width, height, hiRes);
        int level = levelAndDiv[0];
        int div = levelAndDiv[1];
        double dlon = 360.0 / (double)div / 2.0;
        double dlat = 360.0 / (double)div / 2.0;
        for (double lon = minLon; lon < maxLon + dlon; lon += dlon) {
            for (double lat = minLat; lat < maxLat + dlat; lat += dlat) {
                StringBuilder pos = new StringBuilder("t");
                double dx = 180.0;
                double dy = 180.0;
                double x1 = GWC_4326_X_MIN;
                double y1 = level > 2 ? -180.0 : (double)GWC_4326_Y_MIN;
                double x2 = GWC_4326_X_MAX;
                double y2 = level > 2 ? 180.0 : 270.0;
                int i = 2;
                while (i <= level) {
                    boolean down;
                    boolean left = lon < x1 + dx;
                    boolean bl = down = lat < y1 + dy;
                    if (left) {
                        x2 -= dx;
                        if (down) {
                            pos.append('t');
                            y2 -= dy;
                        } else {
                            pos.append('q');
                            y1 += dy;
                        }
                    } else {
                        x1 += dx;
                        if (down) {
                            pos.append('s');
                            y2 -= dy;
                        } else {
                            pos.append('r');
                            y1 += dy;
                        }
                    }
                    ++i;
                    dx /= 2.0;
                    dy /= 2.0;
                }
                String posStr = pos.toString();
                if (!this.isValidPos(posStr)) continue;
                tiles.put(posStr, new double[]{x1, x2, y1, y2});
            }
        }
        this.setCacheSize(this.imgCacheSize, Math.max(1, tiles.size()), this.currentCacheSizeDefault);
        this.gwcLevel = level - 2;
        boolean connectionDebug = (this.debugOptions & 1) != 0;
        double draw1 = connectionDebug ? Time.current() : 0.0;
        double overallMaxLon = -180.0;
        double overallMaxLat = -90.0;
        double overallMinLon = 180.0;
        double overallMinLat = 90.0;
        for (Map.Entry mapentry : tiles.entrySet()) {
            String pos = (String)mapentry.getKey();
            double[] box = (double[])mapentry.getValue();
            if (connectionDebug) {
                this.midas.info("[DEBUG CONNECTION] LayerMap drawing:" + Arrays.toString(box) + " tileWidth:" + this.tileWidth + " tileHeight:" + this.tileHeight + " pos:" + pos);
            }
            this.drawArea(box[0], box[1], box[2], box[3], this.tileWidth, this.tileHeight, hiRes, pos);
            if (box[1] > overallMaxLon) {
                overallMaxLon = box[1];
            }
            if (box[3] > overallMaxLat) {
                overallMaxLat = box[3];
            }
            if (box[0] < overallMinLon) {
                overallMinLon = box[0];
            }
            if (!(box[2] < overallMinLat)) continue;
            overallMinLat = box[3];
        }
        double d = draw2 = connectionDebug ? Time.current() : 0.0;
        if (connectionDebug && this.downloadThreads == null) {
            this.midas.info("[DEBUG CONNECTION] total connect+read+draw time: " + (draw2 - draw1));
        }
        if ((this.debugOptions & 4) != 0) {
            this.midas.info("[DEBUG TILESBBOX] z_level:" + (level - 2) + " nxm_level:" + level + " overallMinLon:" + overallMinLon + " overallMinLat:" + overallMinLat + " overallMaxLon:" + overallMaxLon + " overallMaxLat:" + overallMaxLat);
        }
    }

    private boolean isValidPos(String pos) {
        boolean valid = pos.startsWith("t");
        if (!(pos.length() <= 2 || pos.startsWith("trs") || pos.startsWith("trt") || pos.startsWith("tsq") || pos.startsWith("tsr") || pos.startsWith("ttq") || pos.startsWith("ttr") || pos.startsWith("tqs") || pos.startsWith("tqt"))) {
            valid = false;
        } else if (pos.length() == 2 && (pos.equals("tr") || pos.equals("tq"))) {
            valid = false;
        }
        return valid;
    }

    int[] calcTileLevel(double minLon, double maxLon, double minLat, double maxLat, int width, int height, boolean hiRes) {
        boolean tileRequestInfo;
        double compLimit = hiRes ? this.tileMaxComp / 2.0 : this.tileMaxComp;
        int maxLevel = this.MP.view == 13 ? this.tileGeoLevel : this.tileMaxLevel;
        int level = 1;
        int div = 1;
        double ppd = (double)width / (maxLon - minLon);
        boolean bl = tileRequestInfo = (this.debugOptions & 2) != 0;
        if (tileRequestInfo) {
            this.midas.info("[DEBUG TILEREQUEST] LayerMap.drawTiles lon:" + minLon + "," + maxLon + " lat:" + minLat + "," + maxLat + " width:" + width + " height:" + height + " hiRes:" + hiRes + " ppd:" + ppd);
        }
        while (level < maxLevel) {
            if (this.MP.view != 13) {
                double dpc = 360.0 / (double)div / (double)this.tileWidth;
                double ppc = ppd * dpc;
                if (tileRequestInfo) {
                    this.midas.info("[DEBUG TILEREQUEST] z_level:" + (level - 2) + "nxm_level:" + level + " dpc:" + dpc + " ppc:" + ppc + " div:" + div);
                }
                if (ppc < compLimit) break;
            }
            ++level;
            div *= 2;
        }
        if (level == 1) {
            level = 2;
            div = 2;
        }
        return new int[]{level, div};
    }

    @Override
    public void draw(int flag) {
        super.draw(flag);
        this.process();
        this.setProgress(this.progress());
    }

    protected final void drawImage(BufferedImage img, double minLon, double maxLon, double minLat, double maxLat) {
        this.drawImage(img, 0, img.getWidth(), 0, img.getHeight(), minLon, maxLon, minLat, maxLat);
    }

    protected void drawImage(BufferedImage img, int xMin, int xMax, int yMin, int yMax, double minLon, double maxLon, double minLat, double maxLat) {
        if (img != null) {
            if (!this.isViewSupported(this.MP.view)) {
                this.warn("VIEW=" + this.MP.getView() + " not supported at this time.");
            } else {
                int xSize = xMax - xMin;
                int ySize = yMax - yMin;
                double lonSize = maxLon - minLon;
                double latSize = maxLat - minLat;
                double xstart = minLon;
                double xdelta = lonSize / (double)xSize;
                int nx = xSize;
                double ystart = maxLat;
                double ydelta = -(latSize / (double)ySize);
                int ny = ySize;
                if (xMin != 0) {
                    this.warn("Can not plot xMin!=0 at this time.");
                }
                if (yMin != 0) {
                    this.warn("Can not plot yMin!=0 at this time.");
                }
                if (this.imageAdjustOnPan || this.MP.dragging == 0) {
                    img = !this.legacyImageAdjust ? MColor.adjustImageFast(img, xMin, yMin, xMax, yMax, this.contrast, this.brightness, -1, this.greyscale) : MColor.adjustImage(img, xMin, yMin, xMax, yMax, this.contrast, this.brightness, -1, this.greyscale);
                }
                if (this.MP.view == 14) {
                    this.MP.drawImage(img, ystart, ystart - latSize, xstart + lonSize, xstart);
                } else {
                    this.MP.drawImage(img, null, this.mercator, xstart, xdelta, nx, ystart, ydelta, ny);
                }
            }
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return true;
    }

    public void setContrast(int percent) {
        int oldval = this.contrast;
        this.contrast = Math.max(0, Math.min(100, percent));
        if (this.contrast != oldval) {
            this.refresh();
        }
    }

    public int getContrast() {
        return this.contrast;
    }

    public void setBrightness(int percent) {
        int oldval = this.brightness;
        this.brightness = Math.max(0, Math.min(100, percent));
        if (this.brightness != oldval) {
            this.refresh();
        }
    }

    public int getBrightness() {
        return this.brightness;
    }

    public void setGreyscale(boolean gs) {
        boolean oldval = this.greyscale;
        this.greyscale = gs;
        if (gs != oldval) {
            this.refresh();
        }
    }

    public boolean getGreyscale() {
        return this.greyscale;
    }

    public final int getBusy() {
        return this.getProgress();
    }

    public int getProgress() {
        return this.progress;
    }

    protected void setProgress(int val) {
        String cursor;
        this.progress = val;
        String userCursor = null;
        if (val == 0) {
            userCursor = this.MP.getUserCursor();
        }
        String defCursor = userCursor != null ? userCursor : "DEFAULT";
        String string = cursor = this.progress >= 0 ? "WAIT" : defCursor;
        if (this.MP != null) {
            this.MP.setCursor(cursor);
        }
    }

    @Override
    public boolean isViewSupported(int view) {
        return view == 11 || view == 14 || view == 12 || view == 13;
    }

    public double getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(double val) {
        this.connectTimeout = val;
    }

    public double getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(double val) {
        this.readTimeout = val;
    }

    @InternalUseOnly
    public void setImageAdjustOnPan(boolean adjust) {
        this.imageAdjustOnPan = adjust;
    }

    @InternalUseOnly
    public void setLegacyImageAdjust(boolean legacyCode) {
        this.legacyImageAdjust = legacyCode;
    }

    protected HttpURLConnection openConnection(String url) throws IOException, MapServerException {
        URLConnection conn = null;
        try {
            URL urlObj = new URI(url).toURL();
            conn = urlObj.openConnection();
            if ((this.debugOptions & 1) != 0) {
                this.midas.info("[DEBUG CONNECTION]       - - -  Connection info - - -");
                this.midas.info("[DEBUG CONNECTION] url:" + conn.getURL());
                this.midas.info("[DEBUG CONNECTION] url Host:" + urlObj.getHost());
                this.midas.info("[DEBUG CONNECTION] useCaches:" + conn.getUseCaches());
                this.midas.info("[DEBUG CONNECTION] header fields: " + conn.getHeaderFields());
                this.midas.info("[DEBUG CONNECTION]       - - - - - - - ");
            }
            if (this.connectTimeout > 0.0) {
                conn.setConnectTimeout((int)(this.connectTimeout * 1000.0));
            }
            if (this.readTimeout > 0.0) {
                conn.setReadTimeout((int)(this.readTimeout * 1000.0));
            }
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException("Forming URL via URI failed:" + e.getMessage() + " " + e.getStackTrace());
        }
        return (HttpURLConnection)conn;
    }

    protected BufferedImage requestImage(String url, int trys, boolean checkLength, int width, int height) {
        BufferedImage img = (BufferedImage)this.imgCache.get(url);
        if (img == null && url != null && url.length() > 0) {
            DownloadRequest req = new DownloadRequest(url, trys, checkLength, width, height);
            if (this.downloadThreads == null) {
                if (this.debug) {
                    this.info("Downloading URL=" + req);
                }
                if ((img = this.downloadImage(req)) != null) {
                    this.imgCache.put(url, img);
                }
            } else {
                this.addDownloadRequest(req);
                img = this.getBlankImage("Downloading...", req, Color.darkGray);
            }
        }
        return img == NULL_IMAGE ? null : img;
    }

    private BufferedImage downloadImage(DownloadRequest request) {
        boolean connectionDebug;
        boolean bl = connectionDebug = (this.debugOptions & 1) != 0;
        if (connectionDebug) {
            this.midas.info("[DEBUG CONNECTION] ________ LayerMap Downloading Image __________________");
        }
        BufferedImage img = null;
        InputStream is = null;
        BufferedInputStream bis = null;
        boolean done = false;
        boolean error = false;
        boolean keepTile = true;
        int code = 0;
        for (int i = 1; !(done || error || i > request.trys || this.MP.cancel); ++i) {
            HttpURLConnection conn = null;
            try {
                try {
                    double connect2;
                    double connect1 = connectionDebug ? Time.current() : 0.0;
                    conn = this.openConnection(request.url);
                    double d = connect2 = connectionDebug ? Time.current() : 0.0;
                    if (connectionDebug) {
                        this.midas.info("[DEBUG CONNECTION] connect time:" + (connect2 - connect1));
                    }
                }
                catch (MapServerException e) {
                    this.warn("downLoadImage exception trying to recover image ", e);
                    if (connectionDebug) {
                        this.midas.info("[DEBUG CONNECTION] MapServerException :" + e);
                    }
                    img = e.isInImage() && !this.MP.cancel ? ImageIO.read(new BufferedInputStream(conn.getInputStream())) : this.getBlankImage("Error Accessing Image", request, Color.red);
                    error = true;
                    throw e;
                }
                code = conn.getResponseCode();
                if (connectionDebug) {
                    this.midas.info("[DEBUG CONNECTION] Response message :" + conn.getResponseMessage());
                }
                if (code < 0) {
                    this.warn("LayerMap: Error accessing URL=" + request.url + " (try " + i + ") possible conflict in content length and status in HTML packet. HTTP response code=" + code);
                    done = false;
                } else if (code == 204) {
                    this.warn("received code HTTP_NO_CONTENT");
                    img = NULL_IMAGE;
                    done = true;
                } else if (request.checkLength && (long)conn.getContentLength() < 0L) {
                    this.info("content length is not known");
                    done = false;
                    if (i == request.trys) {
                        this.warn("LayerMap: Error accessing URL=" + request.url + " (try " + i + "): Invalid content length in HTTP header. HTTP response code=" + code);
                    }
                } else if (!this.MP.cancel) {
                    double read2;
                    double read1 = connectionDebug ? Time.current() : 0.0;
                    is = conn.getInputStream();
                    bis = new BufferedInputStream(is);
                    img = ImageIO.read(bis);
                    double d = read2 = connectionDebug ? Time.current() : 0.0;
                    if (connectionDebug) {
                        this.midas.info("[DEBUG CONNECTION] read time:" + (read2 - read1));
                    }
                    this.lastNumRetries = i;
                    done = i <= this.numRetriesIfBGColor ? this.isImageNotJustBackground(img, request) : true;
                    keepTile = done;
                }
            }
            catch (MapServerException e) {
                this.warn("Error accessing URL=" + request.url + " HTTP response code=" + code, e);
            }
            catch (Exception e) {
                this.warn("Error accessing URL=" + request.url + " (try " + i + ") HTTP response code=" + code, e);
            }
            if (done) continue;
            Time.sleep(this.pause);
        }
        if (!done && !error && keepTile && !this.MP.cancel) {
            this.warn("LayerMap: Unable to access URL=" + request.url + " after " + request.trys + " trys.");
            img = this.getBlankImage("Image Not Available", request, Color.red);
        }
        try {
            if (is != null) {
                is.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
        catch (IOException io) {
            this.warning("LayerMap exception closing input streams:" + io);
        }
        if (connectionDebug) {
            this.midas.info("[DEBUG CONNECTION] __________end_downloadImage_________________\n");
        }
        return img;
    }

    @InternalUseOnly
    public int getLastNumRetries() {
        return this.lastNumRetries;
    }

    private boolean isImageNotJustBackground(BufferedImage img, DownloadRequest request) {
        int h = img.getTileHeight();
        int w = img.getTileWidth();
        String requestStr = request.toString();
        int idxBGCOLOR = requestStr.indexOf("BGCOLOR=");
        if (idxBGCOLOR == -1) {
            return true;
        }
        int locBGCOLOR = idxBGCOLOR + 10;
        String bgColorStr = requestStr.substring(locBGCOLOR, locBGCOLOR + 6);
        int[] pixels = new int[h * w];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, w, h, pixels, 0, 256);
        try {
            pg.grabPixels();
            int bgColor = Integer.parseInt(bgColorStr, 16);
            double beforeTileCheck = Time.current();
            for (int pixel : pixels) {
                if ((pixel & 0xFFFFFF) == bgColor) continue;
                return true;
            }
            double afterTileCheck = Time.current();
            if ((this.debugOptions & 1) != 0) {
                this.midas.info("[DEBUG CONNECTION] tile !BGCOLOR check time:" + (afterTileCheck - beforeTileCheck));
            }
        }
        catch (Exception e) {
            this.warn("issue with checking if image is just background color:" + e);
        }
        return false;
    }

    private void emptyErrorStream(HttpURLConnection conn) {
        try {
            InputStream es = conn.getErrorStream();
            int ret = 0;
            byte[] buf = null;
            while ((ret = es.read(buf)) > 0) {
            }
        }
        catch (IOException ex) {
            this.warn("LayerMap: unable to close error stream on conn:" + conn);
        }
    }

    private BufferedImage getBlankImage(String text, DownloadRequest request, Color fgcolor) {
        Color bgcolor = TRANSPARENT;
        BufferedImage img = this.lastBlankImage;
        int w = request.width;
        int h = request.height;
        if (!(img != null && text.equals(this.lastBlankText) && img.getHeight() == h && img.getWidth() == w || w <= 4 || h <= 4)) {
            img = new BufferedImage(w, h, 2);
            Graphics g = img.getGraphics();
            g.setColor(bgcolor);
            g.fillRect(0, 0, w, h);
            g.setColor(fgcolor);
            g.drawRect(1, 1, w - 2, h - 2);
            if (w > 36 && h > 36) {
                g.setClip(2, 2, w - 4, h - 4);
                g.drawString(text, 4, 16);
            }
            g.dispose();
            this.lastBlankImage = img;
            this.lastBlankText = text;
        }
        return img;
    }

    protected void info(String msg) {
        this.midas.info(this.className + ": " + msg);
    }

    protected void warn(String msg) {
        this.midas.warning(this.className + ": " + msg);
    }

    protected void warn(String msg, Throwable t) {
        if (this.debug) {
            this.midas.printStackTrace(this.className + ": " + msg, t);
        } else {
            this.midas.warning(this.className + ": " + msg + ": " + t.getMessage());
        }
    }

    @Override
    public void close() {
        this.setDownloadThreads(0);
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDownloadThreads(int count) {
        DownloadThread[] toStop;
        Object object = this.getLockObj();
        synchronized (object) {
            toStop = this.downloadThreads;
            if (count == 0) {
                this.downloadThreads = null;
            } else {
                this.downloadThreads = new DownloadThread[count];
                for (int i = 0; i < this.downloadThreads.length; ++i) {
                    this.downloadThreads[i] = new DownloadThread(this, "" + this.instance + "." + i);
                    this.downloadThreads[i].start();
                }
            }
        }
        if (toStop != null) {
            for (int i = 0; i < toStop.length; ++i) {
                toStop[i].abort();
            }
        }
    }

    public int getDownloadThreads() {
        return this.downloadThreads == null ? 0 : this.downloadThreads.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DownloadRequest getDownloadRequest() {
        DownloadRequest request = null;
        Object object = this.getLockObj();
        synchronized (object) {
            if (!this.toDownload.empty()) {
                request = this.toDownload.pop();
            }
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDownloadRequest(DownloadRequest request) {
        boolean skip = this.toDownload.contains(request);
        for (int i = 0; !skip && i < this.downloadThreads.length; ++i) {
            skip = request.equals(this.downloadThreads[i].getRequest());
        }
        if (!skip) {
            if (this.debug) {
                this.info("Adding to download queue URL=" + request);
            }
            Object object = this.getLockObj();
            synchronized (object) {
                this.toDownload.push(request);
            }
        }
    }

    void imageDownloaded(DownloadRequest request, BufferedImage img) {
        if (img != null) {
            this.imgCache.put(request.url, img);
        }
        int prog = this.progress();
        this.setProgress(prog);
        if (prog == -1) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int progress() {
        int count;
        Object object = this.getLockObj();
        synchronized (object) {
            count = this.toDownload.size();
            if (this.downloadThreads != null) {
                for (int i = 0; i < this.downloadThreads.length; ++i) {
                    if (!this.downloadThreads[i].isDownloading()) continue;
                    ++count;
                }
            }
        }
        int status = count == 0 ? -1 : (int)(((float)this.getCurrentCacheSize() - (float)count) * 100.0f / (float)this.getCurrentCacheSize());
        return status;
    }

    @ProvisionalUseOnly(value="experimental in 4.0.0")
    public void setNumRetriesIfBGColor(int num) {
        this.numRetriesIfBGColor = num;
    }

    public void setDebug(String arg) {
        this.debugOptions = Parser.mask(debugList, arg, this.debugOptions);
    }

    private static class DownloadThread
    extends Thread {
        private final WeakReference<LayerMap> layer;
        private final double minWait;
        private final double maxWait;
        private boolean abort = false;
        private boolean downloading = false;
        private DownloadRequest request = null;

        DownloadThread(LayerMap layer, String threadID) {
            super(layer.getClass().getName() + ": DownloadThread " + threadID);
            this.layer = new WeakReference<LayerMap>(layer);
            this.minWait = 0.01;
            this.maxWait = 0.1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LayerMap lay;
            double wait = this.minWait;
            while (!this.abort && (lay = (LayerMap)this.layer.get()) != null) {
                Object object = lay.getLockObj();
                synchronized (object) {
                    this.request = lay.getDownloadRequest();
                    this.downloading = this.request != null;
                }
                if (this.request != null) {
                    BufferedImage img = lay.downloadImage(this.request);
                    Object object2 = lay.getLockObj();
                    synchronized (object2) {
                        this.downloading = false;
                        lay.imageDownloaded(this.request, img);
                        this.request = null;
                    }
                    wait = this.minWait;
                    continue;
                }
                Time.sleep(wait);
                wait = Math.min(wait * 2.0, this.maxWait);
            }
        }

        public void abort() {
            this.abort = true;
            try {
                this.join();
            }
            catch (InterruptedException e) {
                Shell.printStackTrace(e);
            }
        }

        private DownloadRequest getRequest() {
            return this.request;
        }

        private boolean isDownloading() {
            return this.downloading;
        }
    }

    private static class DownloadRequest {
        private final String url;
        private final int trys;
        private final boolean checkLength;
        private final int width;
        private final int height;

        DownloadRequest(String url, int trys, boolean checkLength, int width, int height) {
            this.url = url;
            this.trys = trys;
            this.checkLength = checkLength;
            this.width = width;
            this.height = height;
        }

        public String toString() {
            return this.url;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof DownloadRequest)) {
                return false;
            }
            DownloadRequest req = (DownloadRequest)obj;
            return this.url.equals(req.url) && this.width == req.width && this.height == req.height && this.trys == req.trys && this.checkLength == req.checkLength;
        }

        public int hashCode() {
            return this.url.hashCode() ^ this.width ^ this.height ^ this.trys ^ (this.checkLength ? 1 : 0);
        }
    }

    protected static class MapServerException
    extends MidasException {
        private final boolean inImage;

        protected MapServerException(String msg) {
            this(msg, false);
        }

        protected MapServerException(String msg, Throwable t) {
            this(msg, t, false);
        }

        protected MapServerException(String msg, boolean inImage) {
            super(msg);
            this.inImage = inImage;
        }

        protected MapServerException(String msg, Throwable t, boolean inImage) {
            super(msg, t);
            this.inImage = inImage;
        }

        public boolean isInImage() {
            return this.inImage;
        }

        @Override
        public String toString() {
            return super.toString() + " inImage=" + this.inImage;
        }
    }
}

