/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.xml.parsers.SAXParserFactory;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.inc.PlotFile;
import nxm.sys.lib.Args;
import nxm.sys.lib.Cache;
import nxm.sys.lib.FileName;
import nxm.sys.lib.FileUtil;
import nxm.sys.lib.GeodeticUtil;
import nxm.sys.lib.KmlFile;
import nxm.sys.lib.LogUtilities;
import nxm.sys.lib.Message;
import nxm.sys.lib.Position;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StringUtil;
import nxm.sys.lib.Table;
import nxm.sys.lib.Time;
import nxm.sys.libg.GraphicsUtil;
import nxm.sys.libg.Layer;
import nxm.sys.libg.Line;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MJPopup;
import nxm.sys.libg.MPoint;
import nxm.sys.libg.Symbol;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LayerKML
extends Layer {
    public static final int COLORS_MONOCHROME = 1;
    public static final int COLORS_MOD_5 = 2;
    public static final int COLORS_MOD_N = 3;
    public static final int COLORS_MIN_ADJ = 4;
    public static final int COLORS_ON_SELECT = 5;
    public static final int COLORS_DEFAULT = 4;
    public static final String coloringModes = "Mono,Mod5,ModN,MinAdj,OnSelect";
    public static final int OPAQ = 255;
    public static final Color DEFAULT_BORDER_COLOR = Color.lightGray;
    public static final Color DEFAULT_POINT_COLOR = Color.WHITE;
    private Color colorBorder = DEFAULT_BORDER_COLOR;
    public static final String supportedElements = "kml,coordinates,point,polygon,placemark,linearring,linestring,name,description,document,style,key,linestyle,stylemap,pair,polystyle,color,width,bgcolor,extrude,url,altitudemode,heading,iconstyle,icon,scale,outerboundaryis,fill,outline,multigeometry,visibility,networklinkcontrol,folder,styleurl,networklink,link,refreshinterval,groundoverlay,overlay,lookat,minrefreshperiod,refreshmode,longitude,latitude,rotation,range,heading,tilt,range,altitude,href,north,south,east,west,labelstyle,balloonstyle,text,bgcolor,textcolor,displaymode,viewformat,schema";
    private static final Set<String> supportedElems = new HashSet<String>(Arrays.asList("kml,coordinates,point,polygon,placemark,linearring,linestring,name,description,document,style,key,linestyle,stylemap,pair,polystyle,color,width,bgcolor,extrude,url,altitudemode,heading,iconstyle,icon,scale,outerboundaryis,fill,outline,multigeometry,visibility,networklinkcontrol,folder,styleurl,networklink,link,refreshinterval,groundoverlay,overlay,lookat,minrefreshperiod,refreshmode,longitude,latitude,rotation,range,heading,tilt,range,altitude,href,north,south,east,west,labelstyle,balloonstyle,text,bgcolor,textcolor,displaymode,viewformat,schema".split("\\s*,\\s*")));
    private static final Pattern EOL = Pattern.compile("\\s+");
    private final int SYMBOL = 1;
    private final int IMAGE = 2;
    private final int MAX_ICON_SIZE = 32;
    private final int DEFAULT_LINE_WIDTH = 2;
    private final int DEFAULT_TEXT_SIZE = 12;
    private final int DEFAULT_POINT_SIZE = 8;
    private final float DEFAULT_ICON_SCALE = 1.0f;
    private final int DEFAULT_ICON_HEADING = 0;
    private final String DEFAULT_POINT_SYMBOL = "Cross";
    private final int DEFAULT_NON_ZOOM_ICON_SIZE = 20;
    private final int DEFAULT_ICON_ZOOM_SIZE = 64;
    private final float DEFAULT_COLOR_BLEND_RATIO = 0.8f;
    private final String[] LABEL_POSITIONS = new String[]{"TOPR", "TOP", "BOTTOMR", "BOTTOM", "RIGHT"};
    private final String DEFAULT_LABEL_POS = "TOPR";
    private int iconSize = 20;
    private int iconZoomSize = 64;
    private float colorBlendRatio = 0.8f;
    private String labelPos = "TOPR";
    private int coloringMode = 4;
    private int contrast = 50;
    private int brightness = 50;
    private int alpha = -1;
    private KmlParser kmlParser;
    protected kmlObjects objects;
    private HashMap<String, kmlStyle> styles;
    private HashMap<String, kmlStyleMap> styleMaps;
    private ArrayList<kmlPoint> points;
    private ArrayList<kmlPolygon> polygons;
    private ArrayList<KmlImage> images;
    private ArrayList<kmlLineString> lineStrings;
    private double[] buf;
    private int off = 0;
    private int dim = 3;
    private int npts;
    private boolean polygonFill = true;
    private boolean polygonOutline = true;
    private Color polygonColor = DEFAULT_POINT_COLOR;
    private Color lineColor = DEFAULT_POINT_COLOR;
    private int lineWidth = 2;
    private int textSize = 12;
    private float labelScale = 1.0f;
    private Color labelColor = DEFAULT_POINT_COLOR;
    private int pointType = 1;
    private String pointSymbol = "Cross";
    private BufferedImage pointImage;
    private int pointSize = 8;
    private float iconHeading = 0.0f;
    private float iconScale = 1.0f;
    private Color iconColor = DEFAULT_POINT_COLOR;
    private boolean symbolFill = true;
    private boolean showLabel = true;
    private double[] pollRate;
    private double[] lastPoll;
    private double[] lastMods;
    private double minRefreshPeriod = 0.0;
    private String currPath;
    private kmlBalloonStyle balloonStyle;
    private boolean allowPopups = true;
    private boolean keepPopupSmall = false;
    private boolean activePopup;
    private kmlObject selectedObject;
    private PopupSelection popupSelection;
    private Popup kmlPopup;
    private FileName fn;
    private KmlFile[] linkedFile = null;
    private boolean[] isFirstPass;
    private boolean forceRefresh = false;
    protected static final WeakHashMap<String, Cache.TimeStampedValue> SHARED_VCACHE = new WeakHashMap();
    protected final Cache imgCache = this.getDefImgCache();
    private int imgCacheSize = -1;

    public LayerKML() {
        this.line.setRadius(3);
        this.line.setSymbol(this.getPointSymbol());
        this.line.getSymbol().setSize(this.getPointSize());
        this.line.setType(1);
        this.line.setColor(this.coloringMode);
        this.kmlParser = new KmlParser();
        this.objects = new kmlObjects();
        this.styles = new HashMap();
        this.styleMaps = new HashMap();
        this.setCacheSize(-1);
        this.points = new ArrayList();
        this.isFirstPass = new boolean[1];
        this.isFirstPass[0] = true;
        this.x1 = 180.0;
        this.x2 = -180.0;
        this.y1 = 90.0;
        this.y2 = -90.0;
        this.z1 = 0.0;
        this.z2 = 10000.0;
    }

    public LayerKML(int cmap) {
        this();
        this.setColorMap(cmap);
        this.name = "KML";
    }

    @Override
    public boolean setFile(PlotFile pf, Table tab, Args MA) {
        boolean status = true;
        this.fn = FileName.toFileName(pf.getName());
        this.currPath = this.fn.getPath();
        if (this.currPath == null || this.currPath.isEmpty()) {
            try {
                String urlpath = this.fn.toURL().toString();
                this.currPath = urlpath = urlpath.substring(0, urlpath.indexOf(this.fn.getBasename()));
            }
            catch (MalformedURLException urlpath) {
                // empty catch block
            }
        }
        if (status = this.checkFileType(pf)) {
            super.setFile(pf);
            if (tab != null) {
                String pos;
                float ratio;
                int iconZoomSize;
                int iconSize = tab.getL("ICONSIZE", 0);
                if (iconSize > 0) {
                    this.setIconSize(iconSize);
                }
                if ((iconZoomSize = tab.getL("ICONZOOMSIZE", 0)) > 0) {
                    this.setIconZoomSize(iconZoomSize);
                }
                if ((ratio = tab.getF("COLORBLENDRATIO", -1.0f)) >= 0.0f) {
                    this.setColorBlendRatio(ratio);
                }
                if ((pos = tab.getS("LABELPOS", null)) != null) {
                    this.setLabelPos(pos);
                }
                boolean forceRefresh = tab.getState("FORCEREFRESH", this.forceRefresh);
                this.setForceRefresh(forceRefresh);
                boolean allowPopups = tab.getState("ALLOWPOPUPS", this.allowPopups);
                this.setAllowPopups(allowPopups);
            }
            pf.open(1);
            InputStream is = ((KmlFile)pf).getResource().getInputStream();
            this.parseFile(is);
        } else {
            this.warning("File " + pf.getName() + " is not recognized as a KML file");
        }
        return status;
    }

    private boolean checkFileType(PlotFile pf) {
        return pf instanceof KmlFile;
    }

    private void parseFile(InputStream fname) {
        try {
            this.getKmlParser().parseKmlFile(fname);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processMouseMessage(Message msg, int type) {
        Position pos = (Position)msg.getData();
        if (msg.name.equals("HOVER") && !this.testForPopup(pos)) {
            super.processMouseMessage(msg, type);
        }
    }

    public void setAllowPopups(boolean val) {
        this.allowPopups = val;
    }

    public boolean isAllowPopups() {
        return this.allowPopups;
    }

    private boolean testForPopup(Position pos) {
        if (!this.allowPopups || this.points.size() == 0 && this.getImages().size() == 0 && this.getPolygons().size() == 0 && this.getLineStrings().size() == 0) {
            return false;
        }
        double lonRange = Math.abs(this.MP.rx2 - this.MP.rx1);
        double step = lonRange / 200.0;
        double range = step * 20.0;
        for (double ii = 0.0; ii <= range; ii += step) {
            for (kmlPoint p : this.points) {
                String mode;
                double ydist;
                double xdist = Math.abs(pos.x - p.getCoords().lon);
                if (!(xdist <= ii) || !((ydist = Math.abs(pos.y - p.getCoords().lat)) <= ii)) continue;
                kmlBalloonStyle style = p.getBalloonStyle();
                if (style != null && (mode = style.getDisplayMode()) != null && mode.equalsIgnoreCase("hide")) {
                    return false;
                }
                MPoint p1 = this.MP.getPoint(pos);
                Point p2 = this.MP.panel.getLocationOnScreen();
                this.setSelectedObject(p);
                this.popupSelection = new PopupSelection(p, p1.x + p2.x, p1.y + p2.y, null);
                this.drawPopup();
                return true;
            }
            for (KmlImage ti : this.getImages()) {
                double[] polygon = new double[]{ti.west, ti.north, ti.east, ti.north, ti.east, ti.south, ti.west, ti.south, ti.west, ti.north};
                if (!GeodeticUtil.insidePolygon(pos, 2, polygon)) continue;
                MPoint p1 = this.MP.getPoint(pos);
                Point p2 = this.MP.panel.getLocationOnScreen();
                kmlPoint p = new kmlPoint(ti);
                p.setLine(this.line.copy());
                p.setBalloonStyle(this.balloonStyle);
                p.setCoordinates(ti.west + "," + ti.north);
                p.setImage(ti.img);
                this.setSelectedObject(ti);
                this.popupSelection = new PopupSelection(p, p1.x + p2.x, p1.y + p2.y, ti.href);
                this.drawPopup();
                return true;
            }
            for (kmlPolygon polygon : this.getPolygons()) {
                if (!GeodeticUtil.insidePolygon(pos, this.dim, polygon.outerBoundary.getCoordsAsDouble())) continue;
                MPoint p1 = this.MP.getPoint(pos);
                Point p2 = this.MP.panel.getLocationOnScreen();
                kmlPoint p = new kmlPoint(polygon);
                p.setLine(this.line.copy());
                p.setBalloonStyle(this.balloonStyle);
                p.setCoordinates(pos.lon + "," + pos.lat);
                this.setSelectedObject(polygon);
                this.popupSelection = new PopupSelection(p, p1.x + p2.x, p1.y + p2.y, polygon.getParentFeature().name);
                this.drawPopup();
                return true;
            }
            for (kmlLineString lineString : this.getLineStrings()) {
                if (!GeodeticUtil.insidePolygon(pos, this.dim, lineString.getCoordsAsDouble())) continue;
                MPoint p1 = this.MP.getPoint(pos);
                Point p2 = this.MP.panel.getLocationOnScreen();
                kmlPoint p = new kmlPoint(lineString);
                p.setLine(this.line.copy());
                p.setBalloonStyle(this.balloonStyle);
                p.setCoordinates(pos.lon + "," + pos.lat);
                this.setSelectedObject(lineString);
                this.popupSelection = new PopupSelection(p, p1.x + p2.x, p1.y + p2.y, lineString.getParentFeature().name);
                this.drawPopup();
                return true;
            }
        }
        return false;
    }

    private boolean linkedFileModified(KmlFile linkedFile, int index) {
        double fileChangeDif;
        long lastMod = -1L;
        URL url = null;
        try {
            url = new URI(linkedFile.getURL()).toURL();
            if (this.isFirstPass[index]) {
                this.lastMods[index] = FileUtil.lastModified(url);
                return true;
            }
        }
        catch (MalformedURLException | URISyntaxException e1) {
            LogUtilities.log(Level.WARNING, "Error checking if LayerKML file has been changed.", e1);
        }
        if (url != null) {
            lastMod = FileUtil.lastModified(url);
        }
        if ((fileChangeDif = (double)lastMod - this.lastMods[index]) > 0.0) {
            this.lastMods[index] = lastMod;
            return true;
        }
        return false;
    }

    private void pollData(KmlFile linkedFile, double pollRate, int index) {
        if (linkedFile != null && (this.linkedFileModified(linkedFile, index) || this.forceRefresh)) {
            if (index > 0) {
                boolean newLayer = true;
                PlotFile file = null;
                for (int idx = 0; idx < this.MP.layers.size(); ++idx) {
                    Layer lay = (Layer)this.MP.layers.get(idx);
                    if (lay != null) {
                        file = lay.getFile();
                    }
                    if (file == null || !linkedFile.equals(file)) continue;
                    newLayer = false;
                }
                if (newLayer) {
                    linkedFile.setQualifier("FG", "KML");
                    Table tbl = new Table();
                    tbl.addIfNotPresent("ALLOWPOPUPS", this.allowPopups);
                    linkedFile.setQualifier("LAYER", tbl);
                    this.MP.mh.processMessage(new Message("OPENFILE", 0, linkedFile.getName().toString() + linkedFile.getQualifiers()));
                }
            } else {
                this.setFile(linkedFile, null, null);
            }
            this.isFirstPass[index] = false;
            this.needRefresh = true;
        }
    }

    @Override
    public int getData(int flag) {
        if (this.linkedFile != null) {
            for (int idx = 0; idx < this.linkedFile.length; ++idx) {
                if (!(Time.current() >= this.pollRate[idx] + this.lastPoll[idx])) continue;
                this.pollData(this.linkedFile[idx], this.pollRate[idx], idx);
                this.lastPoll[idx] = Time.current();
            }
        }
        return 0;
    }

    @Override
    public void draw(int mode) {
        super.draw(mode);
        this.points = new ArrayList();
        this.polygons = new ArrayList();
        this.images = new ArrayList();
        this.lineStrings = new ArrayList();
        this.handleKmlObjects(this.objects);
    }

    private Line getPolyLine() {
        Line myLine = this.line.copy();
        Color oldColor = myLine.getColor();
        Color newColor = this.getLineColor();
        if (newColor != null && !oldColor.equals(newColor)) {
            myLine.setColor(newColor);
        }
        oldColor = myLine.getFillColor();
        newColor = this.getPolygonColor();
        if (newColor != null && this.isPolygonFill()) {
            if (!oldColor.equals(newColor)) {
                myLine.setFillColor(newColor);
            }
            myLine.setType(myLine.getType() + "Fill");
        }
        if (myLine.getThickness() != this.getLineWidth()) {
            myLine.setThickness(this.getLineWidth());
        }
        return myLine;
    }

    private int drawPoint(kmlPoint point) {
        int status = 0;
        this.npts = 1;
        this.buf = new double[3];
        this.buf[0] = point.getCoords().getLon();
        this.buf[1] = point.getCoords().getLat();
        this.buf[2] = point.getCoords().getAltitude();
        Line myLine = this.line.copy();
        myLine.setType("Symbol");
        BufferedImage drawableImage = null;
        if (this.pointType == 2 && this.pointImage == null) {
            this.setPointType(1);
            this.setPointSymbol("Cross");
        }
        if (this.pointType == 2) {
            drawableImage = this.getDrawableImage();
            if (this.iconColor != null) {
                this.applyPointImageColor(drawableImage);
            }
            if (this.iconScale != 1.0f) {
                drawableImage = this.scalePointImage(drawableImage, this.iconScale);
            }
            if (Math.abs(this.MP.rx2 - this.MP.rx1) > 15.0) {
                drawableImage = this.adjustPointImageSize(drawableImage, this.iconSize);
            }
            myLine.setSymbol(drawableImage);
            this.setPointSize(drawableImage.getHeight(null));
        } else {
            myLine.setSymbol(this.getPointSymbol());
            myLine.setSymbolFill(this.isSymbolFill());
            myLine.setColor(this.getIconColor());
            myLine.setThickness(this.getLineWidth());
            int symbolSize = (int)((float)this.getPointSize() * this.getIconScale());
            if (symbolSize > 32) {
                symbolSize = 32;
            }
            myLine.getSymbol().setSize(symbolSize);
        }
        myLine.setSymbolHeading(this.getIconHeading());
        this.MP.drawLineLonLat(this.buf, this.off, this.dim, this.npts, myLine);
        String label = point.getParentFeature().getName();
        if (this.isShowLabel() && label != null && this.MP.getZoomLevel() > 0) {
            MPoint pix = new MPoint();
            this.MP.getPoint(this.buf[0], this.buf[1], this.buf[2], pix);
            Graphics2D g2d = (Graphics2D)this.MP.gc;
            g2d.setColor(this.getLabelColor());
            int fontStyle = this.MP.font == null ? 0 : this.MP.font.getStyle();
            Font f = new Font(label, fontStyle, (int)((float)this.textSize * this.labelScale));
            g2d.setFont(f);
            pix = this.adjustLabelPosition(g2d, f, label, this.labelPos, pix, myLine.getSymbolSize());
            g2d.drawString(label, pix.x, pix.y);
        }
        if (!this.points.contains(point)) {
            point.setBalloonStyle(this.balloonStyle);
            point.setLine(myLine);
            point.setImage(this.pointType == 2 ? this.pointImage : null);
            this.points.add(point);
        }
        return status;
    }

    private void drawPolygon(double[] coords) {
        this.buf = coords;
        this.npts = coords.length / 3;
        this.off = 0;
        this.dim = 3;
        Line myLine = this.getPolyLine();
        this.MP.drawLineLonLat(this.buf, this.off, this.dim, this.npts, myLine);
    }

    private void drawPolygon(kmlPolygon polygon) {
        int rings = polygon.innerBoundary.size();
        if (!this.isPolygonFill()) {
            this.drawPolygonOutlines(polygon, rings);
        } else {
            this.buf = rings > 1 ? this.combinePolygons(polygon, rings) : (rings > 0 ? this.combineSinglePolygons(polygon) : polygon.getOuterBoundary().getCoordsAsDouble());
            if (this.buf != null) {
                if (polygon.isExtrude()) {
                    this.drawExtrudedPolygon(this.buf);
                } else {
                    this.drawPolygon(this.buf);
                }
            } else {
                this.warning("Polygon has no coordinates, so will not be drawn");
            }
        }
        if (!this.getPolygons().contains(polygon)) {
            this.getPolygons().add(polygon);
        }
    }

    private void drawPolygonOutlines(kmlPolygon polygon, int innerRings) {
        this.buf = polygon.getOuterBoundary().getCoordsAsDouble();
        if (polygon.isExtrude()) {
            this.drawExtrudedPolygon(this.buf);
        } else {
            this.drawPolygon(this.buf);
        }
        if (innerRings > 0) {
            for (int xx = 0; xx < innerRings; ++xx) {
                this.buf = polygon.innerBoundary.get(xx).getCoordsAsDouble();
                if (polygon.isExtrude()) {
                    this.drawExtrudedPolygon(this.buf);
                    continue;
                }
                this.drawPolygon(this.buf);
            }
        }
    }

    private double[] combinePolygons(kmlPolygon polygon, int innerRings) {
        double[] outerCoords = polygon.getOuterBoundary().getCoordsAsDouble();
        int outerLength = outerCoords.length;
        if (innerRings == 0) {
            return outerCoords;
        }
        int totalLength = 0;
        int tmpPos = 0;
        int innerLength = 0;
        int endPathCounter = 0;
        for (int xx = 0; xx < innerRings; ++xx) {
            innerLength += polygon.innerBoundary.get(xx).getCoordsAsDouble().length;
        }
        totalLength = outerLength + innerLength + 3 * (innerRings - 1);
        double[] coords = new double[totalLength];
        double[] endPath = new double[(innerRings - 1) * 3];
        int xx = 0;
        while (xx < outerLength) {
            coords[tmpPos] = outerCoords[xx];
            ++xx;
            ++tmpPos;
        }
        for (xx = 0; xx < innerRings; ++xx) {
            double[] tmpCoords = polygon.innerBoundary.get(xx).getCoordsAsDouble();
            int yy = 0;
            while (yy < tmpCoords.length) {
                coords[tmpPos] = tmpCoords[yy];
                ++yy;
                ++tmpPos;
            }
            if (xx >= innerRings - 1) continue;
            endPathCounter = endPath.length - 3 * xx - 3;
            endPath[endPathCounter] = coords[tmpPos - 3];
            endPath[endPathCounter + 1] = coords[tmpPos - 2];
            endPath[endPathCounter + 2] = coords[tmpPos - 1];
        }
        xx = 0;
        while (xx < endPath.length) {
            coords[tmpPos] = endPath[xx];
            ++xx;
            ++tmpPos;
        }
        return coords;
    }

    private double[] combineSinglePolygons(kmlPolygon polygon) {
        double[] coords;
        int innerRings = polygon.innerBoundary.size();
        if (innerRings > 1) {
            coords = this.combinePolygons(polygon, innerRings);
        } else {
            double[] outerCoords = polygon.getOuterBoundary().getCoordsAsDouble();
            double[] innerCoords = polygon.innerBoundary.get(0).getCoordsAsDouble();
            int length = outerCoords.length + innerCoords.length;
            coords = new double[length];
            int counter = 0;
            int xx = 0;
            while (xx < outerCoords.length) {
                coords[counter] = outerCoords[xx];
                ++xx;
                ++counter;
            }
            xx = 0;
            while (xx < innerCoords.length) {
                coords[counter] = innerCoords[xx];
                ++xx;
                ++counter;
            }
        }
        return coords;
    }

    private double[] combinePolygonsFast(kmlPolygon polygon, int innerRings) {
        if (innerRings == 0) {
            return polygon.getOuterBoundary().getCoordsAsDouble();
        }
        double[] outerCoords = polygon.getOuterBoundary().getCoordsAsDouble();
        int innerLength = 0;
        int innerCounter = 0;
        for (int xx = 0; xx < innerRings; ++xx) {
            innerLength += polygon.innerBoundary.get(xx).getCoordsAsDouble().length;
        }
        double[] innerCoords = new double[innerLength];
        for (int xx = 0; xx < innerRings; ++xx) {
            double[] tmpCoords = polygon.innerBoundary.get(xx).getCoordsAsDouble();
            int yy = 0;
            while (yy < tmpCoords.length) {
                innerCoords[innerCounter] = tmpCoords[yy];
                ++yy;
                ++innerCounter;
            }
        }
        int length = outerCoords.length + innerLength;
        double[] coords = new double[length];
        int counter = 0;
        int xx = 0;
        while (xx < outerCoords.length) {
            coords[counter] = outerCoords[xx];
            ++xx;
            ++counter;
        }
        xx = 0;
        while (xx < innerCoords.length) {
            coords[counter] = innerCoords[xx];
            ++xx;
            ++counter;
        }
        return coords;
    }

    private int drawLineString(kmlLineString lineString) {
        Color newColor;
        int status = 1;
        this.buf = lineString.getCoordsAsDouble();
        if (!this.getLineStrings().contains(lineString)) {
            this.getLineStrings().add(lineString);
        }
        this.npts = this.buf.length / 3;
        this.dim = 3;
        this.off = 0;
        Line myLine = this.line.copy();
        Color currColor = myLine.getColor();
        if (!currColor.equals(newColor = this.getLineColor())) {
            myLine.setColor(newColor);
        }
        if (myLine.getThickness() != this.getLineWidth()) {
            myLine.setThickness(this.getLineWidth());
        }
        this.MP.drawLineLonLat(this.buf, this.off, this.dim, this.npts, myLine);
        return status;
    }

    private int drawLinearRing(kmlLinearRing linearRing) {
        int status = 1;
        return status;
    }

    public void setPollRate(double rate) {
        this.setPollRate(0, rate);
    }

    public void setPollRate(int index, double rate) {
        if (rate >= this.minRefreshPeriod) {
            this.pollRate[index] = rate;
        }
    }

    public double getPollRate() {
        return this.getPollRate(0);
    }

    public double[] getPollRates() {
        return this.pollRate;
    }

    public double getPollRate(int index) {
        return this.pollRate[index];
    }

    public void setPolygonOutline(boolean outline) {
        this.polygonOutline = outline;
    }

    public boolean getPolygonOutline() {
        return this.polygonOutline;
    }

    public boolean isPolygonOutline() {
        return this.getPolygonOutline();
    }

    public void setPolygonFill(boolean doFill) {
        this.polygonFill = doFill;
    }

    public boolean getPolygonFill() {
        return this.polygonFill;
    }

    public boolean isPolygonFill() {
        return this.getPolygonFill();
    }

    public void setPolygonColor(Color color) {
        this.polygonColor = color;
    }

    public Color getPolygonColor() {
        return this.polygonColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLabelScale(float scale) {
        this.labelScale = scale;
    }

    public float getLabelScale() {
        return this.labelScale;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setTextSize(int size) {
        this.textSize = size;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(boolean show) {
        this.showLabel = show;
    }

    public void setPointType(int type) {
        this.pointType = type;
    }

    public int getPointType() {
        return this.pointType;
    }

    private int getPointType(String styleId) {
        String href;
        if (this.styles.containsKey(styleId) && ((href = ((kmlStyle)this.styles.get((Object)styleId)).iconStyle.icon.getHref().toLowerCase()).startsWith("http") || href.startsWith("file") || this.isImage(href))) {
            return 2;
        }
        return 1;
    }

    private boolean isImage(String filename) {
        return (filename = filename.toLowerCase()).endsWith("gif") || filename.endsWith("tif") || filename.endsWith("tiff") || filename.endsWith("jpg") || filename.endsWith("jpeg") || filename.endsWith("bmp") || filename.endsWith("wbmp") || filename.endsWith("pdf");
    }

    public String getPointSymbol() {
        return this.pointSymbol;
    }

    public void setPointSymbol(String symbol) {
        if ("Aero,Arrow,Circle,Cross,Diamond,Dot,Plus,Square,Star,Triangle,UTri,DTri,RTri,LTri,A,B,C,D,Ascii-XYZ,None".indexOf(symbol) >= 0) {
            this.pointSymbol = symbol;
            this.setPointType(1);
        } else {
            this.warning("Invalid symbol: " + symbol + ". Symbol must be in " + "Aero,Arrow,Circle,Cross,Diamond,Dot,Plus,Square,Star,Triangle,UTri,DTri,RTri,LTri,A,B,C,D,Ascii-XYZ,None");
        }
    }

    public Image getPointImage() {
        return this.pointImage;
    }

    public void setPointImage(URL url) {
        this.pointImage = this.addToImgCache(url.toString());
        this.setPointType(2);
    }

    public void setPointImage(String urlString) {
        this.pointImage = this.addToImgCache(urlString);
        this.setPointType(2);
    }

    private BufferedImage addToImgCache(String urlString) {
        BufferedImage img = null;
        Object obj = this.imgCache.get(urlString);
        if (obj == null) {
            img = null;
        } else if (obj instanceof BufferedImage) {
            img = (BufferedImage)obj;
        } else {
            return null;
        }
        if (img == null) {
            URL url = this.getURL(urlString);
            try {
                img = ImageIO.read(url);
                if (img != null) {
                    this.imgCache.put(urlString, img);
                }
            }
            catch (IIOException ioe) {
                this.warning("Unable to retrieve image from url: [" + urlString + "]");
                this.imgCache.put(urlString, "badurl");
            }
            catch (Exception e) {
                Shell.printStackTrace(e);
            }
        }
        return img;
    }

    public void setIconSize(int size) {
        this.iconSize = size;
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconZoomSize(int size) {
        this.iconZoomSize = size;
    }

    public int getIconZoomSize() {
        return this.iconZoomSize;
    }

    public void setForceRefresh(boolean val) {
        this.forceRefresh = val;
    }

    public boolean getForceRefresh() {
        return this.forceRefresh;
    }

    private BufferedImage adjustPointImageSize(BufferedImage img, int maxSize) {
        if (img != null) {
            boolean adjustW;
            float h = img.getHeight();
            float w = img.getWidth();
            boolean adjustH = h > (float)maxSize;
            boolean bl = adjustW = w > (float)maxSize;
            if (adjustH && !adjustW) {
                img = this.scalePointImage(img, (float)maxSize / h);
            } else if (adjustW) {
                img = this.scalePointImage(img, (float)maxSize / w);
            }
        }
        return img;
    }

    private void applyPointImageColor(BufferedImage img) {
        this.applyPointImageColor(img, this.iconColor);
    }

    private void applyPointImageColor(BufferedImage img, Color color) {
        if (color != null && img != null) {
            MColor.colorImage(img, color, this.colorBlendRatio);
        }
    }

    public MPoint adjustLabelPosition(Graphics g2d, Font f, String label, String pos, MPoint pix, int iconSize) {
        int posx = pix.x;
        int posy = pix.y;
        FontMetrics metrics = g2d.getFontMetrics(f);
        int textWidth = metrics.stringWidth(label);
        int textHeight = metrics.getHeight();
        if (pos.equals("TOP")) {
            posx = pix.x - textWidth / 2;
            posy = pix.y - iconSize / 2 - 1;
        } else if (pos.equals("TOPR")) {
            posx = pix.x + iconSize / 2;
            posy = pix.y - iconSize / 2 - 1;
        } else if (pos.equals("BOTTOM")) {
            posx = pix.x - textWidth / 2;
            posy = pix.y + iconSize / 2 + textHeight;
        } else if (pos.equals("BOTTOMR")) {
            posx = pix.x + iconSize / 2;
            posy = pix.y + iconSize / 2 + textHeight;
        } else if (pos.equals("RIGHT")) {
            posx = pix.x + iconSize / 2;
            posy = pix.y + textHeight / 2;
        }
        MPoint newPoint = new MPoint(posx, posy);
        return newPoint;
    }

    public String getLabelPos() {
        return this.labelPos;
    }

    public void setLabelPos(String pos) {
        if (pos == null) {
            return;
        }
        pos = pos.toUpperCase();
        for (int index = 0; index < this.LABEL_POSITIONS.length; ++index) {
            if (!this.LABEL_POSITIONS[index].equals(pos)) continue;
            this.labelPos = pos;
            return;
        }
        String labelString = "'";
        for (int index = 0; index < this.LABEL_POSITIONS.length; ++index) {
            labelString = labelString + this.LABEL_POSITIONS[index] + "', '";
        }
        this.warning("Invalid Label Position: " + pos + ". Position must be in " + labelString.substring(0, labelString.length() - 3) + ".");
    }

    private BufferedImage getDrawableImage() {
        if (this.pointImage == null) {
            return null;
        }
        int w = this.pointImage.getWidth();
        int h = this.pointImage.getHeight();
        BufferedImage newImg = new BufferedImage(w, h, 2);
        Graphics2D g = newImg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(this.pointImage, 0, 0, w, h, 0, 0, w, h, null);
        g.dispose();
        return newImg;
    }

    private BufferedImage scalePointImage(BufferedImage img, float scale) {
        if (scale != 1.0f && img != null) {
            int oldW = img.getWidth();
            int oldH = img.getHeight();
            int newH = (int)((float)oldH * scale);
            int newW = (int)((float)oldW * scale);
            BufferedImage scaled = new BufferedImage(newW, newH, 2);
            Graphics2D g = scaled.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(img, 0, 0, newW, newH, 0, 0, oldW, oldH, null);
            g.dispose();
            return scaled;
        }
        this.warning("Unable to scale image due to NULL image or scale factor of 100%");
        return img;
    }

    public void scalePointImage() {
        if (this.iconScale != 1.0f && this.pointImage != null) {
            this.pointImage = this.scalePointImage(this.pointImage, this.iconScale);
        }
    }

    public int getPointSize() {
        return this.pointSize;
    }

    public void setColorBlendRatio(float ratio) {
        if (ratio <= 1.0f && ratio >= 0.0f) {
            this.colorBlendRatio = ratio;
        } else {
            this.warning("Invalid Image Color ratio of " + ratio + ". Ratio must be between 0.0 and 1.0");
        }
    }

    public float getColorBlendRatio() {
        return this.colorBlendRatio;
    }

    public void setPointSize(int pointSize) {
        this.pointSize = pointSize;
    }

    public float getIconHeading() {
        return this.iconHeading;
    }

    public void setIconHeading(float heading) {
        this.iconHeading = heading;
    }

    public float getIconScale() {
        return this.iconScale;
    }

    public void setIconScale(float scale) {
        this.iconScale = scale;
    }

    public void setIconColor(Color color) {
        this.iconColor = color;
    }

    public Color getIconColor() {
        return this.iconColor;
    }

    private Cache getDefImgCache() {
        return new Cache(2, 4, 3600.0, SHARED_VCACHE);
    }

    public void setCacheSize(int size) {
        this.setCacheSize(size, 0, 4);
    }

    protected final void setCacheSize(int size, int min, int def) {
        if (size == -1) {
            this.imgCache.setMaxSize(Math.max(def, min));
            this.imgCacheSize = -1;
        } else {
            if (size < min) {
                size = min;
            }
            this.imgCache.setMaxSize(size);
            this.imgCacheSize = this.imgCache.getMaxSize();
        }
    }

    public final int getCacheSize() {
        return this.imgCacheSize;
    }

    public final int getCurrentCacheSize() {
        return this.imgCache.getMaxSize();
    }

    public boolean isSymbolFill() {
        return this.symbolFill;
    }

    public boolean getSymbolFill() {
        return this.isSymbolFill();
    }

    public void setSymbolFill(boolean fill) {
        this.symbolFill = fill;
    }

    public KmlParser getKmlParser() {
        return this.kmlParser;
    }

    public void setKmlParser(KmlParser parser) {
        this.kmlParser = parser;
    }

    public kmlObjects getKmlObjects() {
        return this.objects;
    }

    public void setKmlObjects(kmlObjects objs) {
        this.objects = objs;
    }

    private void handleKmlObjects(kmlObjects objects) {
        if (!objects.networkLinks.isEmpty()) {
            int numObjs = objects.networkLinks.size();
            int adjIndex = this.createOrUpdateLinkedFiles(numObjs);
            for (int idx = 0; idx < numObjs; ++idx) {
                this.handleKmlNetworkLink((kmlNetworkLink)objects.networkLinks.get(idx), idx + adjIndex);
            }
        }
        if (!objects.networkLinkControls.isEmpty()) {
            this.handleKmlNetworkLinkControl((kmlNetworkLinkControl)objects.networkLinkControls.get(0));
        }
        for (kmlDocument doc : objects.documents) {
            this.handleKmlDocument(doc);
        }
        for (kmlPlacemark pm : objects.placemarks) {
            this.handleKmlPlacemark(pm);
        }
        for (kmlFolder f : objects.folders) {
            this.handleKmlFolder(f);
        }
        for (kmlGroundOverlay go : objects.groundOverlays) {
            this.handleKmlGroundOverlay(go);
        }
    }

    private int createOrUpdateLinkedFiles(int numLinks) {
        int adjIndex = 0;
        if (this.linkedFile == null) {
            this.linkedFile = new KmlFile[numLinks];
            this.pollRate = new double[numLinks];
            this.lastPoll = new double[numLinks];
            this.isFirstPass = new boolean[numLinks];
            this.lastMods = new double[numLinks];
        } else {
            adjIndex = this.linkedFile.length;
            KmlFile[] tmpF = new KmlFile[adjIndex + numLinks];
            for (int xx = 0; xx < adjIndex; ++xx) {
                tmpF[xx] = this.linkedFile[xx];
            }
            this.linkedFile = tmpF;
            double[] tmpD = new double[this.linkedFile.length];
            for (int xx = 0; xx < adjIndex; ++xx) {
                tmpD[xx] = this.pollRate[xx];
            }
            this.pollRate = tmpD;
            double[] tmpD2 = new double[this.linkedFile.length];
            for (int xx = 0; xx < adjIndex; ++xx) {
                tmpD2[xx] = this.lastPoll[xx];
            }
            this.lastPoll = tmpD2;
            boolean[] tmpB = new boolean[this.linkedFile.length];
            for (int xx = 0; xx < adjIndex; ++xx) {
                tmpB[xx] = this.isFirstPass[xx];
            }
            this.isFirstPass = tmpB;
            double[] tmpL = new double[this.linkedFile.length];
            for (int xx = 0; xx < adjIndex; ++xx) {
                tmpL[xx] = this.lastMods[xx];
            }
            this.lastMods = tmpL;
        }
        return adjIndex;
    }

    private URL getURL(String href) {
        URL url = null;
        FileName fn = new FileName(href);
        String path = fn.getPath();
        if (this.currPath != null && this.currPath.startsWith("jar:")) {
            fn.setPath(this.currPath + path);
        } else if (path.equals("")) {
            fn.setPath(this.currPath);
        }
        try {
            return fn.toURL(-1);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return url;
        }
    }

    private void handleKmlGroundOverlay(kmlGroundOverlay overlay) {
        double rotation;
        BufferedImage img;
        kmlIcon icon = overlay.getIcon();
        Color color = overlay.getColor();
        String href = icon.getHref();
        double north = overlay.getNorth();
        double south = overlay.getSouth();
        double east = overlay.getEast();
        double west = overlay.getWest();
        if ((href.startsWith("http") || href.startsWith("HTTP")) && icon.getViewFormat() != null) {
            href = href + "&" + icon.parseViewFormat(north, south, east, west, this.MP.panel.getWidth(), this.MP.panel.getHeight());
        }
        if ((img = this.addToImgCache(href)) == null) {
            return;
        }
        int alpha = color.getAlpha();
        int h = img.getHeight();
        int w = img.getWidth();
        if (alpha != 255 && alpha != -1) {
            img = MColor.adjustImage(img, 0, 0, w, h, 50, 50, alpha, false);
        }
        if ((rotation = overlay.getRotation()) != 0.0) {
            double rads = Math.toRadians(rotation);
            img = GraphicsUtil.rotateImage(img, rads);
        }
        this.MP.drawImage(img, north, south, east, west);
        KmlImage ti = new KmlImage(img, north, south, east, west, href);
        if (!this.getImages().contains(ti)) {
            this.getImages().add(ti);
        }
    }

    private void handleKmlDocument(kmlDocument document) {
        String styleId = document.getStyleUrl();
        for (kmlStyleMap sm : document.getStyleMaps()) {
            this.styleMaps.put(sm.getId(), sm);
        }
        for (kmlStyle style : document.getStyles()) {
            this.styles.put(style.getId(), style);
        }
        for (kmlFeature feat : document.features) {
            this.handleKmlFeature(feat);
        }
        if (styleId != null) {
            this.handleKmlStyle(styleId);
        } else {
            this.setStyleDefaults();
        }
    }

    private void setStyleDefaults() {
        this.setPolygonFill(false);
        this.setPolygonOutline(true);
        this.setLineWidth(2);
        this.setLineColor(DEFAULT_POINT_COLOR);
        this.setPolygonColor(DEFAULT_POINT_COLOR);
        this.setIconHeading(0.0f);
        this.setIconScale(1.0f);
        this.setPointSymbol("Cross");
        this.setPointSize(8);
    }

    private void handleKmlStyle(String styleId) {
        if (this.styleMaps.containsKey(styleId)) {
            styleId = this.styleMaps.get(styleId).getNormalStyleUrl();
        }
        if (this.styles.containsKey(styleId)) {
            this.handleKmlStyle(this.styles.get(styleId));
        }
    }

    private void handleKmlStyle(kmlStyle style) {
        this.setStyleDefaults();
        if (style.hasLineStyle) {
            this.handleKmlLineStyle(style.getLineStyle());
        }
        if (style.hasPolyStyle) {
            this.handleKmlPolyStyle(style.getPolyStyle());
        }
        if (style.hasIconStyle) {
            this.handleKmlIconStyle(style.getIconStyle());
        }
        if (style.hasLabelStyle) {
            this.handleKmlLabelStyle(style.getLabelStyle());
        }
        this.handleKmlBalloonStyle(style.getBalloonStyle());
    }

    private void handleKmlBalloonStyle(kmlBalloonStyle balloonStyle) {
        this.balloonStyle = balloonStyle == null ? new kmlBalloonStyle() : balloonStyle;
    }

    private void handleKmlLineStyle(kmlLineStyle lineStyle) {
        this.setLineWidth((int)lineStyle.getWidth());
        this.setLineColor(lineStyle.getColor());
    }

    private void handleKmlPolyStyle(kmlPolyStyle polyStyle) {
        this.setPolygonFill(polyStyle.isFill());
        this.setPolygonOutline(polyStyle.isOutline());
        this.setPolygonColor(polyStyle.getColor());
    }

    private void handleKmlIconStyle(kmlIconStyle iconStyle) {
        this.setIconHeading(iconStyle.getHeading());
        this.setIconScale(iconStyle.getScale());
        this.setIconColor(iconStyle.getColor());
        this.handleKmlIcon(iconStyle.getIcon());
    }

    private void handleKmlIcon(kmlIcon icon) {
        String url = icon.getHref();
        if ("Aero,Arrow,Circle,Cross,Diamond,Dot,Plus,Square,Star,Triangle,UTri,DTri,RTri,LTri,A,B,C,D,Ascii-XYZ,None".indexOf(url) >= 0) {
            this.setPointSymbol(url);
        } else if (url.toLowerCase().startsWith("http") || url.toLowerCase().startsWith("file")) {
            this.setPointImage(url);
        } else {
            this.setPointImage(url);
        }
    }

    private void handleKmlLabelStyle(kmlLabelStyle labelStyle) {
        this.setLabelColor(labelStyle.getColor());
        this.setLabelScale(labelStyle.getScale());
    }

    private void handleKmlFolder(kmlFolder folder) {
        int numLinks = folder.networkLinks.size();
        for (kmlFolder f : folder.getFolders()) {
            this.handleKmlFolder(f);
        }
        if (numLinks > 0) {
            int adjIndex = this.createOrUpdateLinkedFiles(numLinks);
            for (int idx = 0; idx < numLinks; ++idx) {
                this.handleKmlNetworkLink((kmlNetworkLink)folder.networkLinks.get(idx), idx + adjIndex);
            }
        }
        if (folder.getStyleUrl() != null) {
            this.handleKmlStyle(folder.getStyleUrl());
        } else {
            this.setStyleDefaults();
        }
        for (kmlFeature feat : folder.features) {
            this.handleKmlFeature(feat);
        }
    }

    private void handleKmlPlacemark(kmlPlacemark placemark) {
        String styleId = placemark.getStyleUrl();
        if (styleId != null) {
            this.handleKmlStyle(styleId);
        } else if (placemark.getStyles().size() > 0) {
            for (kmlStyle style : placemark.getStyles()) {
                this.handleKmlStyle(style);
            }
        } else {
            this.setStyleDefaults();
        }
        this.handleKmlGeometry(placemark.getGeometry());
    }

    private void handleKmlGeometry(kmlGeometry geometry) {
        if (geometry instanceof kmlLineString) {
            this.handleKmlLineString((kmlLineString)geometry);
        } else if (geometry instanceof kmlLinearRing) {
            this.handleKmlLinearRing((kmlLinearRing)geometry);
        } else if (geometry instanceof kmlPoint) {
            this.handleKmlPoint((kmlPoint)geometry);
        } else if (geometry instanceof kmlPolygon) {
            this.handleKmlPolygon((kmlPolygon)geometry);
        } else if (geometry instanceof kmlMultiGeometry) {
            this.handleKmlMultiGeometry((kmlMultiGeometry)geometry);
        }
    }

    private void handleKmlLineString(kmlLineString lineString) {
        if (lineString.isExtrude()) {
            this.drawExtrudedPolygon(lineString.getCoordsAsDouble());
        } else {
            this.drawLineString(lineString);
        }
    }

    private void handleKmlNetworkLink(kmlNetworkLink networkLink, int index) {
        String mode = networkLink.link.getRefreshMode().toLowerCase();
        if (mode.equals("oninterval")) {
            this.pollRate[index] = networkLink.link.getRefreshInterval();
            if (this.pollRate[index] < this.minRefreshPeriod) {
                this.pollRate[index] = this.minRefreshPeriod;
            }
        } else {
            this.pollRate[index] = 3600.0;
        }
        this.linkedFile[index] = new KmlFile(networkLink.link.getHref());
        this.isFirstPass[index] = true;
    }

    private void handleKmlNetworkLinkControl(kmlNetworkLinkControl control) {
        this.minRefreshPeriod = control.getMinRefreshPeriod();
        if (this.pollRate == null) {
            this.pollRate = new double[1];
            this.pollRate[0] = 3600.0;
            return;
        }
        for (int idx = 0; idx < this.pollRate.length; ++idx) {
            if (!(this.pollRate[idx] < this.minRefreshPeriod)) continue;
            this.pollRate[idx] = this.minRefreshPeriod;
        }
    }

    private double[] getExtrudeCoords(double[] coords) {
        int length = coords.length * 2 + 3;
        double[] polyCoords = new double[length];
        int coordsCounter = 0;
        int xx = 0;
        while (xx < coords.length) {
            polyCoords[coordsCounter] = coords[xx];
            ++xx;
            ++coordsCounter;
        }
        for (xx = coords.length - 1; xx >= 0; xx -= 3) {
            polyCoords[coordsCounter++] = coords[xx - 2];
            polyCoords[coordsCounter++] = coords[xx - 1];
            polyCoords[coordsCounter++] = 0.0;
        }
        polyCoords[coordsCounter++] = coords[0];
        polyCoords[coordsCounter++] = coords[1];
        polyCoords[coordsCounter++] = coords[2];
        return polyCoords;
    }

    private void drawExtrudedPolygon(double[] points) {
        int length = points.length;
        this.drawPolygon(points);
        for (int xx = 0; xx < length - 3; xx += 3) {
            double[] poly = new double[]{points[xx], points[xx + 1], points[xx + 2], points[xx + 3], points[xx + 4], points[xx + 5], points[xx + 3], points[xx + 4], 0.0, points[xx], points[xx + 1], 0.0, points[xx], points[xx + 1], points[xx + 2]};
            this.drawPolygon(poly);
        }
    }

    private void handleKmlLinearRing(kmlLinearRing linearRing) {
        if (linearRing.isExtrude()) {
            this.drawExtrudedPolygon(linearRing.getCoordsAsDouble());
        } else {
            this.drawLinearRing(linearRing);
        }
    }

    private void handleKmlPoint(kmlPoint point) {
        this.drawPoint(point);
    }

    private void handleKmlPolygon(kmlPolygon polygon) {
        this.drawPolygon(polygon);
    }

    private void handleKmlMultiGeometry(kmlMultiGeometry multiGeometry) {
        int geoCount = multiGeometry.geometrys.size();
        for (int xx = 0; xx < geoCount; ++xx) {
            this.handleKmlGeometry(multiGeometry.geometrys.get(xx));
        }
    }

    private void handleKmlFeature(kmlFeature feature) {
        String featureType = feature.getClass().getName();
        if (featureType.indexOf("kmlPlacemark") >= 0) {
            this.handleKmlPlacemark((kmlPlacemark)feature);
        } else if (featureType.indexOf("kmlFolder") >= 0) {
            this.handleKmlFolder((kmlFolder)feature);
        } else if (featureType.indexOf("kmlDocument") >= 0) {
            this.handleKmlDocument((kmlDocument)feature);
        } else if (featureType.indexOf("kmlGroundOverlay") >= 0) {
            this.handleKmlGroundOverlay((kmlGroundOverlay)feature);
        }
    }

    private void handleKmlRegion(kmlRegion region) {
    }

    private void handleKmlOverlay(kmlOverlay overlay) {
    }

    protected void updateXRange(double xval) {
        if (xval < this.x1) {
            this.x1 = xval;
        }
        if (xval > this.x2) {
            this.x2 = xval;
        }
    }

    protected void updateYRange(double yval) {
        if (yval < this.y1) {
            this.y1 = yval;
        }
        if (yval > this.y2) {
            this.y2 = yval;
        }
    }

    @Override
    public void findRange() {
    }

    @Override
    public void findFullRange() {
        this.fx1 = this.x1;
        this.fx2 = this.x2;
        this.fy1 = this.y1;
        this.fy2 = this.y2;
        this.fz1 = this.z1;
        this.fz2 = this.z2;
    }

    private void adjustColors() {
    }

    public void setContrast(int percent) {
        if (percent != this.contrast) {
            this.contrast = Math.max(0, Math.min(100, percent));
        }
    }

    public float getContrast() {
        return this.contrast;
    }

    public void setBrightness(int percent) {
        if (percent != this.brightness) {
            this.brightness = Math.max(0, Math.min(100, percent));
        }
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setOpaqueness(int percent) {
        int val = MColor.pct2alpha(percent);
        this.setAlpha(val);
    }

    public int getOpaqueness() {
        return MColor.alpha2pct(this.alpha);
    }

    public void setAlpha(int newAlpha) {
        if (newAlpha != this.alpha) {
            this.alpha = Math.max(0, Math.min(255, newAlpha));
        }
    }

    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public void setEnable(int value) {
        boolean layerHidden;
        if ((this.enable & 1) == 0 != (layerHidden = (value & 1) == 0) && this.selectedObject != null) {
            if (layerHidden) {
                if (this.activePopup && this.kmlPopup != null) {
                    this.closeCurrentPopup();
                    this.activePopup = true;
                }
            } else if (this.activePopup) {
                this.drawPopup();
            }
        }
        super.setEnable(value);
    }

    private void setSelectedObject(kmlObject kmlObject2) {
        if (kmlObject2 != this.selectedObject) {
            this.selectedObject = kmlObject2;
            if (kmlObject2 == null && this.activePopup) {
                this.closeCurrentPopup();
            }
            this.refresh();
        }
    }

    private void drawPopup() {
        if (this.selectedObject == null) {
            return;
        }
        if (this.activePopup) {
            this.closeCurrentPopup();
        }
        this.kmlPopup = new Popup(this.popupSelection);
        this.activePopup = true;
    }

    private void closeCurrentPopup() {
        if (this.kmlPopup != null) {
            this.kmlPopup.close();
        }
        this.activePopup = false;
    }

    @Override
    public boolean clear() {
        this.objects.documents.clear();
        this.objects.folders.clear();
        this.objects.groundOverlays.clear();
        this.objects.networkLinkControls.clear();
        this.objects.networkLinks.clear();
        this.objects.placemarks.clear();
        this.setSelectedObject(null);
        this.popupSelection = null;
        this.refresh();
        return true;
    }

    @Override
    public void close() {
        super.close();
        this.setSelectedObject(null);
        this.popupSelection = null;
        this.activePopup = false;
        this.closeCurrentPopup();
    }

    public ArrayList<KmlImage> getImages() {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        return this.images;
    }

    public ArrayList<kmlPolygon> getPolygons() {
        if (this.polygons == null) {
            this.polygons = new ArrayList();
        }
        return this.polygons;
    }

    public ArrayList<kmlLineString> getLineStrings() {
        if (this.lineStrings == null) {
            this.lineStrings = new ArrayList();
        }
        return this.lineStrings;
    }

    public static Layer getLayer() {
        return new LayerKML();
    }

    private static boolean isKMLFalse(String value) {
        return "false".equalsIgnoreCase(value) || "0".equals(value);
    }

    private static boolean isKMLTrue(String value) {
        return "true".equalsIgnoreCase(value) || "1".equals(value);
    }

    static /* synthetic */ Set access$1400() {
        return supportedElems;
    }

    private class PopupSelection {
        private kmlPoint kmlPoint;
        private int xPos;
        private int yPos;
        private String label;

        private PopupSelection(kmlPoint kmlPoint2, int xPos, int yPos, String label) {
            this.kmlPoint = kmlPoint2;
            this.xPos = xPos;
            this.yPos = yPos;
            this.label = label;
        }

        private kmlPoint getKmlPoint() {
            return this.kmlPoint;
        }

        private int getXPos() {
            return this.xPos;
        }

        private int getYPos() {
            return this.yPos;
        }

        private String getLabel() {
            return this.label;
        }

        private void setLabel(String label) {
            this.label = label;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class Popup {
        private static final int DEFAULT_XPOS = 200;
        private static final int DEFAULT_YPOS = 200;
        JFrame frame;
        private PopupSelection popupSelection;

        public Popup(kmlPoint p) {
            this(p, 200, 200);
        }

        public Popup(kmlPoint p, int xPos, int yPos) {
            this(p, xPos, yPos, null);
        }

        public Popup(kmlPoint p, int xPos, int yPos, String label) {
            this(this$0.new PopupSelection(p, xPos, yPos, label));
        }

        private Popup(PopupSelection popupSelection) {
            this.popupSelection = popupSelection;
            kmlPoint p = popupSelection.getKmlPoint();
            int xPos = popupSelection.getXPos();
            int yPos = popupSelection.getYPos();
            String label = popupSelection.getLabel();
            String newLabel = label != null ? label : p.getParentFeature().getName();
            popupSelection.setLabel(newLabel);
            this.frame = new JFrame(newLabel);
            this.frame.setDefaultCloseOperation(1);
            PopupPanel myPopup = new PopupPanel(p);
            if (LayerKML.this.keepPopupSmall) {
                this.setPopupSmall(this.frame, myPopup, xPos, yPos);
            } else {
                this.setPopupFramePack(this.frame, myPopup, xPos, yPos);
            }
            this.frame.setVisible(true);
        }

        private void setPopupSmall(JFrame frame, PopupPanel myPopup, int xPos, int yPos) {
            int w = Math.min(600, Math.max(200, myPopup.getPreferredSize().width));
            int h = Math.min(600, Math.max(250, myPopup.getPreferredSize().height));
            frame.setSize(w, h);
            frame.setLocation(xPos - w / 2, yPos - h / 2);
            frame.setContentPane(myPopup);
        }

        private void setPopupFramePack(JFrame frame, PopupPanel myPopup, int xPos, int yPos) {
            frame.setContentPane(myPopup);
            frame.pack();
            frame.setLocation(xPos - frame.getWidth() / 2, yPos - frame.getHeight() / 2);
        }

        private void close() {
            this.frame.dispatchEvent(new WindowEvent(this.frame, 201));
            if (Shell.needRemoveNotifyToAvoidJVMHang()) {
                this.frame.removeNotify();
            }
        }

        @InternalUseOnly(value="since NeXtMidas 3.5.3")
        public class PopupPanel
        extends JPanel {
            private static final int DEFAULT_SIZE = 100;
            private static final int MAX_SIZE = 130;
            private static final int MIN_SIZE = 10;
            private Symbol symbol;
            private BufferedImage img;
            private Line line;
            private ImageIcon icon = null;
            private JScrollPane scrollPane;
            private String text;

            public PopupPanel(kmlPoint p) {
                this(p, 100);
            }

            public PopupPanel(kmlPoint p, int symbolSize) {
                this.setLayout(new GridLayout(1, 1));
                String label = Popup.this.popupSelection.getLabel();
                double xPos = p.getCoords().lon;
                double yPos = p.getCoords().lat;
                String desc = p.getParentFeature().description;
                this.line = p.getLine();
                this.symbol = this.line.getSymbol();
                float heading = this.symbol.getHeading();
                kmlBalloonStyle style = p.getBalloonStyle();
                this.setupStyle(style, label, desc);
                this.setupImage(p.getImage(), heading, symbolSize);
                String labelText = this.setupText(label, xPos, yPos, heading, this.text);
                if (!style.getDisplayMode().equalsIgnoreCase("hide")) {
                    this.display(labelText);
                }
            }

            private void setupStyle(kmlBalloonStyle style, String name, String desc) {
                this.text = style.getText();
                if (this.text == null || this.text.isEmpty()) {
                    this.text = desc;
                } else {
                    this.text = this.text.replaceAll("\\$\\[name\\]", name);
                    this.text = this.text.replaceAll("\\$\\[description\\]", desc);
                }
                if (this.text == null || this.text.isEmpty()) {
                    this.text = "None";
                }
            }

            private void setupImage(Object obj, float heading, int newSize) {
                if (obj != null && obj instanceof BufferedImage) {
                    this.img = (BufferedImage)obj;
                    if (heading != 0.0f) {
                        double rads = Math.toRadians(heading);
                        this.img = GraphicsUtil.rotateImage(this.img, rads);
                    }
                } else {
                    int h = this.symbol.getIconHeight();
                    int w = this.symbol.getIconWidth();
                    this.img = this.symbol.getImage(w, h);
                }
                this.resize(newSize);
            }

            private void resize(float newSize) {
                if (newSize > 130.0f) {
                    newSize = 130.0f;
                } else if (newSize < 10.0f) {
                    newSize = 10.0f;
                }
                float oldH = this.img.getHeight();
                float oldW = this.img.getWidth();
                float ratio = oldH > oldW ? newSize / oldH : newSize / oldW;
                int newH = (int)(oldH * ratio);
                int newW = (int)(oldW * ratio);
                Image i = this.img.getScaledInstance(newW, newH, 4);
                this.icon = new ImageIcon(i);
            }

            private String setupText(String label, double xPos, double yPos, double heading, String text) {
                int lIndex;
                int bIndex;
                String lcText = text.toLowerCase();
                String prefix = "Name: <font color=red><b>" + label + "</b></font><p>Lat: <font color=red><b>" + yPos + "</b></font><p>Lon: <font color=red><b>" + xPos + "</b></font><p>Heading: <font color=red><b>" + heading + "</b></font><p>Description: ";
                String displayText = "";
                displayText = lcText.startsWith("<html") ? ((bIndex = lcText.indexOf("<body")) != -1 ? ((lIndex = lcText.indexOf(">", bIndex)) != -1 ? text.substring(0, lIndex + 1) + prefix + text.substring(lIndex + 1) : "<html>" + prefix + text.substring(text.indexOf(">") + 1)) : ((bIndex = lcText.indexOf("</style>")) != -1 ? text.substring(0, bIndex += "</style>".length()) + prefix + text.substring(bIndex) : "<html>" + prefix + text.substring(text.indexOf(">") + 1))) : displayText + "<html>" + prefix + "<font color=red><b>" + text + "</b></font></b></font></html>";
                return displayText;
            }

            private void display(String labelText) {
                JLabel textDisplay = new JLabel(labelText, this.icon, 0);
                textDisplay.setHorizontalTextPosition(0);
                textDisplay.setVerticalTextPosition(3);
                this.scrollPane = new JScrollPane(textDisplay);
                this.add(this.scrollPane);
                this.setVisible(true);
            }
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlTimeStamp
    extends kmlTimePrimitive {
        Time when;

        public Time getWhen() {
            return this.when;
        }

        public void setWhen(Time when) {
            this.when = when;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlTimeSpan
    extends kmlTimePrimitive {
        Time begin;
        Time end;

        public Time getBegin() {
            return this.begin;
        }

        public void setBegin(Time begin) {
            this.begin = begin;
        }

        public Time getEnd() {
            return this.end;
        }

        public void setEnd(Time end) {
            this.end = end;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlTimePrimitive
    extends kmlObject {
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlRegion
    extends kmlObject {
        double north;
        double south;
        double east;
        double west;
        double minAltitude;
        double maxAltitude;
        String altitudeMode;
        float minLodPixels;
        float maxLodPixels;
        float minFadeExtant;
        float maxFadeExtant;

        public kmlRegion() {
            this.minAltitude = 0.0;
            this.maxAltitude = 0.0;
            this.altitudeMode = "clampToGround";
            this.minLodPixels = 0.0f;
            this.maxLodPixels = -1.0f;
            this.minFadeExtant = 0.0f;
            this.maxFadeExtant = 0.0f;
        }

        public double getNorth() {
            return this.north;
        }

        public void setNorth(double north) {
            this.north = north;
            LayerKML.this.updateYRange(north);
        }

        public double getSouth() {
            return this.south;
        }

        public void setSouth(double south) {
            this.south = south;
            LayerKML.this.updateYRange(south);
        }

        public double getEast() {
            return this.east;
        }

        public void setEast(double east) {
            this.east = east;
            LayerKML.this.updateXRange(east);
        }

        public double getWest() {
            return this.west;
        }

        public void setWest(double west) {
            this.west = west;
            LayerKML.this.updateXRange(west);
        }

        public double getMinAltitude() {
            return this.minAltitude;
        }

        public void setMinAltitude(double minAltitude) {
            this.minAltitude = minAltitude;
        }

        public double getMaxAltitude() {
            return this.maxAltitude;
        }

        public void setMaxAltitude(double maxAltitude) {
            this.maxAltitude = maxAltitude;
        }

        public String getAltitudeMode() {
            return this.altitudeMode;
        }

        public void setAltitudeMode(String altitudeMode) {
            if (altitudeMode.equalsIgnoreCase("clamptoground")) {
                this.altitudeMode = "clampToGround";
            } else if (altitudeMode.equalsIgnoreCase("relativetoground")) {
                this.altitudeMode = "relativeToGround";
            } else if (altitudeMode.equalsIgnoreCase("absolute")) {
                this.altitudeMode = "absolute";
            } else {
                LayerKML.this.warning("Invalid altitude mode: " + altitudeMode + ". Mode must be 'clampToGround', 'relativeToGround', or 'absolute'");
            }
        }

        public float getMinLodPixels() {
            return this.minLodPixels;
        }

        public void setMinLodPixels(float minLodPixels) {
            this.minLodPixels = minLodPixels;
        }

        public float getMaxLodPixels() {
            return this.maxLodPixels;
        }

        public void setMaxLodPixels(float maxLodPixels) {
            this.maxLodPixels = maxLodPixels;
        }

        public float getMinFadeExtant() {
            return this.minFadeExtant;
        }

        public void setMinFadeExtant(float minFadeExtant) {
            this.minFadeExtant = minFadeExtant;
        }

        public float getMaxFadeExtant() {
            return this.maxFadeExtant;
        }

        public void setMaxFadeExtant(float maxFadeExtant) {
            this.maxFadeExtant = maxFadeExtant;
        }

        public void setKeepPopupSmall(boolean keepSmall) {
            LayerKML.this.keepPopupSmall = keepSmall;
        }

        public boolean isKeepPopupSmall() {
            return LayerKML.this.keepPopupSmall;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlStyleMapPair {
        private String key;
        private String styleUrl;

        public void setKey(String key) {
            if (key.equals("normal") || key.equals("highlight")) {
                this.key = key;
            } else {
                LayerKML.this.warning("Illegal Style Map Pair Key: " + key + ". Setting to 'normal'.");
            }
        }

        public String getKey() {
            return this.key != null ? this.key : "normal";
        }

        public void setStyleUrl(String url) {
            this.styleUrl = url;
        }

        public String getStyleUrl() {
            return this.styleUrl;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlStyleMap
    extends kmlStyleSelector {
        String normalKey;
        String highlightKey;
        String normalStyleUrl;
        String highlightStyleUrl;

        public kmlStyleMap() {
            this.normalKey = "normal";
            this.highlightKey = "highlight";
        }

        public void setNormalStyleUrl(String url) {
            this.normalStyleUrl = url;
        }

        public String getNormalStyleUrl() {
            return this.normalStyleUrl;
        }

        public void setHighlightStyleUrl(String url) {
            this.highlightStyleUrl = url;
        }

        public String getHighlightStyleUrl() {
            return this.highlightStyleUrl;
        }

        public void setStyleMapPair(kmlStyleMapPair pair) {
            if (pair.getKey().equals("normal")) {
                this.setNormalStyleUrl(pair.getStyleUrl());
            } else {
                this.setHighlightStyleUrl(pair.getStyleUrl());
            }
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlStyleSelector
    extends kmlObject {
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlStyle
    extends kmlStyleSelector {
        private kmlBalloonStyle balloonStyle;
        private boolean hasBalloonStyle = false;
        private kmlIconStyle iconStyle;
        private boolean hasIconStyle = false;
        private kmlLabelStyle labelStyle;
        private boolean hasLabelStyle = false;
        private kmlLineStyle lineStyle;
        private boolean hasLineStyle = false;
        private kmlListStyle listStyle;
        private boolean hasListStyle = false;
        private kmlPolyStyle polyStyle;
        private boolean hasPolyStyle = false;

        public kmlStyle() {
            this.balloonStyle = new kmlBalloonStyle();
            this.iconStyle = new kmlIconStyle();
            this.labelStyle = new kmlLabelStyle();
            this.lineStyle = new kmlLineStyle();
            this.listStyle = new kmlListStyle();
            this.polyStyle = new kmlPolyStyle();
        }

        public kmlBalloonStyle getBalloonStyle() {
            return this.balloonStyle;
        }

        public void setBalloonStyle(kmlBalloonStyle balloonStyle) {
            this.balloonStyle = balloonStyle;
            this.hasBalloonStyle = true;
        }

        public kmlIconStyle getIconStyle() {
            return this.iconStyle;
        }

        public void setIconStyle(kmlIconStyle iconStyle) {
            this.iconStyle = iconStyle;
            this.hasIconStyle = true;
        }

        public kmlLabelStyle getLabelStyle() {
            return this.labelStyle;
        }

        public void setLabelStyle(kmlLabelStyle labelStyle) {
            this.labelStyle = labelStyle;
            this.hasLabelStyle = true;
        }

        public kmlLineStyle getLineStyle() {
            return this.lineStyle;
        }

        public void setLineStyle(kmlLineStyle lineStyle) {
            this.lineStyle = lineStyle;
            this.hasLineStyle = true;
        }

        public kmlListStyle getListStyle() {
            return this.listStyle;
        }

        public void setListStyle(kmlListStyle listStyle) {
            this.listStyle = listStyle;
            this.hasListStyle = true;
        }

        public kmlPolyStyle getPolyStyle() {
            return this.polyStyle;
        }

        public void setPolyStyle(kmlPolyStyle polyStyle) {
            this.polyStyle = polyStyle;
            this.hasPolyStyle = true;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlSchema {
        String name = new String();
        String schemaID = new String();
        String simpleFieldType = new String();
        String simpleFieldName = new String();
        String displayName = new String();
        String parent = "placemark";

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTargetID() {
            return this.schemaID;
        }

        public void setTargetID(String targetID) {
            this.schemaID = targetID;
        }

        public String getSimpleFieldType() {
            return this.simpleFieldType;
        }

        public void setSimpleFieldType(String simpleFieldType) {
            this.simpleFieldType = simpleFieldType;
        }

        public String getSimpleFieldName() {
            return this.simpleFieldName;
        }

        public void setSimpleFieldName(String simpleFieldName) {
            this.simpleFieldName = simpleFieldName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public void setParent(String parent) {
            this.parent = parent;
        }

        public String getParent() {
            return this.parent;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlScreenOverlay
    extends kmlOverlay {
        float overlayX;
        float overlayY;
        String overlayXUnits;
        String overlayYUnits;
        float screenX;
        float screenY;
        String screenXUnits;
        String screenYUnits;
        float rotationX;
        float rotationY;
        String rotationXUnits;
        String rotationYUnits;
        float sizeX;
        float sizeY;
        String sizeXUnits;
        String sizeYUnits;
        float rotation;

        public kmlScreenOverlay() {
            this.overlayXUnits = "fraction";
            this.overlayYUnits = "fraction";
            this.screenXUnits = "fraction";
            this.screenYUnits = "fraction";
            this.rotationXUnits = "fraction";
            this.rotationYUnits = "fraction";
            this.sizeXUnits = "fraction";
            this.sizeYUnits = "fraction";
            this.rotation = 0.0f;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlPolyStyle
    extends kmlColorStyle {
        boolean fill;
        boolean outline;

        public kmlPolyStyle() {
            this.fill = true;
            this.outline = true;
        }

        public boolean isFill() {
            return this.fill;
        }

        public void setFill(boolean fill) {
            this.fill = fill;
        }

        public boolean isOutline() {
            return this.outline;
        }

        public void setOutline(boolean outline) {
            this.outline = outline;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlPolygon
    extends kmlGeometry {
        boolean extrude;
        boolean tessellate;
        String altitudeMode;
        kmlLinearRing outerBoundary;
        boolean outer;
        Vector<kmlLinearRing> innerBoundary;

        public kmlPolygon() {
            this.extrude = false;
            this.tessellate = false;
            this.altitudeMode = "clampToGround";
            this.outerBoundary = new kmlLinearRing();
            this.innerBoundary = new Vector();
            LayerKML.this.getPolygons().add(this);
        }

        public kmlPolygon(kmlFeature feat) {
            this();
            this.setParentFeature(feat);
        }

        public void addInnerBoundary(kmlLinearRing linearRing) {
            this.innerBoundary.add(linearRing);
        }

        public void setOuterBoundary(kmlLinearRing outerBoundary) {
            this.outerBoundary = outerBoundary;
        }

        public kmlLinearRing getOuterBoundary() {
            return this.outerBoundary;
        }

        public boolean isOuter() {
            return this.outer;
        }

        public boolean getOuter() {
            return this.outer;
        }

        public void setOuter(boolean outer) {
            this.outer = outer;
        }

        public boolean isExtrude() {
            return this.extrude;
        }

        public boolean getExtrude() {
            return this.isExtrude();
        }

        public void setExtrude(boolean extrude) {
            this.extrude = extrude;
        }

        public boolean isTessellate() {
            return this.tessellate;
        }

        public void setTessellate(boolean tessellate) {
            this.tessellate = tessellate;
        }

        public String getAltitudeMode() {
            return this.altitudeMode;
        }

        public void setAltitudeMode(String altitudeMode) {
            if (altitudeMode.equalsIgnoreCase("clamptoground")) {
                this.altitudeMode = "clampToGround";
            } else if (altitudeMode.equalsIgnoreCase("relativetoground")) {
                this.altitudeMode = "relativeToGround";
            } else if (altitudeMode.equalsIgnoreCase("absolute")) {
                this.altitudeMode = "absolute";
            } else {
                LayerKML.this.warning("Invalid altitude mode: " + altitudeMode + ". Mode must be 'clampToGround', 'relativeToGround', or 'absolute'");
            }
        }

        public void addCoordinates(String coords) {
            kmlLinearRing linearRing = new kmlLinearRing();
            linearRing.setCoordsVector(coords);
            this.innerBoundary.add(linearRing);
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlPoint
    extends kmlGeometry {
        boolean extrude;
        String altitudeMode;
        kmlCoordinates coords;

        public kmlPoint() {
            this.extrude = false;
            this.altitudeMode = "clampToGround";
            this.coords = new kmlCoordinates();
        }

        public kmlPoint(Object obj) {
            this();
            if (obj instanceof kmlFeature) {
                this.setParentFeature((kmlFeature)obj);
            } else if (obj instanceof kmlMultiGeometry) {
                // empty if block
            }
        }

        public boolean getExtrude() {
            return this.isExtrude();
        }

        public boolean isExtrude() {
            return this.extrude;
        }

        public void setExtrude(boolean extrude) {
            this.extrude = extrude;
        }

        public String getAltitudeMode() {
            return this.altitudeMode;
        }

        public void setAltitudeMode(String altitudeMode) {
            if (altitudeMode.equalsIgnoreCase("clamptoground")) {
                this.altitudeMode = "clampToGround";
            } else if (altitudeMode.equalsIgnoreCase("relativetoground")) {
                this.altitudeMode = "relativeToGround";
            } else if (altitudeMode.equalsIgnoreCase("absolute")) {
                this.altitudeMode = "absolute";
            } else {
                LayerKML.this.warning("Invalid altitude mode: " + altitudeMode + ". Mode must be 'clampToGround', 'relativeToGround', or 'absolute'");
            }
        }

        public kmlCoordinates getCoords() {
            return this.coords;
        }

        public void setCoordinates(String string) {
            this.coords.setCoordinates(string);
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlPlacemark
    extends kmlFeature {
        kmlGeometry geometry;

        public kmlPlacemark() {
            this.geometry = new kmlGeometry();
        }

        public kmlGeometry getGeometry() {
            return this.geometry;
        }

        public void setGeometry(kmlGeometry geometry) {
            this.geometry = geometry;
            geometry.setParentFeature(this);
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlPhotoOverlay
    extends kmlOverlay {
        String shape;
        double leftFov;
        double rightFov;
        double bottomFov;
        double topFov;
        double near;
        float roll;
        int tileSize;
        int maxWidth;
        int maxHeight;
        String gridOrigin;
        kmlPoint point;

        public kmlPhotoOverlay() {
            this.shape = "rectangle";
            this.leftFov = 0.0;
            this.rightFov = 0.0;
            this.bottomFov = 0.0;
            this.topFov = 0.0;
            this.near = 0.0;
            this.tileSize = 256;
            this.gridOrigin = "lowerleft";
            this.point = new kmlPoint();
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlOverlay
    extends kmlFeature {
        private Color color;
        private int drawOrder;
        private kmlIcon icon;

        public kmlOverlay() {
            this.color = Color.white;
            this.drawOrder = 0;
            this.icon = new kmlIcon();
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public int getDrawOrder() {
            return this.drawOrder;
        }

        public void setDrawOrder(int drawOrder) {
            this.drawOrder = drawOrder;
        }

        public kmlIcon getIcon() {
            return this.icon;
        }

        public void setIcon(kmlIcon icon) {
            this.icon = icon;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlNetworkLinkControl {
        float minRefreshPeriod = 0.0f;
        float maxSessionLength = -1.0f;
        String cookie;
        String message;
        String linkName;
        String linkDescription;
        String linkSnippet;
        int linkSnippetMaxLines = 2;
        Date expires;
        String update = new String();
        kmlAbstractView abstractView;

        public kmlNetworkLinkControl() {
            this.cookie = new String();
            this.message = new String();
            this.linkName = new String();
            this.linkDescription = new String();
            this.linkSnippet = new String();
            this.abstractView = new kmlAbstractView();
        }

        public float getMinRefreshPeriod() {
            return this.minRefreshPeriod;
        }

        public void setMinRefreshPeriod(float minRefreshPeriod) {
            this.minRefreshPeriod = minRefreshPeriod;
        }

        public float getMaxSessionLength() {
            return this.maxSessionLength;
        }

        public void setMaxSessionLength(float maxSessionLength) {
            this.maxSessionLength = maxSessionLength;
        }

        public String getCookie() {
            return this.cookie;
        }

        public void setCookie(String cookie) {
            this.cookie = cookie;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getLinkName() {
            return this.linkName;
        }

        public void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        public String getLinkDescription() {
            return this.linkDescription;
        }

        public void setLinkDescription(String linkDescription) {
            this.linkDescription = linkDescription;
        }

        public String getLinkSnippet() {
            return this.linkSnippet;
        }

        public void setLinkSnippet(String linkSnippet) {
            this.linkSnippet = linkSnippet;
        }

        public int getLinkSnippetMaxLines() {
            return this.linkSnippetMaxLines;
        }

        public void setLinkSnippetMaxLines(int linkSnippetMaxLines) {
            this.linkSnippetMaxLines = linkSnippetMaxLines;
        }

        public Date getExpires() {
            return this.expires;
        }

        public void setExpires(Date expires) {
            this.expires = expires;
        }

        public String getUpdate() {
            return this.update;
        }

        public void setUpdate(String update) {
            if (update.equalsIgnoreCase("change")) {
                this.update = "Change";
            } else if (update.equalsIgnoreCase("create")) {
                this.update = "Create";
            } else if (update.equalsIgnoreCase("delete")) {
                this.update = "Delete";
            } else {
                LayerKML.this.warning("Invalid Update entry: " + update + ". Update must be 'Change', 'Create', or 'Delete'");
            }
        }

        public kmlAbstractView getAbstractView() {
            return this.abstractView;
        }

        public void setAbstractView(kmlAbstractView abstractView) {
            this.abstractView = abstractView;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlNetworkLink
    extends kmlFeature {
        boolean refreshVisibility;
        boolean flyToView;
        kmlLink link;

        public kmlNetworkLink() {
            this.refreshVisibility = false;
            this.flyToView = false;
            this.link = new kmlLink();
        }

        public void setLink(kmlLink link) {
            this.link = link;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlMultiGeometry
    extends kmlGeometry {
        Vector<kmlGeometry> geometrys;

        public kmlMultiGeometry() {
            this.geometrys = new Vector();
        }

        public kmlMultiGeometry(kmlFeature feat) {
            this();
            this.setParentFeature(feat);
        }

        public void addGeometry(kmlGeometry geometry) {
            this.geometrys.add(geometry);
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlModel
    extends kmlGeometry {
        String altitudeMode;
        kmlCoordinates coords;
        double heading;
        double tilt;
        double roll;
        float scaleX;
        float scaleY;
        float scaleZ;
        kmlLink link;
        String targetHref;
        String sourceHref;

        public kmlModel() {
            this.altitudeMode = "clampToGround";
            this.heading = 0.0;
            this.tilt = 0.0;
            this.roll = 0.0;
            this.scaleX = 1.0f;
            this.scaleY = 1.0f;
            this.scaleZ = 1.0f;
            this.link = new kmlLink();
        }

        public kmlModel(kmlFeature feat) {
            this();
            this.setParentFeature(feat);
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlLookAt
    extends kmlAbstractView {
        double lon;
        double lat;
        double alt;
        double heading;
        double tilt;
        double range;
        String altitudeMode;

        public kmlLookAt() {
            this.lon = 0.0;
            this.lat = 0.0;
            this.alt = 0.0;
            this.heading = 0.0;
            this.tilt = 0.0;
            this.altitudeMode = "clampToGround";
        }

        public double getLon() {
            return this.lon;
        }

        public void setLon(double lon) {
            this.lon = lon;
        }

        public double getLat() {
            return this.lat;
        }

        public void setLat(double lat) {
            this.lat = lat;
        }

        public double getAlt() {
            return this.alt;
        }

        public void setAlt(double alt) {
            this.alt = alt;
        }

        public double getHeading() {
            return this.heading;
        }

        public void setHeading(double heading) {
            this.heading = heading;
        }

        public double getTilt() {
            return this.tilt;
        }

        public void setTilt(double tilt) {
            this.tilt = tilt;
        }

        public double getRange() {
            return this.range;
        }

        public void setRange(double range) {
            this.range = range;
        }

        public String getAltitudeMode() {
            return this.altitudeMode;
        }

        public void setAltitudeMode(String altitudeMode) {
            this.altitudeMode = altitudeMode;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlListStyle
    extends kmlObject {
        Color bgColor;
        String listItemType;
        Vector<kmlIcon> icons;

        public kmlListStyle() {
            this.bgColor = Color.white;
            this.listItemType = "check";
            this.icons = new Vector();
        }

        public void addIcon(kmlIcon icon) {
            this.icons.add(icon);
        }

        public Color getBgColor() {
            return this.bgColor;
        }

        public void setBgColor(Color bgColor) {
            this.bgColor = bgColor;
        }

        public String getListItemType() {
            return this.listItemType;
        }

        public void setListItemType(String listItemType) {
            if (listItemType.equalsIgnoreCase("check")) {
                this.listItemType = "check";
            } else if (listItemType.equalsIgnoreCase("checkoffonly")) {
                this.listItemType = "checkOffOnly";
            } else if (listItemType.equalsIgnoreCase("checkHideChildren")) {
                this.listItemType = "checkHideChildren";
            } else if (listItemType.equalsIgnoreCase("radioFolder")) {
                this.listItemType = "radioFolder";
            } else {
                LayerKML.this.warning("Invalid List Item Type: " + listItemType + ". Type must be 'check' (default), 'checkOffOnly', 'checkHideChildren', or 'radioFolder'");
            }
        }

        public Vector<kmlIcon> getIcons() {
            return this.icons;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlLink
    extends kmlObject {
        String href;
        String refreshMode;
        float refreshInterval;
        String viewRefreshMode;
        float viewRefreshTime;
        float viewBoundScale;
        String viewFormat;
        String httpQuery;

        public kmlLink() {
            this.refreshMode = "onChange";
            this.refreshInterval = 4.0f;
            this.viewRefreshMode = "never";
            this.viewRefreshTime = 4.0f;
            this.viewBoundScale = 1.0f;
            this.href = new String();
            this.viewFormat = new String();
            this.httpQuery = new String();
        }

        public String getHref() {
            return this.href;
        }

        public void setHref(String href) {
            this.href = href;
        }

        public String getRefreshMode() {
            return this.refreshMode;
        }

        public void setRefreshMode(String mode) {
            if (mode.equalsIgnoreCase("onchange")) {
                this.refreshMode = "onChange";
            } else if (mode.equalsIgnoreCase("oninterval")) {
                this.refreshMode = "onInterval";
            } else if (mode.equalsIgnoreCase("onexpire")) {
                this.refreshMode = "onExpire";
            } else {
                LayerKML.this.warning("Invalid Refresh Mode: " + mode + ". Mode must be 'onChange', 'onInterval', or 'onExpire'.");
            }
        }

        public float getRefreshInterval() {
            return this.refreshInterval;
        }

        public void setRefreshInterval(float refreshInterval) {
            this.refreshInterval = refreshInterval;
        }

        public String getViewRefreshMode() {
            return this.viewRefreshMode;
        }

        public void setViewRefreshMode(String mode) {
            if (mode.equalsIgnoreCase("never")) {
                this.viewRefreshMode = "never";
            } else if (mode.equalsIgnoreCase("onstop")) {
                this.viewRefreshMode = "onStop";
            } else if (mode.equalsIgnoreCase("onrequest")) {
                this.viewRefreshMode = "onRequest";
            } else if (mode.equalsIgnoreCase("onregion")) {
                this.viewRefreshMode = "onRegion";
            } else {
                LayerKML.this.warning("Invalid View Refresh Mode: " + mode + ". Mode must be 'never', 'onStop', 'onRequest', or 'onRegion'.");
            }
        }

        public float getViewRefreshTime() {
            return this.viewRefreshTime;
        }

        public void setViewRefreshTime(float viewRefreshTime) {
            this.viewRefreshTime = viewRefreshTime;
        }

        public float getViewBoundScale() {
            return this.viewBoundScale;
        }

        public void setViewBoundScale(float viewBoundScale) {
            this.viewBoundScale = viewBoundScale;
        }

        public String getViewFormat() {
            return this.viewFormat;
        }

        public void setViewFormat(String viewFormat) {
            this.viewFormat = viewFormat;
        }

        public String getHttpQuery() {
            return this.httpQuery;
        }

        public void setHttpQuery(String httpQuery) {
            this.httpQuery = httpQuery;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlLineStyle
    extends kmlColorStyle {
        float width;

        public kmlLineStyle() {
            this.width = 1.0f;
        }

        public void setWidth(float w) {
            this.width = w;
        }

        public float getWidth() {
            return this.width;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlLineString
    extends kmlGeometry {
        boolean extrude;
        boolean tessellate;
        String altitudeMode;
        String coordsString;
        Vector<kmlCoordinates> coordsVector;

        public kmlLineString() {
            this.extrude = false;
            this.tessellate = false;
            this.altitudeMode = "clampToGround";
            this.coordsString = new String();
            this.coordsVector = new Vector();
        }

        public kmlLineString(kmlFeature feat) {
            this();
            this.setParentFeature(feat);
        }

        public boolean isExtrude() {
            return this.extrude;
        }

        public boolean getExtrude() {
            return this.isExtrude();
        }

        public void setExtrude(boolean extrude) {
            this.extrude = extrude;
        }

        public boolean isTessellate() {
            return this.tessellate;
        }

        public boolean getTessellate() {
            return this.isTessellate();
        }

        public void setTessellate(boolean tessellate) {
            this.tessellate = tessellate;
        }

        public String getAltitudeMode() {
            return this.altitudeMode;
        }

        public void setAltitudeMode(String altitudeMode) {
            if (altitudeMode.equalsIgnoreCase("clamptoground")) {
                this.altitudeMode = "clampToGround";
            } else if (altitudeMode.equalsIgnoreCase("relativetoground")) {
                this.altitudeMode = "relativeToGround";
            } else if (altitudeMode.equalsIgnoreCase("absolute")) {
                this.altitudeMode = "absolute";
            } else {
                LayerKML.this.warning("Invalid altitude mode: " + altitudeMode + ". Mode must be 'clampToGround', 'relativeToGround', or 'absolute'");
            }
        }

        public void setCoordsString(String coords) {
            this.coordsString = coords;
        }

        public String getCoordsString() {
            return this.coordsString;
        }

        public synchronized double[] getCoordsAsDouble() {
            double[] coords = null;
            if (this.coordsVector.isEmpty()) {
                LayerKML.this.warning("Coordinates not set");
                return null;
            }
            int size = this.coordsVector.size();
            coords = new double[size * 3];
            int coordsIndex = 0;
            for (int xx = 0; xx < size; ++xx) {
                coords[coordsIndex++] = this.coordsVector.get(xx).getLon();
                coords[coordsIndex++] = this.coordsVector.get(xx).getLat();
                coords[coordsIndex++] = this.coordsVector.get(xx).getAltitude();
            }
            return coords;
        }

        public synchronized void setCoordsVector(String coordinates) {
            String[] tmp = EOL.split(coordinates);
            for (int xx = 0; xx < tmp.length; ++xx) {
                kmlCoordinates coords;
                boolean valid;
                if (tmp[xx].isEmpty() || !(valid = (coords = new kmlCoordinates()).setCoordinates(tmp[xx]))) continue;
                this.coordsVector.add(coords);
            }
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlLinearRing
    extends kmlGeometry {
        boolean extrude;
        boolean tessellate;
        String altitudeMode;
        Vector<kmlCoordinates> coordsVector;
        String coordsString;

        public kmlLinearRing() {
            this.extrude = false;
            this.tessellate = false;
            this.altitudeMode = "clampToGround";
            this.coordsVector = new Vector();
            this.coordsString = new String();
        }

        public kmlLinearRing(kmlFeature feat) {
            this();
            this.setParentFeature(feat);
        }

        public boolean isExtrude() {
            return this.extrude;
        }

        public void setExtrude(boolean extrude) {
            this.extrude = extrude;
        }

        public boolean isTessellate() {
            return this.tessellate;
        }

        public void setTessellate(boolean tessellate) {
            this.tessellate = tessellate;
        }

        public String getAltitudeMode() {
            return this.altitudeMode;
        }

        public void setAltitudeMode(String altitudeMode) {
            if (altitudeMode.equalsIgnoreCase("clamptoground")) {
                this.altitudeMode = "clampToGround";
            } else if (altitudeMode.equalsIgnoreCase("relativetoground")) {
                this.altitudeMode = "relativeToGround";
            } else if (altitudeMode.equalsIgnoreCase("absolute")) {
                this.altitudeMode = "absolute";
            } else {
                LayerKML.this.warning("Invalid altitude mode: " + altitudeMode + ". Mode must be 'clampToGround', 'relativeToGround', or 'absolute'");
            }
        }

        public void setCoordsString(String coords) {
            this.coordsString = coords;
        }

        public String getCoordsString() {
            return this.coordsString;
        }

        public double[] getCoordsAsDouble() {
            double[] coords = null;
            if (this.coordsVector.isEmpty()) {
                LayerKML.this.warning("Coordinates not set");
                return null;
            }
            int size = this.coordsVector.size();
            coords = new double[size * 3];
            int coordsIndex = 0;
            for (int xx = 0; xx < size; ++xx) {
                coords[coordsIndex] = this.coordsVector.get(xx).getLon();
                coords[++coordsIndex] = this.coordsVector.get(xx).getLat();
                coords[++coordsIndex] = this.coordsVector.get(xx).getAltitude();
                ++coordsIndex;
            }
            return coords;
        }

        public void setCoordsVector(String coordinates) {
            String[] tmp = EOL.split(coordinates);
            for (int xx = 0; xx < tmp.length; ++xx) {
                kmlCoordinates coords;
                boolean valid;
                if (tmp[xx].isEmpty() || !(valid = (coords = new kmlCoordinates()).setCoordinates(tmp[xx]))) continue;
                this.coordsVector.add(coords);
            }
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlLabelStyle
    extends kmlColorStyle {
        float scale;

        public kmlLabelStyle() {
            this.scale = 1.0f;
        }

        public float getScale() {
            return this.scale;
        }

        public void setScale(float scale) {
            this.scale = scale;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlIconStyle
    extends kmlColorStyle {
        float scale;
        float heading;
        kmlIcon icon;
        double hotSpotX;
        double hotSpotY;
        String hotSpotXUnits;
        String hotSpotYUnits;

        public kmlIconStyle() {
            this.scale = 1.0f;
            this.heading = 0.0f;
            this.hotSpotX = 0.5;
            this.hotSpotY = 0.5;
            this.hotSpotXUnits = "fraction";
            this.hotSpotYUnits = "fraction";
            this.icon = new kmlIcon();
        }

        public float getScale() {
            return this.scale;
        }

        public void setScale(float scale) {
            this.scale = scale;
        }

        public float getHeading() {
            return this.heading;
        }

        public void setHeading(float heading) {
            this.heading = heading;
        }

        public kmlIcon getIcon() {
            return this.icon;
        }

        public void setIcon(kmlIcon icon) {
            this.icon = icon;
        }

        public double getHotSpotX() {
            return this.hotSpotX;
        }

        public void setHotSpotX(double hotSpotX) {
            this.hotSpotX = hotSpotX;
        }

        public double getHotSpotY() {
            return this.hotSpotY;
        }

        public void setHotSpotY(double hotSpotY) {
            this.hotSpotY = hotSpotY;
        }

        public String getHotSpotXUnits() {
            return this.hotSpotXUnits;
        }

        public void setHotSpotXUnits(String hotSpotXUnits) {
            this.hotSpotXUnits = this.validateUnits(hotSpotXUnits);
        }

        public String getHotSpotYUnits() {
            return this.hotSpotYUnits;
        }

        public void setHotSpotYUnits(String hotSpotYUnits) {
            this.hotSpotYUnits = this.validateUnits(hotSpotYUnits);
        }

        private String validateUnits(String units) {
            String results = new String();
            if (units.equalsIgnoreCase("fraction")) {
                results = "fraction";
            } else if (units.equalsIgnoreCase("pixels")) {
                results = "pixels";
            } else if (units.equalsIgnoreCase("insetpixels")) {
                results = "insetPixels";
            } else {
                LayerKML.this.warning("Invalid units: " + units + ". Setting Units to default (fraction).");
                results = "fraction";
            }
            return results;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlIcon
    extends kmlObject {
        private String href;
        String refreshMode;
        float refreshInterval;
        String viewRefreshMode;
        float viewRefreshTime;
        float viewBoundScale;
        String viewFormat;
        String httpQuery;

        public kmlIcon() {
            this.href = "None";
            this.refreshMode = "onChange";
            this.refreshInterval = 4.0f;
            this.viewRefreshMode = "never";
            this.viewRefreshTime = 4.0f;
            this.viewBoundScale = 1.0f;
        }

        public String getHref() {
            return this.href;
        }

        public void setHref(String url) {
            this.href = url;
        }

        public String getRefreshMode() {
            return this.refreshMode;
        }

        public void setRefreshMode(String mode) {
            if (mode.equalsIgnoreCase("onchange")) {
                this.refreshMode = "onChange";
            } else if (mode.equalsIgnoreCase("oninterval")) {
                this.refreshMode = "onInterval";
            } else if (mode.equalsIgnoreCase("onexpire")) {
                this.refreshMode = "onExpire";
            } else {
                LayerKML.this.warning("Invalid Refresh Mode: " + mode + ". Mode must be 'onChange', 'onInterval', or 'onExpire'.");
            }
        }

        public float getRefreshInterval() {
            return this.refreshInterval;
        }

        public void setRefreshInterval(float refreshInterval) {
            this.refreshInterval = refreshInterval;
        }

        public String getViewRefreshMode() {
            return this.viewRefreshMode;
        }

        public void setViewRefreshMode(String mode) {
            if (mode.equalsIgnoreCase("never")) {
                this.viewRefreshMode = "never";
            } else if (mode.equalsIgnoreCase("onstop")) {
                this.viewRefreshMode = "onStop";
            } else if (mode.equalsIgnoreCase("onrequest")) {
                this.viewRefreshMode = "onRequest";
            } else if (mode.equalsIgnoreCase("onregion")) {
                this.viewRefreshMode = "onRegion";
            } else {
                LayerKML.this.warning("Invalid View Refresh Mode: " + mode + ". Mode must be 'never', 'onStop', 'onRequest', or 'onRegion'.");
            }
        }

        public float getViewRefreshTime() {
            return this.viewRefreshTime;
        }

        public void setViewRefreshTime(float viewRefreshTime) {
            this.viewRefreshTime = viewRefreshTime;
        }

        public float getViewBoundScale() {
            return this.viewBoundScale;
        }

        public void setViewBoundScale(float viewBoundScale) {
            this.viewBoundScale = viewBoundScale;
        }

        public String getViewFormat() {
            return this.viewFormat;
        }

        public void setViewFormat(String viewFormat) {
            this.viewFormat = viewFormat;
        }

        public String getHttpQuery() {
            return this.httpQuery;
        }

        public void setHttpQuery(String httpQuery) {
            this.httpQuery = httpQuery;
        }

        public String parseViewFormat(double north, double south, double east, double west, int width, int height) {
            String[] elems;
            String raw = this.getViewFormat();
            if (raw == null) {
                return null;
            }
            StringBuffer result = new StringBuffer();
            for (String elem : elems = StringUtil.split(raw, "&")) {
                int indexEQ = elem.indexOf(61);
                if (indexEQ <= 0) continue;
                String key = elem.substring(0, indexEQ).trim();
                String value = elem.substring(indexEQ + 1).trim();
                if (key.equalsIgnoreCase("BBOX")) {
                    Object[] bbelems = StringUtil.split(value, ",");
                    for (int i = 0; i < bbelems.length; ++i) {
                        String bbelem = bbelems[i];
                        if (!bbelem.startsWith("[")) continue;
                        String dir = bbelem.substring(5, 9);
                        if (dir.equalsIgnoreCase("west")) {
                            bbelems[i] = "" + west;
                            continue;
                        }
                        if (dir.equalsIgnoreCase("sout")) {
                            bbelems[i] = "" + south;
                            continue;
                        }
                        if (dir.equalsIgnoreCase("east")) {
                            bbelems[i] = "" + east;
                            continue;
                        }
                        if (!dir.equalsIgnoreCase("nort")) continue;
                        bbelems[i] = "" + north;
                    }
                    result.append("BBOX=" + StringUtil.join(bbelems, "%2C"));
                    continue;
                }
                if (key.equalsIgnoreCase("width")) {
                    if (value.equalsIgnoreCase("[horizPixels]")) {
                        value = "" + width;
                    }
                    result.append("&width=" + value);
                    continue;
                }
                if (!key.equalsIgnoreCase("height")) continue;
                if (value.equalsIgnoreCase("[vertPixels]")) {
                    value = "" + height;
                }
                result.append("&height=" + value);
            }
            return result.toString();
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlGroundOverlay
    extends kmlOverlay {
        double altitude = 0.0;
        String altitudeMode = "clampToGround";
        double north;
        double south;
        double east;
        double west;
        double rotation = 0.0;

        public double getAltitude() {
            return this.altitude;
        }

        public void setAltitude(double altitude) {
            this.altitude = altitude;
        }

        public String getAltitudeMode() {
            return this.altitudeMode;
        }

        public void setAltitudeMode(String altitudeMode) {
            if (altitudeMode.equalsIgnoreCase("clamptoground")) {
                this.altitudeMode = "clampToGround";
            } else if (altitudeMode.equalsIgnoreCase("relativetoground")) {
                this.altitudeMode = "relativeToGround";
            } else if (altitudeMode.equalsIgnoreCase("absolute")) {
                this.altitudeMode = "absolute";
            } else {
                LayerKML.this.warning("Invalid altitude mode: " + altitudeMode + ". Mode must be 'clampToGround', 'relativeToGround', or 'absolute'");
            }
        }

        public double getNorth() {
            return this.north;
        }

        public void setNorth(double north) {
            this.north = north;
            LayerKML.this.updateYRange(north);
        }

        public double getSouth() {
            return this.south;
        }

        public void setSouth(double south) {
            this.south = south;
            LayerKML.this.updateYRange(south);
        }

        public double getEast() {
            return this.east;
        }

        public void setEast(double east) {
            this.east = east;
            LayerKML.this.updateXRange(east);
        }

        public double getWest() {
            return this.west;
        }

        public void setWest(double west) {
            this.west = west;
            LayerKML.this.updateXRange(west);
        }

        public double getRotation() {
            return this.rotation;
        }

        public void setRotation(double rotation) {
            this.rotation = rotation;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlFolder
    extends kmlContainer {
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlExtendedData
    extends kmlObject {
        String dataName;
        String dataDisplayName;
        String dataValue;
        String schemaDataUrl;
        String simpleDataName;

        public String getDataName() {
            return this.dataName;
        }

        public void setDataName(String dataName) {
            this.dataName = dataName;
        }

        public String getDataDisplayName() {
            return this.dataDisplayName;
        }

        public void setDataDisplayName(String dataDisplayName) {
            this.dataDisplayName = dataDisplayName;
        }

        public String getDataValue() {
            return this.dataValue;
        }

        public void setDataValue(String dataValue) {
            this.dataValue = dataValue;
        }

        public String getSchemaDataUrl() {
            return this.schemaDataUrl;
        }

        public void setSchemaDataUrl(String schemaDataUrl) {
            this.schemaDataUrl = schemaDataUrl;
        }

        public String getSimpleDataName() {
            return this.simpleDataName;
        }

        public void setSimpleDataName(String simpleDataName) {
            this.simpleDataName = simpleDataName;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlDocument
    extends kmlContainer {
        Vector<kmlSchema> schemas;

        public kmlDocument() {
            this.schemas = new Vector();
        }

        public void addSchema(kmlSchema schema) {
            this.schemas.add(schema);
        }

        public Vector<kmlSchema> getSchemas() {
            return this.schemas;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlContainer
    extends kmlFeature {
        Vector<kmlFeature> features;
        Vector<kmlNetworkLink> networkLinks;
        Vector<kmlFolder> folders;
        ArrayList<kmlContainer> subContainers;

        public kmlContainer() {
            this.features = new Vector();
            this.networkLinks = new Vector();
            this.folders = new Vector();
            this.subContainers = new ArrayList();
        }

        public void addFeature(kmlFeature feature) {
            this.features.add(feature);
        }

        @Deprecated
        public kmlNetworkLink getNetworkLink() {
            return this.networkLinks.get(0);
        }

        @Deprecated
        public void setNetworkLink(kmlNetworkLink networkLink) {
            this.addNetworkLink(networkLink);
        }

        public Vector<kmlNetworkLink> getNetworkLinks() {
            return this.networkLinks;
        }

        public void addNetworkLink(kmlNetworkLink link) {
            this.networkLinks.add(link);
        }

        public void addFolder(kmlFolder folder) {
            this.folders.add(folder);
        }

        public Vector<kmlFolder> getFolders() {
            return this.folders;
        }

        public void addSubContainer(kmlContainer cont) {
            this.subContainers.add(cont);
        }

        public ArrayList<kmlContainer> getSubContainers() {
            return this.subContainers;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlCoordinates
    extends kmlObject {
        double lat;
        double lon;
        double alt;

        public kmlCoordinates() {
            this.alt = 0.0;
        }

        public boolean setCoordinates(String coords) {
            int i = coords.indexOf(44);
            int j = coords.indexOf(44, i + 1);
            if (j > 0) {
                this.lon = Double.parseDouble(coords.substring(0, i));
                this.lat = Double.parseDouble(coords.substring(i + 1, j));
                this.alt = Double.parseDouble(coords.substring(j + 1));
            } else if (i > 0) {
                this.lon = Double.parseDouble(coords.substring(0, i));
                this.lat = Double.parseDouble(coords.substring(i + 1));
                this.alt = 0.0;
            } else {
                LayerKML.this.warning("Invalid coordinate set: " + coords);
                return false;
            }
            if (this.lat > 90.0 || this.lat < -90.0 || this.lon > 180.0 || this.lon < -180.0) {
                this.lat = 90.0;
                this.lon = 180.0;
                LayerKML.this.warning("Invalid coordinates set [" + coords + "]. Setting coordinates to lon=" + this.lon + ", lat=" + this.lat);
                return false;
            }
            LayerKML.this.updateXRange(this.lon);
            LayerKML.this.updateYRange(this.lat);
            return true;
        }

        public double getLat() {
            return this.lat;
        }

        public void setLat(double lat) {
            this.lat = lat;
        }

        public double getLon() {
            return this.lon;
        }

        public void setLon(double lon) {
            this.lon = lon;
        }

        public double getAltitude() {
            return this.alt;
        }

        public void setAltitude(double altitude) {
            this.alt = altitude;
        }

        public String toString() {
            String res = "";
            res = res + "lat=" + this.lat;
            res = res + ",lon=" + this.lon + "\n";
            return res;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlColorStyle
    extends kmlObject {
        Color color;
        String colorMode;

        public kmlColorStyle() {
            this.color = Color.white;
            this.colorMode = "normal";
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public String getColorMode() {
            return this.colorMode;
        }

        public void setColorMode(String colorMode) {
            if (colorMode.equalsIgnoreCase("normal")) {
                this.colorMode = "normal";
            } else if (colorMode.equalsIgnoreCase("random")) {
                this.colorMode = "random";
            } else {
                LayerKML.this.warning("Invalid color mode: " + colorMode + ". Mode must be 'normal' or 'random'.");
            }
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlCamera
    extends kmlAbstractView {
        double lon;
        double lat;
        double altitude;
        double heading;
        double tilt;
        double roll;
        String altitudeMode;

        public kmlCamera() {
            this.lon = 0.0;
            this.lat = 0.0;
            this.altitude = 0.0;
            this.heading = 0.0;
            this.tilt = 0.0;
            this.roll = 0.0;
            this.altitudeMode = "clampToGround";
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlBalloonStyle
    extends kmlObject {
        private Color bgColor;
        private Color textColor;
        private String text;
        private String displayMode;

        public kmlBalloonStyle() {
            this.bgColor = Color.white;
            this.textColor = Color.black;
            this.displayMode = "default";
            this.text = new String();
        }

        public Color getBgColor() {
            return this.bgColor;
        }

        public void setBgColor(Color bgColor) {
            this.bgColor = bgColor;
        }

        public Color getTextColor() {
            return this.textColor;
        }

        public void setTextColor(Color textColor) {
            this.textColor = textColor;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getDisplayMode() {
            return this.displayMode;
        }

        public void setDisplayMode(String displayMode) {
            if (displayMode.equalsIgnoreCase("default")) {
                this.displayMode = "default";
            } else if (displayMode.equalsIgnoreCase("hide")) {
                this.displayMode = "hide";
            } else {
                LayerKML.this.warning("Invalid display mode: " + displayMode + ". Mode must be 'hide' or 'default'");
            }
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlAbstractView
    extends kmlObject {
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlGeometry
    extends kmlObject {
        private kmlFeature parentFeature;
        private kmlBalloonStyle balloonStyle;
        private Line line;
        private BufferedImage img;

        public kmlGeometry() {
            this.parentFeature = new kmlFeature();
        }

        public void setParentFeature(kmlFeature feat) {
            this.parentFeature = feat;
        }

        public kmlFeature getParentFeature() {
            return this.parentFeature;
        }

        public kmlBalloonStyle getBalloonStyle() {
            return this.balloonStyle;
        }

        public void setBalloonStyle(kmlBalloonStyle bs) {
            this.balloonStyle = bs;
        }

        public Line getLine() {
            return this.line;
        }

        public void setLine(Line line) {
            this.line = line;
        }

        public BufferedImage getImage() {
            return this.img;
        }

        public void setImage(BufferedImage image) {
            this.img = image;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlFeature
    extends kmlObject {
        String name;
        boolean visibility;
        boolean open;
        String address;
        String phoneNumber;
        String snippet;
        int snippetMaxLines;
        String description;
        kmlTimePrimitive timePrimitive;
        String styleUrl;
        kmlStyleSelector styleSelector;
        kmlRegion region;
        kmlExtendedData extendedData;
        Vector<kmlStyle> styles;
        Vector<kmlStyleMap> styleMaps;
        kmlAbstractView abstractView;

        public kmlFeature() {
            this.visibility = true;
            this.open = false;
            this.snippetMaxLines = 2;
            this.name = new String();
            this.address = new String();
            this.phoneNumber = new String();
            this.snippet = new String();
            this.description = new String();
            this.timePrimitive = new kmlTimePrimitive();
            this.styleUrl = null;
            this.styleSelector = new kmlStyleSelector();
            this.region = new kmlRegion();
            this.extendedData = new kmlExtendedData();
            this.styles = new Vector();
            this.abstractView = new kmlAbstractView();
            this.styleMaps = new Vector();
        }

        public void addStyle(kmlStyle style) {
            this.styles.add(style);
        }

        public Vector<kmlStyle> getStyles() {
            return this.styles;
        }

        public void addStyleMap(kmlStyleMap styleMap) {
            this.styleMaps.add(styleMap);
        }

        public Vector<kmlStyleMap> getStyleMaps() {
            return this.styleMaps;
        }

        public String getStyleUrl() {
            return this.styleUrl;
        }

        public void setStyleUrl(String styleUrl) {
            this.styleUrl = styleUrl;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String n) {
            this.name = n;
        }

        public boolean getVisibility() {
            return this.visibility;
        }

        public void setVisibility(boolean v) {
            this.visibility = v;
        }

        public boolean getOpen() {
            return this.open;
        }

        public void setOpen(boolean o) {
            this.open = o;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String a) {
            this.address = a;
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public void setPhoneNumber(String p) {
            this.phoneNumber = p;
        }

        public int getSnippetMaxLines() {
            return this.snippetMaxLines;
        }

        public void setSnippetMaxLines(int lines) {
            this.snippetMaxLines = lines;
        }

        public String getSnippet() {
            return this.snippet;
        }

        public void setSnippet(String s) {
            this.snippet = s;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String s) {
            this.description = s;
        }

        public kmlTimePrimitive getTimePrimitive() {
            return this.timePrimitive;
        }

        public void setTimePrimitive(kmlTimePrimitive tp) {
            this.timePrimitive = tp;
        }

        public kmlStyleSelector getStyleSelector() {
            return this.styleSelector;
        }

        public void setStyleSelector(kmlStyleSelector ss) {
            this.styleSelector = ss;
        }

        public kmlExtendedData getExtendedData() {
            return this.extendedData;
        }

        public void setExtendedData(kmlExtendedData ed) {
            this.extendedData = ed;
        }

        public kmlRegion getRegion() {
            return this.region;
        }

        public void setRegion(kmlRegion r) {
            this.region = r;
        }

        public kmlAbstractView getAbstractView() {
            return this.abstractView;
        }

        public void setAbstractView(kmlAbstractView abstractView) {
            this.abstractView = abstractView;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlObject {
        String id;
        String targetId;

        public String getId() {
            return this.id;
        }

        public void setId(String i) {
            this.id = i;
        }

        public String getTargetId() {
            return this.targetId;
        }

        public void setTargetId(String t) {
            this.targetId = t;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class kmlObjects {
        private Vector<kmlPlacemark> placemarks = new Vector();
        private Vector<kmlFolder> folders = new Vector();
        private Vector<kmlDocument> documents = new Vector();
        private Vector<kmlNetworkLinkControl> networkLinkControls = new Vector();
        private Vector<kmlGroundOverlay> groundOverlays = new Vector();
        private Vector<kmlNetworkLink> networkLinks = new Vector();

        public void addKmlObject(Object obj) {
            if (obj instanceof kmlPlacemark) {
                this.addPlacemark((kmlPlacemark)obj);
            } else if (obj instanceof kmlDocument) {
                this.addDocument((kmlDocument)obj);
            } else if (obj instanceof kmlFolder) {
                this.addFolder((kmlFolder)obj);
            } else if (obj instanceof kmlNetworkLinkControl) {
                this.addNetworkLinkControl((kmlNetworkLinkControl)obj);
            } else if (obj instanceof kmlGroundOverlay) {
                this.addGroundOverlay((kmlGroundOverlay)obj);
            } else if (obj instanceof kmlNetworkLink) {
                this.addNetworkLink((kmlNetworkLink)obj);
            } else {
                LayerKML.this.warning("Unknown object " + obj.getClass().getSimpleName() + ". Not adding to List");
            }
        }

        public void addPlacemark(kmlPlacemark p) {
            this.placemarks.add(p);
        }

        public void addFolder(kmlFolder folder) {
            this.folders.add(folder);
        }

        public void addDocument(kmlDocument d) {
            this.documents.add(d);
        }

        public void addGroundOverlay(kmlGroundOverlay overlay) {
            this.groundOverlays.add(overlay);
        }

        public void addNetworkLinkControl(kmlNetworkLinkControl control) {
            this.networkLinkControls.add(control);
        }

        public void addNetworkLink(kmlNetworkLink link) {
            this.networkLinks.add(link);
        }

        public String toString() {
            String res = "************************************\n";
            res = res + "placemarks.size()=" + this.placemarks.size();
            res = res + "\nfolders.size()=" + this.folders.size();
            res = res + "\ndocuments.size()=" + this.documents.size();
            res = res + "\nnetworkLinkControls.size()=" + this.networkLinkControls.size();
            res = res + "\ngroundOverlays.size()=" + this.groundOverlays.size();
            res = res + "\nnetworkLinks.size()=" + this.networkLinks.size();
            return res;
        }
    }

    @InternalUseOnly(value="since NeXtMidas 3.5.3")
    public class KmlParser
    extends DefaultHandler {
        int DEBUG = 0;
        boolean processData = false;
        final String kmlFile;
        final LayerKML layer = LayerKML.this;
        String tag = new String();
        Set<String> supElemList = LayerKML.access$1400();
        private Stack<Object> stack = new Stack();
        private Locator locator;
        private kmlObjects kmlObjs;
        boolean hasKmlStartTag = false;
        boolean hasKmlEndTag = false;
        boolean objects = false;
        String parent = new String();
        private HashMap<String, kmlSchema> schemas = new HashMap();

        public KmlParser() {
            PlotFile pf = this.layer != null ? this.layer.getFile() : null;
            this.kmlFile = pf != null ? pf.getURL() : null;
        }

        public void parseKmlFile(InputStream filename) throws Exception {
            XMLReader xr = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            xr.setContentHandler(LayerKML.this.kmlParser);
            xr.setErrorHandler(LayerKML.this.kmlParser);
            try {
                InputStreamReader in = new InputStreamReader(filename);
                if (in != null) {
                    xr.parse(new InputSource(in));
                }
            }
            catch (Exception e) {
                String popupMsg = "Bad KML: " + e.getMessage() + " Click OK to continue Plot (excluding this KML) or Cancel to abort";
                String boo = MJPopup.showOkCancel(LayerKML.this.MP.getPanel(), "Bad KML found.", 2, popupMsg);
                String wmswarn = "LayerKML:" + LayerKML.this.name + " Bad KML " + e.getMessage();
                if (boo == null) {
                    wmswarn = wmswarn + " and cancelling this plot.";
                    LayerKML.this.MP.status = -3;
                    LayerKML.this.MP.MW.refresh();
                } else {
                    wmswarn = wmswarn + " but continuing to plot excluding this KML.";
                }
                this.layer.warning(wmswarn);
                e.printStackTrace();
            }
        }

        @Override
        public void startDocument() {
            if (this.DEBUG > 3) {
                System.out.println("Start document");
            }
        }

        @Override
        public void endDocument() {
            if (!this.hasKmlEndTag) {
                Object obj = null;
                if (!this.stack.isEmpty()) {
                    obj = this.stack.pop();
                }
                if (obj instanceof kmlObjects) {
                    this.layer.warning("Missing KML tags in file " + this.kmlFile + " obj=" + obj);
                    this.addToKml((kmlObjects)obj);
                }
            }
            this.layer.setKmlObjects(this.getKmlObjects());
        }

        public kmlObjects getKmlObjects() {
            return this.kmlObjs;
        }

        @Override
        public void setDocumentLocator(Locator rhs) {
            this.locator = rhs;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            String element;
            if (this.DEBUG > 3) {
                System.out.println("startElement: uri=" + uri + ", localName=" + localName + ", qName = " + qName);
            }
            if ((element = qName.toLowerCase()).equals("url")) {
                element = "link";
            }
            if (this.supElemList.contains(element)) {
                if (!this.hasKmlStartTag || element.equalsIgnoreCase("kml")) {
                    this.kmlObjs = new kmlObjects();
                    this.stack.push(this.kmlObjs);
                    this.hasKmlStartTag = true;
                }
                if (!element.equalsIgnoreCase("kml")) {
                    if (element.equalsIgnoreCase("networklinkcontrol")) {
                        this.stack.push(new kmlNetworkLinkControl());
                    } else if (element.equalsIgnoreCase("networklink")) {
                        this.stack.push(new kmlNetworkLink());
                    } else if (element.equalsIgnoreCase("link")) {
                        this.stack.push(new kmlLink());
                    } else if (element.equals("document")) {
                        this.stack.push(new kmlDocument());
                    } else if (element.equals("schema")) {
                        kmlSchema schema = new kmlSchema();
                        this.stack.push(schema);
                        for (int xx = 0; xx < attributes.getLength(); ++xx) {
                            String attr = attributes.getLocalName(xx).toLowerCase();
                            if (attr.equals("name")) {
                                String name = attributes.getValue(xx).toLowerCase();
                                schema.setName(name);
                                this.schemas.put(name, schema);
                                this.supElemList.add(name);
                                continue;
                            }
                            if (!attr.equals("parent")) continue;
                            schema.setParent(attributes.getValue(xx).toLowerCase());
                        }
                    } else if (element.equalsIgnoreCase("folder")) {
                        this.stack.push(new kmlFolder());
                    } else if (element.equals("placemark")) {
                        this.stack.push(new kmlPlacemark());
                    } else if (element.equals("multigeometry")) {
                        this.stack.push(new kmlMultiGeometry());
                    } else if (element.equals("point")) {
                        Object obj = this.stack.peek();
                        if (!(obj instanceof kmlFeature)) {
                            Object tmpObj = this.stack.pop();
                            obj = this.stack.peek();
                            this.stack.push(tmpObj);
                        }
                        this.stack.push(new kmlPoint(obj));
                    } else if (element.equals("polygon")) {
                        this.stack.push(new kmlPolygon());
                    } else if (element.equals("linearring")) {
                        this.stack.push(new kmlLinearRing());
                    } else if (element.equals("linestring")) {
                        this.stack.push(new kmlLineString());
                    } else if (element.equals("outerboundaryis")) {
                        ((kmlPolygon)this.stack.peek()).setOuter(true);
                    } else if (element.equalsIgnoreCase("groundoverlay")) {
                        this.stack.push(new kmlGroundOverlay());
                    } else if (element.equals("lookat")) {
                        this.stack.push(new kmlLookAt());
                    } else if (element.equals("polystyle")) {
                        this.stack.push(new kmlPolyStyle());
                    } else if (element.equals("style")) {
                        this.stack.push(new kmlStyle());
                        for (int xx = 0; xx < attributes.getLength(); ++xx) {
                            if (!attributes.getLocalName(xx).equalsIgnoreCase("id")) continue;
                            ((kmlStyle)this.stack.peek()).setId(attributes.getValue(xx));
                        }
                    } else if (element.equals("stylemap")) {
                        this.stack.push(new kmlStyleMap());
                        for (int xx = 0; xx < attributes.getLength(); ++xx) {
                            if (!attributes.getLocalName(xx).equalsIgnoreCase("id")) continue;
                            ((kmlStyleMap)this.stack.peek()).setId(attributes.getValue(xx));
                        }
                    } else if (element.equals("pair")) {
                        this.stack.push(new kmlStyleMapPair());
                    } else if (element.equals("labelstyle")) {
                        this.stack.push(new kmlLabelStyle());
                    } else if (element.equals("linestyle")) {
                        this.stack.push(new kmlLineStyle());
                    } else if (element.equals("iconstyle")) {
                        this.stack.push(new kmlIconStyle());
                    } else if (element.equals("balloonstyle")) {
                        this.stack.push(new kmlBalloonStyle());
                    } else if (element.equals("icon")) {
                        this.stack.push(new kmlIcon());
                    } else if (!element.equals("latlonbox")) {
                        if (this.schemas.keySet().contains(element)) {
                            if (this.schemas.get((Object)element).parent.equals("placemark")) {
                                this.stack.push(new kmlPlacemark());
                            }
                        } else {
                            this.stack.push(new StringBuffer());
                            this.processData = true;
                        }
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String rawName) {
            this.processData = false;
            String element = rawName.toLowerCase();
            if (element.equals("url")) {
                element = "link";
            }
            if (this.supElemList.contains(element) && !element.equals("outerboundaryis")) {
                Object obj = this.stack.pop();
                obj = StringUtil.trimIfString(obj);
                if (!element.equals("kml")) {
                    this.parent = this.stack.peek().getClass().getName();
                    int i = this.parent.indexOf("$");
                    this.parent = this.parent.substring(i + 4).toLowerCase();
                }
                if (element.equals("kml")) {
                    this.hasKmlEndTag = true;
                    this.addToKml((kmlObjects)obj);
                } else if (element.equals("networklink")) {
                    this.addToContainer(element, obj);
                } else if (element.equals("style")) {
                    this.addToFeature(element, obj);
                } else if (element.equals("stylemap")) {
                    this.addToFeature(element, obj);
                } else if (this.parent.equals("stylemap")) {
                    this.addToStyleMap(element, obj);
                } else if (this.parent.equals("stylemappair")) {
                    this.addToPair(element, obj);
                } else if (this.parent.equals("objects")) {
                    this.addToKmlObjects(obj);
                } else if (this.parent.equals("networklinkcontrol")) {
                    this.addToNetworkLinkControl(element, obj);
                } else if (this.parent.equals("networklink")) {
                    this.addToNetworkLink(element, obj);
                } else if (this.parent.equals("link")) {
                    this.addToLink(element, obj);
                } else if (this.parent.equals("document")) {
                    this.addToDocument(element, obj);
                } else if (this.parent.equals("folder")) {
                    this.addToFolder(element, obj);
                } else if (this.parent.equals("placemark")) {
                    this.addToPlacemark(element, obj);
                } else if (this.parent.equals("multigeometry")) {
                    this.addToMultiGeometry(element, obj);
                } else if (this.parent.equals("point")) {
                    this.addToPoint(element, obj);
                } else if (this.parent.equals("polygon")) {
                    this.addToPolygon(element, obj);
                } else if (this.parent.equals("linearring")) {
                    this.addToLinearRing(element, obj);
                } else if (this.parent.equals("linestring")) {
                    this.addToLineString(element, obj);
                } else if (this.parent.equals("groundoverlay")) {
                    this.addToGroundOverlay(element, obj);
                } else if (this.parent.equals("lookat")) {
                    this.addToLookAt(element, obj);
                } else if (this.parent.equals("polystyle")) {
                    this.addToPolyStyle(element, obj);
                } else if (this.parent.equals("style")) {
                    this.addToStyle(element, obj);
                } else if (this.parent.equals("labelstyle")) {
                    this.addToLabelStyle(element, obj);
                } else if (this.parent.equals("linestyle")) {
                    this.addToLineStyle(element, obj);
                } else if (this.parent.equals("iconstyle")) {
                    this.addToIconStyle(element, obj);
                } else if (this.parent.equals("balloonstyle")) {
                    this.addToBalloonStyle(element, obj);
                } else if (this.parent.equals("icon")) {
                    this.addToIcon(element, obj);
                } else if (this.parent.equals("schema")) {
                    this.addToSchema(element, obj);
                }
            }
        }

        private void addToKml(kmlObjects obj) {
            this.kmlObjs = obj;
            this.objects = true;
        }

        private void addToKmlObjects(Object obj) {
            ((kmlObjects)this.stack.peek()).addKmlObject(obj);
        }

        private void addToNetworkLinkControl(String element, Object obj) {
            if (element.equals("minrefreshperiod")) {
                ((kmlNetworkLinkControl)this.stack.peek()).setMinRefreshPeriod(Float.parseFloat(obj.toString()));
            } else if (element.equals("lookat")) {
                ((kmlNetworkLinkControl)this.stack.peek()).setAbstractView((kmlLookAt)obj);
            }
        }

        private void addToNetworkLink(String element, Object obj) {
            if (element.equals("link")) {
                ((kmlNetworkLink)this.stack.peek()).setLink((kmlLink)obj);
            } else if (element.equals("styleurl")) {
                ((kmlNetworkLink)this.stack.peek()).setStyleUrl(obj.toString());
            } else if (element.equals("name")) {
                ((kmlNetworkLink)this.stack.peek()).setName(obj.toString());
            }
        }

        private void addToLink(String element, Object obj) {
            if (element.equals("refreshinterval")) {
                ((kmlLink)this.stack.peek()).setRefreshInterval(Float.parseFloat(obj.toString()));
            } else if (element.equals("refreshmode")) {
                ((kmlLink)this.stack.peek()).setRefreshMode(obj.toString());
            } else if (element.equals("href")) {
                ((kmlLink)this.stack.peek()).setHref(obj.toString());
            }
        }

        private void addToDocument(String element, Object obj) {
            if (element.equals("folder")) {
                ((kmlDocument)this.stack.peek()).addFeature((kmlFolder)obj);
            } else if (element.equals("placemark")) {
                ((kmlDocument)this.stack.peek()).addFeature((kmlPlacemark)obj);
            } else if (element.equals("groundoverlay")) {
                ((kmlDocument)this.stack.peek()).addFeature((kmlGroundOverlay)obj);
            } else if (element.equals("visibility")) {
                boolean booTmp = !LayerKML.isKMLFalse(obj.toString());
                ((kmlDocument)this.stack.peek()).setVisibility(booTmp);
            } else if (element.equals("styleurl")) {
                String styleId = obj.toString();
                if (styleId.startsWith("#")) {
                    styleId = styleId.substring(1);
                }
                ((kmlDocument)this.stack.peek()).setStyleUrl(styleId);
            } else if (element.equals("name")) {
                ((kmlDocument)this.stack.peek()).setName(obj.toString());
            } else if (element.equals("description")) {
                ((kmlDocument)this.stack.peek()).setDescription(obj.toString());
            } else if (this.schemas.keySet().contains(element)) {
                this.addToDocument(this.schemas.get((Object)element).parent, obj);
            }
        }

        private void addToFolder(String element, Object obj) {
            if (element.equals("folder")) {
                ((kmlFolder)this.stack.peek()).addFolder((kmlFolder)obj);
            } else if (element.equals("document")) {
                ((kmlFolder)this.stack.peek()).addFeature((kmlDocument)obj);
            } else if (element.equals("placemark")) {
                ((kmlFolder)this.stack.peek()).addFeature((kmlPlacemark)obj);
            } else if (element.equals("groundoverlay")) {
                ((kmlFolder)this.stack.peek()).addFeature((kmlGroundOverlay)obj);
            } else if (element.equals("visibility")) {
                boolean booTmp = !LayerKML.isKMLFalse(obj.toString());
                ((kmlFolder)this.stack.peek()).setVisibility(booTmp);
            } else if (element.equals("styleurl")) {
                String styleId = obj.toString();
                if (styleId.startsWith("#")) {
                    styleId = styleId.substring(1);
                }
                ((kmlFolder)this.stack.peek()).setStyleUrl(styleId);
            } else if (element.equals("name")) {
                ((kmlFolder)this.stack.peek()).setName(obj.toString());
            }
        }

        private void addToSchema(String element, Object obj) {
        }

        private void addToPlacemark(String element, Object obj) {
            if (element.equals("multigeometry")) {
                ((kmlPlacemark)this.stack.peek()).setGeometry((kmlMultiGeometry)obj);
            } else if (element.equals("polygon")) {
                ((kmlPlacemark)this.stack.peek()).setGeometry((kmlPolygon)obj);
            } else if (element.equals("point")) {
                ((kmlPlacemark)this.stack.peek()).setGeometry((kmlPoint)obj);
            } else if (element.equals("linearring")) {
                ((kmlPlacemark)this.stack.peek()).setGeometry((kmlLinearRing)obj);
            } else if (element.equals("linestring")) {
                ((kmlPlacemark)this.stack.peek()).setGeometry((kmlLineString)obj);
            } else if (element.equals("styleurl")) {
                String styleId = obj.toString();
                if (styleId.startsWith("#")) {
                    styleId = styleId.substring(1);
                }
                ((kmlPlacemark)this.stack.peek()).setStyleUrl(styleId);
            } else if (element.equals("name")) {
                ((kmlPlacemark)this.stack.peek()).setName(obj.toString());
            } else if (element.equals("description")) {
                ((kmlPlacemark)this.stack.peek()).setDescription(obj.toString());
            }
        }

        private void addToMultiGeometry(String element, Object obj) {
            if (element.equals("polygon")) {
                ((kmlMultiGeometry)this.stack.peek()).addGeometry((kmlPolygon)obj);
            } else if (element.equals("point")) {
                ((kmlMultiGeometry)this.stack.peek()).addGeometry((kmlPoint)obj);
            } else if (element.equals("linearring")) {
                ((kmlMultiGeometry)this.stack.peek()).addGeometry((kmlLinearRing)obj);
            } else if (element.equals("linestring")) {
                ((kmlMultiGeometry)this.stack.peek()).addGeometry((kmlGeometry)obj);
            }
        }

        private void addToPoint(String element, Object obj) {
            if (element.equals("extrude")) {
                boolean boo = LayerKML.isKMLTrue(obj.toString());
                ((kmlPoint)this.stack.peek()).setExtrude(boo);
            } else if (element.equals("coordinates")) {
                ((kmlPoint)this.stack.peek()).setCoordinates(obj.toString());
            }
        }

        private void addToPolygon(String element, Object obj) {
            if (element.equals("linearring")) {
                if (((kmlPolygon)this.stack.peek()).isOuter()) {
                    ((kmlPolygon)this.stack.peek()).setOuterBoundary((kmlLinearRing)obj);
                    ((kmlPolygon)this.stack.peek()).setOuter(false);
                } else {
                    ((kmlPolygon)this.stack.peek()).addInnerBoundary((kmlLinearRing)obj);
                }
            } else if (element.equals("extrude")) {
                boolean boo = LayerKML.isKMLTrue(obj.toString());
                ((kmlPolygon)this.stack.peek()).setExtrude(boo);
            } else if (element.equals("altitudemode")) {
                ((kmlPolygon)this.stack.peek()).setAltitudeMode(obj.toString());
            } else if (element.equals("tessellate")) {
                boolean boo = LayerKML.isKMLTrue(obj.toString());
                ((kmlPolygon)this.stack.peek()).setTessellate(boo);
            } else if (element.equals("coordinates")) {
                ((kmlPolygon)this.stack.peek()).addCoordinates(obj.toString());
            }
        }

        private void addToLinearRing(String element, Object obj) {
            if (element.equals("extrude")) {
                boolean boo = LayerKML.isKMLTrue(obj.toString());
                ((kmlLinearRing)this.stack.peek()).setExtrude(boo);
            } else if (element.equals("coordinates")) {
                ((kmlLinearRing)this.stack.peek()).setCoordsVector(obj.toString());
            }
        }

        private void addToLineString(String element, Object obj) {
            if (element.equals("extrude")) {
                boolean boo = LayerKML.isKMLTrue(obj.toString());
                ((kmlLineString)this.stack.peek()).setExtrude(boo);
            } else if (element.equals("coordinates")) {
                ((kmlLineString)this.stack.peek()).setCoordsVector(obj.toString());
            }
        }

        private void addToGroundOverlay(String element, Object obj) {
            if (element.equals("north")) {
                ((kmlGroundOverlay)this.stack.peek()).setNorth(Double.parseDouble(obj.toString()));
            } else if (element.equals("south")) {
                ((kmlGroundOverlay)this.stack.peek()).setSouth(Double.parseDouble(obj.toString()));
            } else if (element.equals("east")) {
                ((kmlGroundOverlay)this.stack.peek()).setEast(Double.parseDouble(obj.toString()));
            } else if (element.equals("west")) {
                ((kmlGroundOverlay)this.stack.peek()).setWest(Double.parseDouble(obj.toString()));
            } else if (element.equals("rotation")) {
                ((kmlGroundOverlay)this.stack.peek()).setRotation(Double.parseDouble(obj.toString()));
            } else if (element.equals("icon")) {
                ((kmlOverlay)this.stack.peek()).setIcon((kmlIcon)obj);
            } else if (element.equals("color")) {
                Color newColor = this.toColor(obj);
                ((kmlGroundOverlay)this.stack.peek()).setColor(newColor);
            }
        }

        private void addToLookAt(String element, Object obj) {
            if (element.equals("longitude")) {
                ((kmlLookAt)this.stack.peek()).setLon(Double.parseDouble(obj.toString()));
            } else if (element.equals("latitude")) {
                ((kmlLookAt)this.stack.peek()).setLat(Double.parseDouble(obj.toString()));
            } else if (element.equals("altitude")) {
                ((kmlLookAt)this.stack.peek()).setAlt(Double.parseDouble(obj.toString()));
            } else if (element.equals("heading")) {
                ((kmlLookAt)this.stack.peek()).setHeading(Double.parseDouble(obj.toString()));
            } else if (element.equals("range")) {
                ((kmlLookAt)this.stack.peek()).setRange(Double.parseDouble(obj.toString()));
            } else if (element.equals("tilt")) {
                ((kmlLookAt)this.stack.peek()).setTilt(Double.parseDouble(obj.toString()));
            }
        }

        private Color toColor(Object obj) {
            String color = obj.toString().toUpperCase();
            if (!color.startsWith("#") && !color.startsWith("0X")) {
                try {
                    color = "0X" + color;
                    Color newColor = MColor.BGRtoRGB(MColor.getColor(color));
                    return newColor;
                }
                catch (Exception e) {
                    color = obj.toString().toUpperCase();
                    return MColor.getColor(color);
                }
            }
            return MColor.BGRtoRGB(MColor.getColor(color));
        }

        private void addToPolyStyle(String element, Object obj) {
            if (element.equals("fill")) {
                boolean booTmp = !LayerKML.isKMLFalse(obj.toString());
                ((kmlPolyStyle)this.stack.peek()).setFill(booTmp);
            } else if (element.equals("outline")) {
                boolean booTmp = !LayerKML.isKMLFalse(obj.toString());
                ((kmlPolyStyle)this.stack.peek()).setOutline(booTmp);
            } else if (element.equals("color")) {
                Color newColor = this.toColor(obj);
                ((kmlPolyStyle)this.stack.peek()).setColor(newColor);
            }
        }

        private void addToStyleMap(String element, Object obj) {
            if (element.equals("pair")) {
                ((kmlStyleMap)this.stack.peek()).setStyleMapPair((kmlStyleMapPair)obj);
            }
        }

        private void addToPair(String element, Object obj) {
            if (element.equals("key")) {
                ((kmlStyleMapPair)this.stack.peek()).setKey(obj.toString());
            } else if (element.equals("styleurl")) {
                String val = obj.toString();
                if (val.startsWith("#")) {
                    val = val.substring(1);
                }
                ((kmlStyleMapPair)this.stack.peek()).setStyleUrl(val);
            }
        }

        private void addToStyle(String element, Object obj) {
            if (element.equals("linestyle")) {
                ((kmlStyle)this.stack.peek()).setLineStyle((kmlLineStyle)obj);
            } else if (element.equals("labelstyle")) {
                ((kmlStyle)this.stack.peek()).setLabelStyle((kmlLabelStyle)obj);
            } else if (element.equals("polystyle")) {
                ((kmlStyle)this.stack.peek()).setPolyStyle((kmlPolyStyle)obj);
            } else if (element.equals("iconstyle")) {
                ((kmlStyle)this.stack.peek()).setIconStyle((kmlIconStyle)obj);
            } else if (element.equals("balloonstyle")) {
                ((kmlStyle)this.stack.peek()).setBalloonStyle((kmlBalloonStyle)obj);
            }
        }

        private void addToLabelStyle(String element, Object obj) {
            if (element.equals("color")) {
                Color newColor = this.toColor(obj);
                ((kmlLabelStyle)this.stack.peek()).setColor(newColor);
            } else if (element.equals("scale")) {
                ((kmlLabelStyle)this.stack.peek()).setScale(Float.parseFloat(obj.toString()));
            }
        }

        private void addToLineStyle(String element, Object obj) {
            if (element.equals("color")) {
                Color newColor = this.toColor(obj);
                ((kmlLineStyle)this.stack.peek()).setColor(newColor);
            } else if (element.equals("width")) {
                ((kmlLineStyle)this.stack.peek()).setWidth(Float.parseFloat(obj.toString()));
            }
        }

        private void addToIconStyle(String element, Object obj) {
            if (element.equals("icon")) {
                ((kmlIconStyle)this.stack.peek()).setIcon((kmlIcon)obj);
            } else if (element.equals("color")) {
                Color newColor = this.toColor(obj);
                ((kmlIconStyle)this.stack.peek()).setColor(newColor);
            } else if (element.equals("heading")) {
                ((kmlIconStyle)this.stack.peek()).setHeading(Float.parseFloat(obj.toString()));
            } else if (element.equals("scale")) {
                ((kmlIconStyle)this.stack.peek()).setScale(Float.parseFloat(obj.toString()));
            }
        }

        private void addToBalloonStyle(String element, Object obj) {
            if (element.equals("bgcolor")) {
                Color color = this.toColor(obj);
                ((kmlBalloonStyle)this.stack.peek()).setBgColor(color);
            } else if (element.equals("textcolor")) {
                Color color = this.toColor(obj);
                ((kmlBalloonStyle)this.stack.peek()).setTextColor(color);
            } else if (element.equals("text")) {
                ((kmlBalloonStyle)this.stack.peek()).setText(obj.toString());
            } else if (element.equals("displaymode")) {
                ((kmlBalloonStyle)this.stack.peek()).setDisplayMode(obj.toString());
            }
        }

        private void addToIcon(String element, Object obj) {
            if (element.equals("href")) {
                ((kmlIcon)this.stack.peek()).setHref(obj.toString());
            } else if (element.equals("viewformat")) {
                ((kmlIcon)this.stack.peek()).setViewFormat(obj.toString());
            }
        }

        private void addToContainer(String element, Object obj) {
            if (element.equals("networklink")) {
                if (this.stack.peek() instanceof kmlContainer) {
                    ((kmlContainer)this.stack.peek()).addNetworkLink((kmlNetworkLink)obj);
                } else if (this.stack.peek() instanceof kmlObjects) {
                    ((kmlObjects)this.stack.peek()).addNetworkLink((kmlNetworkLink)obj);
                }
            }
        }

        private void addToFeature(String element, Object obj) {
            Object parent = this.stack.peek();
            if (parent instanceof kmlSchema) {
                this.addToSchema(element, obj);
                return;
            }
            if (element.equals("style")) {
                ((kmlFeature)parent).addStyle((kmlStyle)obj);
            } else if (element.equals("lookat")) {
                ((kmlFeature)parent).setAbstractView((kmlLookAt)obj);
            } else if (element.equals("stylemap")) {
                ((kmlFeature)parent).addStyleMap((kmlStyleMap)obj);
            }
        }

        @Deprecated
        public int convertColor(int kmlColor) {
            return MColor.BGRtoRGB(kmlColor);
        }

        @Deprecated
        public Color convertColor(Color kmlColor) {
            return MColor.BGRtoRGB(kmlColor);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.processData) {
                if (this.DEBUG > 1) {
                    System.out.println("Adding char data to StringBuffer");
                }
                ((StringBuffer)this.stack.peek()).append(ch, start, length);
            }
        }
    }

    private class KmlImage
    extends kmlObject {
        BufferedImage img;
        double north;
        double south;
        double east;
        double west;
        String href;

        public KmlImage(BufferedImage img, double north, double south, double east, double west, String href) {
            this.img = img;
            this.north = north;
            this.south = south;
            this.east = east;
            this.west = west;
            this.href = href;
        }

        public String toString() {
            String res = "";
            res = res + "north = " + this.north;
            res = res + ",south = " + this.south;
            res = res + ",east = " + this.east;
            res = res + ",west = " + this.west;
            res = res + ",href=" + this.href;
            return res;
        }
    }
}

