/*
 * Decompiled with CFR 0.152.
 */
package nxm.sys.libg;

import java.awt.Color;
import nxm.sys.inc.Constants;
import nxm.sys.inc.InternalUseOnly;
import nxm.sys.lib.Convert;
import nxm.sys.lib.Data;
import nxm.sys.lib.Parser;
import nxm.sys.lib.Position;
import nxm.sys.lib.Shell;
import nxm.sys.lib.StateVector;
import nxm.sys.lib.Table;
import nxm.sys.lib.Transform;
import nxm.sys.libg.ContourHighPrecision;
import nxm.sys.libg.Layer;
import nxm.sys.libg.Line;
import nxm.sys.libg.MColor;
import nxm.sys.libg.MPlot;
import nxm.sys.libg.MPoint;

public class LayerGeo
extends Layer
implements Constants {
    public static final String sitemodeList = "Current,Offset,Fixed";
    public static final String svecmodeList = "Current,Offset,Fixed";
    public static final int CURRENT = 1;
    public static final int OFFSET = 2;
    public static final int FIXED = 3;
    public static final String predictReferenceList = "SITE,VEH";
    private int PREDICT_REF_SITE = 1;
    private int PREDICT_REF_VEH = 2;
    private int predictReference = this.PREDICT_REF_SITE;
    public static final String tdoamodeList = "Line,Contour,Region,None";
    public static final String fdoamodeList = "Line,Contour,Region,None";
    public static final int LINE = 1;
    public static final int CONTOUR = 2;
    public static final int REGION = 3;
    public static final int NONE = 4;
    public static final String flagsList = "LightTimeCorr,DownLink,Horizon,Markers,AutoTFdoa,ReadOut,FootPrint,HorizonAlt";
    public static final int LTC = 1;
    public static final int DOWNLINK = 2;
    public static final int HORIZON = 4;
    public static final int MARKERS = 8;
    public static final int AUTOTF = 16;
    public static final int READOUT = 32;
    public static final int FOOTPRINT = 64;
    @InternalUseOnly
    public static final int HORIZONALT = 128;
    private static final Color T5_COLOR;
    public static final Color DEFAULT_SITE_COLOR;
    public static final Color DEFAULT_TARGET_COLOR;
    public static final Color DEFAULT_HORIZON_COLOR;
    @InternalUseOnly
    public static final Color DEFAULT_HORIZONALT_COLOR;
    public static final Color DEFAULT_FOOTPRINT_COLOR;
    public static final Color DEFAULT_TDOA_COLOR;
    public static final Color DEFAULT_FDOA_COLOR;
    public static final Color DEFAULT_SVA_COLOR;
    public static final Color DEFAULT_SVB_COLOR;
    public static final int DEFAULT_X_GRID_SIZE = 96;
    public static final int DEFAULT_Y_GRID_SIZE = 64;
    private int flags = 31;
    private boolean drawConeToTarget = true;
    private int sitemode = 1;
    private int svecmode = 1;
    private int tdoamode = 1;
    private int fdoamode = 1;
    private Position pos;
    private Position siteA;
    private Position siteB;
    private Position pointPosA;
    private Position pointPosB;
    private StateVector sva;
    private StateVector svb;
    private String svaLabel = "A";
    private String svbLabel = "B";
    private String siteLabelA = "SITE";
    private String siteLabelB = "SITEB";
    private String targetLabel = "T";
    private double cep = 0.0;
    private double tdoa = 0.0;
    private double dtdoa = -20.0;
    private double fdoa = 0.0;
    private double dfdoa = -20.0;
    private double flinkt = 1000000.0;
    private double flinka = 1000000.0;
    private double flinkb = 1000000.0;
    private int conic = 5;
    private int cdiv = 60;
    private double cangleA;
    private double cangleB = this.cangleA = 1.0;
    private double crange = -1.0;
    private double horizonAlt = 0.0;
    private Color colorTarget = DEFAULT_TARGET_COLOR;
    private Color colorSiteA = DEFAULT_SITE_COLOR;
    private Color colorSiteB = DEFAULT_SITE_COLOR;
    private Color colorFootPrintA = DEFAULT_FOOTPRINT_COLOR;
    private Color colorFootPrintB = DEFAULT_FOOTPRINT_COLOR;
    private Color colorHorizonA = DEFAULT_HORIZON_COLOR;
    private Color colorHorizonB = DEFAULT_HORIZON_COLOR;
    private Color colorHznAtAltA = DEFAULT_HORIZONALT_COLOR;
    private Color colorHznAtAltB = DEFAULT_HORIZONALT_COLOR;
    private Color colorTDOA = DEFAULT_TDOA_COLOR;
    private Color colorFDOA = DEFAULT_FDOA_COLOR;
    private Color colorSVA = DEFAULT_SVA_COLOR;
    private Color colorSVB = DEFAULT_SVB_COLOR;
    private double[] tdoabuf;
    private double[] fdoabuf;
    private double[] aoaabuf;
    private double[] aoabbuf;
    private MPoint pix;
    private double tmin;
    private double fmin;
    private double tmax;
    private double fmax;
    private double gx1;
    private double gxd;
    private double gx2;
    private double gy1;
    private double gyd;
    private double gy2;
    private double pgx1 = 0.0;
    private double pgx2 = 0.0;
    private double pgy1 = 0.0;
    private double pgy2 = 0.0;
    private ContourHighPrecision contour = new ContourHighPrecision();
    private static boolean horizonAltTraditionalCode;

    public LayerGeo() {
        this.name = "GEO";
        this.colors = MColor.getColorMap(7, -1);
        this.findRange();
        this.setGridSize(96, 64);
        this.pix = new MPoint();
        this.pos = new Position(1);
        this.siteA = new Position(1);
        this.siteB = null;
        this.pointPosA = new Position(1);
        this.pointPosB = new Position(1);
        this.sva = new StateVector();
        this.svb = new StateVector();
        this.enable &= 0xFFFFFFFB;
        this.targetLabel = this.name;
    }

    @Override
    public void findRange() {
        this.x1 = -180.0;
        this.x2 = 180.0;
        this.y1 = -90.0;
        this.y2 = 90.0;
        this.a1 = this.y1;
        this.a2 = this.y2;
    }

    @Override
    public void process() {
        Position tpos = new Position();
        Predict pre = new Predict();
        if ((this.flags & 0x10) != 0) {
            this.pos.geo2car();
            this.predict(this.pos, pre);
            this.tdoa = pre.tdoa;
            this.fdoa = pre.fdoa;
        }
        this.fmin = 1.0E20;
        this.tmin = 1.0E20;
        this.fmax = -1.0E20;
        this.tmax = -1.0E20;
        this.gxd = (this.gx2 - this.gx1) / (double)(this.frame - 1);
        this.gyd = (this.gy2 - this.gy1) / (double)(this.size - 1);
        int i = 0;
        for (int iy = 0; iy < this.size; ++iy) {
            tpos.lat = this.gy1 + (double)iy * this.gyd;
            for (int ix = 0; ix < this.frame; ++ix) {
                tpos.lon = this.gx1 + (double)ix * this.gxd;
                tpos.geo2car();
                this.predict(tpos, pre);
                if (pre.tdoa > this.tmax) {
                    this.tmax = pre.tdoa;
                }
                if (pre.tdoa < this.tmin) {
                    this.tmin = pre.tdoa;
                }
                if (pre.fdoa > this.fmax) {
                    this.fmax = pre.fdoa;
                }
                if (pre.fdoa < this.fmin) {
                    this.fmin = pre.fdoa;
                }
                this.tdoabuf[i] = pre.tdoa;
                this.fdoabuf[i] = pre.fdoa;
                this.aoaabuf[i] = pre.aoaa;
                this.aoabbuf[i] = pre.aoab;
                ++i;
            }
        }
        this.pgx1 = this.gx1;
        this.pgy1 = this.gy1;
        this.pgx2 = this.gx2;
        this.pgy2 = this.gy2;
    }

    @Override
    public void draw(int flag) {
        int nd;
        double d;
        double dd;
        boolean redo = this.needRefresh;
        super.draw(flag);
        double[] box = this.MP.view == 14 ? this.MP.getXYGrid(this.MP.getOuterXMin(), this.MP.getOuterXMax(), this.y1, this.y2) : this.MP.getXYGrid(this.x1, this.x2, this.y1, this.y2);
        this.gx1 = box[0];
        this.gx2 = box[1];
        this.gy1 = box[2];
        this.gy2 = box[3];
        if (this.gx2 <= this.gx1 || this.gy2 <= this.gy1) {
            return;
        }
        if (this.gx1 != this.pgx1 || this.gx2 != this.pgx2 || this.gy1 != this.pgy1 || this.gy2 != this.pgy2) {
            redo = true;
        }
        if (redo) {
            this.process();
        }
        Line lin = this.line.copy();
        this.contour.setXAxis(this.gx1, this.gxd, this.frame);
        this.contour.setYAxis(this.gy1, this.gyd, this.size);
        if ((this.flags & 4) != 0) {
            this.drawContour(lin, 0.0, this.colorHorizonA, this.aoaabuf);
            if ((this.flags & 0x80) != 0 && this.horizonAlt > 0.0) {
                this.drawHznAtAlt(this.colorHznAtAltA, this.sva);
            }
            this.drawContour(lin, 0.0, this.colorHorizonB, this.aoabbuf);
            if ((this.flags & 0x80) != 0 && this.horizonAlt > 0.0) {
                this.drawHznAtAlt(this.colorHznAtAltB, this.svb);
            }
        }
        if (this.tdoamode == 1) {
            dd = 1.0;
            d = this.tdoa;
            nd = 1;
        } else if (this.tdoamode == 3) {
            dd = this.dtdoa;
            d = this.tdoa - dd / 2.0;
            nd = 2;
        } else if (this.tdoamode != 2) {
            dd = 1.0;
            d = 1.0;
            nd = 0;
        } else if (this.dtdoa > 0.0) {
            dd = this.dtdoa;
            d = dd * Math.ceil(this.tmin / dd);
            nd = (int)((this.tmax - d) / dd);
        } else {
            dd = (this.tmax - this.tmin + 1.0E-10) / Math.max(2.0, -this.dtdoa);
            d = dd * Math.ceil(this.tmin / dd);
            nd = (int)(-this.dtdoa);
        }
        int n = 0;
        while (n < nd) {
            this.drawContour(lin, d, this.colorTDOA, this.tdoabuf);
            ++n;
            d += dd;
        }
        if (this.fdoamode == 1) {
            dd = 1.0;
            d = this.fdoa;
            nd = 1;
        } else if (this.fdoamode == 3) {
            dd = this.dfdoa;
            d = this.fdoa - dd / 2.0;
            nd = 2;
        } else if (this.fdoamode != 2) {
            dd = 1.0;
            d = 1.0;
            nd = 0;
        } else if (this.dfdoa > 0.0) {
            dd = this.dfdoa;
            d = dd * Math.ceil(this.fmin / dd);
            nd = (int)((this.fmax - d) / dd);
        } else {
            dd = (this.fmax - this.fmin + 1.0E-10) / Math.max(2.0, -this.dfdoa);
            d = dd * Math.ceil(this.fmin / dd);
            nd = (int)(-this.dfdoa);
        }
        n = 0;
        while (n < nd) {
            this.drawContour(lin, d, this.colorFDOA, this.fdoabuf);
            ++n;
            d += dd;
        }
        if ((this.flags & 0x40) != 0 && this.conic > 0) {
            if (this.drawConeToTarget) {
                lin.setColor(this.colorFootPrintA);
                this.MP.drawCone(this.pos, (Position)this.sva, this.conic, this.cdiv, this.cangleA, this.crange, lin, true);
                lin.setColor(this.colorFootPrintB);
                this.MP.drawCone(this.pos, (Position)this.svb, this.conic, this.cdiv, this.cangleB, this.crange, lin, true);
            } else {
                lin.setColor(this.colorFootPrintA);
                this.MP.drawCone(this.pointPosA, (Position)this.sva, this.conic, this.cdiv, this.cangleA, this.crange, lin, true);
                lin.setColor(this.colorFootPrintB);
                this.MP.drawCone(this.pointPosB, (Position)this.svb, this.conic, this.cdiv, this.cangleB, this.crange, lin, true);
            }
        }
        if ((this.flags & 8) != 0) {
            this.MP.setColor(this.colorTarget);
            if (this.MP.getPoint(this.pos, this.pix) > 0) {
                this.drawPoint(lin, this.pix, this.targetLabel);
            }
            this.MP.setColor(this.colorSiteA);
            if (this.MP.getPoint(this.siteA, this.pix) > 0) {
                this.drawPoint(lin, this.pix, this.siteLabelA);
            }
            if (this.siteB != null) {
                this.MP.setColor(this.colorSiteB);
                if (this.MP.getPoint(this.siteB, this.pix) > 0) {
                    this.drawPoint(lin, this.pix, this.siteLabelB);
                }
            }
            this.MP.setColor(this.colorSVA);
            if (this.MP.getPoint((Position)this.sva, this.pix) > 0) {
                this.drawPoint(lin, this.pix, this.svaLabel);
            }
            this.MP.setColor(this.colorSVB);
            if (this.MP.getPoint((Position)this.svb, this.pix) > 0) {
                this.drawPoint(lin, this.pix, this.svbLabel);
            }
            this.MP.setColor(this.colors[0]);
        }
    }

    private void drawHznAtAlt(Color hznAtAltColor, StateVector sv) {
        Line lin = this.line.copy();
        int npts = (int)this.contour.out[0];
        for (int j = 0; j < this.contour.nout; j += 6 + npts * 2) {
            npts = (int)this.contour.out[j];
            double[] ecefHznPts = Transform.lonlat2car(this.contour.out, j + 6, npts);
            double[] hznAtAltPts = horizonAltTraditionalCode ? Transform.hzn2AltHzn(ecefHznPts, 0, npts, sv, this.horizonAlt) : Transform.horizon2HorizonAtAlt(ecefHznPts, 0, npts, this.horizonAlt, sv);
            Transform.car2geo(hznAtAltPts, 1, npts);
            Transform.all2lla(hznAtAltPts, npts);
            lin.setColor(hznAtAltColor);
            this.MP.drawLine(hznAtAltPts, 0, 3, npts, lin, 18, true);
        }
    }

    private void drawPoint(Line lin, MPoint pix, String label) {
        if (this.MP.gc == null) {
            return;
        }
        if (pix.x < this.MP.ix1 || pix.x > this.MP.ix2) {
            return;
        }
        if (pix.y < this.MP.iy1 || pix.y > this.MP.iy2) {
            return;
        }
        int r = lin.getRadius();
        this.MP.gc.drawLine(pix.x - r, pix.y - r, pix.x + r, pix.y + r);
        this.MP.gc.drawLine(pix.x - r, pix.y + r, pix.x + r, pix.y - r);
        if (label != null) {
            this.MP.gc.drawString(label, pix.x + r, pix.y + r);
        }
    }

    private void drawContour(Line lin, double z, int ic, double[] dbuf) {
        Color color = this.colors[ic];
        this.drawContour(lin, z, color, dbuf);
    }

    private void drawContour(Line lin, double z, Color color, double[] dbuf) {
        lin.setColor(color);
        this.contour.setZAxis(z, z, 1);
        this.contour.process(dbuf);
        double[] dout = this.contour.out;
        int j = 0;
        while (j < this.contour.nout && !this.MP.cancel) {
            int npts = (int)dout[j++];
            int ncol = (int)dout[j++];
            int k = j + (2 + npts) * 2;
            if (this.MP.view == 14 && this.MP.hasExtendedRange()) {
                double value;
                if (!((value = dout[j++]) >= this.MP.rx2) || !(value - (double)MPlot.LONGITUDE_RANGE < this.MP.rx1)) {
                    if (!(dout[j++] >= this.MP.ry2)) {
                        if (!((value = dout[j++]) <= this.MP.rx1) || !(value + 360.0 > this.MP.rx2)) {
                            if (!(dout[j++] <= this.MP.ry1)) {
                                this.MP.drawLineContour(dout, j, 2, npts, lin);
                            }
                        }
                    }
                }
            } else if (this.MP.is2D) {
                if (!(dout[j++] >= this.MP.rx2)) {
                    if (!(dout[j++] >= this.MP.ry2)) {
                        if (!(dout[j++] <= this.MP.rx1)) {
                            if (!(dout[j++] <= this.MP.ry1)) {
                                this.MP.drawLineContour(dout, j, 2, npts, lin);
                            }
                        }
                    }
                }
            } else {
                this.MP.drawLineContour(dout, j + 4, 2, npts, lin);
            }
            j = k;
        }
    }

    public void predict(Position pos, Predict pre) {
        double rrsb;
        double rrsa;
        double rsb;
        double rsa;
        double xta = this.sva.x - pos.x;
        double yta = this.sva.y - pos.y;
        double zta = this.sva.z - pos.z;
        double xtb = this.svb.x - pos.x;
        double ytb = this.svb.y - pos.y;
        double ztb = this.svb.z - pos.z;
        double rta = Math.sqrt(xta * xta + yta * yta + zta * zta);
        double rtai = 1.0 / rta;
        double rtb = Math.sqrt(xtb * xtb + ytb * ytb + ztb * ztb);
        double rtbi = 1.0 / rtb;
        double rrta = (xta * this.sva.vx + yta * this.sva.vy + zta * this.sva.vz) * rtai;
        double rrtb = (xtb * this.svb.vx + ytb * this.svb.vy + ztb * this.svb.vz) * rtbi;
        if (this.predictReference == this.PREDICT_REF_SITE) {
            double zsb;
            double ysb;
            double xsb;
            double xsa = this.sva.x - this.siteA.x;
            double ysa = this.sva.y - this.siteA.y;
            double zsa = this.sva.z - this.siteA.z;
            if (this.siteB == null) {
                xsb = this.svb.x - this.siteA.x;
                ysb = this.svb.y - this.siteA.y;
                zsb = this.svb.z - this.siteA.z;
            } else {
                xsb = this.svb.x - this.siteB.x;
                ysb = this.svb.y - this.siteB.y;
                zsb = this.svb.z - this.siteB.z;
            }
            rsa = Math.sqrt(xsa * xsa + ysa * ysa + zsa * zsa);
            double rsai = 1.0 / rsa;
            rsb = Math.sqrt(xsb * xsb + ysb * ysb + zsb * zsb);
            double rsbi = 1.0 / rsb;
            rrsa = (xsa * this.sva.vx + ysa * this.sva.vy + zsa * this.sva.vz) * rsai;
            rrsb = (xsb * this.svb.vx + ysb * this.svb.vy + zsb * this.svb.vz) * rsbi;
        } else {
            rsa = 0.0;
            rsb = 0.0;
            rrsa = 0.0;
            rrsb = 0.0;
        }
        double cci = 3.3356409519815204E-9;
        pre.tdoa = cci * (rtb - rta + rsb - rsa);
        pre.fdoa = -cci * (this.flinkt * (rrtb - rrta) + this.flinkb * rrsb - this.flinka * rrsa);
        double rti = 1.0 / pos.r;
        pre.aoaa = (pos.x * xta + pos.y * yta + pos.z * zta) * rtai * rti;
        pre.aoab = (pos.x * xtb + pos.y * ytb + pos.z * ztb) * rtbi * rti;
    }

    public void setPredictReference(String val) {
        this.setPredictReference(Parser.find(predictReferenceList, val, 0, 0, 1));
    }

    public String getPredictReference() {
        return Parser.get(predictReferenceList, this.predictReference);
    }

    private void setPredictReference(int val) {
        this.predictReference = val;
    }

    @Override
    public String getReadOut(Position mp) {
        Position rpos = mp.cloneOf();
        Predict rpre = new Predict();
        rpos.geo2car();
        this.predict(rpos, rpre);
        String tmp = this.name;
        tmp = tmp + " ( Lat=" + this.MP.formNumber(rpos.lat, 0, 0);
        tmp = tmp + " Lon=" + this.MP.formNumber(rpos.lon, 0, 0);
        tmp = tmp + " CEP=" + this.MP.formNumber(this.cep, 0, 0);
        tmp = tmp + " Tdoa=" + this.MP.formNumber(rpre.tdoa, 0, 0);
        tmp = tmp + " Fdoa=" + this.MP.formNumber(rpre.fdoa, 0, 0);
        tmp = tmp + " )";
        return tmp;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    @Override
    public void setTime(double value) {
        if (value > 8640000.0) {
            this.setTimeCode(value);
            return;
        }
        this.time = value;
        this.sva.setTime(this.time);
        this.svb.setTime(this.time);
        this.refresh();
    }

    public boolean setTimeCode(double value) {
        boolean stat = this.sva.setTimeCode(value) && this.svb.setTimeCode(value);
        this.time = value;
        this.refresh();
        return stat;
    }

    public double getTimeCode() {
        return this.getTime();
    }

    public StateVector getSVA() {
        return this.sva;
    }

    public void setSVA(StateVector value) {
        this.sva = value;
        this.refresh();
    }

    public StateVector getSVB() {
        return this.svb;
    }

    public void setSVB(StateVector value) {
        this.svb = value;
        this.refresh();
    }

    public Position getPos() {
        return this.pos;
    }

    public void setPos(Position value) {
        this.pos = value;
        this.refresh();
    }

    public void setPos(String name) {
        this.setPos(new Position(this.ref, (Object)name));
    }

    public void setPointPosA(Position value) {
        this.pointPosA = value;
        this.refresh();
    }

    public Position getPointPosA() {
        return this.pointPosA;
    }

    public void setPointPosB(Position value) {
        this.pointPosB = value;
        this.refresh();
    }

    public Position getPointPosB() {
        return this.pointPosB;
    }

    public void drawConeToTarget() {
        this.drawConeToTarget = true;
        this.refresh();
    }

    public void drawConeToPointPos() {
        this.drawConeToTarget = false;
        this.refresh();
    }

    public Position getSite() {
        return this.siteA;
    }

    public void setSite(Position value) {
        this.siteA = value;
        this.refresh();
    }

    public void setSite(String name) {
        this.setSite(new Position(this.ref, (Object)name));
    }

    public Position getSiteA() {
        return this.siteA;
    }

    public void setSiteA(Position value) {
        this.siteA = value;
        this.refresh();
    }

    public void setSiteA(String name) {
        this.setSiteA(new Position(this.ref, (Object)name));
    }

    public Position getSiteB() {
        return this.siteB;
    }

    public void setSiteB(Position value) {
        this.siteB = value;
        this.refresh();
    }

    public void setSiteB(String name) {
        this.setSiteB(new Position(this.ref, (Object)name));
    }

    public void setSVA(String name) {
        this.setSVA(new StateVector(this.ref, (Object)name));
    }

    public void setSVB(String name) {
        this.setSVB(new StateVector(this.ref, (Object)name));
    }

    public void setSVALabel(String name) {
        this.svaLabel = name;
        this.refresh();
    }

    public String getSVALabel() {
        return this.svaLabel;
    }

    public void setSVBLabel(String name) {
        this.svbLabel = name;
        this.refresh();
    }

    public String getSVBLabel() {
        return this.svbLabel;
    }

    public void setTargetLabel(String name) {
        this.targetLabel = name;
        this.refresh();
    }

    public String getTargetLabel() {
        return this.targetLabel;
    }

    public void setSiteLabel(String name) {
        this.siteLabelA = name;
        this.refresh();
    }

    public String getSiteLabel() {
        return this.siteLabelA;
    }

    public void setSiteLabelA(String name) {
        this.siteLabelA = name;
        this.refresh();
    }

    public String getSiteLabelA() {
        return this.siteLabelA;
    }

    public void setSiteLabelB(String name) {
        this.siteLabelB = name;
        this.refresh();
    }

    public String getSiteLabelB() {
        return this.siteLabelB;
    }

    public String getFlags() {
        return Parser.mask2s(flagsList, this.flags);
    }

    public void setFlags(int value) {
        this.flags = value;
        this.refresh();
    }

    public void setFlags(String value) {
        this.setFlags(Parser.mask(flagsList, value, this.flags));
    }

    public String getSiteMode() {
        return Parser.get("Current,Offset,Fixed", this.sitemode);
    }

    public void setSiteMode(int value) {
        this.sitemode = value;
        this.refresh();
    }

    public void setSiteMode(String value) {
        this.setSiteMode(Parser.find("Current,Offset,Fixed", value, this.sitemode, 0, 1));
    }

    public String getSVecMode() {
        return Parser.get("Current,Offset,Fixed", this.svecmode);
    }

    public void setSVecMode(int value) {
        this.svecmode = value;
        this.refresh();
    }

    public void setSVecMode(String value) {
        this.setSVecMode(Parser.find("Current,Offset,Fixed", value, this.svecmode, 0, 1));
    }

    public String getTdoaMode() {
        return Parser.get("Line,Contour,Region,None", this.tdoamode);
    }

    public void setTdoaMode(int value) {
        this.tdoamode = value;
        this.refresh();
    }

    public void setTdoaMode(String value) {
        this.setTdoaMode(Parser.find("Line,Contour,Region,None", value, this.tdoamode, 0, 1));
    }

    public String getFdoaMode() {
        return Parser.get("Line,Contour,Region,None", this.fdoamode);
    }

    public void setFdoaMode(int value) {
        this.fdoamode = value;
        this.refresh();
    }

    public void setFdoaMode(String value) {
        this.setFdoaMode(Parser.find("Line,Contour,Region,None", value, this.fdoamode, 0, 1));
    }

    public double getTdoa() {
        return this.tdoa;
    }

    public void setTdoa(double value) {
        this.tdoa = value;
        this.refresh();
    }

    public double getDTdoa() {
        return this.dtdoa;
    }

    public void setDTdoa(double value) {
        this.dtdoa = value;
        this.refresh();
    }

    public double getFdoa() {
        return this.fdoa;
    }

    public void setFdoa(double value) {
        this.fdoa = value;
        this.refresh();
    }

    public double getDFdoa() {
        return this.dfdoa;
    }

    public void setDFdoa(double value) {
        this.dfdoa = value;
        this.refresh();
    }

    public double getCEP() {
        return this.cep;
    }

    public void setCEP(double value) {
        this.cep = value;
        this.refresh();
    }

    public double getFLinkT() {
        return this.flinkt;
    }

    public void setFLinkT(double value) {
        this.flinkt = value;
        this.refresh();
    }

    public double getFLinkA() {
        return this.flinka;
    }

    public void setFLinkA(double value) {
        this.flinka = value;
        this.refresh();
    }

    public double getFLinkB() {
        return this.flinkb;
    }

    public void setFLinkB(double value) {
        this.flinkb = value;
        this.refresh();
    }

    public int getConic() {
        return this.conic;
    }

    public void setConic(int value) {
        this.conic = value;
        this.refresh();
    }

    public int getConeDiv() {
        return this.cdiv;
    }

    public void setConeDiv(int value) {
        this.cdiv = value;
        this.refresh();
    }

    @Deprecated
    public double getConeAngle() {
        return this.cangleA;
    }

    @Deprecated
    public void setConeAngle(double value) {
        Shell.deprecate("setConeAngle since NeXtMidas 2.5.2: Use setConeAngleA or setConeAngleB");
        this.cangleA = this.cangleB = value;
        this.refresh();
    }

    public double getConeAngleA() {
        return this.cangleA;
    }

    public void setConeAngleA(double value) {
        this.cangleA = value;
        this.refresh();
    }

    public double getConeAngleB() {
        return this.cangleB;
    }

    public void setConeAngleB(double value) {
        this.cangleB = value;
        this.refresh();
    }

    public double getConeRange() {
        return this.crange;
    }

    public void setConeRange(double value) {
        this.crange = value;
        this.refresh();
    }

    @InternalUseOnly
    public double getHorizonAlt() {
        return this.horizonAlt;
    }

    @InternalUseOnly
    public void setHorizonAlt(double altitude) {
        this.horizonAlt = Math.max(altitude, 0.0);
        this.refresh();
    }

    public void setColorTable(Table colTab) {
        Table.Iterator ti = colTab.iterator();
        while (ti.getNext()) {
            String key = ti.getKey();
            Object obj = ti.getValue();
            Color color = null;
            try {
                color = obj instanceof Color ? (Color)obj : (obj instanceof Data ? new Color(Convert.o2l(obj)) : MColor.getColor((String)obj));
                if (key.equals("SITE")) {
                    this.colorSiteA = color;
                    continue;
                }
                if (key.equals("SITEA")) {
                    this.colorSiteA = color;
                    continue;
                }
                if (key.equals("SITEB")) {
                    this.colorSiteB = color;
                    continue;
                }
                if (key.equals("TARGET")) {
                    this.colorTarget = color;
                    continue;
                }
                if (key.equals("FOOTPRINTA")) {
                    this.colorFootPrintA = color;
                    continue;
                }
                if (key.equals("HORIZONA")) {
                    this.colorHorizonA = color;
                    continue;
                }
                if (key.equals("HORIZONALTA")) {
                    this.colorHznAtAltA = color;
                    continue;
                }
                if (key.equals("SVA")) {
                    this.colorSVA = color;
                    continue;
                }
                if (key.equals("FOOTPRINTB")) {
                    this.colorFootPrintB = color;
                    continue;
                }
                if (key.equals("HORIZONB")) {
                    this.colorHorizonB = color;
                    continue;
                }
                if (key.equals("HORIZONALTB")) {
                    this.colorHznAtAltB = color;
                    continue;
                }
                if (key.equals("SVB")) {
                    this.colorSVB = color;
                    continue;
                }
                if (key.equals("TDOA")) {
                    this.colorTDOA = color;
                    continue;
                }
                if (key.equals("FDOA")) {
                    this.colorFDOA = color;
                    continue;
                }
                this.warning(" " + this + " setColorTable: Invalid color key " + key);
            }
            catch (Exception e) {
                this.warning("Could not convert " + obj + " to a color");
            }
        }
        this.refresh();
    }

    public Table getColorTable() {
        return this.getColorTable(false);
    }

    public Table getColorTable(boolean doColorObj) {
        Table colTab = new Table();
        if (doColorObj) {
            colTab.put("SITE", (Object)this.colorSiteA);
            colTab.put("SITEA", (Object)this.colorSiteA);
            colTab.put("SITEB", (Object)this.colorSiteB);
            colTab.put("TARGET", (Object)this.colorTarget);
            colTab.put("FOOTPRINTA", (Object)this.colorFootPrintA);
            colTab.put("FOOTPRINTB", (Object)this.colorFootPrintB);
            colTab.put("HORIZONA", (Object)this.colorHorizonA);
            colTab.put("HORIZONB", (Object)this.colorHorizonB);
            colTab.put("HORIZONALTA", (Object)this.colorHznAtAltA);
            colTab.put("HORIZONALTB", (Object)this.colorHznAtAltB);
            colTab.put("SVA", (Object)this.colorSVA);
            colTab.put("SVB", (Object)this.colorSVB);
            colTab.put("TDOA", (Object)this.colorTDOA);
            colTab.put("FDOA", (Object)this.colorFDOA);
        } else {
            colTab.put("SITE", (Object)MColor.toString(this.colorSiteA));
            colTab.put("SITEA", (Object)MColor.toString(this.colorSiteA));
            colTab.put("SITEB", (Object)MColor.toString(this.colorSiteB));
            colTab.put("TARGET", (Object)MColor.toString(this.colorTarget));
            colTab.put("FOOTPRINTA", (Object)MColor.toString(this.colorFootPrintA));
            colTab.put("FOOTPRINTB", (Object)MColor.toString(this.colorFootPrintB));
            colTab.put("HORIZONA", (Object)MColor.toString(this.colorHorizonA));
            colTab.put("HORIZONB", (Object)MColor.toString(this.colorHorizonB));
            colTab.put("HORIZONALTA", (Object)MColor.toString(this.colorHznAtAltA));
            colTab.put("HORIZONALTB", (Object)MColor.toString(this.colorHznAtAltB));
            colTab.put("SVA", (Object)MColor.toString(this.colorSVA));
            colTab.put("SVB", (Object)MColor.toString(this.colorSVB));
            colTab.put("TDOA", (Object)MColor.toString(this.colorTDOA));
            colTab.put("FDOA", (Object)MColor.toString(this.colorFDOA));
        }
        return colTab;
    }

    public void setColorA(String color) {
        this.setColorA(MColor.getColor(color));
    }

    public void setColorA(Color color) {
        this.colorFootPrintA = color;
        this.colorHorizonA = color;
        this.colorSVA = color;
        this.refresh();
    }

    public void setColorB(String color) {
        this.setColorB(MColor.getColor(color));
    }

    public void setColorB(Color color) {
        this.colorFootPrintB = color;
        this.colorHorizonB = color;
        this.colorSVB = color;
        this.refresh();
    }

    public int getGridSizeX() {
        return this.frame;
    }

    public void setGridSizeX(int value) {
        if (value != this.frame) {
            this.setGridSize(value, this.size);
        }
    }

    @Override
    public void setFrame(int value) {
        this.setGridSizeX(value);
    }

    public int getGridSizeY() {
        return this.size;
    }

    public void setGridSizeY(int value) {
        if (value != this.size) {
            this.setGridSize(this.frame, value);
        }
    }

    @Override
    public void setSize(int value) {
        this.setGridSizeY(value);
    }

    public void setGridSize(int val) {
        this.setGridSize(val, val);
    }

    public void setGridSize(int xGridSize, int yGridSize) {
        if (xGridSize < 2) {
            throw new IllegalArgumentException("Grid Size X must be greater than 1.");
        }
        if (yGridSize < 2) {
            throw new IllegalArgumentException("Grid Size Y must be greater than 1.");
        }
        int prev = this.frame * this.size;
        int npts = xGridSize * yGridSize;
        boolean changed = false;
        if (xGridSize != this.frame) {
            this.frame = xGridSize;
            changed = true;
        }
        if (yGridSize != this.size) {
            this.size = yGridSize;
            changed = true;
        }
        if (changed) {
            if (prev != npts) {
                this.tdoabuf = new double[npts];
                this.fdoabuf = new double[npts];
                this.aoaabuf = new double[npts];
                this.aoabbuf = new double[npts];
            }
            this.refresh();
        }
    }

    @InternalUseOnly
    public static void useHorizonAltTraditionalCode(boolean useTraditional) {
        horizonAltTraditionalCode = useTraditional;
    }

    @InternalUseOnly
    public static boolean isHorizonAltTraditionalCode() {
        return horizonAltTraditionalCode;
    }

    static {
        DEFAULT_SITE_COLOR = T5_COLOR = MColor.getColor(20, 100, 20);
        DEFAULT_TARGET_COLOR = T5_COLOR;
        DEFAULT_HORIZON_COLOR = MColor.getColor(0, 60, 0);
        DEFAULT_HORIZONALT_COLOR = Color.BLUE;
        DEFAULT_FOOTPRINT_COLOR = T5_COLOR;
        DEFAULT_TDOA_COLOR = MColor.getColor(80, 0, 0);
        DEFAULT_FDOA_COLOR = MColor.getColor(80, 80, 0);
        DEFAULT_SVB_COLOR = DEFAULT_SVA_COLOR = T5_COLOR;
        horizonAltTraditionalCode = false;
    }

    public class Predict {
        double tdoa;
        double fdoa;
        double aoaa;
        double aoab;
        double cep = 0.0;
    }
}

